/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mcquay.point;

import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.mcquay.BMcQuayDevice;
import com.tridium.mcquay.BMcQuayNetwork;
import com.tridium.mcquay.messages.McQuayMessageConst;
import com.tridium.mcquay.messages.McQuayReadRequest;
import com.tridium.mcquay.messages.McQuayReadResponse;
import com.tridium.mcquay.point.BMcQuayEnumProxyExt;
import com.tridium.mcquay.point.BMcQuayPointDeviceExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BMcQuayProxyExt
extends BBasicProxyExt
implements BIBasicPollable,
McQuayMessageConst {
    public static final Property pollFrequency = BMcQuayProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property registerHex = BMcQuayProxyExt.newProperty((int)0, (String)"-", null);
    public static final Property dataLenRegisters = BMcQuayProxyExt.newProperty((int)0, (int)1, null);
    public static final Type TYPE;
    Log mcQuayReadLog;
    Log mcQuayWriteLog;
    BMcQuayNetwork network;
    BMcQuayDevice objDevice;
    McQuayReadRequest req;
    McQuayReadResponse rsp;
    McQuayReadResponse comboRsp;
    static /* synthetic */ Class class$com$tridium$mcquay$point$BMcQuayProxyExt;

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public String getRegisterHex() {
        return this.getString(registerHex);
    }

    public void setRegisterHex(String string) {
        this.setString(registerHex, string, null);
    }

    public int getDataLenRegisters() {
        return this.getInt(dataLenRegisters);
    }

    public void setDataLenRegisters(int n) {
        this.setInt(dataLenRegisters, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        BStatusValue bStatusValue = this.getParentPoint().getOutStatusValue();
        return super.post(action, (BValue)bStatusValue, context);
    }

    public void started() throws Exception {
        super.started();
        this.getMcQuayNetwork().getPollScheduler().subscribe((BIPollable)this);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.getMcQuayNetwork().getPollScheduler().unsubscribe((BIPollable)this);
    }

    public final BMcQuayNetwork getMcQuayNetwork() {
        return (BMcQuayNetwork)this.getNetwork();
    }

    public final BMcQuayDevice getMcQuayDevice() {
        return (BMcQuayDevice)this.getDevice();
    }

    public final BMcQuayPointDeviceExt getMcQuayPointDeviceExt() {
        return (BMcQuayPointDeviceExt)this.getDeviceExt();
    }

    public Type getDeviceExtType() {
        return BMcQuayPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public String getRegister() {
        String string = this.getRegisterHex();
        if (string.startsWith("-")) {
            return string;
        }
        try {
            Integer n = Integer.valueOf(string, 16);
        }
        catch (Exception exception) {
            return "-1";
        }
        string = "0000" + string;
        return string.substring(string.length() - 4);
    }

    public void poll() {
        try {
            BMcQuayDevice bMcQuayDevice = this.getMcQuayDevice();
            BMcQuayNetwork bMcQuayNetwork = bMcQuayDevice.getMcQuayNetwork();
            if (this.isUnoperational() || !bMcQuayNetwork.getPollScheduler().getPollEnabled()) {
                return;
            }
            this.pollForData();
        }
        catch (Exception exception) {
            this.mcQuayReadLog.error("Exception in McQuayProxyExt-->poll()");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void pollForData() {
        block23: {
            block22: {
                block21: {
                    try {
                        try {
                            int n;
                            this.network = (BMcQuayNetwork)this.getNetwork();
                            if (this instanceof BMcQuayEnumProxyExt) {
                                n = ((BMcQuayEnumProxyExt)this).getEnumType().getOrdinal();
                                switch (n) {
                                    case 0: {
                                        this.setRegisterHex("0801");
                                        break;
                                    }
                                    case 1: {
                                        this.setRegisterHex("043D");
                                        break;
                                    }
                                    case 2: {
                                        this.setRegisterHex("081C");
                                        break;
                                    }
                                    case 3: {
                                        this.setRegisterHex("081D");
                                        break;
                                    }
                                    case 4: {
                                        this.setRegisterHex("081E");
                                        break;
                                    }
                                    case 5: {
                                        this.setRegisterHex("081F");
                                        break;
                                    }
                                }
                            }
                            this.objDevice = this.getMcQuayDevice();
                            n = this.objDevice.getMasterNodeL2Addr();
                            int n2 = this.objDevice.getSlaveNodeL3Addr();
                            String string = this.getRegister();
                            if (string.startsWith("-")) {
                                Object var2_5 = null;
                                this.network = null;
                                return;
                            }
                            String string2 = this.objDevice.getMcQuayNetwork().getPassword();
                            this.comboRsp = new McQuayReadResponse();
                            int n3 = 0;
                            while (n3 < this.getDataLenRegisters()) {
                                String string3 = Integer.toHexString(Integer.parseInt(string, 16) + n3);
                                while (true) {
                                    if (string3.length() >= 4) {
                                        this.req = new McQuayReadRequest(1, n, n2, string3, string2);
                                        this.rsp = (McQuayReadResponse)this.network.sendSync(this.req);
                                        if (this.rsp != null && !this.rsp.isError()) break;
                                        this.rsp = new McQuayReadResponse();
                                        this.rsp.exceptionCode = 9;
                                        this.readFail("DEVICE TIMEOUT");
                                        break block21;
                                    }
                                    string3 = "0" + string3;
                                }
                                if (this.rsp.exceptionCode == 2) {
                                    this.mcQuayReadLog.error("Poll Request Received Negative Acknowledgement");
                                    break block22;
                                }
                                if (n3 == 0) {
                                    this.comboRsp = this.rsp;
                                } else {
                                    this.comboRsp.setValue(this.comboRsp.getValue() * 256 + this.rsp.getValue());
                                }
                                ++n3;
                            }
                            break block23;
                        }
                        catch (Exception exception) {
                            this.mcQuayReadLog.error("Exception in McQuayProxyExt-->pollForData()");
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var2_8 = null;
                        this.network = null;
                        throw throwable;
                    }
                }
                Object var2_6 = null;
                this.network = null;
                return;
            }
            Object var2_7 = null;
            this.network = null;
            return;
        }
        Object var2_9 = null;
        this.network = null;
        this.setOutValue(this.comboRsp);
    }

    public void doWrite(BStatusValue bStatusValue) {
        if (this.isUnoperational()) {
            return;
        }
    }

    public void setOutValue(McQuayReadResponse mcQuayReadResponse) {
    }

    protected boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    protected boolean isNumeric() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusNumeric;
    }

    protected boolean isString() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusString;
    }

    protected boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }

    public void readSubscribed(Context context) throws Exception {
        super.readSubscribed(context);
    }

    public void readUnsubscribed(Context context) throws Exception {
        super.readUnsubscribed(context);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.mcQuayReadLog = Log.getLog((String)"McQuayReadLog");
        this.mcQuayWriteLog = Log.getLog((String)"McQuayWriteLog");
        this.req = null;
        this.rsp = null;
    }

    public BMcQuayProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$mcquay$point$BMcQuayProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$mcquay$point$BMcQuayProxyExt = BMcQuayProxyExt.class("[Lcom.tridium.mcquay.point.BMcQuayProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

