/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.util;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.datatypes.BAxisVideoResolutionSettings;
import com.tridium.naxisVideo.identify.BAxisVideoCameraDeviceId;
import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.http.NHttpStream;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.VideoStream;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BajaRuntimeException;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class AxisHttpUtil {
    static PatternCompiler oroCompiler = new Perl5Compiler();
    static PatternMatcher oroMatcher = new Perl5Matcher();

    public static void streamToDestination(BAxisVideoCamera bAxisVideoCamera, BPlaybackParams bPlaybackParams, IVideoDestination iVideoDestination) {
        try {
            BIpAddress bIpAddress = new BIpAddress(((BAxisVideoCameraDeviceId)bAxisVideoCamera.getVideoDeviceId()).getUrlAddress(), 80);
            HttpComm httpComm = bAxisVideoCamera.getAxisVideoNetwork().hcomm();
            String string = AxisHttpUtil.makeUri(bAxisVideoCamera, bPlaybackParams);
            NHttpRequest nHttpRequest = new NHttpRequest(bIpAddress, "GET", string);
            nHttpRequest.addBasicAuthorization(bAxisVideoCamera.getCredentials().getUsername(), bAxisVideoCamera.getCredentials().getPassword().getString());
            nHttpRequest.setUsernamePassword((BUsernameAndPassword)bAxisVideoCamera.getCredentials());
            NHttpStream nHttpStream = httpComm.openStream(nHttpRequest);
            AxisVideoSteam axisVideoSteam = new AxisVideoSteam(bPlaybackParams, nHttpStream.getInputStream(), nHttpStream);
            iVideoDestination.receiveVideoStream((IVideoStream)axisVideoSteam);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BajaRuntimeException("Unable to establish stream", (Throwable)exception);
        }
    }

    static String makeUri(BAxisVideoCamera bAxisVideoCamera, BPlaybackParams bPlaybackParams) {
        StringBuffer stringBuffer = AxisHttpUtil.initUrlRequest(bAxisVideoCamera);
        AxisHttpUtil.updateUrlToRequestResolution(stringBuffer, bPlaybackParams.getResolution(), bAxisVideoCamera.getResolutionSettings(), bPlaybackParams);
        AxisHttpUtil.updateUrlToRequestFrameRate(stringBuffer, bPlaybackParams.getFrameRate());
        return stringBuffer.toString();
    }

    static StringBuffer initUrlRequest(BAxisVideoCamera bAxisVideoCamera) {
        BAxisVideoCameraDeviceId bAxisVideoCameraDeviceId = (BAxisVideoCameraDeviceId)bAxisVideoCamera.getVideoDeviceId();
        StringBuffer stringBuffer = new StringBuffer("http://");
        stringBuffer.append(bAxisVideoCameraDeviceId.getUrlAddress());
        stringBuffer.append("/axis-cgi/mjpg/video.cgi?clock=0&date=0");
        return stringBuffer;
    }

    static void updateUrlToRequestResolution(StringBuffer stringBuffer, BVideoResolutionEnum bVideoResolutionEnum, BAxisVideoResolutionSettings bAxisVideoResolutionSettings, BPlaybackParams bPlaybackParams) {
        if (bVideoResolutionEnum == BVideoResolutionEnum.high) {
            String string = bAxisVideoResolutionSettings.getHigh();
            if (string.length() != 0) {
                stringBuffer.append("&resolution=" + string);
            }
        } else if (bVideoResolutionEnum == BVideoResolutionEnum.medium) {
            String string = bAxisVideoResolutionSettings.getMedium();
            if (string.length() != 0) {
                stringBuffer.append("&resolution=" + string);
            }
        } else if (bVideoResolutionEnum == BVideoResolutionEnum.low) {
            String string = bAxisVideoResolutionSettings.getLow();
            if (string.length() != 0) {
                stringBuffer.append("&resolution=" + string);
            }
        } else {
            System.out.println(">> Unrecognized Niagara AX video resolution: " + bVideoResolutionEnum);
        }
        stringBuffer.append("&compression=" + AxisHttpUtil.getAxisVideoCompression(bPlaybackParams));
    }

    static int getAxisVideoCompression(BPlaybackParams bPlaybackParams) {
        BVideoCompressionEnum bVideoCompressionEnum = bPlaybackParams.getCompression();
        if (bVideoCompressionEnum == BVideoCompressionEnum.none) {
            return 0;
        }
        if (bVideoCompressionEnum == BVideoCompressionEnum.low) {
            return 10;
        }
        if (bVideoCompressionEnum == BVideoCompressionEnum.medium) {
            return 30;
        }
        if (bVideoCompressionEnum == BVideoCompressionEnum.high) {
            return 80;
        }
        throw new IllegalArgumentException("Requested compression unrecognized: " + bVideoCompressionEnum);
    }

    static void updateUrlToRequestFrameRate(StringBuffer stringBuffer, BVideoFrameRateEnum bVideoFrameRateEnum) {
        if (bVideoFrameRateEnum == BVideoFrameRateEnum.high) {
            stringBuffer.append("&fps=30");
        } else if (bVideoFrameRateEnum == BVideoFrameRateEnum.medium) {
            stringBuffer.append("&fps=15");
        } else if (bVideoFrameRateEnum == BVideoFrameRateEnum.low) {
            stringBuffer.append("&fps=4");
        } else {
            System.out.println(">> Unrecognized Niagara AX frame rate: " + bVideoFrameRateEnum);
        }
    }

    public static String[] inspectHtml(String string, int n, String string2) {
        Pattern pattern = null;
        try {
            pattern = oroCompiler.compile(string);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new BajaRuntimeException((Throwable)malformedPatternException);
        }
        if (oroMatcher.contains(string2, pattern)) {
            MatchResult matchResult = oroMatcher.getMatch();
            String[] stringArray = new String[n + 1];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = matchResult.group(n2);
                ++n2;
            }
            return stringArray;
        }
        return null;
    }

    public static String inspectLeftHtml(String string, String string2) {
        Pattern pattern = null;
        try {
            pattern = oroCompiler.compile(string + "=(.*)");
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new BajaRuntimeException((Throwable)malformedPatternException);
        }
        if (oroMatcher.contains(string2, pattern)) {
            MatchResult matchResult = oroMatcher.getMatch();
            return matchResult.group(1);
        }
        return null;
    }

    public static String inspectRightHtml(String string, String string2) {
        Pattern pattern = null;
        try {
            pattern = oroCompiler.compile("(.*)=" + string);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new BajaRuntimeException((Throwable)malformedPatternException);
        }
        if (oroMatcher.contains(string2, pattern)) {
            MatchResult matchResult = oroMatcher.getMatch();
            return matchResult.group(1);
        }
        return null;
    }

    private static class AxisVideoSteam
    extends VideoStream {
        NHttpStream hstream;

        public void closeVideoStream() throws IOException {
            this.hstream.close();
        }

        AxisVideoSteam(BPlaybackParams bPlaybackParams, InputStream inputStream, NHttpStream nHttpStream) {
            super(bPlaybackParams, inputStream);
            this.hstream = nHttpStream;
        }
    }
}

