/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.messages;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.datatypes.BAxisVideoPanTiltZoomSettings;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.videoDriver.enums.BVideoZoomEnum;

public class AxisVideoZoomRequest
extends NHttpRequest {
    BAxisVideoCamera camera;
    BVideoZoomEnum zoomAction;

    public int getResponseTimeOut() {
        return 30000;
    }

    public int getRetryCount() {
        return 0;
    }

    public String getMethod() {
        return "GET";
    }

    public String getUri() {
        StringBuffer stringBuffer = this.initUrlRequest();
        stringBuffer.append(this.getZoomUrlParams());
        return stringBuffer.toString();
    }

    private final StringBuffer initUrlRequest() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("/axis-cgi/com/ptz.cgi?");
        return stringBuffer;
    }

    private final String getZoomUrlParams() {
        BAxisVideoPanTiltZoomSettings bAxisVideoPanTiltZoomSettings = this.camera.getPanTiltZoomSettings();
        int n = 0;
        if (this.zoomAction == BVideoZoomEnum.none) {
            n = 0;
        } else if (this.zoomAction == BVideoZoomEnum.reset) {
            n = 0;
        } else if (this.zoomAction == BVideoZoomEnum.zoomInFast) {
            n = bAxisVideoPanTiltZoomSettings.getZoomIndexFast();
        } else if (this.zoomAction == BVideoZoomEnum.zoomInMedium) {
            n = bAxisVideoPanTiltZoomSettings.getZoomIndexMedium();
        } else if (this.zoomAction == BVideoZoomEnum.zoomInSlow) {
            n = bAxisVideoPanTiltZoomSettings.getZoomIndexSlow();
        } else if (this.zoomAction == BVideoZoomEnum.zoomOutFast) {
            n = -bAxisVideoPanTiltZoomSettings.getZoomIndexFast();
        } else if (this.zoomAction == BVideoZoomEnum.zoomOutMedium) {
            n = -bAxisVideoPanTiltZoomSettings.getZoomIndexMedium();
        } else if (this.zoomAction == BVideoZoomEnum.zoomOutSlow) {
            n = -bAxisVideoPanTiltZoomSettings.getZoomIndexSlow();
        } else {
            throw new IllegalArgumentException("Unsupported zoomAction: " + this.zoomAction);
        }
        return "continuouszoommove=" + n;
    }

    public AxisVideoZoomRequest(BIpAddress bIpAddress, BAxisVideoCamera bAxisVideoCamera, BVideoZoomEnum bVideoZoomEnum) {
        super(bIpAddress);
        this.camera = bAxisVideoCamera;
        this.zoomAction = bVideoZoomEnum;
    }
}

