/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.messages;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.datatypes.BAxisVideoResolutionSettings;
import com.tridium.naxisVideo.identify.BAxisVideoCameraDeviceId;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoStream;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.net.UrlConnection;
import javax.baja.sys.BajaRuntimeException;

public class AxisVideoStreamRequest
extends NHttpRequest {
    private UrlConnection videoConnection;
    BAxisVideoCamera camera;
    BPlaybackParams playbackParams;
    protected IVideoDestination videoDestination;
    protected BIVideoSource videoSource;

    public int getResponseTimeOut() {
        return 30000;
    }

    public int getRetryCount() {
        return 0;
    }

    public String getMethod() {
        return "GET";
    }

    public String getUri() {
        StringBuffer stringBuffer = this.initUrlRequest();
        BPlaybackParams bPlaybackParams = this.getPlaybackParams();
        this.updateUrlToRequestResolution(stringBuffer, bPlaybackParams.getResolution(), this.camera.getResolutionSettings());
        this.updateUrlToRequestFrameRate(stringBuffer, bPlaybackParams.getFrameRate());
        return stringBuffer.toString();
    }

    public boolean processHttpStream(UrlConnection urlConnection) {
        this.videoConnection = urlConnection;
        return false;
    }

    private final StringBuffer initUrlRequest() {
        BAxisVideoCameraDeviceId bAxisVideoCameraDeviceId = (BAxisVideoCameraDeviceId)this.camera.getVideoDeviceId();
        StringBuffer stringBuffer = new StringBuffer("http://");
        stringBuffer.append(bAxisVideoCameraDeviceId.getUrlAddress());
        stringBuffer.append("/axis-cgi/mjpg/video.cgi?clock=0&date=0");
        return stringBuffer;
    }

    private final void updateUrlToRequestResolution(StringBuffer stringBuffer, BVideoResolutionEnum bVideoResolutionEnum, BAxisVideoResolutionSettings bAxisVideoResolutionSettings) {
        if (bVideoResolutionEnum == BVideoResolutionEnum.high) {
            String string = bAxisVideoResolutionSettings.getHigh();
            if (string.length() != 0) {
                stringBuffer.append("&resolution=" + string);
            }
        } else if (bVideoResolutionEnum == BVideoResolutionEnum.medium) {
            String string = bAxisVideoResolutionSettings.getMedium();
            if (string.length() != 0) {
                stringBuffer.append("&resolution=" + string);
            }
        } else if (bVideoResolutionEnum == BVideoResolutionEnum.low) {
            String string = bAxisVideoResolutionSettings.getLow();
            if (string.length() != 0) {
                stringBuffer.append("&resolution=" + string);
            }
        } else {
            System.out.println(">> Unrecognized Niagara AX video resolution: " + bVideoResolutionEnum);
        }
        stringBuffer.append("&compression=" + this.getAxisVideoCompression());
    }

    private final int getAxisVideoCompression() {
        BVideoCompressionEnum bVideoCompressionEnum = this.getPlaybackParams().getCompression();
        if (bVideoCompressionEnum == BVideoCompressionEnum.none) {
            return 0;
        }
        if (bVideoCompressionEnum == BVideoCompressionEnum.low) {
            return 10;
        }
        if (bVideoCompressionEnum == BVideoCompressionEnum.medium) {
            return 30;
        }
        if (bVideoCompressionEnum == BVideoCompressionEnum.high) {
            return 80;
        }
        throw new IllegalArgumentException("Requested compression unrecognized: " + bVideoCompressionEnum);
    }

    private final void updateUrlToRequestFrameRate(StringBuffer stringBuffer, BVideoFrameRateEnum bVideoFrameRateEnum) {
        if (bVideoFrameRateEnum == BVideoFrameRateEnum.high) {
            stringBuffer.append("&fps=30");
        } else if (bVideoFrameRateEnum == BVideoFrameRateEnum.medium) {
            stringBuffer.append("&fps=15");
        } else if (bVideoFrameRateEnum == BVideoFrameRateEnum.low) {
            stringBuffer.append("&fps=4");
        } else {
            System.out.println(">> Unrecognized Niagara AX frame rate: " + bVideoFrameRateEnum);
        }
    }

    public IVideoStream makeVideoStream() {
        return new IVideoStream(){

            public final void closeVideoStream() throws IOException {
                AxisVideoStreamRequest.this.videoConnection.close();
            }

            public final InputStream getInputStream() {
                try {
                    return AxisVideoStreamRequest.this.videoConnection.getInputStream();
                }
                catch (IOException iOException) {
                    throw new BajaRuntimeException((Throwable)iOException);
                }
            }

            public final BPlaybackParams getPlaybackParams() {
                return AxisVideoStreamRequest.this.playbackParams;
            }
        };
    }

    public BPlaybackParams getPlaybackParams() {
        return this.playbackParams;
    }

    public void setPlaybackParams(BPlaybackParams bPlaybackParams) {
        this.playbackParams = bPlaybackParams;
    }

    public void setVideoDestination(IVideoDestination iVideoDestination) {
        this.videoDestination = iVideoDestination;
    }

    public IVideoDestination getVideoDestination() {
        return this.videoDestination;
    }

    public BIVideoSource getVideoSource() {
        return this.videoSource;
    }

    public void setVideoSource(BIVideoSource bIVideoSource) {
        this.videoSource = bIVideoSource;
    }

    public AxisVideoStreamRequest(BIpAddress bIpAddress, BAxisVideoCamera bAxisVideoCamera, BPlaybackParams bPlaybackParams) {
        super(bIpAddress);
        this.camera = bAxisVideoCamera;
        this.playbackParams = bPlaybackParams;
    }
}

