/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.discover.dns;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;

public class DnsResourceRecord {
    public static final int ADDRESS_TYPE = 1;
    public static final int SRV_TYPE = 33;
    public static final int TXT_TYPE = 16;
    private String domainName;
    private int type;
    private int rrClass;
    private int ttl;
    private int rdLength;
    protected byte[] rData;

    public static DnsResourceRecord readResourceRecord(DataInput dataInput) throws IOException {
        DnsResourceRecord dnsResourceRecord = new DnsResourceRecord();
        dnsResourceRecord.read(dataInput);
        return dnsResourceRecord;
    }

    public void read(DataInput dataInput) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = dataInput.readUnsignedByte()) != 0) {
            if (n >= 192) {
                dataInput.readUnsignedByte();
                break;
            }
            int n2 = n;
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append((char)dataInput.readUnsignedByte());
                ++n3;
            }
            stringBuffer.append(".");
        }
        this.domainName = stringBuffer.toString();
        this.type = dataInput.readUnsignedShort();
        this.rrClass = dataInput.readUnsignedShort();
        this.ttl = dataInput.readInt();
        this.readResourceData(dataInput);
    }

    protected void readResourceData(DataInput dataInput) throws IOException {
        this.rdLength = dataInput.readUnsignedShort();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.rdLength);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n = 0;
        while (n < this.rdLength) {
            dataOutputStream.writeByte(dataInput.readUnsignedByte());
            ++n;
        }
        this.rData = byteArrayOutputStream.toByteArray();
    }

    public void write(DataOutput dataOutput) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.domainName, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            dataOutput.writeByte(string.length());
            dataOutput.writeBytes(string);
        }
        dataOutput.writeByte(0);
        dataOutput.writeShort(this.type);
        dataOutput.writeShort(this.rrClass);
        dataOutput.writeInt(this.ttl);
        dataOutput.writeShort(this.rdLength);
        dataOutput.write(this.rData);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public int getType() {
        return this.type;
    }

    public int getRecordClass() {
        return this.rrClass;
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public int getResourceDataLength() {
        return this.rdLength;
    }

    public byte[] getResourceData() {
        return this.rData;
    }
}

