/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.discover.dns;

import com.tridium.naxisVideo.discover.dns.DnsHeader;
import com.tridium.naxisVideo.discover.dns.DnsQuestion;
import com.tridium.naxisVideo.discover.dns.DnsResourceRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import javax.baja.sys.Clock;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DnsMessage {
    private static final int PTR_TYPE = 12;
    private static final int SRV_TYPE = 33;
    private static final int IN_CLASS = 32769;
    private static final String MULTICAST_ADDRESS = "224.0.0.251";
    private static final int MULTICAST_PORT = 5353;
    private String address;
    private int port;
    private DnsHeader header;
    private Array questions;
    private Array answers;
    private Array authorities;
    private Array additionals;
    static /* synthetic */ Class class$com$tridium$naxisVideo$discover$dns$DnsQuestion;
    static /* synthetic */ Class class$com$tridium$naxisVideo$discover$dns$DnsResourceRecord;
    static /* synthetic */ Class class$com$tridium$naxisVideo$discover$dns$DnsMessage;

    public DnsMessage[] send(InetAddress inetAddress, int n, long l) throws IOException {
        Class clazz = class$com$tridium$naxisVideo$discover$dns$DnsMessage;
        if (clazz == null) {
            clazz = class$com$tridium$naxisVideo$discover$dns$DnsMessage = DnsMessage.class("[Lcom.tridium.naxisVideo.discover.dns.DnsMessage;", false);
        }
        Array array = new Array(clazz);
        MulticastSocket multicastSocket = new MulticastSocket(n);
        multicastSocket.setSoTimeout(100);
        multicastSocket.joinGroup(inetAddress);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.write(dataOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        multicastSocket.send(datagramPacket);
        long l2 = Clock.millis();
        byte[] byArray2 = new byte[512];
        DatagramPacket datagramPacket2 = new DatagramPacket(byArray2, byArray2.length);
        DnsMessage dnsMessage = null;
        while (Clock.millis() - l2 < l) {
            try {
                multicastSocket.receive(datagramPacket2);
                while (datagramPacket2.getLength() == datagramPacket.getLength()) {
                    multicastSocket.receive(datagramPacket2);
                }
                dnsMessage = DnsMessage.readMessage(datagramPacket2);
                array.add((Object)dnsMessage);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        multicastSocket.leaveGroup(inetAddress);
        multicastSocket.close();
        return (DnsMessage[])array.trim();
    }

    public DnsMessage[] send(long l) throws IOException {
        byte[] byArray = new byte[4];
        byArray[0] = -32;
        byArray[3] = -5;
        DnsMessage[] dnsMessageArray = this.send(InetAddress.getByAddress(byArray), 5353, l);
        return dnsMessageArray;
    }

    public static DnsMessage readMessage(DataInput dataInput) throws IOException {
        DnsMessage dnsMessage = new DnsMessage();
        dnsMessage.read(dataInput);
        return dnsMessage;
    }

    public static DnsMessage readMessage(DatagramPacket datagramPacket) throws IOException {
        DnsMessage dnsMessage = new DnsMessage();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        dnsMessage.read(dataInputStream);
        return dnsMessage;
    }

    public static DnsMessage makeRequestMessage(String string, int n, int n2) throws IOException {
        DnsMessage dnsMessage = new DnsMessage();
        dnsMessage.header = DnsHeader.makeMulticastDnsQueryHeader();
        DnsQuestion dnsQuestion = DnsQuestion.makeQuestion(string, n, n2);
        dnsMessage.questions.add((Object)dnsQuestion);
        return dnsMessage;
    }

    public static DnsMessage make_PTR_RequestMessage(String string) throws IOException {
        return DnsMessage.makeRequestMessage(string, 12, 32769);
    }

    public static DnsMessage make_SRV_RequestMessage(String string) throws IOException {
        return DnsMessage.makeRequestMessage(string, 33, 32769);
    }

    public void read(DataInput dataInput) throws IOException {
        this.header = DnsHeader.readHeader(dataInput);
        int n = this.header.getQuestionCount();
        int n2 = 0;
        while (n2 < n) {
            DnsQuestion dnsQuestion = DnsQuestion.readQuestion(dataInput);
            this.addQuestion(dnsQuestion);
            ++n2;
        }
        n2 = this.header.getAnswerCount();
        int n3 = 0;
        while (n3 < n2) {
            DnsResourceRecord dnsResourceRecord = DnsResourceRecord.readResourceRecord(dataInput);
            this.addAnswer(dnsResourceRecord);
            ++n3;
        }
        n3 = this.header.getAuthorityCount();
        int n4 = 0;
        while (n4 < n3) {
            DnsResourceRecord dnsResourceRecord = DnsResourceRecord.readResourceRecord(dataInput);
            this.addAuthority(dnsResourceRecord);
            ++n4;
        }
        n4 = this.header.getAdditionalRecordCount();
        int n5 = 0;
        while (n5 < n4) {
            DnsResourceRecord dnsResourceRecord = DnsResourceRecord.readResourceRecord(dataInput);
            this.addAdditional(dnsResourceRecord);
            ++n5;
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        this.header.write(dataOutput);
        DnsQuestion[] dnsQuestionArray = this.getQuestions();
        int n = 0;
        while (n < dnsQuestionArray.length) {
            dnsQuestionArray[n].write(dataOutput);
            ++n;
        }
        DnsResourceRecord[] dnsResourceRecordArray = this.getAnswers();
        int n2 = 0;
        while (n2 < dnsResourceRecordArray.length) {
            dnsResourceRecordArray[n2].write(dataOutput);
            ++n2;
        }
        DnsResourceRecord[] dnsResourceRecordArray2 = this.getAuthorities();
        int n3 = 0;
        while (n3 < dnsResourceRecordArray2.length) {
            dnsResourceRecordArray2[n3].write(dataOutput);
            ++n3;
        }
        DnsResourceRecord[] dnsResourceRecordArray3 = this.getAdditionals();
        int n4 = 0;
        while (n4 < dnsResourceRecordArray3.length) {
            dnsResourceRecordArray3[n4].write(dataOutput);
            ++n4;
        }
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public DnsHeader getHeader() {
        return this.header;
    }

    public DnsQuestion[] getQuestions() {
        return (DnsQuestion[])this.questions.trim();
    }

    public void addQuestion(DnsQuestion dnsQuestion) {
        this.questions.add((Object)dnsQuestion);
    }

    public DnsResourceRecord[] getAnswers() {
        return (DnsResourceRecord[])this.answers.trim();
    }

    public void addAnswer(DnsResourceRecord dnsResourceRecord) {
        this.answers.add((Object)dnsResourceRecord);
    }

    public DnsResourceRecord[] getAuthorities() {
        return (DnsResourceRecord[])this.authorities.trim();
    }

    public void addAuthority(DnsResourceRecord dnsResourceRecord) {
        this.authorities.add((Object)dnsResourceRecord);
    }

    public DnsResourceRecord[] getAdditionals() {
        return (DnsResourceRecord[])this.additionals.trim();
    }

    public void addAdditional(DnsResourceRecord dnsResourceRecord) {
        this.additionals.add((Object)dnsResourceRecord);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$com$tridium$naxisVideo$discover$dns$DnsQuestion;
        if (clazz == null) {
            clazz = class$com$tridium$naxisVideo$discover$dns$DnsQuestion = DnsMessage.class("[Lcom.tridium.naxisVideo.discover.dns.DnsQuestion;", false);
        }
        this.questions = new Array(clazz);
        Class clazz2 = class$com$tridium$naxisVideo$discover$dns$DnsResourceRecord;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$naxisVideo$discover$dns$DnsResourceRecord = DnsMessage.class("[Lcom.tridium.naxisVideo.discover.dns.DnsResourceRecord;", false);
        }
        this.answers = new Array(clazz2);
        Class clazz3 = class$com$tridium$naxisVideo$discover$dns$DnsResourceRecord;
        if (clazz3 == null) {
            clazz3 = class$com$tridium$naxisVideo$discover$dns$DnsResourceRecord = DnsMessage.class("[Lcom.tridium.naxisVideo.discover.dns.DnsResourceRecord;", false);
        }
        this.authorities = new Array(clazz3);
        Class clazz4 = class$com$tridium$naxisVideo$discover$dns$DnsResourceRecord;
        if (clazz4 == null) {
            clazz4 = class$com$tridium$naxisVideo$discover$dns$DnsResourceRecord = DnsMessage.class("[Lcom.tridium.naxisVideo.discover.dns.DnsResourceRecord;", false);
        }
        this.additionals = new Array(clazz4);
    }

    public DnsMessage() {
        this.this();
    }
}

