/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.discover.dns;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.net.DatagramPacket;

public class DnsHeader {
    private int id;
    private int flags;
    private int qdCount;
    private int anCount;
    private int nsCount;
    private int arCount;

    public static void main(String[] stringArray) throws IOException {
        DnsHeader dnsHeader = DnsHeader.makeMulticastDnsQueryHeader();
        System.out.println(dnsHeader.getId());
        System.out.println(dnsHeader.getFlags());
        System.out.println(dnsHeader.getQuestionCount());
        System.out.println(dnsHeader.getAnswerCount());
        System.out.println(dnsHeader.getAuthorityCount());
        System.out.println(dnsHeader.getAdditionalRecordCount());
    }

    public static DnsHeader makeMulticastDnsQueryHeader() throws IOException {
        byte[] byArray = new byte[12];
        byArray[5] = 1;
        byte[] byArray2 = byArray;
        DnsHeader dnsHeader = new DnsHeader();
        dnsHeader.read(byArray2);
        return dnsHeader;
    }

    public static DnsHeader readHeader(DataInput dataInput) throws IOException {
        DnsHeader dnsHeader = new DnsHeader();
        dnsHeader.read(dataInput);
        return dnsHeader;
    }

    public void read(DataInput dataInput) throws IOException {
        this.id = dataInput.readUnsignedShort();
        this.flags = dataInput.readUnsignedShort();
        this.qdCount = dataInput.readUnsignedShort();
        this.anCount = dataInput.readUnsignedShort();
        this.nsCount = dataInput.readUnsignedShort();
        this.arCount = dataInput.readUnsignedShort();
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.id);
        dataOutput.writeShort(this.flags);
        dataOutput.writeShort(this.qdCount);
        dataOutput.writeShort(this.anCount);
        dataOutput.writeShort(this.nsCount);
        dataOutput.writeShort(this.arCount);
    }

    public void read(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.read(new DataInputStream(byteArrayInputStream));
    }

    public void read(DatagramPacket datagramPacket) throws IOException {
        this.read(datagramPacket.getData());
    }

    public void read(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length < 12) {
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.read(byteArrayInputStream);
    }

    public int getId() {
        return this.id;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getQueryFlag() {
        return (this.flags & 0x8000) >> 15;
    }

    public boolean isQuery() {
        boolean bl = false;
        if (this.getQueryFlag() == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isResponse() {
        return this.isQuery() ^ true;
    }

    public int getOpcode() {
        return (this.flags & 0x7800) >> 11;
    }

    public boolean isStandardQuery() {
        boolean bl = false;
        if (this.getOpcode() == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isInverseQuery() {
        boolean bl = false;
        if (this.getOpcode() == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isServerStatusRequest() {
        boolean bl = false;
        if (this.getOpcode() == 2) {
            bl = true;
        }
        return bl;
    }

    public int getAuthoritativeAnswerFlag() {
        return (this.flags & 0x400) >> 10;
    }

    public boolean isAuthoritativeAnswer() {
        boolean bl = false;
        if (this.getAuthoritativeAnswerFlag() == 1) {
            bl = true;
        }
        return bl;
    }

    public int getTruncationFlag() {
        return (this.flags & 0x200) >> 9;
    }

    public boolean isTruncated() {
        boolean bl = false;
        if (this.getTruncationFlag() == 1) {
            bl = true;
        }
        return bl;
    }

    public int getRecursionDesiredFlag() {
        return (this.flags & 0x100) >> 8;
    }

    public boolean isRecursionDesired() {
        boolean bl = false;
        if (this.getRecursionDesiredFlag() == 1) {
            bl = true;
        }
        return bl;
    }

    public int getRecusionAvailableFlag() {
        return (this.flags & 0x80) >> 7;
    }

    public boolean isRecursionAvailable() {
        boolean bl = false;
        if (this.getRecusionAvailableFlag() == 1) {
            bl = true;
        }
        return bl;
    }

    public int getReservedFlag() {
        return (this.flags & 0x70) >> 4;
    }

    public int getResponseCode() {
        return this.flags & 0xF;
    }

    public boolean isNoError() {
        boolean bl = false;
        if (this.getResponseCode() == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isFormatError() {
        boolean bl = false;
        if (this.getResponseCode() == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isServerFailure() {
        boolean bl = false;
        if (this.getResponseCode() == 2) {
            bl = true;
        }
        return bl;
    }

    public boolean isNameError() {
        boolean bl = false;
        if (this.getResponseCode() == 3) {
            bl = true;
        }
        return bl;
    }

    public boolean isNotImplemented() {
        boolean bl = false;
        if (this.getResponseCode() == 4) {
            bl = true;
        }
        return bl;
    }

    public boolean isOperationRefused() {
        boolean bl = false;
        if (this.getResponseCode() == 5) {
            bl = true;
        }
        return bl;
    }

    public int getQuestionCount() {
        return this.qdCount;
    }

    public int getAnswerCount() {
        return this.anCount;
    }

    public int getAuthorityCount() {
        return this.nsCount;
    }

    public int getAdditionalRecordCount() {
        return this.arCount;
    }
}

