/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarmOrion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import java.io.IOException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.alarmOrion.BOrionAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmFacetName;
import javax.baja.alarmOrion.BOrionAlarmFacetValue;
import javax.baja.alarmOrion.BOrionAlarmSource;
import javax.baja.alarmOrion.BOrionAlarmSourceOrder;
import javax.baja.data.BIDataValue;
import javax.baja.data.DataUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.query.BExpression;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.BOrdering;
import javax.baja.query.BQuery;
import javax.baja.query.util.Columns;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDate;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BUuid;

public class BOrionAlarmRecord
extends BOrionObject {
    public static final Property id = BOrionAlarmRecord.newProperty((int)9, (int)-1, (BFacets)BFacets.make((BFacets)ID_KEY, (BFacets)BFacets.make((String)"descending", (boolean)true)));
    public static final Property timestamp = BOrionAlarmRecord.newProperty((int)8, (BValue)BAbsTime.NULL, null);
    public static final Property datestamp = BOrionAlarmRecord.newProperty((int)8, (BValue)BDate.NULL, (BFacets)BFacets.make((String)"indexed", (boolean)true));
    public static final Property uuidHash = BOrionAlarmRecord.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"indexed", (boolean)true));
    public static final Property uuid = BOrionAlarmRecord.newProperty((int)0, (BValue)BUuid.make(), (BFacets)BFacets.NULL);
    public static final Property isOpen = BOrionAlarmRecord.newProperty((int)0, (boolean)false, null);
    public static final Property sourceState = BOrionAlarmRecord.newProperty((int)0, (BValue)BSourceState.offnormal, (BFacets)BFacets.make((String)"indexed", (boolean)true));
    public static final Property ackState = BOrionAlarmRecord.newProperty((int)0, (BValue)BAckState.unacked, (BFacets)BFacets.make((String)"indexed", (boolean)true));
    public static final Property ackRequired = BOrionAlarmRecord.newProperty((int)0, (boolean)true, null);
    public static final Property alarmClass = BOrionAlarmRecord.newProperty((int)8, (BValue)BRef.make((String)"alarmOrion:OrionAlarmClass"), (BFacets)BFacets.make((BFacets)BFacets.make((String)"onDelete", (int)1), (BFacets)BFacets.make((String)"autoResolve", (boolean)true)));
    public static final Property priority = BOrionAlarmRecord.newProperty((int)8, (int)0, null);
    public static final Property normalTime = BOrionAlarmRecord.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Property ackTime = BOrionAlarmRecord.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Property userAccount = BOrionAlarmRecord.newProperty((int)0, (String)"Unknown User", (BFacets)BFacets.make((String)"width", (int)32));
    public static final Property alarmTransition = BOrionAlarmRecord.newProperty((int)0, (BValue)BSourceState.offnormal, null);
    public static final Property lastUpdate = BOrionAlarmRecord.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$alarmOrion$BOrionAlarmRecord == null ? (class$javax$baja$alarmOrion$BOrionAlarmRecord = BOrionAlarmRecord.class$("javax.baja.alarmOrion.BOrionAlarmRecord")) : class$javax$baja$alarmOrion$BOrionAlarmRecord));
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    static /* synthetic */ Class class$javax$baja$alarmOrion$BOrionAlarmRecord;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$baja$data$BIDataValue;

    public int getId() {
        return this.getInt(id);
    }

    public void setId(int n) {
        this.setInt(id, n, null);
    }

    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    public void setTimestamp(BAbsTime bAbsTime) {
        this.set(timestamp, (BValue)bAbsTime, null);
    }

    public BDate getDatestamp() {
        return (BDate)this.get(datestamp);
    }

    public void setDatestamp(BDate bDate) {
        this.set(datestamp, (BValue)bDate, null);
    }

    public int getUuidHash() {
        return this.getInt(uuidHash);
    }

    public void setUuidHash(int n) {
        this.setInt(uuidHash, n, null);
    }

    public BUuid getUuid() {
        return (BUuid)this.get(uuid);
    }

    public void setUuid(BUuid bUuid) {
        this.set(uuid, (BValue)bUuid, null);
    }

    public boolean getIsOpen() {
        return this.getBoolean(isOpen);
    }

    public void setIsOpen(boolean bl) {
        this.setBoolean(isOpen, bl, null);
    }

    public BSourceState getSourceState() {
        return (BSourceState)this.get(sourceState);
    }

    public void setSourceState(BSourceState bSourceState) {
        this.set(sourceState, (BValue)bSourceState, null);
    }

    public BAckState getAckState() {
        return (BAckState)this.get(ackState);
    }

    public void setAckState(BAckState bAckState) {
        this.set(ackState, (BValue)bAckState, null);
    }

    public boolean getAckRequired() {
        return this.getBoolean(ackRequired);
    }

    public void setAckRequired(boolean bl) {
        this.setBoolean(ackRequired, bl, null);
    }

    public BRef getAlarmClass() {
        return (BRef)this.get(alarmClass);
    }

    public void setAlarmClass(BRef bRef) {
        this.set(alarmClass, (BValue)bRef, null);
    }

    public BOrionAlarmClass resolveAlarmClass(OrionSession orionSession) {
        return (BOrionAlarmClass)this.getAlarmClass().getTarget(orionSession);
    }

    public int getPriority() {
        return this.getInt(priority);
    }

    public void setPriority(int n) {
        this.setInt(priority, n, null);
    }

    public BAbsTime getNormalTime() {
        return (BAbsTime)this.get(normalTime);
    }

    public void setNormalTime(BAbsTime bAbsTime) {
        this.set(normalTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getAckTime() {
        return (BAbsTime)this.get(ackTime);
    }

    public void setAckTime(BAbsTime bAbsTime) {
        this.set(ackTime, (BValue)bAbsTime, null);
    }

    public String getUserAccount() {
        return this.getString(userAccount);
    }

    public void setUserAccount(String string) {
        this.setString(userAccount, string, null);
    }

    public BSourceState getAlarmTransition() {
        return (BSourceState)this.get(alarmTransition);
    }

    public void setAlarmTransition(BSourceState bSourceState) {
        this.set(alarmTransition, (BValue)bSourceState, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime bAbsTime) {
        this.set(lastUpdate, (BValue)bAbsTime, null);
    }

    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public static BOrionAlarmRecord make(BAlarmRecord bAlarmRecord, OrionSession orionSession) {
        BOrionAlarmClass bOrionAlarmClass = BOrionAlarmClass.get(bAlarmRecord.getAlarmClass(), orionSession);
        BOrionAlarmRecord bOrionAlarmRecord = new BOrionAlarmRecord();
        bOrionAlarmRecord.setTimestamp(bAlarmRecord.getTimestamp());
        bOrionAlarmRecord.setUuid(bAlarmRecord.getUuid());
        bOrionAlarmRecord.setSourceState(bAlarmRecord.getSourceState());
        bOrionAlarmRecord.setAckState(bAlarmRecord.getAckState());
        bOrionAlarmRecord.setAckRequired(bAlarmRecord.getAckRequired());
        bOrionAlarmRecord.setPriority(bAlarmRecord.getPriority());
        bOrionAlarmRecord.setNormalTime(bAlarmRecord.getNormalTime());
        bOrionAlarmRecord.setAckTime(bAlarmRecord.getAckTime());
        bOrionAlarmRecord.setUserAccount(bAlarmRecord.getUser());
        bOrionAlarmRecord.setAlarmTransition(bAlarmRecord.getAlarmTransition());
        bOrionAlarmRecord.setLastUpdate(bAlarmRecord.getLastUpdate());
        bOrionAlarmRecord.setAlarmClass(BRef.make((BIOrionObject)bOrionAlarmClass));
        return bOrionAlarmRecord;
    }

    public static BOrionAlarmRecord get(BUuid bUuid, OrionSession orionSession) {
        return (BOrionAlarmRecord)orionSession.read(ORION_TYPE, new PropertyValue(uuid, (BValue)bUuid));
    }

    public BAlarmRecord getAlarmRecord(OrionSession orionSession) {
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        bAlarmRecord.setTimestamp(this.getTimestamp());
        bAlarmRecord.setUuid(this.getUuid());
        bAlarmRecord.setSourceState(this.getSourceState());
        bAlarmRecord.setAckState(this.getAckState());
        bAlarmRecord.setAckRequired(this.getAckRequired());
        bAlarmRecord.setAlarmClass(this.getAlarmClass(orionSession));
        bAlarmRecord.setPriority(this.getPriority());
        bAlarmRecord.setNormalTime(this.getNormalTime());
        bAlarmRecord.setAckTime(this.getAckTime());
        bAlarmRecord.setUser(this.getUserAccount());
        bAlarmRecord.setAlarmTransition(this.getAlarmTransition());
        bAlarmRecord.setLastUpdate(this.getLastUpdate());
        bAlarmRecord.setSource(this.getSource(orionSession));
        bAlarmRecord.setAlarmData(this.getAlarmData(orionSession));
        return bAlarmRecord;
    }

    public String getAlarmClass(OrionSession orionSession) {
        return this.resolveAlarmClass(orionSession).getAlarmClass();
    }

    public BOrdList getSource(OrionSession orionSession) {
        BSqlExtent bSqlExtent = new BSqlExtent(BOrionAlarmSource.ORION_TYPE);
        BSqlExtent bSqlExtent2 = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE);
        BSqlQuery bSqlQuery = BSqlQuery.make((OrionType)BOrionAlarmSourceOrder.ORION_TYPE);
        bSqlQuery.join(new BSqlJoin(new BSqlField(bSqlExtent2, BOrionAlarmSourceOrder.alarmSource), new BSqlField(bSqlExtent, BOrionAlarmSource.id)));
        bSqlQuery.where(Exprs.builder((BExpression)Predicates.eq((Property)BOrionAlarmSourceOrder.alarm, (BSimple)BRef.make((BIOrionObject)this))));
        bSqlQuery.orderBy(BOrdering.make((BOrderByColumn)Columns.orderBy((BExpression)Exprs.field((Property)BOrionAlarmSourceOrder.sourceOrder)).asc()));
        OrionCursor orionCursor = orionSession.select((BQuery)bSqlQuery);
        try {
            Object object;
            BOrdList bOrdList = BOrdList.make((BOrd[])new BOrd[0]);
            while (orionCursor.next()) {
                object = (BOrionAlarmSourceOrder)orionCursor.get();
                bOrdList = BOrdList.add((BOrdList)bOrdList, (BOrd)((BOrionAlarmSourceOrder)((Object)object)).resolveAlarmSource(orionSession).getSource());
            }
            object = bOrdList;
            return object;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException("Unable to load alarm source (" + this.getUuid() + ").", (Throwable)exception);
        }
        finally {
            if (orionCursor != null) {
                orionCursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFacets getAlarmData(OrionSession orionSession) {
        BSqlQuery bSqlQuery = BSqlQuery.make((OrionType)BOrionAlarmFacetValue.ORION_TYPE);
        bSqlQuery.where(Exprs.builder((BExpression)Predicates.eq((Property)BOrionAlarmFacetValue.alarm, (BSimple)BRef.make((BIOrionObject)this))));
        OrionCursor orionCursor = orionSession.select((BQuery)bSqlQuery);
        try {
            Object object;
            BOrionAlarmFacetValue bOrionAlarmFacetValue;
            Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BOrionAlarmRecord.class$("java.lang.String")) : class$java$lang$String);
            Array array2 = new Array(class$javax$baja$data$BIDataValue == null ? (class$javax$baja$data$BIDataValue = BOrionAlarmRecord.class$("javax.baja.data.BIDataValue")) : class$javax$baja$data$BIDataValue);
            while (orionCursor.next()) {
                try {
                    bOrionAlarmFacetValue = (BOrionAlarmFacetValue)orionCursor.get();
                    object = bOrionAlarmFacetValue.resolveFacetName(orionSession).getFacetName();
                    BIDataValue bIDataValue = (BIDataValue)DataUtil.unmarshal((String)bOrionAlarmFacetValue.getValue());
                    array.add(object);
                    array2.add((Object)bIDataValue);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            bOrionAlarmFacetValue = BFacets.make((String[])((String[])array.trim()), (BIDataValue[])((BIDataValue[])array2.trim()));
            object = bOrionAlarmFacetValue;
            return object;
        }
        catch (Exception exception) {
            BOrionAlarmDatabase.log.error("Unable to retrieve alarm facets from database.", (Throwable)exception);
            BFacets bFacets = BFacets.NULL;
            return bFacets;
        }
        finally {
            orionCursor.close();
        }
    }

    public BIDataValue getAlarmData(String string, OrionSession orionSession) {
        BSqlQuery bSqlQuery = BSqlQuery.make((OrionType)BOrionAlarmFacetValue.ORION_TYPE);
        BSqlExtent bSqlExtent = new BSqlExtent(BOrionAlarmFacetName.ORION_TYPE).alias("facetName");
        BSqlExtent bSqlExtent2 = new BSqlExtent(BOrionAlarmFacetValue.ORION_TYPE).alias("facetValue");
        bSqlQuery.join(new BSqlJoin(new BSqlField(bSqlExtent, BOrionAlarmFacetName.id), new BSqlField(bSqlExtent2, BOrionAlarmFacetValue.facetName)));
        bSqlQuery.where(Exprs.builder((BExpression)Predicates.eq((Property)BOrionAlarmFacetName.facetName, (BSimple)BString.make((String)string))).and(Predicates.eq((Property)BOrionAlarmFacetValue.alarm, (BSimple)BInteger.make((int)this.getId()))));
        OrionCursor orionCursor = orionSession.select((BQuery)bSqlQuery);
        if (orionCursor.next()) {
            try {
                BOrionAlarmFacetValue bOrionAlarmFacetValue = (BOrionAlarmFacetValue)orionCursor.get();
                BIDataValue bIDataValue = (BIDataValue)DataUtil.unmarshal((String)bOrionAlarmFacetValue.getValue());
                return bIDataValue;
            }
            catch (IOException iOException) {
                throw new BajaRuntimeException("Unable to unmarshal data value");
            }
            finally {
                orionCursor.close();
            }
        }
        return null;
    }

    public boolean isAlarm() {
        return this.getSourceState() != BSourceState.normal && this.getAckState() != BAckState.acked;
    }

    public boolean isAcknowledged() {
        return this.getAckState() == BAckState.acked;
    }

    public boolean isAckPending() {
        return this.getAckState() == BAckState.ackPending;
    }

    public boolean isNormal() {
        return this.getSourceState() == BSourceState.normal;
    }

    public boolean isOpen() {
        if (this.getSourceState() == BSourceState.alert && this.getAckState() != BAckState.acked) {
            return true;
        }
        return this.getAckState() != BAckState.acked && this.getAckRequired() || this.getSourceState() != BSourceState.normal && this.getSourceState() != BSourceState.alert;
    }

    public void changed(Property property, Context context) {
        if (property.equals(timestamp)) {
            this.setDatestamp(BDate.make((BAbsTime)this.getTimestamp()));
        }
        if (property.equals(uuid)) {
            this.setUuidHash(this.getUuid().hashCode());
        }
        super.changed(property, context);
    }

    public boolean beforeInsert(OrionSession orionSession) {
        this.setIsOpen(this.isOpen());
        this.setUuidHash(this.getUuid().hashCode());
        return super.beforeInsert(orionSession);
    }

    public boolean beforeUpdate(OrionSession orionSession) {
        this.setIsOpen(this.isOpen());
        this.setUuidHash(this.getUuid().hashCode());
        return super.beforeUpdate(orionSession);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

