/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarmOrion;

import com.tridium.alarmOrion.OrionAlarmCursor;
import com.tridium.alarmOrion.transactions.AlarmRecordTransaction;
import com.tridium.alarmOrion.transactions.AppendAlarmRecord;
import com.tridium.alarmOrion.transactions.BOrionAlarmTransactionStatistics;
import com.tridium.alarmOrion.transactions.ClearAlarmRecord;
import com.tridium.alarmOrion.transactions.ToNormal;
import com.tridium.alarmOrion.transactions.UpdateAlarmRecord;
import com.tridium.bql.Range;
import com.tridium.bql.RangeSet;
import com.tridium.bql.SelectQuery;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.sql.BExtentProjection;
import com.tridium.orion.sql.BSqlCase;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.orion.sql.SqlColumns;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarmOrion.BOrionAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmFacetName;
import javax.baja.alarmOrion.BOrionAlarmFacetValue;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.alarmOrion.BOrionAlarmSource;
import javax.baja.alarmOrion.BOrionAlarmSourceOrder;
import javax.baja.bql.BqlQuery;
import javax.baja.data.BIDataValue;
import javax.baja.data.DataUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.query.BExpression;
import javax.baja.query.BExtent;
import javax.baja.query.BGroupByColumn;
import javax.baja.query.BGrouping;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.BOrdering;
import javax.baja.query.BProjection;
import javax.baja.query.BQuery;
import javax.baja.query.util.Columns;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.rdb.BRdbms;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDate;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Queue;

public class BOrionAlarmDatabase
extends BAlarmDatabase {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$alarmOrion$BOrionAlarmDatabase == null ? (class$javax$baja$alarmOrion$BOrionAlarmDatabase = BOrionAlarmDatabase.class$("javax.baja.alarmOrion.BOrionAlarmDatabase")) : class$javax$baja$alarmOrion$BOrionAlarmDatabase));
    public final Object exclusiveAccessMutex = new Integer(0);
    public boolean open = false;
    static /* synthetic */ Class class$javax$baja$alarmOrion$BOrionAlarmDatabase;
    static /* synthetic */ Class class$com$tridium$alarmOrion$transactions$BOrionAlarmTransactionStatistics;

    public Type getType() {
        return TYPE;
    }

    public boolean isOpen() {
        BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        return this.open && super.isOpen() && bOrionService.isOrionReady() && this.getStatus().isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOpen() throws IOException {
        BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        if (bOrionService.isOrionReady()) {
            BAbsTime bAbsTime = BAbsTime.now();
            OrionSession orionSession = this.getOrionSession(null);
            int n = 0;
            try {
                OrionCursor orionCursor = orionSession.scan(BOrionAlarmClass.ORION_TYPE);
                while (orionCursor.next()) {
                    BOrionAlarmClass bOrionAlarmClass = (BOrionAlarmClass)orionCursor.get();
                    bOrionAlarmClass.updateAlarmClass();
                    n += bOrionAlarmClass.getTotalAlarmCount();
                }
            }
            finally {
                orionSession.close();
                log.message("Loaded " + n + " alarms (" + bAbsTime.delta(BAbsTime.now()) + ")");
            }
        }
        this.open = true;
    }

    protected void doClose() {
        this.open = false;
        Queue queue = this.getQueue();
        if (log.isTraceOn()) {
            log.message("Flushing queued transactions.");
        }
        while (!queue.isEmpty()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllRecords(Context context) throws IOException {
        BAlarmClass[] bAlarmClassArray;
        Object object = this.exclusiveAccessMutex;
        synchronized (object) {
            bAlarmClassArray = null;
            try {
                bAlarmClassArray = this.getOrionSession(context);
                bAlarmClassArray.delete(BOrionAlarmRecord.ORION_TYPE, null);
            }
            finally {
                if (bAlarmClassArray != null) {
                    bAlarmClassArray.close();
                }
            }
        }
        object = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        bAlarmClassArray = object.getAlarmClasses();
        for (int i = 0; i < bAlarmClassArray.length; ++i) {
            BAlarmClass bAlarmClass = bAlarmClassArray[i];
            bAlarmClass.setUnackedAlarmCount(0);
            bAlarmClass.setOpenAlarmCount(0);
            bAlarmClass.setInAlarmCount(0);
            bAlarmClass.setTotalAlarmCount(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOldRecords(BAbsTime bAbsTime, Context context) throws IOException {
        Object object = this.exclusiveAccessMutex;
        synchronized (object) {
            OrionSession orionSession = null;
            try {
                orionSession = this.getOrionSession(context);
                BExpression bExpression = Exprs.builder((BExpression)Predicates.lt((Property)BOrionAlarmRecord.datestamp, (BSimple)BDate.make((BAbsTime)bAbsTime).nextDay())).and(Predicates.lt((Property)BOrionAlarmRecord.timestamp, (BSimple)bAbsTime)).getExpression();
                orionSession.delete(BOrionAlarmRecord.ORION_TYPE, bExpression);
            }
            finally {
                if (orionSession != null) {
                    orionSession.close();
                }
            }
        }
        this.recalculateAlarmClassStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculateAlarmClassStatistics() {
        OrionSession orionSession = this.getOrionSession(null);
        try {
            BInteger bInteger;
            BInteger bInteger2;
            BInteger bInteger3;
            BInteger bInteger4;
            BDynamicOrionObject bDynamicOrionObject;
            BOrionAlarmClass bOrionAlarmClass;
            BatchStatement batchStatement;
            BOrionAlarmService bOrionAlarmService = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
            BSqlQuery bSqlQuery = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
            BSqlExtent bSqlExtent = new BSqlExtent(BOrionAlarmClass.ORION_TYPE).alias("alarmClass");
            Object object = new BProjection();
            BAlarmClass[] bAlarmClassArray = new BSqlCase((BExpression)new BSqlField(BOrionAlarmRecord.ORION_TYPE, BOrionAlarmRecord.ackState));
            bAlarmClassArray.whenThen((BExpression)Exprs.simple((BSimple)BAckState.acked), Exprs.Null());
            bAlarmClassArray.setElse((BExpression)Exprs.simple((BSimple)BInteger.make((int)1)));
            object.add(SqlColumns.make((BExpression)Funcs.count((BExpression)bAlarmClassArray)).as("unackedAlarms"));
            bAlarmClassArray = new BSqlCase((BExpression)new BSqlField(BOrionAlarmRecord.ORION_TYPE, BOrionAlarmRecord.isOpen));
            bAlarmClassArray.whenThen((BExpression)Exprs.simple((BSimple)BBoolean.TRUE), (BExpression)Exprs.simple((BSimple)BInteger.make((int)1)));
            bAlarmClassArray.setElse(Exprs.Null());
            object.add(SqlColumns.make((BExpression)Funcs.count((BExpression)bAlarmClassArray)).as("openAlarms"));
            bAlarmClassArray = new BSqlCase((BExpression)new BSqlField(BOrionAlarmRecord.ORION_TYPE, BOrionAlarmRecord.sourceState));
            bAlarmClassArray.whenThen((BExpression)Exprs.simple((BSimple)BInteger.make((int)0)), Exprs.Null());
            bAlarmClassArray.setElse((BExpression)Exprs.simple((BSimple)BInteger.make((int)1)));
            object.add(SqlColumns.make((BExpression)Funcs.count((BExpression)bAlarmClassArray)).as("inAlarm"));
            object.add(SqlColumns.make((BExpression)Funcs.count((BExpression)Exprs.simple((BSimple)BInteger.make((int)1)))).as("totalAlarms"));
            object.add(SqlColumns.make((BExpression)Funcs.make((String)"MAX", (Type)BAbsTime.TYPE, (String)BOrionAlarmRecord.timestamp.getName())).as("lastAlarm"));
            object.add(SqlColumns.make((BSqlField)new BSqlField(bSqlExtent, BOrionAlarmClass.alarmClass)));
            bSqlQuery.select((BProjection)object);
            bSqlQuery.join(new BSqlJoin(new BSqlField(BOrionAlarmRecord.ORION_TYPE, BOrionAlarmRecord.alarmClass), new BSqlField(bSqlExtent, BOrionAlarmClass.id)));
            object = new BGrouping();
            object.add(new BGroupByColumn((BExpression)new BSqlField(bSqlExtent, BOrionAlarmClass.id)));
            object.add(new BGroupByColumn((BExpression)new BSqlField(bSqlExtent, BOrionAlarmClass.alarmClass)));
            bSqlQuery.groupBy((BGrouping)object);
            bSqlExtent = orionSession.select((BQuery)bSqlQuery);
            object = new HashMap();
            while (bSqlExtent.next()) {
                bAlarmClassArray = (BDynamicOrionObject)bSqlExtent.get();
                batchStatement = (BString)bAlarmClassArray.get(BOrionAlarmRecord.alarmClass);
                ((HashMap)object).put(batchStatement.toString(), bAlarmClassArray);
            }
            bAlarmClassArray = orionSession.batchUpdate(BOrionAlarmClass.ORION_TYPE);
            batchStatement = orionSession.batchDelete(BOrionAlarmClass.ORION_TYPE);
            OrionCursor orionCursor = orionSession.scan(BOrionAlarmClass.ORION_TYPE);
            while (orionCursor.next()) {
                bOrionAlarmClass = (BOrionAlarmClass)orionCursor.get();
                bDynamicOrionObject = (BDynamicOrionObject)((HashMap)object).get(bOrionAlarmClass.getAlarmClass());
                if (bDynamicOrionObject == null) {
                    batchStatement.add((BIOrionObject)bOrionAlarmClass);
                    continue;
                }
                bInteger4 = (BInteger)bDynamicOrionObject.get("unackedAlarms");
                bInteger3 = (BInteger)bDynamicOrionObject.get("openAlarms");
                bInteger2 = (BInteger)bDynamicOrionObject.get("inAlarm");
                bInteger = (BInteger)bDynamicOrionObject.get("totalAlarms");
                BAbsTime bAbsTime = (BAbsTime)bDynamicOrionObject.get("lastAlarm");
                bOrionAlarmClass.setUnackedAlarmCount(bInteger4.getInt());
                bOrionAlarmClass.setOpenAlarmCount(bInteger3.getInt());
                bOrionAlarmClass.setInAlarmCount(bInteger2.getInt());
                bOrionAlarmClass.setTotalAlarmCount(bInteger.getInt());
                bOrionAlarmClass.setTimeOfLastAlarm(bAbsTime);
                bAlarmClassArray.add((BIOrionObject)bOrionAlarmClass);
            }
            bAlarmClassArray.execute();
            batchStatement.execute();
            bAlarmClassArray = bOrionAlarmService.getAlarmClasses();
            for (int i = 0; i < bAlarmClassArray.length; ++i) {
                orionCursor = bAlarmClassArray[i];
                bOrionAlarmClass = (BDynamicOrionObject)((HashMap)object).get(orionCursor.getName());
                if (bOrionAlarmClass == null) {
                    orionCursor.setUnackedAlarmCount(0);
                    orionCursor.setOpenAlarmCount(0);
                    orionCursor.setInAlarmCount(0);
                    orionCursor.setTotalAlarmCount(0);
                    continue;
                }
                bDynamicOrionObject = (BInteger)bOrionAlarmClass.get("unackedAlarms");
                bInteger4 = (BInteger)bOrionAlarmClass.get("openAlarms");
                bInteger3 = (BInteger)bOrionAlarmClass.get("inAlarm");
                bInteger2 = (BInteger)bOrionAlarmClass.get("totalAlarms");
                bInteger = (BAbsTime)bOrionAlarmClass.get("lastAlarm");
                orionCursor.setUnackedAlarmCount(bDynamicOrionObject.getInt());
                orionCursor.setOpenAlarmCount(bInteger4.getInt());
                orionCursor.setInAlarmCount(bInteger3.getInt());
                orionCursor.setTotalAlarmCount(bInteger2.getInt());
                orionCursor.setTimeOfLastAlarm((BAbsTime)bInteger);
            }
        }
        finally {
            orionSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor getAckPendingAlarms() throws IOException {
        BSqlQuery bSqlQuery = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        bSqlQuery.where(Predicates.eq((Property)BOrionAlarmRecord.ackState, (BSimple)BAckState.ackPending));
        BOrdering bOrdering = new BOrdering();
        bOrdering.add(Columns.orderBy((BExpression)Exprs.field((Property)BOrionAlarmRecord.id)).desc());
        bSqlQuery.orderBy(bOrdering);
        bOrdering = BSqlQuery.make((OrionType)BOrionAlarmFacetValue.ORION_TYPE);
        BSqlExtent bSqlExtent = new BSqlExtent(BOrionAlarmFacetValue.ORION_TYPE);
        Object object = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        bOrdering.where(Predicates.eq((Property)BOrionAlarmRecord.ackState, (BSimple)BAckState.ackPending));
        bOrdering.join(new BSqlJoin(new BSqlField(bSqlExtent, BOrionAlarmFacetValue.alarm), new BSqlField(object, BOrionAlarmRecord.id)));
        BOrdering bOrdering2 = new BOrdering();
        bOrdering2.add(Columns.orderBy((BExpression)new BSqlField(object, BOrionAlarmRecord.id)).desc());
        bOrdering.orderBy(bOrdering2);
        bSqlExtent = BSqlQuery.make((OrionType)BOrionAlarmSourceOrder.ORION_TYPE);
        object = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE);
        bOrdering2 = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        bSqlExtent.where(Predicates.eq((Property)BOrionAlarmRecord.ackState, (BSimple)BAckState.ackPending));
        bSqlExtent.join(new BSqlJoin(new BSqlField(object, BOrionAlarmSourceOrder.alarm), new BSqlField((BSqlExtent)bOrdering2, BOrionAlarmRecord.id)));
        BOrdering bOrdering3 = new BOrdering();
        bOrdering3.add(Columns.orderBy((BExpression)new BSqlField((BSqlExtent)bOrdering2, BOrionAlarmRecord.id)).desc());
        bOrdering3.add(Columns.orderBy((BExpression)new BSqlField(object, BOrionAlarmSourceOrder.sourceOrder)));
        bSqlExtent.orderBy(bOrdering3);
        object = this.exclusiveAccessMutex;
        synchronized (object) {
            bOrdering2 = this.getOrionSession(null);
            return new OrionAlarmCursor(bOrdering2.select((BQuery)bSqlQuery), bOrdering2.select((BQuery)bOrdering), bOrdering2.select((BQuery)bSqlExtent), (OrionSession)bOrdering2);
        }
    }

    public Cursor getAlarmsForSource(BOrdList bOrdList) throws IOException {
        OrionSession orionSession = this.getOrionSession(null);
        BSqlQuery bSqlQuery = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        BExpression bExpression = null;
        BSqlExtent bSqlExtent = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        for (int i = 0; i < bOrdList.size(); ++i) {
            BSqlExtent bSqlExtent2 = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE).alias("sourceOrder" + i);
            BSqlExtent bSqlExtent3 = new BSqlExtent(BOrionAlarmSource.ORION_TYPE).alias("alarmSource" + i);
            bSqlQuery.join(new BSqlJoin(new BSqlField(bSqlExtent, BOrionAlarmRecord.id), new BSqlField(bSqlExtent2, BOrionAlarmSourceOrder.alarm)));
            bSqlQuery.join(new BSqlJoin(new BSqlField(bSqlExtent2, BOrionAlarmSourceOrder.alarmSource), new BSqlField(bSqlExtent3, BOrionAlarmSource.id)));
            BExpression bExpression2 = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(bSqlExtent2, BOrionAlarmSourceOrder.sourceOrder), (BSimple)BInteger.make((int)i))).and(Predicates.eq((BExpression)new BSqlField(bSqlExtent3, BOrionAlarmSource.source), (BSimple)bOrdList.get(i))).getExpression();
            bExpression = bExpression == null ? bExpression2 : Exprs.builder((BExpression)bExpression).and(bExpression2).getExpression();
        }
        bSqlQuery.where(bExpression);
        bSqlQuery.orderBy(BOrdering.make((BOrderByColumn)Columns.orderBy((BExpression)new BSqlField(bSqlExtent, BOrionAlarmRecord.id)).desc()));
        OrionCursor orionCursor = orionSession.select((BQuery)bSqlQuery);
        return new OrionAlarmCursor(orionCursor, orionSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor getOpenAlarms() throws IOException {
        BSqlQuery bSqlQuery = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        bSqlQuery.where(Exprs.builder((BExpression)Predicates.eq((Property)BOrionAlarmRecord.isOpen, (BSimple)BBoolean.TRUE)));
        BOrdering bOrdering = new BOrdering();
        bOrdering.add(Columns.orderBy((BExpression)Exprs.field((Property)BOrionAlarmRecord.id)).desc());
        bSqlQuery.orderBy(bOrdering);
        bOrdering = BSqlQuery.make((OrionType)BOrionAlarmFacetValue.ORION_TYPE);
        BSqlExtent bSqlExtent = new BSqlExtent(BOrionAlarmFacetValue.ORION_TYPE);
        Object object = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        bOrdering.join(new BSqlJoin(new BSqlField(bSqlExtent, BOrionAlarmFacetValue.alarm), new BSqlField(object, BOrionAlarmRecord.id)));
        bOrdering.where(Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(object, BOrionAlarmRecord.isOpen), (BSimple)BBoolean.TRUE)));
        BOrdering bOrdering2 = new BOrdering();
        bOrdering2.add(Columns.orderBy((BExpression)new BSqlField(bSqlExtent, BOrionAlarmFacetValue.alarm)).desc());
        bOrdering.orderBy(bOrdering2);
        bSqlExtent = BSqlQuery.make((OrionType)BOrionAlarmSourceOrder.ORION_TYPE);
        object = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE);
        bOrdering2 = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        bSqlExtent.join(new BSqlJoin(new BSqlField(object, BOrionAlarmSourceOrder.alarm), new BSqlField((BSqlExtent)bOrdering2, BOrionAlarmRecord.id)));
        bSqlExtent.where(Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField((BSqlExtent)bOrdering2, BOrionAlarmRecord.isOpen), (BSimple)BBoolean.TRUE)));
        BOrdering bOrdering3 = new BOrdering();
        bOrdering3.add(Columns.orderBy((BExpression)new BSqlField(object, BOrionAlarmSourceOrder.alarm)).desc());
        bOrdering3.add(Columns.orderBy((BExpression)new BSqlField(object, BOrionAlarmSourceOrder.sourceOrder)));
        bSqlExtent.orderBy(bOrdering3);
        object = this.exclusiveAccessMutex;
        synchronized (object) {
            bOrdering2 = this.getOrionSession(null);
            bOrdering3 = bOrdering2.select((BQuery)bSqlQuery);
            OrionCursor orionCursor = bOrdering2.select((BQuery)bOrdering);
            OrionCursor orionCursor2 = bOrdering2.select((BQuery)bSqlExtent);
            return new OrionAlarmCursor((OrionCursor)bOrdering3, orionCursor, orionCursor2, (OrionSession)bOrdering2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAlarmRecord getRecord(BUuid bUuid) {
        OrionSession orionSession = this.getOrionSession(null);
        try {
            BAlarmRecord bAlarmRecord = this.getRecord(bUuid, orionSession);
            return bAlarmRecord;
        }
        finally {
            orionSession.close();
        }
    }

    public BAlarmRecord getRecord(BUuid bUuid, OrionSession orionSession) {
        BOrionAlarmRecord bOrionAlarmRecord = this.getOrionRecord(bUuid, orionSession);
        if (bOrionAlarmRecord != null) {
            return bOrionAlarmRecord.getAlarmRecord(orionSession);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrionAlarmRecord getOrionRecord(BUuid bUuid) {
        OrionSession orionSession = this.getOrionSession(null);
        try {
            BOrionAlarmRecord bOrionAlarmRecord = this.getOrionRecord(bUuid, orionSession);
            return bOrionAlarmRecord;
        }
        finally {
            orionSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrionAlarmRecord getOrionRecord(BUuid bUuid, OrionSession orionSession) {
        OrionCursor orionCursor = orionSession.select(BOrionAlarmRecord.ORION_TYPE, new PropertyValue[]{new PropertyValue(BOrionAlarmRecord.uuidHash, (BValue)BInteger.make((int)bUuid.hashCode())), new PropertyValue(BOrionAlarmRecord.uuid, (BValue)bUuid)});
        try {
            if (orionCursor.next()) {
                BOrionAlarmRecord bOrionAlarmRecord = (BOrionAlarmRecord)orionCursor.get();
                return bOrionAlarmRecord;
            }
            BOrionAlarmRecord bOrionAlarmRecord = null;
            return bOrionAlarmRecord;
        }
        finally {
            orionCursor.close();
        }
    }

    public int getRecordCount() {
        int n = 0;
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmClass[] bAlarmClassArray = bAlarmService.getAlarmClasses();
        for (int i = 0; i < bAlarmClassArray.length; ++i) {
            n += bAlarmClassArray[i].getTotalAlarmCount();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor scan() throws IOException, AlarmException {
        BSqlQuery bSqlQuery = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        BOrdering bOrdering = new BOrdering();
        bOrdering.add(Columns.orderBy((BExpression)Exprs.field((Property)BOrionAlarmRecord.id)));
        bSqlQuery.orderBy(bOrdering);
        bOrdering = BSqlQuery.make((OrionType)BOrionAlarmFacetValue.ORION_TYPE);
        BSqlExtent bSqlExtent = new BSqlExtent(BOrionAlarmFacetValue.ORION_TYPE);
        Object object = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        bOrdering.join(new BSqlJoin(new BSqlField(object, BOrionAlarmRecord.id), new BSqlField(bSqlExtent, BOrionAlarmFacetValue.alarm)));
        BOrdering bOrdering2 = new BOrdering();
        bOrdering2.add(Columns.orderBy((BExpression)new BSqlField(object, BOrionAlarmRecord.id)).desc());
        bOrdering.orderBy(bOrdering2);
        bSqlExtent = BSqlQuery.make((OrionType)BOrionAlarmSourceOrder.ORION_TYPE);
        object = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE);
        bOrdering2 = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        bSqlExtent.join(new BSqlJoin(new BSqlField((BSqlExtent)bOrdering2, BOrionAlarmRecord.id), new BSqlField(object, BOrionAlarmFacetValue.alarm)));
        BOrdering bOrdering3 = new BOrdering();
        bOrdering3.add(Columns.orderBy((BExpression)new BSqlField((BSqlExtent)bOrdering2, BOrionAlarmRecord.id)).desc());
        bOrdering3.add(Columns.orderBy((BExpression)new BSqlField(object, BOrionAlarmSourceOrder.sourceOrder)));
        bSqlExtent.orderBy(bOrdering3);
        object = this.exclusiveAccessMutex;
        synchronized (object) {
            bOrdering2 = this.getOrionSession(null);
            bOrdering3 = bOrdering2.select((BQuery)bSqlQuery);
            OrionCursor orionCursor = bOrdering2.select((BQuery)bOrdering);
            OrionCursor orionCursor2 = bOrdering2.select((BQuery)bSqlExtent);
            return new OrionAlarmCursor((OrionCursor)bOrdering3, orionCursor, orionCursor2, (OrionSession)bOrdering2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor timeQuery(BAbsTime bAbsTime, BAbsTime bAbsTime2) throws IOException, AlarmException {
        BSqlQuery bSqlQuery = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        bSqlQuery.where(Exprs.builder((BExpression)Predicates.gt((Property)BOrionAlarmRecord.timestamp, (BSimple)bAbsTime)).and(Predicates.lt((Property)BOrionAlarmRecord.timestamp, (BSimple)bAbsTime2)));
        BOrdering bOrdering = new BOrdering();
        bOrdering.add(Columns.orderBy((BExpression)Exprs.field((Property)BOrionAlarmRecord.id)).desc());
        bSqlQuery.orderBy(bOrdering);
        bOrdering = BSqlQuery.make((OrionType)BOrionAlarmFacetValue.ORION_TYPE);
        BSqlExtent bSqlExtent = new BSqlExtent(BOrionAlarmFacetValue.ORION_TYPE);
        Object object = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        bSqlQuery.join(new BSqlJoin(new BSqlField(object, BOrionAlarmRecord.id), new BSqlField(bSqlExtent, BOrionAlarmFacetValue.alarm)));
        bOrdering.where(Exprs.builder((BExpression)Predicates.gt((Property)BOrionAlarmRecord.timestamp, (BSimple)bAbsTime)).and(Predicates.lt((Property)BOrionAlarmRecord.timestamp, (BSimple)bAbsTime2)));
        BOrdering bOrdering2 = new BOrdering();
        bOrdering2.add(Columns.orderBy((BExpression)new BSqlField(object, BOrionAlarmRecord.id)).desc());
        bOrdering.orderBy(bOrdering2);
        bSqlExtent = BSqlQuery.make((OrionType)BOrionAlarmSourceOrder.ORION_TYPE);
        object = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE);
        bOrdering2 = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        bSqlQuery.join(new BSqlJoin(new BSqlField((BSqlExtent)bOrdering2, BOrionAlarmRecord.id), new BSqlField(object, BOrionAlarmFacetValue.alarm)));
        bOrdering.where(Exprs.builder((BExpression)Predicates.gt((Property)BOrionAlarmRecord.timestamp, (BSimple)bAbsTime)).and(Predicates.lt((Property)BOrionAlarmRecord.timestamp, (BSimple)bAbsTime2)));
        BOrdering bOrdering3 = new BOrdering();
        bOrdering3.add(Columns.orderBy((BExpression)new BSqlField((BSqlExtent)bOrdering2, BOrionAlarmRecord.id)).desc());
        bOrdering3.add(Columns.orderBy((BExpression)new BSqlField(object, BOrionAlarmSourceOrder.sourceOrder)));
        bSqlExtent.orderBy(bOrdering3);
        object = this.exclusiveAccessMutex;
        synchronized (object) {
            bOrdering2 = this.getOrionSession(null);
            bOrdering3 = bOrdering2.select((BQuery)bSqlQuery);
            OrionCursor orionCursor = bOrdering2.select((BQuery)bOrdering);
            OrionCursor orionCursor2 = bOrdering2.select((BQuery)bSqlExtent);
            return new OrionAlarmCursor((OrionCursor)bOrdering3, orionCursor, orionCursor2, (OrionSession)bOrdering2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor doBqlQuery(BqlQuery bqlQuery) throws AlarmException {
        if (log.isTraceOn()) {
            log.trace("Executing bql " + bqlQuery.toString());
        }
        try {
            Range range;
            BAbsTime bAbsTime;
            Object object;
            Property property;
            SelectQuery selectQuery = (SelectQuery)bqlQuery;
            BSqlQuery bSqlQuery = (BSqlQuery)new BSqlQuery().select((BProjection)new BExtentProjection());
            bSqlQuery.getProjection().setDistinct(true);
            Object object2 = null;
            BSqlExtent bSqlExtent = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE).alias("alarms");
            Object object3 = new BOrionAlarmRecord().getProperties();
            while (object3.next()) {
                RangeSet rangeSet;
                property = object3.property();
                if (property.getType().is(BRef.TYPE) || (rangeSet = selectQuery.getRange(property.getName(), property.getType(), false)).isAll()) continue;
                object2 = object2 == null ? this.createExpression(rangeSet, property) : Exprs.builder(object2).and(this.createExpression(rangeSet, property)).getExpression();
                if (!property.equals(BOrionAlarmRecord.timestamp)) continue;
                object = (BAbsTime)rangeSet.getRange((int)0).max;
                bAbsTime = (BAbsTime)rangeSet.getRange((int)0).min;
                for (int i = 1; i < rangeSet.getCount(); ++i) {
                    range = rangeSet.getRange(i);
                    if (object != null && (range.max == null || ((BAbsTime)range.max).isAfter(object))) {
                        object = (BAbsTime)range.max;
                    }
                    if (bAbsTime == null || range.min != null && !((BAbsTime)range.min).isBefore(bAbsTime)) continue;
                    bAbsTime = (BAbsTime)range.min;
                }
                if (bAbsTime != null) {
                    object2 = Exprs.builder((BExpression)object2).and(Predicates.gt((Property)BOrionAlarmRecord.datestamp, (BSimple)BDate.make((BAbsTime)bAbsTime).prevDay())).getExpression();
                }
                if (object == null) continue;
                object2 = Exprs.builder((BExpression)object2).and(Predicates.lt((Property)BOrionAlarmRecord.datestamp, (BSimple)BDate.make((BAbsTime)object).nextDay())).getExpression();
            }
            object3 = selectQuery.getRange("source", BOrdList.TYPE, true);
            if (!object3.isAll() && object3.getCount() == 1) {
                property = (BOrdList)object3.getRange(0).getMin();
                for (int i = 0; i < property.size(); ++i) {
                    object = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE).alias("sourceOrder" + i);
                    bAbsTime = new BSqlExtent(BOrionAlarmSource.ORION_TYPE).alias("alarmSource" + i);
                    bSqlQuery.join(new BSqlJoin(new BSqlField(bSqlExtent, BOrionAlarmRecord.id), new BSqlField((BSqlExtent)object, BOrionAlarmSourceOrder.alarm)));
                    bSqlQuery.join(new BSqlJoin(new BSqlField((BSqlExtent)object, BOrionAlarmSourceOrder.alarmSource), new BSqlField((BSqlExtent)bAbsTime, BOrionAlarmSource.id)));
                    BExpression bExpression = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField((BSqlExtent)object, BOrionAlarmSourceOrder.sourceOrder), (BSimple)BInteger.make((int)i))).and(Predicates.eq((BExpression)new BSqlField((BSqlExtent)bAbsTime, BOrionAlarmSource.source), (BSimple)property.get(i))).getExpression();
                    object2 = object2 == null ? bExpression : Exprs.builder((BExpression)object2).and(bExpression).getExpression();
                }
            }
            if (!(object3 = selectQuery.getRange("alarmClass", BString.TYPE, true)).isAll() && object3.getCount() == 1) {
                property = (BString)object3.getRange(0).getMin();
                BSqlExtent bSqlExtent2 = new BSqlExtent(BOrionAlarmClass.ORION_TYPE);
                bSqlQuery.join(new BSqlJoin(new BSqlField(bSqlExtent, BOrionAlarmRecord.alarmClass), new BSqlField(bSqlExtent2, BOrionAlarmClass.id)));
                object = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(bSqlExtent2, BOrionAlarmClass.alarmClass), (BSimple)property)).getExpression();
                object2 = object2 == null ? object : Exprs.builder((BExpression)object2).and((BExpression)object).getExpression();
            }
            object3 = null;
            try {
                object3 = this.getOrionSession(null);
                property = object3.scan(BOrionAlarmFacetName.ORION_TYPE);
                Range range2 = null;
                while (property.next()) {
                    object = (BOrionAlarmFacetName)property.get();
                    bAbsTime = selectQuery.getRange(object.getFacetName(), BIDataValue.TYPE, true);
                    if (bAbsTime.isAll() || bAbsTime.getCount() != 1) continue;
                    BSqlExtent bSqlExtent3 = new BSqlExtent(BOrionAlarmFacetValue.ORION_TYPE).alias("value_" + object.getFacetName());
                    bSqlQuery.join(new BSqlJoin(new BSqlField(bSqlExtent, BOrionAlarmRecord.id), new BSqlField(bSqlExtent3, BOrionAlarmFacetValue.alarm)));
                    try {
                        range = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(bSqlExtent3, BOrionAlarmFacetValue.value), (BSimple)BString.make((String)DataUtil.marshal((BObject)bAbsTime.getRange(0).getMin())))).and(Predicates.eq((BExpression)new BSqlField(bSqlExtent3, BOrionAlarmFacetValue.facetName), (BSimple)BRef.make((BIOrionObject)object))).getExpression();
                    }
                    catch (IOException iOException) {
                        throw new BajaRuntimeException("Unable to marshal facet expression: " + bAbsTime.getRange(0).getMin(), (Throwable)iOException);
                    }
                    if (object2 == null) {
                        range2 = range;
                        continue;
                    }
                    range2 = Exprs.builder((BExpression)range2).or((BExpression)range).getExpression();
                }
                object2 = object2 == null ? range2 : Exprs.builder((BExpression)object2).and(range2).getExpression();
            }
            finally {
                if (object3 != null) {
                    object3.close();
                }
            }
            bSqlQuery.where(object2);
            bSqlQuery = (BSqlQuery)bSqlQuery.from((BExtent)bSqlExtent);
            bSqlQuery.orderBy(BOrdering.make((BOrderByColumn)Columns.orderBy((BExpression)new BSqlField(bSqlExtent, BOrionAlarmRecord.id)).desc()));
            object3 = this.exclusiveAccessMutex;
            synchronized (object3) {
                property = this.getOrionSession(null);
                return new OrionAlarmCursor(property.select((BQuery)bSqlQuery), (OrionSession)property);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new BajaRuntimeException("Unable to execute BQL against alarm database.", (Throwable)runtimeException);
        }
    }

    private BExpression createExpression(RangeSet rangeSet, Property property) {
        BExpression bExpression = null;
        for (int i = 0; i < rangeSet.getCount(); ++i) {
            Range range = rangeSet.getRange(i);
            BExpression bExpression2 = null;
            if (range.getMin() != null) {
                bExpression2 = range.getMax() != null ? (range.getMinInclusive() ? (range.getMaxInclusive() ? (range.getMin().equals((Object)range.getMax()) ? Predicates.eq((Property)property, (BSimple)range.getMin()) : Exprs.builder((BExpression)Predicates.ge((Property)property, (BSimple)range.getMin())).and(Predicates.le((Property)property, (BSimple)range.getMax())).getExpression()) : Exprs.builder((BExpression)Predicates.ge((Property)property, (BSimple)range.getMin())).and(Predicates.lt((Property)property, (BSimple)range.getMax())).getExpression()) : (range.getMaxInclusive() ? Exprs.builder((BExpression)Predicates.gt((Property)property, (BSimple)range.getMin())).and(Predicates.le((Property)property, (BSimple)range.getMax())).getExpression() : Exprs.builder((BExpression)Predicates.gt((Property)property, (BSimple)range.getMin())).and(Predicates.lt((Property)property, (BSimple)range.getMax())).getExpression())) : (range.getMinInclusive() ? Predicates.ge((Property)property, (BSimple)range.getMin()) : Predicates.gt((Property)property, (BSimple)range.getMin()));
            } else if (range.getMax() != null) {
                bExpression2 = range.getMaxInclusive() ? Predicates.le((Property)property, (BSimple)range.getMax()) : Predicates.lt((Property)property, (BSimple)range.getMax());
            }
            bExpression = bExpression == null ? bExpression2 : Exprs.builder(bExpression).or(bExpression2).getExpression();
        }
        return bExpression;
    }

    private Queue getQueue() {
        BOrionAlarmService bOrionAlarmService = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        return (Queue)bOrionAlarmService.fw(601);
    }

    public void toNormal(BAlarmRecord bAlarmRecord) {
        if (log.isTraceOn() && bAlarmRecord.getSource().size() > 0) {
            log.trace("Returning to normal " + bAlarmRecord.getSource().get(0));
        }
        if (!this.isOpen()) {
            throw new AlarmException("Unable to append, database unavailable.");
        }
        this.enqueue(new ToNormal(bAlarmRecord));
    }

    public void clearRecord(BUuid bUuid, Context context) throws IOException {
        if (log.isTraceOn()) {
            log.trace("Clearing record " + bUuid);
        }
        if (!this.isOpen()) {
            throw new AlarmException("Unable to update, database unavailable.");
        }
        this.enqueue(new ClearAlarmRecord(bUuid));
    }

    public void update(BAlarmRecord bAlarmRecord) throws IOException, AlarmException {
        if (log.isTraceOn()) {
            log.trace("Updating record " + bAlarmRecord.getUuid());
        }
        if (!this.isOpen()) {
            throw new AlarmException("Unable to update, database unavailable.");
        }
        if (bAlarmRecord.getSource().size() == 0) {
            throw new AlarmException("Alarm must have a source " + bAlarmRecord.getUuid());
        }
        this.enqueue(new UpdateAlarmRecord(bAlarmRecord));
    }

    public void append(BAlarmRecord bAlarmRecord) throws IOException, AlarmException {
        if (log.isTraceOn()) {
            log.trace("Appending record " + bAlarmRecord.getUuid());
        }
        if (!this.isOpen()) {
            throw new AlarmException("Unable to append, database unavailable.");
        }
        if (bAlarmRecord.getSource().size() == 0) {
            throw new AlarmException("Alarm must have a source " + bAlarmRecord.getUuid());
        }
        this.enqueue(new AppendAlarmRecord(bAlarmRecord));
    }

    private void enqueue(AlarmRecordTransaction alarmRecordTransaction) {
        Queue queue = this.getQueue();
        if (queue.isFull()) {
            throw new AlarmException("Alarm queue is full, unable to enqueue " + alarmRecordTransaction);
        }
        BOrionAlarmService bOrionAlarmService = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        Object[] objectArray = bOrionAlarmService.getChildren(class$com$tridium$alarmOrion$transactions$BOrionAlarmTransactionStatistics == null ? (class$com$tridium$alarmOrion$transactions$BOrionAlarmTransactionStatistics = BOrionAlarmDatabase.class$("com.tridium.alarmOrion.transactions.BOrionAlarmTransactionStatistics")) : class$com$tridium$alarmOrion$transactions$BOrionAlarmTransactionStatistics);
        if (objectArray.length > 0) {
            ((BOrionAlarmTransactionStatistics)((Object)objectArray[0])).transactionEnqueued();
        }
        queue.enqueue((Object)alarmRecordTransaction);
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        return super.fw(n, object, object2, object3, object4);
    }

    public BStatus getStatus() {
        BOrionAlarmService bOrionAlarmService = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        if (bOrionAlarmService.getDatabase().isNull()) {
            throw new OrionException("Database not configured.");
        }
        BRdbms bRdbms = (BRdbms)bOrionAlarmService.getDatabase().resolve((BObject)bOrionAlarmService).get();
        return bRdbms.getStatus();
    }

    public BOrionDatabase getOrionDatabase() {
        BOrionAlarmService bOrionAlarmService = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        if (bOrionAlarmService.getDatabase().isNull()) {
            throw new OrionException("Database not configured.");
        }
        BRdbms bRdbms = (BRdbms)bOrionAlarmService.getDatabase().resolve((BObject)bOrionAlarmService).get();
        BOrionSpace bOrionSpace = (BOrionSpace)BOrd.make((String)"orion:").resolve((BObject)bOrionAlarmService).get();
        return bOrionSpace.getOrionDatabase(bRdbms);
    }

    public OrionSession getOrionSession(Context context) {
        return this.getOrionDatabase().createSession(context);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

