/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.transactions;

import com.tridium.alarmOrion.transactions.AlarmRecordTransaction;
import com.tridium.alarmOrion.transactions.AppendAlarmRecord;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.orion.sql.PropertyValue;
import java.io.IOException;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmFacetName;
import javax.baja.alarmOrion.BOrionAlarmFacetValue;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.alarmOrion.BOrionAlarmSourceOrder;
import javax.baja.data.DataUtil;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ICoalesceable;

public class UpdateAlarmRecord
extends AlarmRecordTransaction
implements ICoalesceable {
    protected BAlarmRecord alarmRecord;

    public UpdateAlarmRecord(BAlarmRecord bAlarmRecord) {
        this.alarmRecord = bAlarmRecord;
    }

    public ICoalesceable coalesce(ICoalesceable iCoalesceable) {
        return iCoalesceable;
    }

    public Object getCoalesceKey() {
        return this.alarmRecord.getUuid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() {
        BOrionAlarmService bOrionAlarmService = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        BOrionAlarmDatabase bOrionAlarmDatabase = (BOrionAlarmDatabase)bOrionAlarmService.getAlarmDb();
        Object object = bOrionAlarmDatabase.exclusiveAccessMutex;
        synchronized (object) {
            OrionSession orionSession = null;
            try {
                orionSession = bOrionAlarmDatabase.getOrionSession(null);
                orionSession.setAutoCommit(false);
                BOrionAlarmRecord bOrionAlarmRecord = bOrionAlarmDatabase.getOrionRecord(this.alarmRecord.getUuid(), orionSession);
                if (bOrionAlarmRecord == null) {
                    new AppendAlarmRecord(this.alarmRecord).run();
                } else {
                    Object object2;
                    BFacets bFacets;
                    BatchStatement batchStatement;
                    BAlarmRecord bAlarmRecord = bOrionAlarmRecord.getAlarmRecord(orionSession);
                    BOrionAlarmClass bOrionAlarmClass = bOrionAlarmRecord.resolveAlarmClass(orionSession);
                    bOrionAlarmClass.setTotalAlarmCount(bOrionAlarmClass.getTotalAlarmCount() - 1);
                    if (!bAlarmRecord.isAcknowledged()) {
                        bOrionAlarmClass.setUnackedAlarmCount(bOrionAlarmClass.getUnackedAlarmCount() - 1);
                    }
                    if (!bAlarmRecord.isNormal()) {
                        bOrionAlarmClass.setInAlarmCount(bOrionAlarmClass.getInAlarmCount() - 1);
                    }
                    if (bAlarmRecord.isOpen()) {
                        bOrionAlarmClass.setOpenAlarmCount(bOrionAlarmClass.getOpenAlarmCount() - 1);
                    }
                    bOrionAlarmRecord.setTimestamp(this.alarmRecord.getTimestamp());
                    bOrionAlarmRecord.setSourceState(this.alarmRecord.getSourceState());
                    bOrionAlarmRecord.setAckState(this.alarmRecord.getAckState());
                    bOrionAlarmRecord.setAckRequired(this.alarmRecord.getAckRequired());
                    bOrionAlarmRecord.setPriority(this.alarmRecord.getPriority());
                    bOrionAlarmRecord.setNormalTime(this.alarmRecord.getNormalTime());
                    bOrionAlarmRecord.setAckTime(this.alarmRecord.getAckTime());
                    bOrionAlarmRecord.setUserAccount(this.alarmRecord.getUser());
                    bOrionAlarmRecord.setAlarmTransition(this.alarmRecord.getAlarmTransition());
                    bOrionAlarmRecord.setLastUpdate(this.alarmRecord.getLastUpdate());
                    if (!this.alarmRecord.getAlarmClass().equals(bAlarmRecord.getAlarmClass())) {
                        orionSession.update((BIOrionObject)bOrionAlarmClass);
                        bOrionAlarmClass = BOrionAlarmClass.get(this.alarmRecord.getAlarmClass(), orionSession);
                        bOrionAlarmRecord.setAlarmClass(BRef.make((BIOrionObject)bOrionAlarmClass));
                    }
                    if (!this.alarmRecord.getAlarmData().equivalent((Object)bAlarmRecord.getAlarmData())) {
                        BObject bObject;
                        batchStatement = this.alarmRecord.getAlarmData().list();
                        bFacets = bAlarmRecord.getAlarmData();
                        BatchStatement batchStatement2 = orionSession.batchInsert(BOrionAlarmFacetValue.ORION_TYPE);
                        object2 = orionSession.batchUpdate(BOrionAlarmFacetValue.ORION_TYPE);
                        BatchStatement batchStatement3 = orionSession.batchDelete(BOrionAlarmFacetValue.ORION_TYPE);
                        for (int i = 0; i < ((BatchStatement)batchStatement).length; ++i) {
                            block54: {
                                Object object3;
                                String string;
                                BObject bObject2 = bFacets.get((String)batchStatement[i]);
                                if (bObject2 == null) {
                                    bObject = this.alarmRecord.getAlarmData().get((String)batchStatement[i]);
                                    try {
                                        try {
                                            string = DataUtil.marshal((BObject)bObject);
                                        }
                                        catch (IOException iOException) {
                                            throw new BajaRuntimeException("Facet " + (String)batchStatement[i] + " can not be marshalled.", (Throwable)iOException);
                                        }
                                        if (string.length() > BOrionAlarmFacetValue.value.getFacets().geti("width", 0)) {
                                            throw new BajaRuntimeException("Facet " + (String)batchStatement[i] + " too big, " + string.length() + ">" + BOrionAlarmFacetValue.value.getFacets().geti("width", 0));
                                        }
                                        object3 = BOrionAlarmFacetValue.make((String)batchStatement[i], string, bOrionAlarmRecord, orionSession);
                                        batchStatement2.add((BIOrionObject)object3);
                                    }
                                    catch (Exception exception) {
                                        if (BOrionAlarmService.logger.isTraceOn()) {
                                            BOrionAlarmService.logger.warning("Unable to save alarm facet", (Throwable)exception);
                                        }
                                        break block54;
                                    }
                                }
                                if (this.alarmRecord.getAlarmData().get((String)batchStatement[i]) != null && !bObject2.equivalent((Object)this.alarmRecord.getAlarmData().get((String)batchStatement[i]))) {
                                    bObject = null;
                                    try {
                                        BOrionAlarmFacetValue bOrionAlarmFacetValue;
                                        bObject = orionSession.select(BOrionAlarmFacetValue.ORION_TYPE, new PropertyValue[]{new PropertyValue(BOrionAlarmFacetValue.alarm, (BValue)BRef.make((BIOrionObject)bOrionAlarmRecord)), new PropertyValue(BOrionAlarmFacetValue.facetName, (BValue)BRef.make((BIOrionObject)BOrionAlarmFacetName.get((String)batchStatement[i], orionSession)))});
                                        if (bObject.next()) {
                                            string = this.alarmRecord.getAlarmData().get((String)batchStatement[i]);
                                            try {
                                                try {
                                                    object3 = DataUtil.marshal((BObject)string);
                                                }
                                                catch (IOException iOException) {
                                                    throw new BajaRuntimeException("Facet " + (String)batchStatement[i] + " can not be marshalled.", (Throwable)iOException);
                                                }
                                                if (((String)object3).length() > BOrionAlarmFacetValue.value.getFacets().geti("width", 0)) {
                                                    throw new BajaRuntimeException("Facet " + (String)batchStatement[i] + " too big, " + ((String)object3).length() + ">" + BOrionAlarmFacetValue.value.getFacets().geti("width", 0));
                                                }
                                                bOrionAlarmFacetValue = (BOrionAlarmFacetValue)bObject.get();
                                                bOrionAlarmFacetValue.setValue((String)object3);
                                                object2.add((BIOrionObject)bOrionAlarmFacetValue);
                                                if (bObject.next()) {
                                                    throw new BajaRuntimeException("Multiple values defined found for facet " + (String)batchStatement[i] + ", should only be one.");
                                                }
                                                break block54;
                                            }
                                            catch (Exception exception) {
                                                if (BOrionAlarmService.logger.isTraceOn()) {
                                                    BOrionAlarmService.logger.warning("Unable to save alarm facet", (Throwable)exception);
                                                }
                                                break block54;
                                            }
                                        }
                                        batchStatement2.add((BIOrionObject)BOrionAlarmFacetValue.make((String)batchStatement[i], this.alarmRecord.getAlarmData().get((String)batchStatement[i]), bOrionAlarmRecord, orionSession));
                                        string = this.alarmRecord.getAlarmData().get((String)batchStatement[i]);
                                        try {
                                            try {
                                                object3 = DataUtil.marshal((BObject)string);
                                            }
                                            catch (IOException iOException) {
                                                throw new BajaRuntimeException("Facet " + (String)batchStatement[i] + " can not be marshalled.", (Throwable)iOException);
                                            }
                                            if (((String)object3).length() > BOrionAlarmFacetValue.value.getFacets().geti("width", 0)) {
                                                throw new BajaRuntimeException("Facet " + (String)batchStatement[i] + " too big, " + ((String)object3).length() + ">" + BOrionAlarmFacetValue.value.getFacets().geti("width", 0));
                                            }
                                            bOrionAlarmFacetValue = BOrionAlarmFacetValue.make((String)batchStatement[i], (String)object3, bOrionAlarmRecord, orionSession);
                                            batchStatement2.add((BIOrionObject)bOrionAlarmFacetValue);
                                        }
                                        catch (Exception exception) {
                                            if (BOrionAlarmService.logger.isTraceOn()) {
                                                BOrionAlarmService.logger.warning("Unable to save alarm facet", (Throwable)exception);
                                            }
                                        }
                                    }
                                    finally {
                                        bObject.close();
                                    }
                                }
                            }
                            bFacets = BFacets.makeRemove((BFacets)bFacets, (String)batchStatement[i]);
                        }
                        batchStatement2.execute();
                        object2.execute();
                        String[] stringArray = bFacets.list();
                        for (int i = 0; i < stringArray.length; ++i) {
                            bObject = null;
                            try {
                                bObject = orionSession.select(BOrionAlarmFacetValue.ORION_TYPE, new PropertyValue[]{new PropertyValue(BOrionAlarmFacetValue.alarm, (BValue)BRef.make((BIOrionObject)bOrionAlarmRecord)), new PropertyValue(BOrionAlarmFacetValue.facetName, (BValue)BRef.make((BIOrionObject)BOrionAlarmFacetName.get(stringArray[i], orionSession)))});
                                if (!bObject.next()) continue;
                                do {
                                    batchStatement3.add((BIOrionObject)((BOrionAlarmFacetValue)bObject.get()));
                                } while (bObject.next());
                                continue;
                            }
                            finally {
                                if (bObject != null) {
                                    bObject.close();
                                }
                            }
                        }
                        batchStatement3.execute();
                    }
                    if (!bAlarmRecord.getSource().equivalent((Object)this.alarmRecord.getSource())) {
                        orionSession.delete(BOrionAlarmSourceOrder.ORION_TYPE, Predicates.eq((Property)BOrionAlarmSourceOrder.alarm, (BSimple)BRef.make((BIOrionObject)bOrionAlarmRecord)));
                        batchStatement = orionSession.batchInsert(BOrionAlarmSourceOrder.ORION_TYPE);
                        bFacets = this.alarmRecord.getSource();
                        for (int i = 0; i < bFacets.size(); ++i) {
                            object2 = BOrionAlarmSourceOrder.make(bFacets.get(i), i, bOrionAlarmRecord, orionSession);
                            batchStatement.add((BIOrionObject)object2);
                        }
                        batchStatement.execute();
                    }
                    orionSession.update((BIOrionObject)bOrionAlarmRecord);
                    bOrionAlarmClass.setTotalAlarmCount(bOrionAlarmClass.getTotalAlarmCount() + 1);
                    if (!this.alarmRecord.isAcknowledged()) {
                        bOrionAlarmClass.setUnackedAlarmCount(bOrionAlarmClass.getUnackedAlarmCount() + 1);
                    }
                    if (!this.alarmRecord.isNormal()) {
                        bOrionAlarmClass.setInAlarmCount(bOrionAlarmClass.getInAlarmCount() + 1);
                    }
                    if (this.alarmRecord.isOpen()) {
                        bOrionAlarmClass.setOpenAlarmCount(bOrionAlarmClass.getOpenAlarmCount() + 1);
                    }
                    orionSession.update((BIOrionObject)bOrionAlarmClass);
                }
                orionSession.commit();
            }
            catch (RuntimeException runtimeException) {
                if (orionSession != null) {
                    orionSession.rollback();
                }
                BOrionAlarmDatabase.log.error("Unable to update record " + this.alarmRecord.getUuid(), (Throwable)runtimeException);
            }
            finally {
                if (orionSession != null) {
                    orionSession.close();
                }
            }
        }
    }
}

