/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.transactions;

import com.tridium.alarmOrion.transactions.AlarmRecordTransaction;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.BatchStatement;
import java.io.IOException;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmFacetValue;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.alarmOrion.BOrionAlarmSourceOrder;
import javax.baja.data.DataUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ICoalesceable;

public class AppendAlarmRecord
extends AlarmRecordTransaction
implements ICoalesceable {
    protected BAlarmRecord alarmRecord;

    public AppendAlarmRecord(BAlarmRecord bAlarmRecord) {
        this.alarmRecord = bAlarmRecord;
    }

    public ICoalesceable coalesce(ICoalesceable iCoalesceable) {
        return iCoalesceable;
    }

    public Object getCoalesceKey() {
        return this.alarmRecord.getUuid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() {
        BOrionAlarmService bOrionAlarmService = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        BOrionAlarmDatabase bOrionAlarmDatabase = (BOrionAlarmDatabase)bOrionAlarmService.getAlarmDb();
        Object object = bOrionAlarmDatabase.exclusiveAccessMutex;
        synchronized (object) {
            OrionSession orionSession = null;
            try {
                BOrionAlarmSourceOrder bOrionAlarmSourceOrder;
                orionSession = bOrionAlarmDatabase.getOrionSession(null);
                orionSession.setAutoCommit(false);
                BOrionAlarmRecord bOrionAlarmRecord = BOrionAlarmRecord.make(this.alarmRecord, orionSession);
                orionSession.insert((BIOrionObject)bOrionAlarmRecord);
                Object object2 = this.alarmRecord.getSource();
                BatchStatement batchStatement = orionSession.batchInsert(BOrionAlarmSourceOrder.ORION_TYPE);
                for (int i = 0; i < object2.size(); ++i) {
                    bOrionAlarmSourceOrder = BOrionAlarmSourceOrder.make(object2.get(i), i, bOrionAlarmRecord, orionSession);
                    batchStatement.add((BIOrionObject)bOrionAlarmSourceOrder);
                }
                batchStatement.execute();
                batchStatement = this.alarmRecord.getAlarmData();
                String[] stringArray = batchStatement.list();
                bOrionAlarmSourceOrder = orionSession.batchInsert(BOrionAlarmFacetValue.ORION_TYPE);
                for (int i = 0; i < stringArray.length; ++i) {
                    BObject bObject = batchStatement.get(stringArray[i]);
                    try {
                        String string;
                        try {
                            string = DataUtil.marshal((BObject)bObject);
                        }
                        catch (IOException iOException) {
                            throw new BajaRuntimeException("Facet " + stringArray[i] + " can not be marshalled.", (Throwable)iOException);
                        }
                        if (string.length() > BOrionAlarmFacetValue.value.getFacets().geti("width", 0)) {
                            BOrionAlarmService.logger.warning("Facet " + stringArray[i] + " too big, " + string.length() + ">" + BOrionAlarmFacetValue.value.getFacets().geti("width", 0));
                            continue;
                        }
                        BOrionAlarmFacetValue bOrionAlarmFacetValue = BOrionAlarmFacetValue.make(stringArray[i], string, bOrionAlarmRecord, orionSession);
                        bOrionAlarmSourceOrder.add((BIOrionObject)bOrionAlarmFacetValue);
                        continue;
                    }
                    catch (Exception exception) {
                        if (!BOrionAlarmService.logger.isTraceOn()) continue;
                        BOrionAlarmService.logger.warning("Unable to save alarm facet", (Throwable)exception);
                    }
                }
                bOrionAlarmSourceOrder.execute();
                object2 = bOrionAlarmRecord.resolveAlarmClass(orionSession);
                ((BOrionAlarmClass)((Object)object2)).setTotalAlarmCount(((BOrionAlarmClass)((Object)object2)).getTotalAlarmCount() + 1);
                if (!this.alarmRecord.isAcknowledged()) {
                    ((BOrionAlarmClass)((Object)object2)).setUnackedAlarmCount(((BOrionAlarmClass)((Object)object2)).getUnackedAlarmCount() + 1);
                }
                if (!this.alarmRecord.isNormal()) {
                    ((BOrionAlarmClass)((Object)object2)).setInAlarmCount(((BOrionAlarmClass)((Object)object2)).getInAlarmCount() + 1);
                }
                if (this.alarmRecord.isOpen()) {
                    ((BOrionAlarmClass)((Object)object2)).setOpenAlarmCount(((BOrionAlarmClass)((Object)object2)).getOpenAlarmCount() + 1);
                }
                ((BOrionAlarmClass)((Object)object2)).setTimeOfLastAlarm(BAbsTime.now());
                if (((BOrionAlarmClass)((Object)object2)).getTimeOfLastAlarm().isBefore(this.alarmRecord.getTimestamp())) {
                    ((BOrionAlarmClass)((Object)object2)).setTimeOfLastAlarm(this.alarmRecord.getTimestamp());
                }
                orionSession.update((BIOrionObject)object2);
                orionSession.commit();
            }
            catch (RuntimeException runtimeException) {
                if (orionSession != null) {
                    orionSession.rollback();
                }
                BOrionAlarmDatabase.log.error("Unable to append alarm " + this.alarmRecord.getUuid(), (Throwable)runtimeException);
            }
            finally {
                if (orionSession != null) {
                    orionSession.close();
                }
            }
        }
    }
}

