/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.conversion.rdb;

import com.tridium.alarm.BTextOp;
import com.tridium.alarmOrion.conversion.BAlarmConversion;
import com.tridium.alarmOrion.conversion.BAlarmConversionJob;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.priv.model.DynamicOrionProperty;
import com.tridium.orion.priv.model.DynamicOrionType;
import com.tridium.rdb.BRdbmsDeprecatedDialect;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Queue;

public class BRdbAlarmConversionJob
extends BAlarmConversionJob {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarmOrion$conversion$rdb$BRdbAlarmConversionJob == null ? (class$com$tridium$alarmOrion$conversion$rdb$BRdbAlarmConversionJob = BRdbAlarmConversionJob.class$("com.tridium.alarmOrion.conversion.rdb.BRdbAlarmConversionJob")) : class$com$tridium$alarmOrion$conversion$rdb$BRdbAlarmConversionJob));
    private boolean running = true;
    private static final Property timestamp = new DynamicOrionProperty("TIMESTAMP", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property uuid = new DynamicOrionProperty("UUID", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property sourceState = new DynamicOrionProperty("SOURCESTATE", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property ackState = new DynamicOrionProperty("ACKSTATE", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property ackRequired = new DynamicOrionProperty("ACKREQUIRED", BBoolean.TYPE, (BValue)BBoolean.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property source = new DynamicOrionProperty("SOURCE", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property alarmClass = new DynamicOrionProperty("ALARMCLASS", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property priority = new DynamicOrionProperty("PRIORITY", BInteger.TYPE, (BValue)BInteger.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property normalTime = new DynamicOrionProperty("NORMALTIME", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property ackTime = new DynamicOrionProperty("ACKTIME", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property user = new DynamicOrionProperty("USER", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property alarmData = new DynamicOrionProperty("ALARMDATA", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property alarmTransition = new DynamicOrionProperty("ALARMTRANSITION", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property lastUpdate = new DynamicOrionProperty("LASTUPDATE", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final DynamicOrionType dynamicOrionType = DynamicOrionType.makeTemporary((Property[])new Property[]{timestamp, uuid, sourceState, ackState, ackRequired, source, alarmClass, priority, normalTime, ackTime, user, alarmData, alarmTransition, lastUpdate});
    private BAlarmConversion conversion;
    static /* synthetic */ Class class$com$tridium$alarmOrion$conversion$rdb$BRdbAlarmConversionJob;

    public Type getType() {
        return TYPE;
    }

    public BRdbAlarmConversionJob() {
    }

    public BRdbAlarmConversionJob(BAlarmConversion bAlarmConversion) {
        this.conversion = bAlarmConversion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context context) {
        BOrionAlarmService bOrionAlarmService = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        BOrionAlarmDatabase bOrionAlarmDatabase = (BOrionAlarmDatabase)bOrionAlarmService.getAlarmDb();
        OrionSession orionSession = bOrionAlarmDatabase.getOrionSession(context);
        Queue queue = (Queue)bOrionAlarmService.fw(601);
        this.log().start("Conversion started");
        this.recordsConverted = 0.0;
        this.recordsFailed = 0.0;
        this.running = true;
        try {
            DynamicOrionType dynamicOrionType = DynamicOrionType.makeTemporary((Property[])new Property[]{new DynamicOrionProperty("recordCount", BInteger.TYPE, (BValue)BInteger.DEFAULT, BFacets.DEFAULT, 0)});
            OrionCursor orionCursor = orionSession.select((OrionType)dynamicOrionType, "SELECT count(1) AS recordCount FROM AlarmRecord");
            if (!orionCursor.next()) {
                this.recordsConverted = 0.0;
                this.recordsFailed = 0.0;
                this.recordsTotal = 0.0;
                this.failed((Throwable)new BajaRuntimeException("No data found to convert."));
                return;
            }
            try {
                this.recordsTotal = ((BInteger)((BIOrionObject)orionCursor.get()).get("recordCount")).getDouble();
                this.log().message("Discovered " + (int)this.recordsTotal + " records for conversion");
            }
            catch (Exception exception) {
                this.recordsConverted = 0.0;
                this.recordsFailed = 0.0;
                this.recordsTotal = 0.0;
                this.failed((Throwable)new BajaRuntimeException("Unable to count rdb alarm records.", (Throwable)exception));
                return;
            }
            dynamicOrionType = (BRdbms)bOrionAlarmService.getDatabase().resolve((BObject)bOrionAlarmService).get();
            orionCursor = BRdbmsDeprecatedDialect.make((BRdbms)dynamicOrionType);
            boolean bl = orionCursor.supportsTimestamp();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS");
            OrionCursor orionCursor2 = orionSession.select((OrionType)BRdbAlarmConversionJob.dynamicOrionType, "SELECT * FROM AlarmRecord");
            while (orionCursor2.next() && this.running) {
                BAlarmRecord bAlarmRecord = new BAlarmRecord();
                BDynamicOrionObject bDynamicOrionObject = (BDynamicOrionObject)orionCursor2.get();
                this.progress();
                try {
                    String string;
                    BString bString;
                    bAlarmRecord.setTimestamp(this.makeTime(bl, bDynamicOrionObject.get(timestamp), simpleDateFormat));
                    bAlarmRecord.setUuid(BUuid.make((String)bDynamicOrionObject.get(uuid).toString()));
                    bAlarmRecord.setSourceState(BSourceState.make((String)bDynamicOrionObject.get(sourceState).toString()));
                    bAlarmRecord.setAckState(BAckState.make((String)bDynamicOrionObject.get(ackState).toString()));
                    bAlarmRecord.setAckRequired(((BBoolean)bDynamicOrionObject.get(ackRequired)).getBoolean());
                    bAlarmRecord.setSource(BOrdList.make((String)bDynamicOrionObject.get(source).toString()));
                    bAlarmRecord.setAlarmClass(bDynamicOrionObject.get(alarmClass).toString());
                    bAlarmRecord.setPriority(((BInteger)bDynamicOrionObject.get(priority)).getInt());
                    bAlarmRecord.setNormalTime(this.makeTime(bl, bDynamicOrionObject.get(normalTime), simpleDateFormat));
                    bAlarmRecord.setAckTime(this.makeTime(bl, bDynamicOrionObject.get(ackTime), simpleDateFormat));
                    bAlarmRecord.setUser(bDynamicOrionObject.get(user).toString());
                    bAlarmRecord.setAlarmData(BFacets.make((String)bDynamicOrionObject.get(alarmData).toString()));
                    bAlarmRecord.setAlarmTransition(BSourceState.make((String)bDynamicOrionObject.get(alarmTransition).toString()));
                    if (this.conversion.getChangeLastUpdated()) {
                        bAlarmRecord.setLastUpdate(Clock.time());
                    } else {
                        bAlarmRecord.setLastUpdate(this.makeTime(bl, bDynamicOrionObject.get(lastUpdate), simpleDateFormat));
                    }
                    String string2 = this.conversion.getAlarmClass();
                    if (string2 != null && !string2.equals("")) {
                        bAlarmRecord.setAlarmClass(SlotPath.escape((String)TextUtil.replace((String)string2, (String)"%alarmClass%", (String)SlotPath.unescape((String)bAlarmRecord.getAlarmClass()))));
                    }
                    if ((bString = (BString)bAlarmRecord.getAlarmData().get("sourceName")) != null) {
                        string = this.conversion.getSourceName().customize(bString.toString());
                        bAlarmRecord.setAlarmData(BFacets.make((BFacets)bAlarmRecord.getAlarmData(), (String)"sourceName", (BIDataValue)BString.make((String)string)));
                    } else if (this.conversion.getSourceName().getOp() == BTextOp.replace) {
                        string = this.conversion.getSourceName().customize("");
                        bAlarmRecord.setAlarmData(BFacets.make((BFacets)bAlarmRecord.getAlarmData(), (String)"sourceName", (BIDataValue)BString.make((String)string)));
                    }
                    bOrionAlarmDatabase.update(bAlarmRecord);
                    try {
                        while (queue.size() > 250) {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.recordsConverted += 1.0;
                }
                catch (IOException iOException) {
                    this.log().add(new JobLogItem(0, iOException.getMessage(), (Throwable)iOException));
                    this.recordsFailed += 1.0;
                }
                catch (ParseException parseException) {
                    this.log().add(new JobLogItem(0, parseException.getMessage(), (Throwable)parseException));
                    this.recordsFailed += 1.0;
                }
            }
        }
        finally {
            orionSession.close();
        }
    }

    public void doCancel(Context context) {
        this.running = false;
    }

    private BAbsTime makeTime(boolean bl, BValue bValue, DateFormat dateFormat) throws ParseException {
        if (bl) {
            return BAbsTime.make((long)dateFormat.parse(bValue.toString()).getTime());
        }
        return BAbsTime.make((long)Long.parseLong(bValue.toString()));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

