/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platBacnet;

import com.tridium.platBacnet.EthernetConst;
import com.tridium.platBacnet.EthernetListener;
import javax.baja.log.Log;
import javax.baja.sys.BajaRuntimeException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BacnetEthernetAdapter
implements Runnable,
EthernetConst {
    private static final int LLC_LENGTH_OFFSET = 12;
    private static final int DSAP_OFFSET = 14;
    private static final int SSAP_OFFSET = 15;
    private static final int LLC_CONTROL_OFFSET = 16;
    protected static final Log log = Log.getLog((String)"bacnet.link.ethernet");
    String E_BACNET_STACK_LINK_ETHERNET_DRIVER_FAILED;
    private String adapterName;
    private boolean alive;
    private Thread t;
    private EthernetListener listener;
    private boolean debug;

    public String getAdapterName() {
        return this.adapterName;
    }

    public void commStart() {
        try {
            log.trace("Opening BACnet Ethernet driver using " + this.adapterName);
            this.open();
            this.t = new Thread((Runnable)this, "BnEthLRcv_" + this.adapterName);
            if (!this.t.isAlive()) {
                this.t.start();
            }
        }
        catch (Exception exception) {
            log.error(this.E_BACNET_STACK_LINK_ETHERNET_DRIVER_FAILED, (Throwable)exception);
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void commStop() {
        try {
            this.stopReception();
            this.alive = false;
            if (this.t != null) {
                this.t.interrupt();
            }
            this.close();
            this.t = null;
        }
        catch (Exception exception) {
            log.message(this.E_BACNET_STACK_LINK_ETHERNET_DRIVER_FAILED, (Throwable)exception);
        }
    }

    public void commCleanup() {
        this.t = null;
        this.listener = null;
    }

    public abstract void getAddress(byte[] var1) throws Exception;

    public void sendPacket(byte[] byArray) throws Exception {
        this.send(byArray, byArray.length);
    }

    public void addListener(EthernetListener ethernetListener) {
        this.listener = ethernetListener;
    }

    public void removeListener(EthernetListener ethernetListener) {
        if (this.listener == ethernetListener) {
            this.listener = null;
        }
    }

    public void run() {
        this.alive = true;
        while (this.alive) {
            try {
                log.trace("BACnetEthernetAdapter.run():Starting packet reception...");
                this.startReception();
                this.alive = false;
            }
            catch (Exception exception) {
                log.error("BACnetEthernetAdapter error!", (Throwable)exception);
            }
        }
        try {
            this.stopReception();
        }
        catch (Exception exception) {
            log.error("Error stopping packet reception in BACnetEthernetAdapter!", (Throwable)exception);
        }
    }

    public void receivePacket(byte[] byArray) {
        this.receivePacket(byArray, byArray.length);
    }

    public void receivePacket(byte[] byArray, int n) {
        try {
            if (this.listener != null) {
                this.listener.receivePacket(byArray, n);
            }
        }
        catch (Exception exception) {
            log.error("BACnetEthernetAdapter: receivePacket error", (Throwable)exception);
        }
    }

    protected abstract void open() throws Exception;

    protected abstract void startReception() throws Exception;

    protected abstract void stopReception() throws Exception;

    protected abstract void send(byte[] var1, int var2) throws Exception;

    protected abstract void close() throws Exception;

    private final /* synthetic */ void this() {
        this.E_BACNET_STACK_LINK_ETHERNET_DRIVER_FAILED = "Ethernet driver failed to open";
        this.alive = false;
        this.listener = null;
        this.debug = false;
    }

    public BacnetEthernetAdapter(String string) {
        this.this();
        this.adapterName = string;
    }
}

