/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BFolder;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.Invocation;
import javax.baja.util.Queue;
import javax.baja.util.Worker;
import javax.baja.weather.BWeatherReport;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWeatherService
extends BAbstractService {
    public static final Property updatePeriod = BWeatherService.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)15)));
    public static final Property airQualityApiKey = BWeatherService.newProperty((int)0, (String)"AEB3057E-30DF-4F5B-BC84-EE2C30E3F943", null);
    public static final Action updateWeatherReports = BWeatherService.newAction((int)16, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static final Log log;
    private CoalesceQueue queue;
    private Worker worker;
    private Clock.Ticket updateTicket;
    static /* synthetic */ Class class$javax$baja$weather$BWeatherService;
    static /* synthetic */ Class class$javax$baja$util$BFolder;
    static /* synthetic */ Class class$javax$baja$weather$BWeatherReport;

    public BRelTime getUpdatePeriod() {
        return (BRelTime)this.get(updatePeriod);
    }

    public void setUpdatePeriod(BRelTime bRelTime) {
        this.set(updatePeriod, (BValue)bRelTime, null);
    }

    public String getAirQualityApiKey() {
        return this.getString(airQualityApiKey);
    }

    public void setAirQualityApiKey(String string) {
        this.setString(airQualityApiKey, string, null);
    }

    public void updateWeatherReports() {
        this.invoke(updateWeatherReports, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() throws Exception {
        if (this.worker == null) {
            this.worker = new Worker((Worker.ITodo)this.queue);
            this.worker.start("WeatherService");
        }
    }

    public void stationStarted() {
        if (this.getEnabled()) {
            this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)updateWeatherReports, null);
        }
    }

    public void serviceStopped() throws Exception {
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
            this.updateTicket = null;
        }
        if (this.worker != null) {
            this.worker.stop();
            this.worker = null;
        }
        if (log.isTraceOn()) {
            log.trace("BWeatherService.serviceStopped");
        }
    }

    protected void enabled() {
        this.invoke(updateWeatherReports, null);
        this.updateStatus();
        if (log.isTraceOn()) {
            log.trace("BWeatherService.enabled");
        }
    }

    protected void disabled() {
        this.updateStatus();
        this.queue.clear();
        if (log.isTraceOn()) {
            log.trace("BWeatherService.disabled");
        }
    }

    public BWeatherReport[] getReports() {
        return this.getReports((BComponent)this);
    }

    private final BWeatherReport[] getReports(BComponent bComponent) {
        BFolder[] bFolderArray;
        Class clazz = class$javax$baja$util$BFolder;
        if (clazz == null) {
            clazz = class$javax$baja$util$BFolder = BWeatherService.class("[Ljavax.baja.util.BFolder;", false);
        }
        if ((bFolderArray = (BFolder[])bComponent.getChildren(clazz)).length > 0) {
            Class clazz2 = class$javax$baja$weather$BWeatherReport;
            if (clazz2 == null) {
                clazz2 = class$javax$baja$weather$BWeatherReport = BWeatherService.class("[Ljavax.baja.weather.BWeatherReport;", false);
            }
            Array array = new Array(clazz2);
            Class clazz3 = class$javax$baja$weather$BWeatherReport;
            if (clazz3 == null) {
                clazz3 = class$javax$baja$weather$BWeatherReport = BWeatherService.class("[Ljavax.baja.weather.BWeatherReport;", false);
            }
            array.addAll((Object[])((BWeatherReport[])this.getChildren(clazz3)));
            int n = 0;
            while (n < bFolderArray.length) {
                array.addAll((Object[])this.getReports((BComponent)bFolderArray[n]));
                ++n;
            }
            return (BWeatherReport[])array.trim();
        }
        Class clazz4 = class$javax$baja$weather$BWeatherReport;
        if (clazz4 == null) {
            clazz4 = class$javax$baja$weather$BWeatherReport = BWeatherService.class("[Ljavax.baja.weather.BWeatherReport;", false);
        }
        return (BWeatherReport[])bComponent.getChildren(clazz4);
    }

    Queue getQueue() {
        return this.queue;
    }

    public void doUpdateWeatherReports() {
        if (!this.getEnabled()) {
            return;
        }
        BWeatherReport[] bWeatherReportArray = this.getReports();
        int n = 0;
        while (n < bWeatherReportArray.length) {
            this.getQueue().enqueue((Object)new Invocation((BComponent)bWeatherReportArray[n], BWeatherReport.updateWeatherReport, null, null));
            ++n;
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)enabled) || property.equals((Object)updatePeriod) || property.equals((Object)airQualityApiKey)) {
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
                this.updateTicket = null;
            }
            if (this.getEnabled() && this.getUpdatePeriod().getMillis() != 0L) {
                this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)updateWeatherReports, null);
            }
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"Weather", 2);
        spyWriter.prop((Object)"queueSize", this.queue.size());
        spyWriter.endProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BVector getReports(Object object, Context context) {
        try {
            BVector bVector;
            BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            BNiagaraStation bNiagaraStation = (BNiagaraStation)bNiagaraNetwork.getStation(object.toString());
            if (bNiagaraStation == null) {
                throw new Exception("Station not found in Niagara Network: " + object);
            }
            bNiagaraStation.lease(1);
            BIpHost bIpHost = (BIpHost)bNiagaraStation.getRemoteHost();
            BFoxSession bFoxSession = BFoxSession.make((String)bNiagaraStation.getName(), (BHost)bIpHost, (int)bNiagaraStation.getFoxPort(), (boolean)bNiagaraStation.getClientConnection().getUseFoxs());
            if (bFoxSession == null) {
                throw new RuntimeException("Unable to connect to station " + object);
            }
            BUsernameAndPassword bUsernameAndPassword = new BUsernameAndPassword(bNiagaraStation.getClientConnection().getUsername(), bNiagaraStation.getClientConnection().getPassword());
            bFoxSession.setCredentials((BICredentials)bUsernameAndPassword);
            bFoxSession.getConnection().setUsername(bUsernameAndPassword.getUsername());
            bFoxSession.getConnection().setPassword(bUsernameAndPassword.getPassword());
            if (bFoxSession == null) {
                return new BVector();
            }
            try {
                bFoxSession.engageNoRetry(this.getType().toString() + "_getReports");
                BVector bVector2 = new BVector();
                BOrd bOrd = BOrd.make((String)"station:|slot:/|bql:select displayName, slotPath from weather:WeatherReport");
                BITable bITable = (BITable)bOrd.resolve((BObject)bFoxSession).get();
                ColumnList columnList = bITable.getColumns();
                int n = 0;
                while (true) {
                    if (n >= bITable.size()) {
                        bVector = bVector2;
                        Object var9_16 = null;
                        if (bFoxSession == null) return bVector;
                        break;
                    }
                    BComponent bComponent = new BComponent();
                    bComponent.add("name", (BValue)((BString)bITable.get(n, columnList.get(0))));
                    bComponent.add("ord", (BValue)BOrd.make((String)bITable.get(n, columnList.get(1)).toString()));
                    bVector2.add(null, (BValue)bComponent);
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Object var9_17 = null;
                if (bFoxSession != null) {
                    bFoxSession.disengage(this.getType().toString() + "_getReports");
                }
                throw throwable;
            }
            bFoxSession.disengage(this.getType().toString() + "_getReports");
            return bVector;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new BVector();
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.queue = new CoalesceQueue();
    }

    public BWeatherService() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$weather$BWeatherService;
        if (clazz == null) {
            clazz = class$javax$baja$weather$BWeatherService = BWeatherService.class("[Ljavax.baja.weather.BWeatherService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://weather/icons/weather.png");
        log = Log.getLog((String)"weather");
    }
}

