/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather;

import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.weather.BWeatherService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSunPosition
extends BComponent {
    public static final Property enabled = BSunPosition.newProperty((int)0, (boolean)true, null);
    public static final Property updatePeriod = BSunPosition.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0)));
    public static final Property longitude = BSunPosition.newProperty((int)8, (double)-77.4605636597, (BFacets)BFacets.make((String[])new String[]{"units", "precision", "max", "min"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"degrees angular"), BInteger.make((int)5), BDouble.make((double)180.0), BDouble.make((double)-180.0)}));
    public static final Property latitude = BSunPosition.newProperty((int)8, (double)37.5536117554, (BFacets)BFacets.make((String[])new String[]{"units", "precision", "max", "min"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"degrees angular"), BInteger.make((int)5), BDouble.make((double)180.0), BDouble.make((double)-180.0)}));
    public static final Property dayLength = BSunPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"hour")));
    public static final Property sunrise = BSunPosition.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    public static final Property sunset = BSunPosition.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    public static final Property noon = BSunPosition.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    public static final Property midnight = BSunPosition.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    public static final Property maxElevation = BSunPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"degrees angular"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    public static final Property minElevation = BSunPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"degrees angular"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    public static final Property currentElevation = BSunPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"degrees angular"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    public static final Property currentAzimuth = BSunPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"degrees angular"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    public static final Property currentDeclination = BSunPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"degrees angular"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    public static final Property currentRightAscension = BSunPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"degrees angular"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    public static final Action recalculate = BSunPosition.newAction((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static final double toDegrees;
    private static final double toRadians;
    private static final double radiansPerHour;
    private Clock.Ticket updateTicket;
    static /* synthetic */ Class class$javax$baja$weather$BSunPosition;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BRelTime getUpdatePeriod() {
        return (BRelTime)this.get(updatePeriod);
    }

    public void setUpdatePeriod(BRelTime bRelTime) {
        this.set(updatePeriod, (BValue)bRelTime, null);
    }

    public double getLongitude() {
        return this.getDouble(longitude);
    }

    public void setLongitude(double d) {
        this.setDouble(longitude, d, null);
    }

    public double getLatitude() {
        return this.getDouble(latitude);
    }

    public void setLatitude(double d) {
        this.setDouble(latitude, d, null);
    }

    public double getDayLength() {
        return this.getDouble(dayLength);
    }

    public void setDayLength(double d) {
        this.setDouble(dayLength, d, null);
    }

    public BAbsTime getSunrise() {
        return (BAbsTime)this.get(sunrise);
    }

    public void setSunrise(BAbsTime bAbsTime) {
        this.set(sunrise, (BValue)bAbsTime, null);
    }

    public BAbsTime getSunset() {
        return (BAbsTime)this.get(sunset);
    }

    public void setSunset(BAbsTime bAbsTime) {
        this.set(sunset, (BValue)bAbsTime, null);
    }

    public BAbsTime getNoon() {
        return (BAbsTime)this.get(noon);
    }

    public void setNoon(BAbsTime bAbsTime) {
        this.set(noon, (BValue)bAbsTime, null);
    }

    public BAbsTime getMidnight() {
        return (BAbsTime)this.get(midnight);
    }

    public void setMidnight(BAbsTime bAbsTime) {
        this.set(midnight, (BValue)bAbsTime, null);
    }

    public double getMaxElevation() {
        return this.getDouble(maxElevation);
    }

    public void setMaxElevation(double d) {
        this.setDouble(maxElevation, d, null);
    }

    public double getMinElevation() {
        return this.getDouble(minElevation);
    }

    public void setMinElevation(double d) {
        this.setDouble(minElevation, d, null);
    }

    public double getCurrentElevation() {
        return this.getDouble(currentElevation);
    }

    public void setCurrentElevation(double d) {
        this.setDouble(currentElevation, d, null);
    }

    public double getCurrentAzimuth() {
        return this.getDouble(currentAzimuth);
    }

    public void setCurrentAzimuth(double d) {
        this.setDouble(currentAzimuth, d, null);
    }

    public double getCurrentDeclination() {
        return this.getDouble(currentDeclination);
    }

    public void setCurrentDeclination(double d) {
        this.setDouble(currentDeclination, d, null);
    }

    public double getCurrentRightAscension() {
        return this.getDouble(currentRightAscension);
    }

    public void setCurrentRightAscension(double d) {
        this.setDouble(currentRightAscension, d, null);
    }

    public void recalculate() {
        this.invoke(recalculate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static void main(String[] stringArray) {
    }

    public static BSunPosition make(double d, double d2) {
        return BSunPosition.make(d, d2, BAbsTime.now());
    }

    public static BSunPosition make(double d, double d2, BAbsTime bAbsTime) {
        BSunPosition bSunPosition = new BSunPosition();
        bSunPosition.setLongitude(d2);
        bSunPosition.setLatitude(d);
        bSunPosition.doRecalculate(bAbsTime);
        return bSunPosition;
    }

    public void started() {
        if (Sys.isStationStarted() && this.getEnabled()) {
            this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)recalculate, null);
            this.invoke(recalculate, null);
        }
    }

    public void stopped() throws Exception {
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
            this.updateTicket = null;
        }
    }

    public void stationStarted() {
        if (this.getEnabled()) {
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
            }
            this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)recalculate, null);
            this.invoke(recalculate, null);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)latitude) || property.equals((Object)longitude)) {
            this.recalculate();
        }
        if (property.equals((Object)enabled) || property.equals((Object)updatePeriod)) {
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
                this.updateTicket = null;
            }
            if (this.getEnabled() && this.isRunning()) {
                this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)recalculate, null);
            }
        }
    }

    private final double normalizeRadians(double d) {
        double d2 = (double)2 * Math.PI;
        while (d > d2) {
            d -= d2;
        }
        while (d < 0.0) {
            d += d2;
        }
        return d;
    }

    private final BAbsTime convertTime(int n, int n2, int n3, double d) {
        int n4 = Math.abs((int)d % 24);
        int n5 = Math.abs((int)((d - (double)n4) * 60.0) % 60);
        BAbsTime bAbsTime = BAbsTime.make((BAbsTime)BAbsTime.make((int)n, (BMonth)BMonth.make((int)(n2 - 1)), (int)n3, (int)n4, (int)n5, (int)0, (int)0, (BTimeZone)BTimeZone.UTC), (BTimeZone)BTimeZone.getLocal());
        return BAbsTime.make((int)n, (BMonth)BMonth.make((int)(n2 - 1)), (int)n3, (int)bAbsTime.getHour(), (int)bAbsTime.getMinute(), (int)0, (int)0, (BTimeZone)BTimeZone.getLocal());
    }

    public void doRecalculate() {
        this.doRecalculate(BAbsTime.now());
    }

    public void doRecalculate(BAbsTime bAbsTime) {
        if (!this.getEnabled()) {
            return;
        }
        BAbsTime bAbsTime2 = BAbsTime.make((BAbsTime)bAbsTime, (BTimeZone)BTimeZone.getLocal());
        int n = bAbsTime2.getYear();
        int n2 = bAbsTime2.getMonth().getOrdinal() + 1;
        int n3 = bAbsTime2.getDay();
        BAbsTime bAbsTime3 = bAbsTime.toUtcTime();
        int n4 = bAbsTime3.getYear();
        int n5 = bAbsTime3.getMonth().getOrdinal() + 1;
        int n6 = bAbsTime3.getDay();
        double d = (double)bAbsTime3.getHour() + (double)bAbsTime3.getMinute() / 60.0 + (double)bAbsTime3.getSecond() / 3600.0;
        double d2 = Math.floor((double)((long)(-7 * (n4 + (n5 + 9) / 12) / 4 + 275 * n5 / 9 + n6) + (long)n4 * 367L) - (730530.0 + d / 24.0));
        if (BWeatherService.log.isTraceOn()) {
            BWeatherService.log.trace("Calculating sun position at " + n6 + '/' + n5 + '/' + n4);
        }
        double d3 = this.getLatitude() * toRadians;
        double d4 = this.getLongitude() * toRadians;
        double d5 = this.normalizeRadians((356.047 + 0.9856002585 * d2) * toRadians);
        double d6 = this.normalizeRadians((282.9404 + 4.70935E-5 * d2) * toRadians);
        double d7 = 0.016709 - 1.151E-9 * d2;
        double d8 = this.normalizeRadians(d5 + d7 * Math.sin(d5) * (1.0 + d7 * Math.cos(d5)));
        double d9 = Math.cos(d8) - d7;
        double d10 = Math.sin(d8) * Math.sqrt(1.0 - d7 * d7);
        double d11 = Math.atan2(d10, d9);
        double d12 = Math.sqrt(d9 * d9 + d10 * d10);
        double d13 = this.normalizeRadians(d11 + d6);
        d7 = 23.4393 * toRadians - 3.563E-7 * toRadians * d2;
        d8 = d12 * Math.cos(d13);
        d9 = d12 * Math.sin(d13) * Math.cos(d7);
        d10 = d9 * Math.sin(d7);
        double d14 = Math.atan2(d9, d8);
        double d15 = Math.atan2(d10, Math.sqrt(d8 * d8 + d9 * d9));
        d7 = this.normalizeRadians(d6 + d5) / radiansPerHour + 12.0;
        d8 = d7 + d + d4 / radiansPerHour;
        d9 = this.normalizeRadians(radiansPerHour * d8 - d14);
        d10 = Math.cos(d9) * Math.cos(d15);
        d11 = Math.sin(d9) * Math.cos(d15);
        double d16 = Math.sin(d15);
        double d17 = d10 * Math.sin(d3) - d16 * Math.cos(d3);
        double d18 = d11;
        double d19 = d10 * Math.cos(d3) + d16 * Math.sin(d3);
        d12 = this.normalizeRadians(Math.atan2(d18, d17) + Math.PI);
        d13 = Math.asin(d19);
        if (d13 > Math.PI) {
            d13 = Math.PI - d13;
        }
        if (d13 < -Math.PI) {
            d13 = -(d13 + Math.PI);
        }
        d17 = 0.004625;
        if (d3 < 0.0) {
            d17 = -d17;
        }
        d16 = Math.asin(Math.tan(d15 + d17) * Math.tan(d3)) + Math.PI / (double)2;
        d17 = 24.0 - (this.normalizeRadians(d6 + d5) - d14) * 3.819718634;
        d7 = 12.0 - 12.0 * d16 / Math.PI - d4 / radiansPerHour + d17;
        d8 = 12.0 + 12.0 * d16 / Math.PI - d4 / radiansPerHour + d17;
        d10 = d16 / (radiansPerHour / (double)2);
        d9 = d7 + 12.0 * d16 / Math.PI;
        d11 = d9 + 12.0;
        if (d9 > 24.0) {
            d9 -= 24.0;
        }
        if (d9 < 0.0) {
            d9 += 24.0;
        }
        if (d11 > 24.0) {
            d11 -= 24.0;
        }
        if (d11 < 0.0) {
            d11 += 24.0;
        }
        if (d7 > 24.0) {
            d7 -= 24.0;
        }
        if (d7 < 0.0) {
            d7 += 24.0;
        }
        if (d8 > 24.0) {
            d8 -= 24.0;
        }
        if (d8 < 0.0) {
            d8 += 24.0;
        }
        d16 = Math.PI / (double)2 + d15 - d3;
        d17 = d16 + (double)2 * d3 - Math.PI;
        if (d16 > Math.PI / (double)2) {
            d16 = Math.PI - d16;
        }
        if (d17 < -Math.PI / (double)2) {
            d17 = -(d17 + Math.PI);
        }
        this.setCurrentDeclination(d15 * toDegrees);
        this.setDayLength(d10);
        this.setSunrise(this.convertTime(n, n2, n3, d7));
        this.setSunset(this.convertTime(n, n2, n3, d8));
        this.setMaxElevation(d16 * toDegrees);
        this.setMinElevation(d17 * toDegrees);
        this.setNoon(this.convertTime(n, n2, n3, d9));
        this.setMidnight(this.convertTime(n, n2, n3, d11));
        this.setCurrentAzimuth(d12 * toDegrees);
        this.setCurrentElevation(d13 * toDegrees);
        this.setCurrentRightAscension(d14 * toDegrees);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$weather$BSunPosition;
        if (clazz == null) {
            clazz = class$javax$baja$weather$BSunPosition = BSunPosition.class("[Ljavax.baja.weather.BSunPosition;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://weather/icons/weather.png");
        toDegrees = 180.0 / Math.PI;
        toRadians = Math.PI / 180.0;
        radiansPerHour = 15.0 * toRadians;
    }
}

