/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.ui;

import com.tridium.weather.ui.BWeatherIconSize;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.weather.BMoonPosition;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BMoonView
extends BWbComponentView {
    private static Lexicon lex = Lexicon.make((String)"weather");
    public static final Property iconSize = BMoonView.newProperty((int)0, (BValue)BWeatherIconSize.x64, null);
    public static final Property northernHemisphere = BMoonView.newProperty((int)0, (boolean)true, null);
    public static final Property phaseFont = BMoonView.newProperty((int)0, (BValue)BFont.make((String)lex.getText("phase.font")), null);
    public static final Property phaseBrush = BMoonView.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Property illuminatedFont = BMoonView.newProperty((int)0, (BValue)BFont.make((String)lex.getText("illumination.font")), null);
    public static final Property illuminatedBrush = BMoonView.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$weather$ui$BMoonView;

    public BWeatherIconSize getIconSize() {
        return (BWeatherIconSize)this.get(iconSize);
    }

    public void setIconSize(BWeatherIconSize bWeatherIconSize) {
        this.set(iconSize, (BValue)bWeatherIconSize, null);
    }

    public boolean getNorthernHemisphere() {
        return this.getBoolean(northernHemisphere);
    }

    public void setNorthernHemisphere(boolean bl) {
        this.setBoolean(northernHemisphere, bl, null);
    }

    public BFont getPhaseFont() {
        return (BFont)this.get(phaseFont);
    }

    public void setPhaseFont(BFont bFont) {
        this.set(phaseFont, (BValue)bFont, null);
    }

    public BBrush getPhaseBrush() {
        return (BBrush)this.get(phaseBrush);
    }

    public void setPhaseBrush(BBrush bBrush) {
        this.set(phaseBrush, (BValue)bBrush, null);
    }

    public BFont getIlluminatedFont() {
        return (BFont)this.get(illuminatedFont);
    }

    public void setIlluminatedFont(BFont bFont) {
        this.set(illuminatedFont, (BValue)bFont, null);
    }

    public BBrush getIlluminatedBrush() {
        return (BBrush)this.get(illuminatedBrush);
    }

    public void setIlluminatedBrush(BBrush bBrush) {
        this.set(illuminatedBrush, (BValue)bBrush, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.getCurrentValue() == null) {
            return;
        }
        if (property.equals((Object)iconSize) || property.equals((Object)phaseFont) || property.equals((Object)phaseBrush)) {
            this.loadValue(this.getCurrentValue(), this.getCurrentContext());
        }
    }

    protected void doLoadValue(BObject bObject, Context context) {
        BMoonPosition bMoonPosition = (BMoonPosition)bObject;
        bMoonPosition.lease();
        String string = BMoonView.getMoonIcon(bMoonPosition.getPhase().getEnum(), this.getNorthernHemisphere());
        String string2 = this.getIconSize() == BWeatherIconSize.x64 ? "64" : "32";
        BLabel bLabel = new BLabel(BImage.make((String)("module://weather/rc/" + string + string2 + ".png")));
        BFacets bFacets = bMoonPosition.getSlotFacets((Slot)BMoonPosition.phase);
        BLabel bLabel2 = new BLabel(bMoonPosition.getPhase().toString((Context)bFacets));
        bLabel2.setFont(this.getPhaseFont());
        bLabel2.setForeground(this.getPhaseBrush());
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setRowGap(1.0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bMoonPosition.getIllumination());
        stringBuffer.append("% ");
        stringBuffer.append(lex.get("illuminated"));
        BLabel bLabel3 = new BLabel(stringBuffer.toString());
        bLabel3.setFont(this.getIlluminatedFont());
        bLabel3.setForeground(this.getIlluminatedBrush());
        bGridPane.add(null, (BValue)bLabel2);
        bGridPane.add(null, (BValue)bLabel3);
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.setColumnGap(6.0);
        bGridPane2.add(null, (BValue)bLabel);
        bGridPane2.add(null, (BValue)bGridPane);
        this.setContent((BWidget)bGridPane2);
        this.registerForComponentEvents(bMoonPosition);
    }

    public static String getMoonIcon(BEnum bEnum, boolean bl) {
        switch (bEnum.getOrdinal()) {
            case 0: {
                return "moonNew";
            }
            case 4: {
                return "moonFull";
            }
        }
        if (bl) {
            switch (bEnum.getOrdinal()) {
                case 7: {
                    return "moonWaningCrescent";
                }
                case 6: {
                    return "moonLastQuarter";
                }
                case 5: {
                    return "moonWaningGibbous";
                }
                case 3: {
                    return "moonWaxingGibbous";
                }
                case 2: {
                    return "moonFirstQuarter";
                }
                case 1: {
                    return "moonWaxingCrescent";
                }
            }
        } else {
            switch (bEnum.getOrdinal()) {
                case 7: {
                    return "moonWaxingCrescent";
                }
                case 6: {
                    return "moonFirstQuarter";
                }
                case 5: {
                    return "moonWaxingGibbous";
                }
                case 3: {
                    return "moonWaningGibbous";
                }
                case 2: {
                    return "moonLastQuarter";
                }
                case 1: {
                    return "moonWaningCrescent";
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        BComponent bComponent = bComponentEvent.getSourceComponent();
        if (bComponent instanceof BMoonPosition && (bComponentEvent.getSlot().equals((Object)BMoonPosition.phase) || bComponentEvent.getSlot().equals((Object)BMoonPosition.illumination))) {
            this.doLoadValue((BObject)((BMoonPosition)bComponentEvent.getSourceComponent()), this.getCurrentContext());
            this.relayout();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$weather$ui$BMoonView;
        if (clazz == null) {
            clazz = class$com$tridium$weather$ui$BMoonView = BMoonView.class("[Lcom.tridium.weather.ui.BMoonView;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

