/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.ui;

import com.tridium.weather.AirQualityIndexUtil;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BForecast;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BForecastAirQualityView
extends BWbComponentView {
    private static Lexicon lex = Lexicon.make((String)"weather");
    public static final Property font = BForecastAirQualityView.newProperty((int)0, (BValue)BFont.make((String)lex.getText("state.font")), null);
    public static final Property showAqi = BForecastAirQualityView.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE;
    private BLabel label;
    static /* synthetic */ Class class$com$tridium$weather$ui$BForecastAirQualityView;

    public BFont getFont() {
        return (BFont)this.get(font);
    }

    public void setFont(BFont bFont) {
        this.set(font, (BValue)bFont, null);
    }

    public boolean getShowAqi() {
        return this.getBoolean(showAqi);
    }

    public void setShowAqi(boolean bl) {
        this.setBoolean(showAqi, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.getCurrentValue() == null) {
            return;
        }
        if (property.equals((Object)font) || property.equals((Object)showAqi)) {
            this.loadValue(this.getCurrentValue(), this.getCurrentContext());
        }
    }

    protected void doLoadValue(BObject bObject, Context context) {
        BForecast bForecast = (BForecast)bObject;
        bForecast.lease();
        this.label = new BLabel();
        this.label.setLayout(BLayout.FILL);
        this.label.setFont(this.getFont());
        int n = -1;
        int n2 = -1;
        if (!bForecast.getOzone().getStatus().isNull()) {
            n = AirQualityIndexUtil.ozoneConcentrationToAqi(bForecast.getOzone().getValue());
        }
        if (!bForecast.getParticulateMatter().getStatus().isNull()) {
            n2 = AirQualityIndexUtil.particulateConcentrationToAqi(bForecast.getParticulateMatter().getValue());
        }
        int n3 = Math.max(n, n2);
        StringBuffer stringBuffer = new StringBuffer();
        if (n3 == -1 || !this.getEnabled()) {
            stringBuffer.append(lex.get("airQuality.unknown"));
            this.label.setForeground(BBrush.makeSolid((BColor)BColor.black));
            this.label.setBackground(BBrush.makeSolid((BColor)BColor.white));
        } else if (n3 <= 50) {
            stringBuffer.append(lex.get("airQuality.good"));
            this.label.setForeground(BBrush.makeSolid((BColor)BColor.black));
            this.label.setBackground(BBrush.makeSolid((BColor)BColor.make((int)0, (int)228, (int)0)));
        } else if (n3 <= 100) {
            stringBuffer.append(lex.get("airQuality.moderate"));
            this.label.setForeground(BBrush.makeSolid((BColor)BColor.black));
            this.label.setBackground(BBrush.makeSolid((BColor)BColor.make((int)255, (int)255, (int)0)));
        } else if (n3 <= 150) {
            stringBuffer.append(lex.get("airQuality.unhealthyForSensitiveGroups"));
            this.label.setForeground(BBrush.makeSolid((BColor)BColor.black));
            this.label.setBackground(BBrush.makeSolid((BColor)BColor.make((int)255, (int)126, (int)0)));
        } else if (n3 <= 200) {
            stringBuffer.append(lex.get("airQuality.unhealthy"));
            this.label.setForeground(BBrush.makeSolid((BColor)BColor.white));
            this.label.setBackground(BBrush.makeSolid((BColor)BColor.make((int)255, (int)0, (int)0)));
        } else if (n3 <= 300) {
            stringBuffer.append(lex.get("airQuality.veryUnhealthy"));
            this.label.setForeground(BBrush.makeSolid((BColor)BColor.white));
            this.label.setBackground(BBrush.makeSolid((BColor)BColor.make((int)153, (int)0, (int)76)));
        } else {
            stringBuffer.append(lex.get("airQuality.hazardous"));
            this.label.setForeground(BBrush.makeSolid((BColor)BColor.white));
            this.label.setBackground(BBrush.makeSolid((BColor)BColor.make((int)126, (int)0, (int)35)));
        }
        if (this.getShowAqi() && n3 != -1 && this.getEnabled()) {
            stringBuffer.append(" (").append(n3).append(")");
        }
        this.label.setText(stringBuffer.toString());
        this.setContent((BWidget)this.label);
        this.registerForComponentEvents(bForecast);
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        BComponent bComponent = bComponentEvent.getSourceComponent();
        if (bComponent instanceof BForecast) {
            BForecast bForecast = (BForecast)bComponent;
            if (bComponentEvent.getSlot().equals((Object)BCurrentConditions.ozone) || bComponentEvent.getSlot().equals((Object)BCurrentConditions.particulateMatter)) {
                this.loadValue((BObject)bForecast, this.getCurrentContext());
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$weather$ui$BForecastAirQualityView;
        if (clazz == null) {
            clazz = class$com$tridium$weather$ui$BForecastAirQualityView = BForecastAirQualityView.class("[Lcom.tridium.weather.ui.BForecastAirQualityView;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

