/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.ui;

import com.tridium.weather.ui.BWeatherIconSize;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BWeatherReport;
import javax.baja.weather.advisory.BAdvisory;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCurrentWeatherView
extends BWbComponentView {
    private static Lexicon lex = Lexicon.make((String)"weather");
    public static final Property iconSize = BCurrentWeatherView.newProperty((int)0, (BValue)BWeatherIconSize.x64, null);
    public static final Property tempFont = BCurrentWeatherView.newProperty((int)0, (BValue)BFont.make((String)lex.getText("temp.font")), null);
    public static final Property tempBrush = BCurrentWeatherView.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Property stateFont = BCurrentWeatherView.newProperty((int)0, (BValue)BFont.make((String)lex.getText("state.font")), null);
    public static final Property stateBrush = BCurrentWeatherView.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Property alarmStateBrush = BCurrentWeatherView.newProperty((int)0, (BValue)BColor.red.toBrush(), null);
    public static final Property halign = BCurrentWeatherView.newProperty((int)0, (BValue)BHalign.center, null);
    public static final Property valign = BCurrentWeatherView.newProperty((int)0, (BValue)BValign.center, null);
    public static final Type TYPE;
    private BLabel icon;
    private BLabel temperature;
    private BLabel state;
    private Context cx;
    static /* synthetic */ Class class$com$tridium$weather$ui$BCurrentWeatherView;

    public BWeatherIconSize getIconSize() {
        return (BWeatherIconSize)this.get(iconSize);
    }

    public void setIconSize(BWeatherIconSize bWeatherIconSize) {
        this.set(iconSize, (BValue)bWeatherIconSize, null);
    }

    public BFont getTempFont() {
        return (BFont)this.get(tempFont);
    }

    public void setTempFont(BFont bFont) {
        this.set(tempFont, (BValue)bFont, null);
    }

    public BBrush getTempBrush() {
        return (BBrush)this.get(tempBrush);
    }

    public void setTempBrush(BBrush bBrush) {
        this.set(tempBrush, (BValue)bBrush, null);
    }

    public BFont getStateFont() {
        return (BFont)this.get(stateFont);
    }

    public void setStateFont(BFont bFont) {
        this.set(stateFont, (BValue)bFont, null);
    }

    public BBrush getStateBrush() {
        return (BBrush)this.get(stateBrush);
    }

    public void setStateBrush(BBrush bBrush) {
        this.set(stateBrush, (BValue)bBrush, null);
    }

    public BBrush getAlarmStateBrush() {
        return (BBrush)this.get(alarmStateBrush);
    }

    public void setAlarmStateBrush(BBrush bBrush) {
        this.set(alarmStateBrush, (BValue)bBrush, null);
    }

    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    public void setHalign(BHalign bHalign) {
        this.set(halign, (BValue)bHalign, null);
    }

    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    public void setValign(BValign bValign) {
        this.set(valign, (BValue)bValign, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.getCurrentValue() == null) {
            return;
        }
        if (property.equals((Object)iconSize) || property.equals((Object)tempFont) || property.equals((Object)tempBrush) || property.equals((Object)stateFont) || property.equals((Object)stateBrush) || property.equals((Object)halign) || property.equals((Object)valign)) {
            this.loadValue(this.getCurrentValue(), this.getCurrentContext());
        }
    }

    protected void doLoadValue(BObject bObject, Context context) {
        BAdvisory bAdvisory;
        BCurrentConditions bCurrentConditions;
        this.cx = context;
        if (bObject instanceof BWeatherReport) {
            bCurrentConditions = ((BWeatherReport)bObject).getCurrent();
        } else if (bObject instanceof BCurrentConditions) {
            bCurrentConditions = (BCurrentConditions)bObject;
        } else {
            throw new IllegalStateException("No current conditions available from " + bObject.getType());
        }
        bCurrentConditions.lease();
        BFacets bFacets = bCurrentConditions.getSlotFacets((Slot)BCurrentConditions.temp);
        this.temperature = new BLabel(bCurrentConditions.getTemp().valueToString((Context)bFacets));
        this.temperature.setFont(this.getTempFont());
        this.temperature.setForeground(this.getTempBrush());
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setRowGap(1.0);
        if (bCurrentConditions.getTemp().getStatus().isValid()) {
            bGridPane.add(null, (BValue)this.temperature);
        }
        if (bCurrentConditions.getState().getStatus().isValid()) {
            bCurrentConditions.getAdvisories().lease();
            bAdvisory = bCurrentConditions.getAdvisories().getMostUrgent();
            if (bAdvisory != null) {
                bAdvisory.lease();
                this.state = new BLabel(bAdvisory.getWeatherSummary().getValue());
                this.state.setForeground(this.getAlarmStateBrush());
                String string = bAdvisory.getState().getValue().getOrdinal() != 21 ? BCurrentWeatherView.getWeatherIcon(bAdvisory.getState().getEnum(), bCurrentConditions.getSunDown().getBoolean()) : BCurrentWeatherView.getWeatherIcon(bCurrentConditions.getState().getEnum(), bCurrentConditions.getSunDown().getBoolean());
                if (!bCurrentConditions.getState().getStatus().isValid()) {
                    string = "unknown";
                }
                String string2 = this.getIconSize() == BWeatherIconSize.x64 ? "64" : "32";
                this.icon = new BLabel(BImage.make((String)("module://weather/rc/" + string + string2 + ".png")));
            } else {
                this.state = new BLabel(bCurrentConditions.getState().valueToString(context));
                this.state.setForeground(this.getStateBrush());
                String string = BCurrentWeatherView.getWeatherIcon(bCurrentConditions.getState().getEnum(), bCurrentConditions.getSunDown().getBoolean());
                if (!bCurrentConditions.getState().getStatus().isValid()) {
                    string = "unknown";
                }
                String string3 = this.getIconSize() == BWeatherIconSize.x64 ? "64" : "32";
                this.icon = new BLabel(BImage.make((String)("module://weather/rc/" + string + string3 + ".png")));
            }
            this.state.setFont(this.getStateFont());
            bGridPane.add(null, (BValue)this.state);
        } else {
            this.icon = new BLabel(BImage.make((String)"module://weather/rc/unknown32.png"));
        }
        bAdvisory = new BGridPane(2);
        bAdvisory.setColumnGap(6.0);
        bAdvisory.add(null, (BValue)this.icon);
        bAdvisory.add(null, (BValue)bGridPane);
        bAdvisory.setHalign(this.getHalign());
        bAdvisory.setValign(this.getValign());
        this.setContent((BWidget)bAdvisory);
        this.registerForComponentEvents(bCurrentConditions);
    }

    public static String getWeatherIcon(BEnum bEnum) {
        return BCurrentWeatherView.getWeatherIcon(bEnum, false);
    }

    public static String getWeatherIcon(BEnum bEnum, boolean bl) {
        switch (bEnum.getOrdinal()) {
            case 0: 
            case 1: 
            case 4: {
                if (!bl) {
                    return "sunny";
                }
                return "nightClear";
            }
            case 3: 
            case 7: {
                if (!bl) {
                    return "partlySunny";
                }
                return "nightMostlyCloudy";
            }
            case 2: 
            case 5: 
            case 6: {
                if (!bl) {
                    return "mostlySunny";
                }
                return "nightPartlyCloudy";
            }
            case 8: 
            case 9: {
                return "cloudy";
            }
            case 15: {
                if (!bl) {
                    return "fog";
                }
                return "nightFog";
            }
            case 16: {
                return "haze";
            }
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 26: {
                return "rain";
            }
            case 14: {
                return "freezingRain";
            }
            case 13: {
                return "thunder";
            }
            case 17: {
                return "snow";
            }
            case 18: 
            case 23: {
                return "windy";
            }
            case 20: {
                return "dust";
            }
            case 22: 
            case 24: {
                return "flood";
            }
            case 27: {
                return "earthquake";
            }
            case 25: 
            case 28: {
                return "fire";
            }
        }
        return "unknown";
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        BComponent bComponent = bComponentEvent.getSourceComponent();
        if (bComponent instanceof BCurrentConditions) {
            BCurrentConditions bCurrentConditions = (BCurrentConditions)bComponent;
            if (bComponentEvent.getSlot().equals((Object)BCurrentConditions.temp)) {
                this.temperature.setText(bCurrentConditions.getTemp().valueToString((Context)bCurrentConditions.getSlotFacets((Slot)BCurrentConditions.temp)));
            }
            if (bComponentEvent.getSlot().equals((Object)BCurrentConditions.state) || bComponentEvent.getSlot().equals((Object)BCurrentConditions.status)) {
                String string = BCurrentWeatherView.getWeatherIcon(bCurrentConditions.getState().getEnum(), bCurrentConditions.getSunDown().getBoolean());
                if (!bCurrentConditions.getState().getStatus().isValid()) {
                    string = "unknown";
                }
                String string2 = this.getIconSize() == BWeatherIconSize.x64 ? "64" : "32";
                this.icon.setImage(BImage.make((String)("module://weather/rc/" + string + string2 + ".png")));
                if (bCurrentConditions.getState().getStatus().isValid()) {
                    if (bCurrentConditions.getStatus().isAlarm()) {
                        this.state.setText(bCurrentConditions.getWeatherSummary().getValue());
                    } else {
                        this.state.setText(bCurrentConditions.getState().valueToString(this.cx));
                    }
                }
            }
            this.relayout();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$weather$ui$BCurrentWeatherView;
        if (clazz == null) {
            clazz = class$com$tridium$weather$ui$BCurrentWeatherView = BCurrentWeatherView.class("[Lcom.tridium.weather.ui.BCurrentWeatherView;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

