/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws;

import java.io.InputStream;
import java.util.ArrayList;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public final class NwsStationList {
    private static Station[] list = null;

    public final String[] getStates() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < list.length) {
            Station station = list[n];
            if (!arrayList.contains(station.state) && station.name.length() > 0 && station.latitude != 0.0 && station.longitude != 0.0) {
                arrayList.add(station.state);
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public final String[] getLocations(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < list.length) {
            Station station = list[n];
            if (string.equals(station.state) && station.name.length() > 0 && station.latitude != 0.0 && station.longitude != 0.0) {
                arrayList.add(station.name);
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public final String getStationId(String string, String string2) {
        if (string == null || string2 == null) {
            return "";
        }
        int n = 0;
        while (n < list.length) {
            Station station = list[n];
            if (string.equals(station.name) && string2.equals(station.state)) {
                return station.id;
            }
            ++n;
        }
        return "";
    }

    public final String searchStationId(String string, String string2) {
        int n = 0;
        while (n < list.length) {
            Station station = list[n];
            if (station.name.toLowerCase().indexOf(string.toLowerCase()) > -1 && string2.equalsIgnoreCase(station.state)) {
                return station.id;
            }
            ++n;
        }
        return null;
    }

    public final Station getStation(String string) {
        int n = 0;
        while (n < list.length) {
            Station station = list[n];
            if (station.id.equals(string)) {
                return station;
            }
            ++n;
        }
        return null;
    }

    private final void loadStationList() {
        try {
            BOrd bOrd = BOrd.make((String)"module://weather/com/tridium/weather/nws/nwsStationList.xml");
            BIFile bIFile = (BIFile)bOrd.resolve().get();
            XElem xElem = XParser.make((InputStream)bIFile.getInputStream()).parse();
            XElem[] xElemArray = xElem.elems();
            list = new Station[xElemArray.length];
            int n = 0;
            while (n < list.length) {
                Station station = new Station();
                station.state = xElemArray[n].get("s", "");
                station.id = xElemArray[n].get("i", "");
                station.name = xElemArray[n].get("n", "");
                station.latitude = xElemArray[n].getd("x", Double.NaN);
                station.longitude = xElemArray[n].getd("y", Double.NaN);
                station.zone = xElemArray[n].get("z", null);
                station.zipCode = xElemArray[n].get("c", null);
                NwsStationList.list[n] = station;
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public NwsStationList() {
        if (list == null) {
            this.loadStationList();
        }
    }

    public static class Station {
        public String state;
        public String id;
        public String name;
        public double latitude;
        public double longitude;
        public String zone;
        public String zipCode;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name);
            stringBuffer.append(", ").append(this.state);
            return stringBuffer.toString();
        }
    }
}

