/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws;

import com.tridium.weather.nws.BNwsWeatherProvider;
import com.tridium.weather.nws.FeedReader;
import com.tridium.weather.nws.NwsStationList;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnum;
import javax.baja.sys.BMonth;
import javax.baja.sys.BajaException;
import javax.baja.timezone.BTimeZone;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BWeatherState;
import javax.baja.weather.BWindDirection;
import javax.baja.weather.advisory.BAdvisory;
import javax.baja.weather.advisory.BAdvisoryUrgency;
import javax.baja.xml.XElem;

public class NwsCurrentReader {
    static final Log log = Log.getLog((String)"weather");
    private static final int MAX_REDIRECTS = 5;
    BNwsWeatherProvider provider;

    XElem getFeed(NwsStationList.Station station) throws Exception {
        String string = this.provider.getConditionsPath() + station.id + ".xml";
        return this.getFeed(station, this.provider.getConditionsServer(), string);
    }

    XElem getFeed(NwsStationList.Station station, String string, String string2) throws Exception {
        try {
            return FeedReader.getFeed(string, string2, 5, false);
        }
        catch (IOException iOException) {
            throw new BajaException("Unable to get NWS Current Conditions feed", (Throwable)iOException);
        }
    }

    public void getCurrent(BNwsWeatherProvider bNwsWeatherProvider, BCurrentConditions bCurrentConditions, NwsStationList.Station station) throws Exception {
        String string;
        String string2;
        Object object;
        XElem[] xElemArray;
        XElem xElem = this.getFeed(station);
        bCurrentConditions.setSun(station.longitude, station.latitude);
        try {
            xElemArray = xElem.elem("observation_time_rfc822").string();
            object = new SimpleDateFormat("EEE, d MMM yy HH:mm:ss z");
            Date date = ((DateFormat)object).parse((String)xElemArray);
            string2 = BTimeZone.makeIgnoringCache((String)"nws_CurrentObservations", (int)(-1 * date.getTimezoneOffset() * 60 * 1000));
            string = BAbsTime.make((int)(date.getYear() + 1900), (BMonth)BMonth.make((int)date.getMonth()), (int)date.getDate(), (int)date.getHours(), (int)date.getMinutes(), (int)date.getSeconds(), (int)0, (BTimeZone)string2);
            bCurrentConditions.setObserved(BAbsTime.make((BAbsTime)string, (BTimeZone)BTimeZone.getLocal()));
        }
        catch (Exception exception) {
            bCurrentConditions.setObserved(BAbsTime.NULL);
        }
        xElemArray = xElem.elems();
        object = null;
        int n = 0;
        while (n < xElemArray.length) {
            string2 = xElemArray[n].name();
            if (xElemArray[n].contentSize() != 0) {
                string = String.valueOf(xElemArray[n].content(0));
                if (string2.equals("temp_f")) {
                    this.setStatusNumeric(bCurrentConditions.getTemp(), string);
                } else if (string2.equals("weather")) {
                    object = string;
                    this.setStatusString(bCurrentConditions.getWeatherSummary(), (String)object);
                } else if (string2.equals("location")) {
                    bNwsWeatherProvider.setLocation(string.toString());
                } else if (string2.equals("wind_dir")) {
                    this.setWindDir(bCurrentConditions.getWindDirection(), string);
                } else if (string2.equals("wind_mph")) {
                    this.setStatusNumeric(bCurrentConditions.getWindSpeed(), string);
                } else if (string2.equals("wind_gust_mph")) {
                    this.setStatusNumeric(bCurrentConditions.getWindGust(), string);
                } else if (string2.equals("windchill_f")) {
                    this.setStatusNumeric(bCurrentConditions.getWindChill(), string);
                } else if (string2.equals("relative_humidity")) {
                    this.setStatusNumeric(bCurrentConditions.getHumidity(), string);
                } else if (string2.equals("pressure_in")) {
                    this.setStatusNumeric(bCurrentConditions.getPressure(), string);
                } else if (string2.equals("heat_index_f")) {
                    this.setStatusNumeric(bCurrentConditions.getHeatIndex(), string);
                } else if (string2.equals("dewpoint_f")) {
                    this.setStatusNumeric(bCurrentConditions.getDewPoint(), string);
                } else if (string2.equals("visibility_mi")) {
                    this.setStatusNumeric(bCurrentConditions.getVisibility(), string);
                }
            }
            ++n;
        }
        BAdvisory bAdvisory = bCurrentConditions.getAdvisories().getMostUrgent();
        if (bAdvisory != null && (bAdvisory.getUrgency().equals((Object)BAdvisoryUrgency.immediate) || bAdvisory.getUrgency().equals((Object)BAdvisoryUrgency.expected))) {
            if (!bAdvisory.getState().equals((Object)BWeatherState.unknown)) {
                bCurrentConditions.getState().setValue(bAdvisory.getState().getValue());
            } else {
                bCurrentConditions.getState().setValue((BEnum)BWeatherState.make((String)object));
            }
        } else {
            bCurrentConditions.getState().setValue((BEnum)BWeatherState.make((String)object));
        }
        try {
            if (bCurrentConditions.getTemp().getValue() > -50.0 && bCurrentConditions.getTemp().getValue() < 50.0 && bCurrentConditions.getWindSpeed().getValue() > (double)3 && bCurrentConditions.getWindSpeed().getValue() < 110.0) {
                double d = 35.74 + 0.6215 * bCurrentConditions.getTemp().getValue() + (0.4275 * bCurrentConditions.getTemp().getValue() - 35.75) * Math.pow(bCurrentConditions.getWindSpeed().getValue(), 0.16);
                bCurrentConditions.getWindChill().setValue(d);
                bCurrentConditions.getWindChill().setStatusNull(false);
            } else {
                bCurrentConditions.getWindChill().setStatusNull(true);
                bCurrentConditions.getWindChill().setValue(Double.NaN);
            }
        }
        catch (Exception exception) {
            log.warning("Unable to calculate wind chill", (Throwable)exception);
            bCurrentConditions.getWindChill().setStatusNull(true);
            bCurrentConditions.getWindChill().setValue(Double.NaN);
        }
        try {
            if (bCurrentConditions.getTemp().getValue() > 80.0 && bCurrentConditions.getDewPoint().getValue() > 60.0 && bCurrentConditions.getHumidity().getValue() > 40.0) {
                double d = bCurrentConditions.getHumidity().getValue();
                double d2 = bCurrentConditions.getTemp().getValue();
                double d3 = -42.379 + 2.04901523 * d2 + 10.14333127 * d - 0.22475541 * d2 * d - 6.83783 * Math.pow(10.0, -3.0) * Math.pow(d2, 2) - 5.481717 * Math.pow(10.0, -2.0) * Math.pow(d, 2) + 1.22874 * Math.pow(10.0, -3.0) * Math.pow(d2, 2) * d + 8.5282 * Math.pow(10.0, -4.0) * d2 * Math.pow(d, 2) - 1.99 * Math.pow(10.0, -6.0) * Math.pow(d2, 2) * Math.pow(d, 2);
                bCurrentConditions.getHeatIndex().setStatus(BStatus.ok);
                bCurrentConditions.getHeatIndex().setValue(d3);
            } else {
                bCurrentConditions.getHeatIndex().setStatusNull(true);
                bCurrentConditions.getHeatIndex().setValue(Double.NaN);
            }
        }
        catch (Exception exception) {
            log.warning("Unable to calculate head index", (Throwable)exception);
            bCurrentConditions.getHeatIndex().setStatusNull(true);
            bCurrentConditions.getHeatIndex().setValue(Double.NaN);
        }
        bCurrentConditions.setLastUpdate(BAbsTime.now());
    }

    private final void setWindDir(BStatusEnum bStatusEnum, String string) throws Exception {
        if (string.equals("North")) {
            this.setStatusEnum(bStatusEnum, (BEnum)BWindDirection.north);
        } else if (string.equals("Northeast")) {
            this.setStatusEnum(bStatusEnum, (BEnum)BWindDirection.northeast);
        } else if (string.equals("East")) {
            this.setStatusEnum(bStatusEnum, (BEnum)BWindDirection.east);
        } else if (string.equals("Southeast")) {
            this.setStatusEnum(bStatusEnum, (BEnum)BWindDirection.southeast);
        } else if (string.equals("South")) {
            this.setStatusEnum(bStatusEnum, (BEnum)BWindDirection.south);
        } else if (string.equals("Southwest")) {
            this.setStatusEnum(bStatusEnum, (BEnum)BWindDirection.southwest);
        } else if (string.equals("West")) {
            this.setStatusEnum(bStatusEnum, (BEnum)BWindDirection.west);
        } else if (string.equals("Northwest")) {
            this.setStatusEnum(bStatusEnum, (BEnum)BWindDirection.northwest);
        } else if (string.equals("Variable")) {
            this.setStatusEnum(bStatusEnum, (BEnum)BWindDirection.variable);
        } else {
            this.setStatusEnum(bStatusEnum, null);
        }
    }

    private final void setStatusString(BStatusString bStatusString, String string) throws Exception {
        try {
            if (string != null && !string.equalsIgnoreCase("NULL")) {
                bStatusString.setStatusNull(false);
                bStatusString.setValue(string);
            } else {
                bStatusString.setStatusNull(true);
            }
        }
        catch (Exception exception) {
            bStatusString.setStatusNull(true);
        }
    }

    private final void setStatusNumeric(BStatusNumeric bStatusNumeric, String string) throws Exception {
        try {
            if (string != null && !string.equalsIgnoreCase("NULL")) {
                bStatusNumeric.setStatusNull(false);
                bStatusNumeric.setValue(Double.parseDouble(string));
            } else {
                bStatusNumeric.setStatusNull(true);
            }
        }
        catch (Exception exception) {
            bStatusNumeric.setStatusNull(true);
        }
    }

    private final void setStatusEnum(BStatusEnum bStatusEnum, BEnum bEnum) throws Exception {
        try {
            if (bEnum != null) {
                bStatusEnum.setStatusNull(false);
                bStatusEnum.setValue(bEnum);
            } else {
                bStatusEnum.setStatusNull(true);
            }
        }
        catch (Exception exception) {
            bStatusEnum.setStatusNull(true);
        }
    }

    public NwsCurrentReader(BNwsWeatherProvider bNwsWeatherProvider) {
        this.provider = bNwsWeatherProvider;
    }
}

