/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws;

import com.tridium.weather.AirQualityIndexUtil;
import com.tridium.weather.nws.BNwsWeatherProvider;
import com.tridium.weather.nws.FeedReader;
import com.tridium.weather.nws.NwsStationList;
import java.io.IOException;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.sys.BajaException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BWeatherService;
import javax.baja.xml.XElem;

public class EpaCurrentReader {
    static final Log log = Log.getLog((String)"weather");
    private static final int MAX_REDIRECTS = 5;
    BNwsWeatherProvider provider;

    XElem getFeed(NwsStationList.Station station) throws Exception {
        BWeatherService bWeatherService = (BWeatherService)Sys.getService((Type)BWeatherService.TYPE);
        String string = bWeatherService.getAirQualityApiKey();
        if (string.equals("")) {
            throw new Exception("Air Quality API key has not been set.");
        }
        String string2 = this.provider.getAirQualityCurrentPath() + station.zipCode + this.provider.getAirQualityApiKeyField() + string;
        String string3 = this.provider.getAirQualityHost();
        return this.getFeed(station, string3, string2);
    }

    XElem getFeed(NwsStationList.Station station, String string, String string2) throws Exception {
        try {
            return FeedReader.getFeed(string, string2, 5, false);
        }
        catch (IOException iOException) {
            throw new BajaException("Unable to get EPA Current Conditions feed", (Throwable)iOException);
        }
    }

    public void getCurrent(BNwsWeatherProvider bNwsWeatherProvider, BCurrentConditions bCurrentConditions, NwsStationList.Station station) throws Exception {
        if (station.zipCode == null) {
            return;
        }
        if (!bNwsWeatherProvider.getAirQualityEnabled()) {
            bCurrentConditions.getOzone().setValue(Double.NaN);
            bCurrentConditions.getOzone().setStatus(BStatus.nullStatus);
            bCurrentConditions.getParticulateMatter().setValue(Double.NaN);
            bCurrentConditions.getParticulateMatter().setStatus(BStatus.nullStatus);
            return;
        }
        XElem[] xElemArray = new XElem[]{};
        boolean bl = false;
        try {
            XElem xElem = this.getFeed(station);
            xElemArray = xElem.elems("ObsByZip");
            if (xElemArray.length == 0) {
                if (xElem.name().equals("WebServiceError")) {
                    if (xElem.elem("Message").text().string().indexOf("Web service request limit exceeded") != -1) {
                        log.warning("Exceeded Air quality request limit. Change the poll frequency, or request a new API key from http://airnowapi.org/");
                    } else {
                        log.warning("Air quality web service error.");
                    }
                } else if (xElem.name().equals("ObsByZipList")) {
                    log.warning("No air quality reporting stations nearby.");
                } else {
                    log.warning("Air quality unknown error.");
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            log.error("Unable to retrieve EPA current air quality.", (Throwable)exception);
            bl = true;
        }
        if (bl) {
            bCurrentConditions.getOzone().setStatus(BStatus.makeStale((BStatus)bCurrentConditions.getOzone().getStatus(), (boolean)true));
            bCurrentConditions.getParticulateMatter().setStatus(BStatus.makeStale((BStatus)bCurrentConditions.getParticulateMatter().getStatus(), (boolean)true));
            return;
        }
        try {
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            while (n < xElemArray.length) {
                XElem xElem = xElemArray[n];
                try {
                    double d;
                    int n2;
                    if (xElem.elem("ParameterName").text().string().equalsIgnoreCase("ozone")) {
                        try {
                            n2 = Integer.parseInt(xElem.elem("AQI").text().string());
                            d = AirQualityIndexUtil.aqiToOzoneConcentration(n2);
                            bCurrentConditions.getOzone().setValue(d);
                            bCurrentConditions.getOzone().setStatus(BStatus.ok);
                            bl2 = true;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    if (xElem.elem("ParameterName").text().string().equalsIgnoreCase("pm2.5")) {
                        try {
                            n2 = Integer.parseInt(xElem.elem("AQI").text().string());
                            d = AirQualityIndexUtil.aqiToParticulateConcentration(n2);
                            bCurrentConditions.getParticulateMatter().setValue(d);
                            bCurrentConditions.getParticulateMatter().setStatus(BStatus.ok);
                            bl3 = true;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                catch (Exception exception) {
                    log.warning("Difficulty parsing current air quality data.", (Throwable)exception);
                }
                ++n;
            }
            if (!bl2) {
                bCurrentConditions.getOzone().setValue(Double.NaN);
                bCurrentConditions.getOzone().setStatus(BStatus.nullStatus);
            }
            if (!bl3) {
                bCurrentConditions.getParticulateMatter().setValue(Double.NaN);
                bCurrentConditions.getParticulateMatter().setStatus(BStatus.nullStatus);
            }
        }
        catch (Exception exception) {
            log.error("Unable to get current air quality data.", (Throwable)exception);
            bCurrentConditions.getOzone().setValue(Double.NaN);
            bCurrentConditions.getOzone().setStatus(BStatus.fault);
            bCurrentConditions.getParticulateMatter().setValue(Double.NaN);
            bCurrentConditions.getParticulateMatter().setStatus(BStatus.fault);
        }
    }

    public EpaCurrentReader(BNwsWeatherProvider bNwsWeatherProvider) {
        this.provider = bNwsWeatherProvider;
    }
}

