/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather;

import java.security.InvalidParameterException;

public class AirQualityIndexUtil {
    private static final double[][] O3;
    private static final double[][] PM25;

    public static double aqiToOzoneConcentration(int n) {
        return AirQualityIndexUtil.aqiToConcentration(O3, n);
    }

    public static int ozoneConcentrationToAqi(double d) {
        return AirQualityIndexUtil.concentrationToAqi(O3, d);
    }

    public static double aqiToParticulateConcentration(int n) {
        return AirQualityIndexUtil.aqiToConcentration(PM25, n);
    }

    public static int particulateConcentrationToAqi(double d) {
        return AirQualityIndexUtil.concentrationToAqi(PM25, d);
    }

    private static final double aqiToConcentration(double[][] dArray, int n) {
        int n2 = 0;
        while (n2 < dArray.length) {
            double d = dArray[n2][2];
            double d2 = dArray[n2][3];
            if ((double)n >= d && (double)n <= d2) {
                double d3 = dArray[n2][0];
                double d4 = dArray[n2][1];
                return d3 + ((double)n - d) * ((d4 - d3) / (d2 - d));
            }
            ++n2;
        }
        throw new InvalidParameterException("Invalid AQI value: " + n);
    }

    private static final int concentrationToAqi(double[][] dArray, double d) {
        int n = 0;
        while (n < dArray.length) {
            double d2 = dArray[n][0];
            double d3 = dArray[n][1];
            if (d >= d2 && d <= d3) {
                double d4 = dArray[n][2];
                double d5 = dArray[n][3];
                return (int)Math.ceil((d5 - d4) * ((d - d2) / (d3 - d2)) + d4);
            }
            ++n;
        }
        throw new InvalidParameterException("Invalid concentration value: " + d);
    }

    static {
        double[][] dArrayArray = new double[7][];
        double[] dArray = new double[4];
        dArray[1] = 0.059;
        dArray[3] = 50.0;
        dArrayArray[0] = dArray;
        dArrayArray[1] = new double[]{0.06, 0.075, 51.0, 100.0};
        dArrayArray[2] = new double[]{0.076, 0.095, 101.0, 150.0};
        dArrayArray[3] = new double[]{0.096, 0.115, 151.0, 200.0};
        dArrayArray[4] = new double[]{0.116, 0.404, 201.0, 300.0};
        dArrayArray[5] = new double[]{0.405, 0.504, 301.0, 400.0};
        dArrayArray[6] = new double[]{0.505, 0.604, 401.0, 500.0};
        O3 = dArrayArray;
        double[][] dArrayArray2 = new double[7][];
        double[] dArray2 = new double[4];
        dArray2[1] = 15.4;
        dArray2[3] = 50.0;
        dArrayArray2[0] = dArray2;
        dArrayArray2[1] = new double[]{15.5, 40.5, 51.0, 100.0};
        dArrayArray2[2] = new double[]{40.5, 64.4, 101.0, 150.0};
        dArrayArray2[3] = new double[]{65.5, 150.4, 151.0, 200.0};
        dArrayArray2[4] = new double[]{150.5, 250.4, 201.0, 300.0};
        dArrayArray2[5] = new double[]{250.5, 350.4, 301.0, 400.0};
        dArrayArray2[6] = new double[]{350.5, 500.4, 401.0, 500.0};
        PM25 = dArrayArray2;
    }
}

