/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.query;

import com.tridium.bql.BBqlExtent;
import com.tridium.bql.BBqlInterval;
import com.tridium.bql.BBqlLibrary;
import com.tridium.bql.BBqlTime;
import com.tridium.bql.BSelect;
import com.tridium.bql.expression.BBqlFunction;
import com.tridium.query.QueryStringVisitor;
import javax.baja.bql.BqlQuery;
import javax.baja.query.BExtent;
import javax.baja.query.BNull;
import javax.baja.query.BQuery;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.expression.BSimpleExpression;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Type;

public class BqlVisitor
extends QueryStringVisitor {
    public void visit(BQuery bQuery) {
        BSelect bSelect;
        this.queryText.append("SELECT ");
        if (bQuery instanceof BSelect && (bSelect = (BSelect)bQuery).getTop() != null) {
            this.queryText.append("TOP ").append(bSelect.getTop().getLimit()).append(' ');
        }
        if (bQuery.hasProjection()) {
            this.visit(bQuery.getProjection());
        }
        if (bQuery.hasExtent()) {
            this.visit(bQuery.getExtent());
        }
        if (bQuery.hasPredicate()) {
            this.queryText.append("WHERE ");
            this.visit(bQuery.getPredicate());
            this.queryText.append(' ');
        }
        if (bQuery.hasHaving()) {
            this.queryText.append("HAVING ");
            this.visit(bQuery.getHaving());
            this.queryText.append(' ');
        }
        if (bQuery.hasOrdering()) {
            this.queryText.append("ORDER BY ");
            this.visit(bQuery.getOrdering());
            this.queryText.append(' ');
        }
    }

    public void visit(BExtent bExtent) {
        String[] stringArray = bExtent.list();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                this.queryText.append(", ");
            } else {
                this.queryText.append("FROM ");
            }
            this.queryText.append(stringArray[n]);
            ++n;
        }
        if (bExtent instanceof BBqlExtent) {
            BBqlExtent bBqlExtent = (BBqlExtent)bExtent;
            if (bBqlExtent.getDepth() != Integer.MAX_VALUE) {
                this.queryText.append(" DEPTH=").append(bBqlExtent.getDepth());
            }
            if (bBqlExtent.getStop()) {
                this.queryText.append(" STOP");
            }
        }
        this.queryText.append(' ');
    }

    public void visit(BFunctionExpression bFunctionExpression) {
        BBqlFunction bBqlFunction;
        if (bFunctionExpression instanceof BBqlFunction && !(bBqlFunction = (BBqlFunction)bFunctionExpression).getLib().getResolvedType().equals(BBqlLibrary.TYPE)) {
            if (bBqlFunction.getLib().getResolvedType().equals(BBqlTime.TYPE)) {
                this.queryText.append("bqltime.");
            } else {
                this.queryText.append(bBqlFunction.getLib().toString()).append('.');
            }
        }
        super.visit(bFunctionExpression);
    }

    public void visit(BSimpleExpression bSimpleExpression) {
        BSimple bSimple = bSimpleExpression.getSimpleValue();
        Type type = bSimple.getType();
        if (type.is(BString.TYPE)) {
            this.queryText.append("'").append(bSimple.toString()).append("'");
        } else if (type.is(BNumber.TYPE)) {
            this.queryText.append(bSimple.toString());
        } else if (type.is(BBoolean.TYPE)) {
            this.queryText.append(((BBoolean)bSimple).getDisplayTag(null));
        } else if (type.is(BFrozenEnum.TYPE)) {
            this.queryText.append(type.toString()).append('.').append(((BFrozenEnum)bSimple).getTag());
        } else if (type.is(BNull.TYPE)) {
            this.queryText.append(BNull.NULL.toString(null));
        } else if (type.is(BBqlInterval.TYPE)) {
            this.queryText.append("interval '").append(bSimple.toString()).append("'");
        } else {
            this.queryText.append(BqlQuery.toBqlLiteral(bSimple));
        }
    }
}

