/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.projection;

import com.tridium.bql.expression.BPath;
import com.tridium.bql.projection.ProjectionColumn;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

public class PathProjectionColumn
extends ProjectionColumn {
    private BPath path;
    private String name;
    private Type type;
    private Context cx;

    public String getName() {
        return this.name;
    }

    public String getDefaultDisplayName(Context context) {
        return this.path.getPath().getDisplayName(null, context);
    }

    public Type getType() {
        return this.type;
    }

    public int getFlags() {
        return 0;
    }

    public BFacets getFacets() {
        return BFacets.NULL;
    }

    public BObject get(int n, BITable bITable) {
        return this.path.evaluate(bITable.get(n), this.cx);
    }

    public String getString(int n, BITable bITable) {
        BObject bObject = this.get(n, bITable);
        if (bObject == null) {
            return "";
        }
        return bObject.toString();
    }

    public double getDouble(int n, BITable bITable) {
        BObject bObject = this.get(n, bITable);
        if (bObject == null) {
            return 0.0;
        }
        return ((BDouble)bObject).getDouble();
    }

    public float getFloat(int n, BITable bITable) {
        BObject bObject = this.get(n, bITable);
        if (bObject == null) {
            return 0.0f;
        }
        return ((BFloat)bObject).getFloat();
    }

    public boolean getBoolean(int n, BITable bITable) {
        BObject bObject = this.get(n, bITable);
        if (bObject == null) {
            return false;
        }
        return ((BBoolean)bObject).getBoolean();
    }

    public int getInt(int n, BITable bITable) {
        BObject bObject = this.get(n, bITable);
        if (bObject == null) {
            return 0;
        }
        return ((BInteger)bObject).getInt();
    }

    public long getLong(int n, BITable bITable) {
        BObject bObject = this.get(n, bITable);
        if (bObject == null) {
            return 0L;
        }
        return ((BLong)bObject).getLong();
    }

    public int getFlags(int n, BITable bITable) {
        return 0;
    }

    public BFacets getFacets(int n, BITable bITable) {
        return this.path.evaluateFacets(bITable.get(n), this.cx);
    }

    public BObject get(TableCursor tableCursor) {
        return this.path.evaluate(tableCursor.get(), tableCursor.getContext());
    }

    public String getString(TableCursor tableCursor) {
        BPath.PathTarget pathTarget = this.path.resolve(tableCursor.get(), tableCursor.getContext());
        if (pathTarget == null) {
            return "";
        }
        if (pathTarget.target instanceof BObject) {
            return ((BObject)pathTarget.target).toString((Context)pathTarget.facets);
        }
        return pathTarget.target.toString();
    }

    public double getDouble(TableCursor tableCursor) {
        BObject bObject = this.get(tableCursor);
        if (bObject == null) {
            return 0.0;
        }
        return ((BDouble)bObject).getDouble();
    }

    public float getFloat(TableCursor tableCursor) {
        BObject bObject = this.get(tableCursor);
        if (bObject == null) {
            return 0.0f;
        }
        return ((BFloat)bObject).getFloat();
    }

    public boolean getBoolean(TableCursor tableCursor) {
        BObject bObject = this.get(tableCursor);
        if (bObject == null) {
            return false;
        }
        return ((BBoolean)bObject).getBoolean();
    }

    public int getInt(TableCursor tableCursor) {
        BObject bObject = this.get(tableCursor);
        if (bObject == null) {
            return 0;
        }
        return ((BInteger)bObject).getInt();
    }

    public long getLong(TableCursor tableCursor) {
        BObject bObject = this.get(tableCursor);
        if (bObject == null) {
            return 0L;
        }
        return ((BLong)bObject).getLong();
    }

    public int getFlags(TableCursor tableCursor) {
        return 0;
    }

    public BFacets getFacets(TableCursor tableCursor) {
        return this.path.evaluateFacets(tableCursor.get(), tableCursor.getContext());
    }

    public String toString() {
        return this.getName() + ',' + this.getType();
    }

    public PathProjectionColumn(BPath bPath, Type type, String string, Context context) {
        this(bPath.toString(), bPath, type, string, context);
    }

    public PathProjectionColumn(String string, BPath bPath, Type type, String string2, Context context) {
        super(string2);
        this.name = string;
        this.path = bPath;
        this.type = type;
        this.cx = context;
    }
}

