/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.expression;

import com.tridium.bql.compiler.BqlTokenizer;
import com.tridium.bql.compiler.Constants;
import com.tridium.bql.compiler.ExprParser;
import com.tridium.bql.compiler.ExprUtil;
import com.tridium.bql.query.BqlVisitor;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.expression.BBinaryExpression;
import javax.baja.query.expression.BUnaryExpression;
import javax.baja.query.util.Exprs;

public abstract class NormalForms {
    private static final Transformer NE = new NotEqual();
    private static final Transformer NNF = new NegativeNormal();
    private static final Transformer CNF = new JunctiveNormal(true);
    private static final Transformer DNF = new JunctiveNormal(false);

    public static BExpression cnf(BExpression bExpression) {
        return CNF.transform(NNF.transform(NE.transform(bExpression)));
    }

    public static BExpression dnf(BExpression bExpression) {
        return DNF.transform(NNF.transform(NE.transform(bExpression)));
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            return;
        }
        ExprParser exprParser = new ExprParser();
        BqlTokenizer bqlTokenizer = new BqlTokenizer(stringArray[0]);
        BExpression bExpression = exprParser.parse(bqlTokenizer);
        System.out.println("Transforming: " + Transformer.toString(bExpression) + '\n');
        System.out.println("CNF: " + Transformer.toString(NormalForms.cnf(bExpression)));
    }

    public static abstract class Transformer
    implements Constants {
        public abstract BExpression transform(BExpression var1);

        public static String toString(BExpression bExpression) {
            BqlVisitor bqlVisitor = new BqlVisitor();
            bqlVisitor.visit(bExpression);
            return bqlVisitor.getQueryString();
        }

        protected BExpression transformBinary(BBinaryExpression bBinaryExpression) {
            BExpression bExpression = this.transform(bBinaryExpression.lhs());
            BExpression bExpression2 = this.transform(bBinaryExpression.rhs());
            return ExprUtil.tag((BExpression)Exprs.binary((BExpression)bExpression, (String)bBinaryExpression.op(), (BExpression)bExpression2));
        }

        protected BExpression transformUnary(BUnaryExpression bUnaryExpression) {
            BExpression bExpression = this.transform(bUnaryExpression.operand());
            return ExprUtil.tag((BExpression)Exprs.unary((String)bUnaryExpression.op(), (BExpression)bExpression));
        }

        protected BExpression not(BExpression bExpression) {
            return ExprUtil.tag((BExpression)Exprs.unary((String)Constants.OPTYPE_STRINGS[12], (BExpression)bExpression));
        }

        protected BExpression eq(BExpression bExpression, BExpression bExpression2) {
            return ExprUtil.tag((BExpression)Exprs.binary((BExpression)bExpression, (String)Constants.OPTYPE_STRINGS[5], (BExpression)bExpression2));
        }

        protected BExpression or(BExpression bExpression, BExpression bExpression2) {
            return ExprUtil.tag((BExpression)Exprs.binary((BExpression)bExpression, (String)Constants.OPTYPE_STRINGS[14], (BExpression)bExpression2));
        }

        protected BExpression and(BExpression bExpression, BExpression bExpression2) {
            return ExprUtil.tag((BExpression)Exprs.binary((BExpression)bExpression, (String)Constants.OPTYPE_STRINGS[13], (BExpression)bExpression2));
        }
    }

    protected static class NotEqual
    extends Transformer {
        public BExpression transform(BExpression bExpression) {
            if (ExprUtil.isBinary(bExpression)) {
                BBinaryExpression bBinaryExpression = (BBinaryExpression)bExpression;
                switch (ExprUtil.getOpId((BExpression)bBinaryExpression)) {
                    case 6: {
                        BExpression bExpression2 = this.transform(bBinaryExpression.lhs());
                        BExpression bExpression3 = this.transform(bBinaryExpression.rhs());
                        return this.not(this.eq(bExpression2, bExpression3));
                    }
                }
                return this.transformBinary(bBinaryExpression);
            }
            if (ExprUtil.isUnary(bExpression)) {
                return this.transformUnary((BUnaryExpression)bExpression);
            }
            return bExpression.newExprCopy();
        }
    }

    protected static class NegativeNormal
    extends Transformer {
        public BExpression transform(BExpression bExpression) {
            if (ExprUtil.isUnary(bExpression)) {
                BUnaryExpression bUnaryExpression = (BUnaryExpression)bExpression;
                switch (ExprUtil.getOpId((BExpression)bUnaryExpression)) {
                    case -1: {
                        throw new IllegalStateException();
                    }
                    case 12: {
                        int n = ExprUtil.getOpId(bUnaryExpression.operand());
                        if (n == 12) {
                            return this.transform(((BUnaryExpression)bUnaryExpression.operand()).operand());
                        }
                        if (n == 13) {
                            BBinaryExpression bBinaryExpression = (BBinaryExpression)bUnaryExpression.operand();
                            BExpression bExpression2 = this.transform(bBinaryExpression.lhs());
                            BExpression bExpression3 = this.transform(bBinaryExpression.rhs());
                            return this.or(this.transform(this.not(bExpression2)), this.transform(this.not(bExpression3)));
                        }
                        if (n == 14) {
                            BBinaryExpression bBinaryExpression = (BBinaryExpression)bUnaryExpression.operand();
                            BExpression bExpression4 = this.transform(bBinaryExpression.lhs());
                            BExpression bExpression5 = this.transform(bBinaryExpression.rhs());
                            return this.and(this.transform(this.not(bExpression4)), this.transform(this.not(bExpression5)));
                        }
                        return this.transformUnary(bUnaryExpression);
                    }
                }
                return this.transformUnary(bUnaryExpression);
            }
            if (ExprUtil.isBinary(bExpression)) {
                return this.transformBinary((BBinaryExpression)bExpression);
            }
            return bExpression.newExprCopy();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected static final class JunctiveNormal
    extends Transformer {
        protected final boolean isConjunctive;
        protected final int distribute;
        protected final int junctive;
        static /* synthetic */ Class class$javax$baja$query$BExpression;

        public final BExpression transform(BExpression bExpression) {
            if (ExprUtil.isBinary(bExpression)) {
                BBinaryExpression bBinaryExpression = (BBinaryExpression)bExpression;
                if (ExprUtil.getOpId((BExpression)bBinaryExpression) == this.distribute) {
                    return this.doTransformation(bBinaryExpression);
                }
                return this.transformBinary(bBinaryExpression);
            }
            if (ExprUtil.isUnary(bExpression)) {
                return this.transformUnary((BUnaryExpression)bExpression);
            }
            return bExpression.newExprCopy();
        }

        private final BExpression doTransformation(BBinaryExpression bBinaryExpression) {
            BExpression bExpression = this.transform(bBinaryExpression.lhs());
            BExpression bExpression2 = this.transform(bBinaryExpression.rhs());
            Class clazz = class$javax$baja$query$BExpression;
            if (clazz == null) {
                clazz = class$javax$baja$query$BExpression = JunctiveNormal.class("[Ljavax.baja.query.BExpression;", false);
            }
            Array array = new Array(clazz);
            Class clazz2 = class$javax$baja$query$BExpression;
            if (clazz2 == null) {
                clazz2 = class$javax$baja$query$BExpression = JunctiveNormal.class("[Ljavax.baja.query.BExpression;", false);
            }
            Array array2 = new Array(clazz2);
            this.getParts(bExpression, array);
            this.getParts(bExpression2, array2);
            return this.distribute(array, array2);
        }

        private final void getParts(BExpression bExpression, Array array) {
            BBinaryExpression bBinaryExpression;
            if (ExprUtil.isBinary(bExpression) && this.junctive == ExprUtil.getOpId((BExpression)(bBinaryExpression = (BBinaryExpression)bExpression))) {
                this.getParts(bBinaryExpression.lhs(), array);
                this.getParts(bBinaryExpression.rhs(), array);
                return;
            }
            array.add((Object)bExpression.newExprCopy());
        }

        private final BExpression distribute(Array array, Array array2) {
            BExpression bExpression = null;
            int n = array.size();
            int n2 = array2.size();
            int n3 = 0;
            while (n3 < n) {
                BExpression bExpression2 = (BExpression)array.get(n3);
                int n4 = 0;
                while (n4 < n2) {
                    BExpression bExpression3 = (BExpression)array2.get(n4);
                    BExpression bExpression4 = null;
                    if (this.junctive == 13) {
                        bExpression4 = this.or(bExpression2.newExprCopy(), bExpression3.newExprCopy());
                        bExpression = n3 == 0 && n4 == 0 ? bExpression4 : this.and(bExpression, bExpression4);
                    } else {
                        bExpression4 = this.and(bExpression2.newExprCopy(), bExpression3.newExprCopy());
                        bExpression = n3 == 0 && n4 == 0 ? bExpression4 : this.or(bExpression, bExpression4);
                    }
                    ++n4;
                }
                ++n3;
            }
            return bExpression;
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public JunctiveNormal(boolean bl) {
            this.isConjunctive = bl;
            if (bl) {
                this.distribute = 14;
                this.junctive = 13;
            } else {
                this.distribute = 13;
                this.junctive = 14;
            }
        }
    }
}

