/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.expression;

import com.tridium.bql.BBqlInterval;
import com.tridium.bql.BDateTimeSource;
import com.tridium.bql.DateTimeSource;
import com.tridium.bql.FunctionUtil;
import com.tridium.bql.compiler.Constants;
import com.tridium.bql.compiler.ExprParser;
import com.tridium.bql.compiler.ExprUtil;
import com.tridium.bql.expression.BAggregateFunction;
import com.tridium.bql.expression.BBqlFunction;
import com.tridium.bql.expression.BPath;
import com.tridium.bql.expression.BScalarFunction;
import com.tridium.bql.expression.Pattern;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.baja.naming.UnresolvedException;
import javax.baja.query.BExpression;
import javax.baja.query.BNull;
import javax.baja.query.expression.BBinaryExpression;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.query.expression.BListExpression;
import javax.baja.query.expression.BSimpleExpression;
import javax.baja.query.expression.BUnaryExpression;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.util.BAbsTimeRange;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExprEngine
implements Constants {
    private final DateTimeSource dts;
    private final HashMap patterns;
    private final HashMap scalars;
    private final HashMap constants;
    private final MorphUtil morpher;
    private BObject target;
    private Context cx;
    static /* synthetic */ Class class$javax$baja$sys$BObject;
    static /* synthetic */ Class class$javax$baja$sys$BInterface;

    public static BObject instantEval(BExpression bExpression, BObject bObject, Context context) {
        return new ExprEngine(null).evaluate(bExpression, bObject, context);
    }

    public BObject evaluate(BExpression bExpression, BObject bObject, Context context) {
        this.target = bObject;
        this.cx = context;
        return this.eval(bExpression);
    }

    protected BObject eval(BExpression bExpression) {
        BNull bNull = BNull.NULL;
        if (this.constants.get(bExpression) != null) {
            bNull = (BObject)this.constants.get(bExpression);
        } else if (bExpression instanceof BFieldExpression) {
            bNull = this.field((BFieldExpression)bExpression);
        } else if (bExpression instanceof BBinaryExpression) {
            BBinaryExpression bBinaryExpression = (BBinaryExpression)bExpression;
            int n = ExprUtil.getOpId(bExpression);
            switch (n) {
                case 13: {
                    bNull = this.and(bBinaryExpression);
                    break;
                }
                case 14: {
                    bNull = this.or(bBinaryExpression);
                    break;
                }
                case 5: {
                    bNull = this.eq(bBinaryExpression);
                    break;
                }
                case 6: {
                    bNull = this.ne(bBinaryExpression);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    bNull = this.comparison(bBinaryExpression, n);
                    break;
                }
                case 11: {
                    bNull = this.like(bBinaryExpression);
                    break;
                }
                case 15: {
                    bNull = this.in(bBinaryExpression);
                    break;
                }
                case 0: {
                    bNull = this.add(bBinaryExpression);
                    break;
                }
                case 1: {
                    bNull = this.subtract(bBinaryExpression);
                    break;
                }
                case 2: {
                    bNull = this.multiply(bBinaryExpression);
                    break;
                }
                case 3: {
                    bNull = this.divide(bBinaryExpression);
                    break;
                }
                case 4: {
                    bNull = this.modulo(bBinaryExpression);
                    break;
                }
                default: {
                    throw new IllegalStateException("Op id: " + n);
                }
            }
            if (ExprUtil.isConstant(bExpression)) {
                this.constants.put(bExpression, bNull);
            }
        } else if (bExpression instanceof BUnaryExpression) {
            BObject bObject = this.eval(((BUnaryExpression)bExpression).operand());
            int n = ExprUtil.getOpId(bExpression);
            switch (n) {
                case 0: {
                    bNull = bObject instanceof BNumber ? bObject : BNull.NULL;
                    break;
                }
                case 1: {
                    bNull = BNull.NULL;
                    if (!(bObject instanceof BNumber)) break;
                    BNumber bNumber = (BNumber)bObject;
                    if (bNumber instanceof BDouble) {
                        bNull = BDouble.make((double)(-bNumber.getDouble()));
                        break;
                    }
                    if (bNumber instanceof BFloat) {
                        bNull = BFloat.make((float)(-bNumber.getFloat()));
                        break;
                    }
                    if (bNumber instanceof BLong) {
                        bNull = BLong.make((long)(-bNumber.getLong()));
                        break;
                    }
                    if (bNumber instanceof BInteger) {
                        bNull = BInteger.make((int)(-bNumber.getInt()));
                        break;
                    }
                    throw new IllegalStateException(bNumber.toString());
                }
                case 12: {
                    bNull = bObject instanceof BBoolean ? ((BBoolean)bObject).not() : BNull.NULL;
                    break;
                }
                default: {
                    throw new IllegalStateException("Op id: " + n);
                }
            }
            if (ExprUtil.isConstant(bExpression)) {
                this.constants.put(bExpression, bNull);
            }
        } else if (bExpression instanceof BSimpleExpression) {
            bNull = ((BSimpleExpression)bExpression).getSimpleValue();
        } else if (bExpression instanceof BBqlFunction) {
            bNull = ((BBqlFunction)bExpression).isScalar() ? this.scalar((BScalarFunction)bExpression) : ((BAggregateFunction)bExpression).evaluate(this.target, this.cx);
        } else {
            throw new IllegalStateException(bExpression.getType().toString());
        }
        return bNull;
    }

    protected BObject field(BFieldExpression bFieldExpression) {
        BPath bPath = null;
        bPath = bFieldExpression instanceof BPath ? (BPath)bFieldExpression : new BPath(bFieldExpression.getField());
        BObject bObject = bPath.evaluate(this.target, this.cx);
        return bObject == null ? BNull.NULL : bObject;
    }

    protected BObject and(BBinaryExpression bBinaryExpression) {
        BObject bObject = this.eval(bBinaryExpression.lhs());
        if (!(bObject instanceof BBoolean)) {
            return BNull.NULL;
        }
        BBoolean bBoolean = (BBoolean)bObject;
        if (!bBoolean.getBoolean()) {
            return BBoolean.FALSE;
        }
        bObject = this.eval(bBinaryExpression.rhs());
        if (!(bObject instanceof BBoolean)) {
            return BNull.NULL;
        }
        return bObject;
    }

    protected BObject or(BBinaryExpression bBinaryExpression) {
        BObject bObject = this.eval(bBinaryExpression.lhs());
        if (!(bObject instanceof BBoolean)) {
            return BNull.NULL;
        }
        BBoolean bBoolean = (BBoolean)bObject;
        if (bBoolean.getBoolean()) {
            return BBoolean.TRUE;
        }
        bObject = this.eval(bBinaryExpression.rhs());
        if (!(bObject instanceof BBoolean)) {
            return BNull.NULL;
        }
        return bObject;
    }

    protected BObject eq(BBinaryExpression bBinaryExpression) {
        return this.eq(this.eval(bBinaryExpression.lhs()), this.eval(bBinaryExpression.rhs()));
    }

    protected BBoolean eq(BObject bObject, BObject bObject2) {
        try {
            MorphUtil.MorphedTuple morphedTuple = this.morpher.morph(bObject, bObject2);
            bObject = morphedTuple.lhs;
            bObject2 = morphedTuple.rhs;
            if (bObject.isNull()) {
                return BBoolean.make((boolean)bObject2.isNull());
            }
            if (bObject2.isNull()) {
                return BBoolean.FALSE;
            }
            if (this.bothComparable(bObject, bObject2)) {
                boolean bl = false;
                if (this.doCompare(bObject, bObject2) == 0) {
                    bl = true;
                }
                return BBoolean.make((boolean)bl);
            }
            if (bObject instanceof BTypeSpec && bObject2 instanceof BTypeSpec) {
                Type type = ((BTypeSpec)bObject).getResolvedType();
                Type type2 = ((BTypeSpec)bObject2).getResolvedType();
                return BBoolean.make((boolean)type.is(type2));
            }
        }
        catch (ClassCastException classCastException) {}
        return BBoolean.make((boolean)bObject.equals((Object)bObject2));
    }

    protected BObject ne(BBinaryExpression bBinaryExpression) {
        return ((BBoolean)this.eq(bBinaryExpression)).not();
    }

    protected BObject comparison(BBinaryExpression bBinaryExpression, int n) {
        BObject bObject = this.eval(bBinaryExpression.lhs());
        BObject bObject2 = this.eval(bBinaryExpression.rhs());
        MorphUtil.MorphedTuple morphedTuple = this.morpher.morph(bObject, bObject2);
        bObject = morphedTuple.lhs;
        bObject2 = morphedTuple.rhs;
        if (this.bothComparable(bObject, bObject2)) {
            try {
                switch (n) {
                    case 7: {
                        boolean bl = false;
                        if (this.doCompare(bObject, bObject2) > 0) {
                            bl = true;
                        }
                        return BBoolean.make((boolean)bl);
                    }
                    case 8: {
                        boolean bl = false;
                        if (this.doCompare(bObject, bObject2) >= 0) {
                            bl = true;
                        }
                        return BBoolean.make((boolean)bl);
                    }
                    case 9: {
                        boolean bl = false;
                        if (this.doCompare(bObject, bObject2) < 0) {
                            bl = true;
                        }
                        return BBoolean.make((boolean)bl);
                    }
                    case 10: {
                        boolean bl = false;
                        if (this.doCompare(bObject, bObject2) <= 0) {
                            bl = true;
                        }
                        return BBoolean.make((boolean)bl);
                    }
                }
                throw new IllegalArgumentException("Invalid comparison operator id: " + n);
            }
            catch (ClassCastException classCastException) {}
        }
        return BNull.NULL;
    }

    protected BObject like(BBinaryExpression bBinaryExpression) {
        String string = null;
        BObject bObject = this.eval(bBinaryExpression.lhs());
        String string2 = ((BString)this.eval(bBinaryExpression.rhs())).getString();
        string = bObject instanceof BString ? ((BString)bObject).getString() : bObject.toString();
        Pattern pattern = null;
        pattern = (Pattern)this.patterns.get(string2);
        if (pattern == null) {
            pattern = new Pattern(string2);
            this.patterns.put(string2, pattern);
        }
        return pattern.isMatch(string) ? BBoolean.TRUE : BBoolean.FALSE;
    }

    protected BObject in(BBinaryExpression bBinaryExpression) {
        BObject bObject = this.eval(bBinaryExpression.lhs());
        if (bObject.isNull()) {
            return BNull.NULL;
        }
        if (bBinaryExpression.rhs() instanceof BListExpression) {
            BListExpression bListExpression = (BListExpression)bBinaryExpression.rhs();
            BExpression[] bExpressionArray = bListExpression.getExpressions();
            int n = 0;
            while (n < bExpressionArray.length) {
                if (this.eq(bObject, this.eval(bExpressionArray[n])).getBoolean()) {
                    return BBoolean.TRUE;
                }
                ++n;
            }
            return BBoolean.FALSE;
        }
        if (bBinaryExpression.rhs() instanceof BScalarFunction) {
            if (!(bObject instanceof BAbsTime)) {
                return BNull.NULL;
            }
            BScalarFunction bScalarFunction = (BScalarFunction)bBinaryExpression.rhs();
            BObject bObject2 = this.eval((BExpression)bScalarFunction);
            if (!(bObject2 instanceof BAbsTimeRange)) {
                return BNull.NULL;
            }
            return BBoolean.make((boolean)((BAbsTimeRange)bObject2).includes((BAbsTime)bObject));
        }
        return BNull.NULL;
    }

    protected BObject add(BBinaryExpression bBinaryExpression) {
        BObject bObject = this.eval(bBinaryExpression.lhs());
        BObject bObject2 = this.eval(bBinaryExpression.rhs());
        if (bObject instanceof BNumber && bObject2 instanceof BNumber) {
            BNumber bNumber = (BNumber)bObject;
            BNumber bNumber2 = (BNumber)bObject2;
            if (bNumber instanceof BDouble || bNumber2 instanceof BDouble) {
                return BDouble.make((double)(bNumber.getDouble() + bNumber2.getDouble()));
            }
            if (bNumber instanceof BFloat || bNumber2 instanceof BFloat) {
                return BFloat.make((float)(bNumber.getFloat() + bNumber2.getFloat()));
            }
            if (bNumber instanceof BLong || bNumber2 instanceof BLong) {
                return BLong.make((long)(bNumber.getLong() + bNumber2.getLong()));
            }
            return BInteger.make((int)(bNumber.getInt() + bNumber2.getInt()));
        }
        if (bObject instanceof BAbsTime && this.canAddToAbsTime(bObject2)) {
            return this.addTime((BAbsTime)bObject, bObject2);
        }
        if (bObject instanceof BString) {
            return BString.make((String)bObject.toString().concat(bObject2.toString()));
        }
        if (bObject2 instanceof BAbsTime && this.canAddToAbsTime(bObject)) {
            return this.addTime((BAbsTime)bObject2, bObject);
        }
        if (bObject2 instanceof BString) {
            return BString.make((String)bObject.toString().concat(bObject2.toString()));
        }
        return BNull.NULL;
    }

    protected BObject addTime(BAbsTime bAbsTime, BObject bObject) {
        if (bObject instanceof BRelTime) {
            return bAbsTime.add((BRelTime)bObject);
        }
        if (bObject instanceof BBqlInterval) {
            return ((BBqlInterval)bObject).addTo(bAbsTime);
        }
        return BNull.NULL;
    }

    protected boolean canAddToAbsTime(BObject bObject) {
        boolean bl = false;
        if (bObject instanceof BRelTime || bObject instanceof BBqlInterval) {
            bl = true;
        }
        return bl;
    }

    protected BObject subtract(BBinaryExpression bBinaryExpression) {
        BObject bObject = this.eval(bBinaryExpression.lhs());
        BObject bObject2 = this.eval(bBinaryExpression.rhs());
        if (bObject instanceof BNumber && bObject2 instanceof BNumber) {
            BNumber bNumber = (BNumber)bObject;
            BNumber bNumber2 = (BNumber)bObject2;
            if (bNumber instanceof BDouble || bNumber2 instanceof BDouble) {
                return BDouble.make((double)(bNumber.getDouble() - bNumber2.getDouble()));
            }
            if (bNumber instanceof BFloat || bNumber2 instanceof BFloat) {
                return BFloat.make((float)(bNumber.getFloat() - bNumber2.getFloat()));
            }
            if (bNumber instanceof BLong || bNumber2 instanceof BLong) {
                return BLong.make((long)(bNumber.getLong() - bNumber2.getLong()));
            }
            return BInteger.make((int)(bNumber.getInt() - bNumber2.getInt()));
        }
        if (bObject instanceof BAbsTime) {
            return this.subtractTime((BAbsTime)bObject, bObject2);
        }
        return BNull.NULL;
    }

    protected BObject subtractTime(BAbsTime bAbsTime, BObject bObject) {
        if (bObject instanceof BRelTime) {
            return bAbsTime.subtract((BRelTime)bObject);
        }
        if (bObject instanceof BBqlInterval) {
            return ((BBqlInterval)bObject).subtractFrom(bAbsTime);
        }
        return BNull.NULL;
    }

    protected BObject multiply(BBinaryExpression bBinaryExpression) {
        BObject bObject = this.eval(bBinaryExpression.lhs());
        BObject bObject2 = this.eval(bBinaryExpression.rhs());
        if (bObject instanceof BNumber && bObject2 instanceof BNumber) {
            BNumber bNumber = (BNumber)bObject;
            BNumber bNumber2 = (BNumber)bObject2;
            if (bNumber instanceof BDouble || bNumber2 instanceof BDouble) {
                return BDouble.make((double)(bNumber.getDouble() * bNumber2.getDouble()));
            }
            if (bNumber instanceof BFloat || bNumber2 instanceof BFloat) {
                return BFloat.make((float)(bNumber.getFloat() * bNumber2.getFloat()));
            }
            if (bNumber instanceof BLong || bNumber2 instanceof BLong) {
                return BLong.make((long)(bNumber.getLong() * bNumber2.getLong()));
            }
            return BInteger.make((int)(bNumber.getInt() * bNumber2.getInt()));
        }
        return BNull.NULL;
    }

    protected BObject divide(BBinaryExpression bBinaryExpression) {
        BObject bObject = this.eval(bBinaryExpression.lhs());
        BObject bObject2 = this.eval(bBinaryExpression.rhs());
        if (bObject instanceof BNumber && bObject2 instanceof BNumber) {
            BNumber bNumber = (BNumber)bObject;
            BNumber bNumber2 = (BNumber)bObject2;
            try {
                if (bNumber instanceof BDouble || bNumber2 instanceof BDouble) {
                    return BDouble.make((double)(bNumber.getDouble() / bNumber2.getDouble()));
                }
                if (bNumber instanceof BFloat || bNumber2 instanceof BFloat) {
                    return BFloat.make((float)(bNumber.getFloat() / bNumber2.getFloat()));
                }
                if (bNumber instanceof BLong || bNumber2 instanceof BLong) {
                    return BLong.make((long)(bNumber.getLong() / bNumber2.getLong()));
                }
                return BInteger.make((int)(bNumber.getInt() / bNumber2.getInt()));
            }
            catch (ArithmeticException arithmeticException) {
                return BNull.NULL;
            }
        }
        return BNull.NULL;
    }

    protected BObject modulo(BBinaryExpression bBinaryExpression) {
        BObject bObject = this.eval(bBinaryExpression.lhs());
        BObject bObject2 = this.eval(bBinaryExpression.rhs());
        if (bObject instanceof BNumber && bObject2 instanceof BNumber) {
            BNumber bNumber = (BNumber)bObject;
            BNumber bNumber2 = (BNumber)bObject2;
            try {
                if (bNumber instanceof BDouble || bNumber2 instanceof BDouble) {
                    return BDouble.make((double)(bNumber.getDouble() % bNumber2.getDouble()));
                }
                if (bNumber instanceof BFloat || bNumber2 instanceof BFloat) {
                    return BFloat.make((float)(bNumber.getFloat() % bNumber2.getFloat()));
                }
                if (bNumber instanceof BLong || bNumber2 instanceof BLong) {
                    return BLong.make((long)(bNumber.getLong() % bNumber2.getLong()));
                }
                return BInteger.make((int)(bNumber.getInt() % bNumber2.getInt()));
            }
            catch (ArithmeticException arithmeticException) {
                return BNull.NULL;
            }
        }
        return BNull.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BObject scalar(BScalarFunction bScalarFunction) {
        BExpression[] bExpressionArray = bScalarFunction.getParameters();
        Object[] objectArray = new BObject[bExpressionArray.length + 1];
        objectArray[0] = ExprParser.TIME_LIB.equals((Object)bScalarFunction.getLib()) ? this.dts.currentAbsTime() : this.target;
        int n = 0;
        while (n < bExpressionArray.length) {
            objectArray[n + 1] = this.eval(bExpressionArray[n]);
            if (objectArray[n + 1].isNull()) {
                return BNull.NULL;
            }
            ++n;
        }
        Method method = null;
        ExprEngine exprEngine = this;
        synchronized (exprEngine) {
            method = (Method)this.scalars.get((Object)bScalarFunction);
            if (method == null) {
                method = this.resolveFunction(bScalarFunction, (BObject[])objectArray);
                this.scalars.put(bScalarFunction, method);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl20 : MonitorExitStatement: MONITOREXIT : var5_6
            if (method == null) {
                return BNull.NULL;
            }
        }
        try {
            return (BObject)method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return BNull.NULL;
        }
    }

    private final boolean bothComparable(BObject bObject, BObject bObject2) {
        boolean bl = false;
        if (bObject instanceof Comparable && bObject2 instanceof Comparable) {
            bl = true;
        }
        return bl;
    }

    private final int doCompare(BObject bObject, BObject bObject2) throws ClassCastException {
        Comparable comparable = (Comparable)bObject;
        Comparable comparable2 = (Comparable)bObject2;
        if (bObject.getClass() == bObject2.getClass()) {
            return comparable.compareTo(comparable2);
        }
        if (bObject.getClass().isInstance(bObject2)) {
            return comparable.compareTo(comparable2);
        }
        if (bObject2.getClass().isInstance(bObject)) {
            return -comparable2.compareTo(comparable);
        }
        throw new ClassCastException(bObject.getType() + " not comparable to " + bObject2.getType());
    }

    private final Method resolveFunction(BBqlFunction bBqlFunction, BObject[] bObjectArray) {
        Method method = null;
        Class[] classArray = new Class[bObjectArray.length];
        int n = 0;
        while (n < bObjectArray.length) {
            classArray[n] = bObjectArray[n].getClass();
            ++n;
        }
        try {
            method = FunctionUtil.getFunction(bBqlFunction.getLib().getResolvedType().getTypeClass(), bBqlFunction.getFunctionName(), classArray, true);
        }
        catch (Exception exception) {}
        if (method == null) {
            throw new UnresolvedException("Function not found with matching parameters: " + BBqlFunction.toFunctionDebug(bBqlFunction.getFunctionName(), classArray));
        }
        Class<?> clazz = method.getReturnType();
        Class clazz2 = class$javax$baja$sys$BObject;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$sys$BObject = ExprEngine.class("[Ljavax.baja.sys.BObject;", false);
        }
        if (!clazz2.isAssignableFrom(clazz)) {
            Class clazz3 = class$javax$baja$sys$BInterface;
            if (clazz3 == null) {
                clazz3 = class$javax$baja$sys$BInterface = ExprEngine.class("[Ljavax.baja.sys.BInterface;", false);
            }
            if (!clazz3.isAssignableFrom(clazz)) {
                throw new UnresolvedException("Return type must be a BObject.  Return type for " + bBqlFunction.getFunctionName() + " is " + method.getReturnType().getName());
            }
        }
        try {
            bBqlFunction.setReturnType(BTypeSpec.make((Type)((Type)method.getReturnType().getField("TYPE").get(null))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new UnresolvedException("Could not set return type for the function: " + bBqlFunction.getFunctionName());
        }
        return method;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ExprEngine(DateTimeSource dateTimeSource) {
        this.dts = dateTimeSource == null ? new BDateTimeSource() : dateTimeSource;
        this.patterns = new HashMap();
        this.scalars = new HashMap();
        this.constants = new HashMap();
        this.morpher = new MorphUtil();
    }

    public static final class MorphUtil {
        public final MorphedTuple morph(BObject bObject, BObject bObject2) {
            if (bObject.getClass() == bObject2.getClass()) {
                return new MorphedTuple(bObject, bObject2);
            }
            if (this.isNumber(bObject) && this.isNumber(bObject2)) {
                return this.morphNumbers((BNumber)bObject, (BNumber)bObject2);
            }
            if (this.isMorphable(bObject2)) {
                if (this.isNumber(bObject2) && this.isString(bObject)) {
                    return new MorphedTuple(bObject, (BObject)BString.make((String)bObject2.toString()));
                }
                if (this.isString(bObject2)) {
                    return new MorphedTuple(bObject, this.morphAs((BString)bObject2, bObject));
                }
            } else if (this.isMorphable(bObject) && this.isString(bObject)) {
                return new MorphedTuple(this.morphAs((BString)bObject, bObject2), bObject2);
            }
            return new MorphedTuple(bObject, bObject2);
        }

        private final BObject morphAs(BString bString, BObject bObject) {
            if (!bObject.isSimple()) {
                return bString;
            }
            String string = bString.toString();
            if (bObject.getType().is(BBoolean.TYPE)) {
                if (string.equalsIgnoreCase("true")) {
                    return BBoolean.TRUE;
                }
                if (string.equalsIgnoreCase("false")) {
                    return BBoolean.FALSE;
                }
                return bString;
            }
            try {
                return bObject.asSimple().decodeFromString(string);
            }
            catch (Exception exception) {
                return bString;
            }
        }

        private final MorphedTuple morphNumbers(BNumber bNumber, BNumber bNumber2) {
            if (bNumber instanceof BDouble || bNumber2 instanceof BDouble) {
                return new MorphedTuple((BObject)BDouble.make((double)bNumber.getDouble()), (BObject)BDouble.make((double)bNumber2.getDouble()));
            }
            if (bNumber instanceof BFloat || bNumber2 instanceof BFloat) {
                return new MorphedTuple((BObject)BFloat.make((float)bNumber.getFloat()), (BObject)BFloat.make((float)bNumber2.getFloat()));
            }
            if (bNumber instanceof BLong || bNumber2 instanceof BLong) {
                return new MorphedTuple((BObject)BLong.make((long)bNumber.getLong()), (BObject)BLong.make((long)bNumber2.getLong()));
            }
            return new MorphedTuple((BObject)BInteger.make((int)bNumber.getInt()), (BObject)BInteger.make((int)bNumber2.getInt()));
        }

        public final boolean isMorphable(BObject bObject) {
            boolean bl = false;
            if (this.isString(bObject) || this.isNumber(bObject)) {
                bl = true;
            }
            return bl;
        }

        private final boolean isNumber(BObject bObject) {
            return bObject instanceof BNumber;
        }

        private final boolean isString(BObject bObject) {
            return bObject instanceof BString;
        }

        public static final class MorphedTuple {
            public BObject lhs;
            public BObject rhs;

            public MorphedTuple(BObject bObject, BObject bObject2) {
                this.lhs = bObject;
                this.rhs = bObject2;
            }
        }
    }
}

