/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.compiler;

import com.tridium.bql.compiler.Constants;

public class Token
implements Constants {
    public final int type;
    public final int index;
    public String lex;
    public int opType;
    public boolean booleanValue;
    public final boolean isWord;

    public static Token identifier(int n, String string) {
        Token token = new Token(1, n, string);
        return token;
    }

    public static Token operator(int n, int n2, String string) {
        Token token = new Token(6, n2, string);
        token.opType = n;
        return token;
    }

    public static Token number(int n, String string) {
        Token token = new Token(3, n, string);
        return token;
    }

    public static Token bool(int n, String string, boolean bl) {
        Token token = new Token(4, n, string);
        token.booleanValue = bl;
        return token;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(Constants.TOKEN_STRINGS[this.type]);
        if (this.lex != null) {
            stringBuffer.append(": '").append(this.lex).append('\'');
        } else if (this.type == 4) {
            stringBuffer.append(": '").append(this.booleanValue).append('\'');
        } else if (this.type == 6) {
            stringBuffer.append(": '").append(Constants.OPTYPE_STRINGS[this.opType]).append('\'');
        }
        return stringBuffer.toString();
    }

    public String toDisplay() {
        if (this.lex != null) {
            return this.lex;
        }
        if (this.type == 6) {
            return Constants.OPTYPE_STRINGS[this.opType];
        }
        return Constants.TOKEN_STRINGS[this.type];
    }

    Token(int n, int n2, String string) {
        this.type = n;
        this.index = n2;
        this.lex = string;
        if (string != null) {
            boolean bl = false;
            if (string.length() == 0 || Character.isLetter(string.charAt(0))) {
                bl = true;
            }
            this.isWord = bl;
        } else {
            this.isWord = false;
        }
    }
}

