/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.compiler;

import com.tridium.bql.compiler.RuntimeCompilerException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BTime;

public class TimeUtil {
    private static final char[] DATE_DELIM = new char[]{'-', ' ', '/', '\\'};
    private static final char[] AFTER_MINUTE = new char[]{':', ' '};
    private static final char[] AFTER_SECOND = new char[]{' ', '.'};

    public static BAbsTime parseDate(String string) {
        DateTimeFields dateTimeFields = new DateTimeFields();
        if (TimeUtil.parseDate(string.toCharArray(), 0, dateTimeFields) != string.length()) {
            throw new RuntimeCompilerException(0, "invalid.format.date", string);
        }
        return BAbsTime.make((int)dateTimeFields.year, (BMonth)BMonth.make((int)dateTimeFields.month), (int)dateTimeFields.day, (int)0, (int)0, (int)0, (int)0);
    }

    public static BAbsTime parseTimestamp(String string) {
        char[] cArray = string.toCharArray();
        int n = string.length();
        DateTimeFields dateTimeFields = new DateTimeFields();
        int n2 = TimeUtil.parseDate(cArray, 0, dateTimeFields);
        if (n2 == n || cArray[n2] != ' ') {
            throw new RuntimeCompilerException(0, "invalid.format.timestamp", string);
        }
        if ((n2 = TimeUtil.parseTime(cArray, n2 + 1, dateTimeFields)) != string.length()) {
            throw new RuntimeCompilerException(0, "invalid.format.timestamp", string);
        }
        return BAbsTime.make((int)dateTimeFields.year, (BMonth)BMonth.make((int)dateTimeFields.month), (int)dateTimeFields.day, (int)dateTimeFields.hour, (int)dateTimeFields.minute, (int)dateTimeFields.second, (int)dateTimeFields.milli);
    }

    public static int parseDate(char[] cArray, int n, DateTimeFields dateTimeFields) {
        Object var3_3 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        int n6 = n;
        int n7 = cArray.length;
        n6 = n5;
        n5 = TimeUtil.advance(cArray, n5, DATE_DELIM);
        n2 = TimeUtil.stringToInt(cArray, n6, n5 - n6);
        if (n5 == n7) {
            throw new RuntimeCompilerException(0, "invalid.format.date", new String(cArray));
        }
        n6 = ++n5;
        n5 = TimeUtil.advance(cArray, n5, DATE_DELIM);
        n3 = Character.isDigit(cArray[n6]) ? TimeUtil.stringToInt(cArray, n6, n5 - n6) - 1 : TimeUtil.stringToMonth(cArray, n6, n5 - n6);
        if (n5 == n7) {
            throw new RuntimeCompilerException(0, "invalid.format.date", new String(cArray));
        }
        n6 = ++n5;
        n5 = TimeUtil.advance(cArray, n5, DATE_DELIM);
        n4 = TimeUtil.stringToInt(cArray, n6, n5 - n6);
        if (n2 > 1000) {
            dateTimeFields.year = n2;
            dateTimeFields.month = n3;
            dateTimeFields.day = n4;
            return n5;
        }
        if (n4 > 1000) {
            dateTimeFields.year = n4;
            dateTimeFields.month = n3;
            dateTimeFields.day = n2;
            return n5;
        }
        throw new RuntimeCompilerException(0, "required.fourDigitYear", new String(cArray));
    }

    public static BTime parseTime(String string) {
        DateTimeFields dateTimeFields = new DateTimeFields();
        if (TimeUtil.parseTime(string.toCharArray(), 0, dateTimeFields) != string.length()) {
            throw new RuntimeCompilerException(0, "invalid.format.time", string);
        }
        return BTime.make((int)dateTimeFields.hour, (int)dateTimeFields.minute, (int)dateTimeFields.second, (int)dateTimeFields.milli);
    }

    private static final int parseTime(char[] cArray, int n, DateTimeFields dateTimeFields) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        int n7 = n;
        int n8 = cArray.length;
        n6 = n7;
        n7 = TimeUtil.advance(cArray, n6, ':');
        n2 = TimeUtil.stringToInt(cArray, n6, n7 - n6);
        if (cArray[n7++] != ':') {
            throw new RuntimeCompilerException(0, "invalid.format.time", new String(cArray));
        }
        n6 = n7;
        n7 = TimeUtil.advance(cArray, n6, AFTER_MINUTE);
        n3 = TimeUtil.stringToInt(cArray, n6, n7 - n6);
        if (n7 != n8 && cArray[n7] == ':') {
            n6 = ++n7;
            n7 = TimeUtil.advance(cArray, n6, AFTER_SECOND);
            n4 = TimeUtil.stringToInt(cArray, n6, n7 - n6);
            if (n7 != n8 && cArray[n7] == '.') {
                n6 = ++n7;
                n7 = TimeUtil.advance(cArray, n6, ' ');
                n5 = TimeUtil.stringToInt(cArray, n6, n7 - n6);
            }
        }
        if (n2 > 23 || n3 > 59 || n4 > 59 || n5 > 999) {
            throw new RuntimeCompilerException(0, "invalid.format.time", new String(cArray));
        }
        dateTimeFields.hour = n2;
        dateTimeFields.minute = n3;
        dateTimeFields.second = n4;
        dateTimeFields.milli = n5;
        return n7;
    }

    private static final boolean in(char c, char[] cArray) {
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static final int advance(char[] cArray, int n, char[] cArray2) {
        int n2 = n;
        int n3 = cArray.length;
        int n4 = cArray2.length;
        while (n2 != n3) {
            int n5 = 0;
            while (n5 < n4) {
                if (cArray[n2] == cArray2[n5]) {
                    return n2;
                }
                ++n5;
            }
            ++n2;
        }
        return n2;
    }

    private static final int advance(char[] cArray, int n, char c) {
        int n2 = n;
        int n3 = cArray.length;
        while (n2 != n3) {
            if (cArray[n2] == c) {
                return n2;
            }
            ++n2;
        }
        return n2;
    }

    private static final int stringToInt(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 1;
        if (n2 == 0) {
            throw new NumberFormatException(new String(cArray, n, n2));
        }
        int n5 = n + n2 - 1;
        while (n5 >= n) {
            if (cArray[n5] >= '0' && cArray[n5] <= '9') {
                n3 += (cArray[n5] - 48) * n4;
            } else {
                throw new NumberFormatException(new String(cArray, n, n2));
            }
            n4 *= 10;
            --n5;
        }
        return n3;
    }

    private static final int stringToMonth(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2).toLowerCase();
        char c = string.charAt(0);
        switch (c) {
            case 'a': {
                if (string.equals("apr")) {
                    return 3;
                }
                if (string.equals("aug")) {
                    return 7;
                }
                return -1;
            }
            case 'd': {
                if (string.equals("dec")) {
                    return 11;
                }
                return -1;
            }
            case 'f': {
                if (string.equals("feb")) {
                    return 1;
                }
                return -1;
            }
            case 'j': {
                if (string.equals("jan")) {
                    return 0;
                }
                if (string.equals("jun")) {
                    return 5;
                }
                if (string.equals("jul")) {
                    return 6;
                }
                return -1;
            }
            case 'm': {
                if (string.equals("mar")) {
                    return 2;
                }
                if (string.equals("may")) {
                    return 4;
                }
                return -1;
            }
            case 'n': {
                if (string.equals("nov")) {
                    return 10;
                }
                return -1;
            }
            case 'o': {
                if (string.equals("oct")) {
                    return 9;
                }
                return -1;
            }
            case 's': {
                if (string.equals("sep")) {
                    return 8;
                }
                return -1;
            }
        }
        return -1;
    }

    static final /* synthetic */ int access$1(char[] cArray, int n, int n2) {
        return TimeUtil.stringToInt(cArray, n, n2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class DateTimeFields {
        public int year;
        public int month;
        public int day;
        public int hour;
        public int minute;
        public int second;
        public int milli;

        private final /* synthetic */ void this() {
            this.year = 0;
            this.month = 0;
            this.day = 0;
            this.hour = 0;
            this.minute = 0;
            this.second = 0;
            this.milli = 0;
        }

        private DateTimeFields() {
            this.this();
        }
    }

    private static class CharBuf {
        public char[] buf;
        public int offset;
        public int len;
        public int end;
        public int index;

        public final boolean done() {
            boolean bl = false;
            if (this.index == this.end) {
                bl = true;
            }
            return bl;
        }

        public final void advance() {
            if (this.index != this.end) {
                ++this.index;
            }
        }

        public final void skip(char c) {
            while (this.index != this.end && this.buf[this.index] == c) {
                ++this.index;
            }
        }

        public final void skip(char[] cArray) {
            while (this.index != this.end && TimeUtil.in(this.buf[this.index], cArray)) {
                ++this.index;
            }
        }

        public final void checkDone(String string) {
            if (this.index != this.end) {
                throw new RuntimeCompilerException(0, string, this.toString());
            }
        }

        public final void checkNotDone(String string) {
            if (this.index == this.end) {
                throw new RuntimeCompilerException(0, string, this.toString());
            }
        }

        public final void checkCurrent(char c, String string) {
            if (this.index == this.end || this.buf[this.index] != c) {
                throw new RuntimeCompilerException(0, string, this.toString());
            }
        }

        /*
         * Unable to fully structure code
         */
        public final int readNumber() {
            var1_1 = this.index;
            if (Character.isDigit(this.buf[var1_1])) ** GOTO lbl6
            System.out.println("not digit: '" + this.buf[var1_1] + '\'');
            throw new RuntimeCompilerException(0, "invalid.format.interval", new String(this.buf, this.offset, this.len));
lbl-1000:
            // 1 sources

            {
                ++this.index;
lbl6:
                // 2 sources

                ** while (this.index < this.end && Character.isDigit((char)this.buf[this.index]))
            }
lbl7:
            // 1 sources

            return TimeUtil.access$1(this.buf, var1_1, this.index - var1_1);
        }

        public final String readString(char[] cArray) {
            int n = this.index;
            while (this.index < this.end && !TimeUtil.in(this.buf[this.index], cArray)) {
                ++this.index;
            }
            int n2 = this.index;
            int n3 = n2 - 1;
            if (this.buf[n3] == 's' && n3 != n) {
                --n2;
            }
            return new String(this.buf, n, n2 - n);
        }

        public final String toString() {
            return new String(this.buf, this.offset, this.len);
        }

        public CharBuf(char[] cArray, int n, int n2) {
            this.buf = cArray;
            this.offset = n;
            this.len = n2;
            this.end = n + n2;
            this.index = n;
        }
    }
}

