/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.compiler;

import com.tridium.bql.BBqlLibrary;
import com.tridium.bql.BBqlTime;
import com.tridium.bql.compiler.BooleanRequiredException;
import com.tridium.bql.compiler.BqlTokenizer;
import com.tridium.bql.compiler.BqlTypeSpec;
import com.tridium.bql.compiler.ComparableRequiredException;
import com.tridium.bql.compiler.Constants;
import com.tridium.bql.compiler.ExprUtil;
import com.tridium.bql.compiler.InvalidNumberException;
import com.tridium.bql.compiler.LiteralParseException;
import com.tridium.bql.compiler.NumericRequiredException;
import com.tridium.bql.compiler.RuntimeCompilerException;
import com.tridium.bql.compiler.SimpleTypeRequiredException;
import com.tridium.bql.compiler.Token;
import com.tridium.bql.compiler.UnexpectedOperatorTypeException;
import com.tridium.bql.compiler.UnexpectedSymbolException;
import com.tridium.bql.compiler.UnexpectedTokenTypeException;
import com.tridium.bql.compiler.UnrecognizedModuleException;
import com.tridium.bql.compiler.UnrecognizedTypeException;
import com.tridium.bql.expression.BBqlFunction;
import com.tridium.bql.expression.BPath;
import com.tridium.bql.expression.BScalarFunction;
import java.io.IOException;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BNull;
import javax.baja.query.expression.BListExpression;
import javax.baja.query.expression.BSimpleExpression;
import javax.baja.query.util.Exprs;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExprParser
implements Constants {
    public static final BTypeSpec TIME_LIB = BBqlTime.TYPE.getTypeSpec();
    private static final BTypeSpec STD_LIB = BBqlLibrary.TYPE.getTypeSpec();
    private static final Lexicon lex = Lexicon.make((String)"bql");
    private static final BExpression[] NO_PARAMS = new BExpression[0];
    private BqlTokenizer tokens;
    private Token current;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$baja$query$BExpression;

    public BExpression parse(BqlTokenizer bqlTokenizer) {
        this.tokens = bqlTokenizer;
        this.next();
        BExpression bExpression = this.or();
        bqlTokenizer.push(this.current);
        return bExpression;
    }

    protected BExpression or() {
        BExpression bExpression = this.or(null);
        while (this.current.type == 6) {
            bExpression = this.or(bExpression);
        }
        return bExpression;
    }

    protected BExpression or(BExpression bExpression) {
        int n = this.current.index;
        int n2 = this.current.index;
        if (bExpression == null) {
            bExpression = this.and();
        }
        while (this.current.type == 6 && this.current.opType == 14) {
            n = n2;
            Token token = this.current;
            this.next();
            n2 = this.current.index;
            BExpression bExpression2 = this.and();
            this.verifyBoolean(bExpression, n);
            this.verifyBoolean(bExpression2, n2);
            bExpression = ExprUtil.tag((BExpression)Exprs.binary((BExpression)bExpression, (String)token.lex, (BExpression)bExpression2));
        }
        return bExpression;
    }

    protected BExpression and() {
        int n = this.current.index;
        int n2 = this.current.index;
        BExpression bExpression = this.comparison();
        while (this.current.type == 6 && this.current.opType == 13) {
            n = n2;
            Token token = this.current;
            this.next();
            n2 = this.current.index;
            BExpression bExpression2 = this.comparison();
            this.verifyBoolean(bExpression, n);
            this.verifyBoolean(bExpression2, n2);
            bExpression = ExprUtil.tag((BExpression)Exprs.binary((BExpression)bExpression, (String)token.lex, (BExpression)bExpression2));
        }
        return bExpression;
    }

    private final void verifyBoolean(BExpression bExpression, int n) {
        if (!ExprUtil.isBoolean(bExpression)) {
            throw new BooleanRequiredException(n);
        }
    }

    protected BExpression comparison() {
        int n = this.current.index;
        int n2 = this.current.index;
        BExpression bExpression = this.addition();
        while (this.isComparisonOperator()) {
            n = n2;
            Token token = this.current;
            this.next();
            n2 = this.current.index;
            BExpression bExpression2 = this.addition();
            switch (token.opType) {
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    if (!ExprUtil.isComparable(bExpression)) {
                        throw new ComparableRequiredException(n);
                    }
                    if (!ExprUtil.isComparable(bExpression2)) {
                        throw new ComparableRequiredException(n2);
                    }
                }
                case 5: 
                case 6: {
                    break;
                }
                case 11: {
                    if (ExprUtil.isConstant(bExpression2) && bExpression2 instanceof BSimpleExpression && ((BSimpleExpression)bExpression2).getSimpleValue().getType().is(BString.TYPE)) break;
                    throw new SimpleTypeRequiredException(n2, BString.TYPE);
                }
                case 15: {
                    this.validateIN_Right(bExpression2, n2);
                    break;
                }
                default: {
                    throw new RuntimeCompilerException(token.index, "invalid.opType.comparison", token.lex);
                }
            }
            bExpression = ExprUtil.tag((BExpression)Exprs.binary((BExpression)bExpression, (String)token.lex, (BExpression)bExpression2));
        }
        return bExpression;
    }

    private final boolean isComparisonOperator() {
        boolean bl = false;
        if (this.current.type == 6 && (this.current.opType == 5 || this.current.opType == 6 || this.current.opType == 7 || this.current.opType == 8 || this.current.opType == 9 || this.current.opType == 10 || this.current.opType == 11 || this.current.opType == 15)) {
            bl = true;
        }
        return bl;
    }

    private final void validateIN_Right(BExpression bExpression, int n) throws RuntimeCompilerException {
        if (bExpression instanceof BListExpression) {
            return;
        }
        if (bExpression instanceof BScalarFunction) {
            return;
        }
        throw new RuntimeCompilerException(n, this.lexText("in.invalidRHS"));
    }

    protected BExpression addition() {
        int n = this.current.index;
        int n2 = this.current.index;
        BExpression bExpression = this.multiplication();
        while (this.current.type == 6 && (this.current.opType == 0 || this.current.opType == 1)) {
            n = n2;
            Token token = this.current;
            this.next();
            n2 = this.current.index;
            BExpression bExpression2 = this.multiplication();
            if (!ExprUtil.isComparable(bExpression)) {
                throw new NumericRequiredException(n);
            }
            if (!ExprUtil.isComparable(bExpression2)) {
                throw new NumericRequiredException(n2);
            }
            bExpression = ExprUtil.tag((BExpression)Exprs.binary((BExpression)bExpression, (String)token.lex, (BExpression)bExpression2));
        }
        return bExpression;
    }

    protected BExpression multiplication() {
        int n = this.current.index;
        int n2 = this.current.index;
        BExpression bExpression = this.unary();
        while (this.current.type == 6 && (this.current.opType == 2 || this.current.opType == 3 || this.current.opType == 4)) {
            n = n2;
            Token token = this.current;
            this.next();
            n2 = this.current.index;
            BExpression bExpression2 = this.unary();
            if (!ExprUtil.isComparable(bExpression)) {
                throw new NumericRequiredException(n);
            }
            if (!ExprUtil.isComparable(bExpression2)) {
                throw new NumericRequiredException(n2);
            }
            bExpression = ExprUtil.tag((BExpression)Exprs.binary((BExpression)bExpression, (String)token.lex, (BExpression)bExpression2));
        }
        return bExpression;
    }

    protected BExpression unary() {
        Token token = null;
        if (this.current.type == 6) {
            token = this.current;
            switch (token.opType) {
                case 0: 
                case 1: {
                    this.next();
                    break;
                }
                case 12: {
                    return this.not();
                }
                default: {
                    throw new RuntimeCompilerException(this.current.index, "unexpected.operator", token.lex);
                }
            }
        }
        int n = this.current.index;
        BExpression bExpression = this.term();
        if (token != null) {
            switch (token.opType) {
                case 0: {
                    if (!ExprUtil.isComparable(bExpression)) {
                        throw new NumericRequiredException(n);
                    }
                    return ExprUtil.tag((BExpression)Exprs.unary((String)token.lex, (BExpression)bExpression));
                }
                case 1: {
                    if (!ExprUtil.isComparable(bExpression)) {
                        throw new NumericRequiredException(n);
                    }
                    return ExprUtil.tag((BExpression)Exprs.unary((String)token.lex, (BExpression)bExpression));
                }
            }
            throw new IllegalStateException();
        }
        return bExpression;
    }

    protected BExpression not() {
        int n = this.current.index;
        Token token = null;
        int n2 = 0;
        while (this.current.type == 6 && this.current.opType == 12) {
            token = this.current;
            this.next();
            ++n2;
        }
        if (token == null) {
            throw new IllegalStateException("Should have NOT");
        }
        int n3 = this.current.index;
        BExpression bExpression = this.term();
        this.verifyBoolean(bExpression, n3);
        int n4 = 0;
        while (n4 < n2) {
            bExpression = ExprUtil.tag((BExpression)Exprs.unary((String)token.lex, (BExpression)bExpression));
            ++n4;
        }
        return bExpression;
    }

    protected BExpression term() {
        Token token = this.current;
        int n = token.type;
        switch (n) {
            case 1: {
                return ExprUtil.tag(this.id());
            }
            case 3: 
            case 12: {
                return ExprUtil.tag(this.number());
            }
            case 5: {
                this.next();
                return ExprUtil.tag((BExpression)Exprs.simple((BSimple)BString.make((String)token.lex)));
            }
            case 4: {
                this.next();
                return ExprUtil.tag((BExpression)Exprs.simple((BSimple)BBoolean.make((boolean)token.booleanValue)));
            }
            case 23: {
                return ExprUtil.tag(this.typeSpec());
            }
            case 7: {
                this.match(7);
                BExpression bExpression = this.or();
                this.match(8);
                return bExpression;
            }
            case 35: {
                this.tokens.push(this.current);
                return this.makeList(this.parameters(35, 36));
            }
            case 29: {
                return ExprUtil.tag((BExpression)BBqlFunction.make(TIME_LIB, this.match((int)29).lex, this.makeList(NO_PARAMS)));
            }
            case 30: {
                return ExprUtil.tag((BExpression)BBqlFunction.make(TIME_LIB, this.match((int)30).lex, this.makeList(NO_PARAMS)));
            }
            case 31: {
                return ExprUtil.tag((BExpression)BBqlFunction.make(TIME_LIB, this.match((int)31).lex, this.makeList(NO_PARAMS)));
            }
            case 33: {
                return ExprUtil.tag(this.bqltime());
            }
            case 26: {
                this.next();
                return ExprUtil.tag((BExpression)Exprs.simple((BSimple)BNull.NULL));
            }
            case 25: {
                throw new IllegalStateException();
            }
        }
        throw new UnexpectedSymbolException(token.index, "identifier or literal", token.toDisplay());
    }

    protected BExpression id() {
        Token token = this.match(1);
        if (this.current.type == 7) {
            this.tokens.push(this.current);
            return this.function(STD_LIB, token.lex);
        }
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = ExprParser.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        array.add((Object)token.lex);
        while (this.current.type == 12) {
            this.match(12);
            array.add((Object)this.matchWord().lex);
        }
        return new BPath((String[])array.trim());
    }

    protected BExpression typeSpec() {
        int n = this.current.index;
        Token token = this.match(23);
        if (this.current.type == 5) {
            Token token2 = this.match(5);
            BqlTypeSpec bqlTypeSpec = new BqlTypeSpec(token.lex);
            try {
                return Exprs.simple((BSimple)((BSimple)bqlTypeSpec.parse(token2.lex)));
            }
            catch (ModuleException moduleException) {
                throw new UnrecognizedModuleException(n, token.lex);
            }
            catch (TypeException typeException) {
                throw new UnrecognizedTypeException(n, token.lex);
            }
            catch (LiteralParseException literalParseException) {
                throw new LiteralParseException(n, token.lex, token2.lex);
            }
            catch (IOException iOException) {
                throw new LiteralParseException(n, token.lex, token2.lex);
            }
        }
        if (this.current.type == 12) {
            this.match(12);
            return this.enumOrFunctionExpr(token);
        }
        return Exprs.simple((BSimple)BTypeSpec.make((String)token.lex));
    }

    protected BExpression enumOrFunctionExpr(Token token) {
        if (this.current.type != 1) {
            throw new UnexpectedTokenTypeException(this.current.index, 1, this.current.type);
        }
        Token token2 = this.match(1);
        if (this.current.type == 7) {
            this.tokens.push(this.current);
            return this.function(BTypeSpec.make((String)token.lex), token2.lex);
        }
        Token token3 = token2;
        Type type = BTypeSpec.make((String)token.lex).getResolvedType();
        BObject bObject = type.getInstance();
        if (!(bObject instanceof BFrozenEnum)) {
            throw new RuntimeCompilerException(token.index, "invalid.enum.tag", token.lex);
        }
        BFrozenEnum bFrozenEnum = (BFrozenEnum)bObject;
        BFrozenEnum bFrozenEnum2 = (BFrozenEnum)bFrozenEnum.getRange().get(token3.lex);
        if (bFrozenEnum2 == null) {
            throw new RuntimeCompilerException(token3.index, "invalid.enum.tag", token3.lex);
        }
        return Exprs.simple((BSimple)bFrozenEnum2);
    }

    protected BExpression number() {
        this.tokens.setShowWhite(true);
        Token token = null;
        if (this.current.type != 12) {
            token = this.current;
            this.next();
        } else {
            token = Token.number(this.current.index, "0");
        }
        if (this.current.type == 12) {
            this.match(12);
            Token token2 = this.current;
            if (token2.type != 3) {
                throw new InvalidNumberException(token.index, token.lex + '.' + token2.lex);
            }
            this.match(3);
            this.tokens.setShowWhite(false);
            if (this.current.type == 0) {
                this.next();
            }
            return Exprs.simple((BSimple)BDouble.make((double)Double.parseDouble(token.lex + '.' + token2.lex)));
        }
        this.tokens.setShowWhite(false);
        if (this.current.type == 0) {
            this.next();
        }
        return Exprs.simple((BSimple)BLong.make((long)Long.parseLong(token.lex)));
    }

    protected BExpression[] parameters(int n, int n2) {
        if (this.tokens.peek().type != n) {
            this.next();
            return NO_PARAMS;
        }
        this.next();
        if (this.tokens.peek().type == n2) {
            this.next();
            this.next();
            return NO_PARAMS;
        }
        Class clazz = class$javax$baja$query$BExpression;
        if (clazz == null) {
            clazz = class$javax$baja$query$BExpression = ExprParser.class("[Ljavax.baja.query.BExpression;", false);
        }
        Array array = new Array(clazz);
        while (this.current.type != n2) {
            ExprParser exprParser = new ExprParser();
            BExpression bExpression = exprParser.parse(this.tokens);
            array.add((Object)bExpression);
            this.next();
        }
        this.next();
        return (BExpression[])array.trim();
    }

    protected BExpression function(BTypeSpec bTypeSpec, String string) {
        boolean bl = false;
        if (this.tokens.peek().type != 7) {
            this.next();
            return BBqlFunction.make(bTypeSpec, string, this.makeList(NO_PARAMS));
        }
        this.next();
        if (this.tokens.peek().type == 8) {
            this.next();
            this.next();
            return BBqlFunction.make(bTypeSpec, string, this.makeList(NO_PARAMS));
        }
        if (this.tokens.peek().type == 19) {
            this.next();
            bl = true;
        }
        BBqlFunction bBqlFunction = null;
        if (this.tokens.peek().type == 6 && this.tokens.peek().opType == 2) {
            if (bl) {
                throw new RuntimeCompilerException(this.current.index, this.lexText("function.distinctStar"));
            }
            this.next();
            if (this.tokens.peek().type != 8) {
                throw new RuntimeCompilerException(this.current.index, this.lexText("function.starAndArgs"));
            }
            this.next();
            this.next();
            bBqlFunction = BBqlFunction.make(bTypeSpec, string, this.makeList(new BExpression[]{new BPath("toString")}));
        } else {
            int n = this.current.type;
            this.tokens.push(this.current);
            bBqlFunction = BBqlFunction.make(bTypeSpec, string, this.makeList(this.parameters(n, 8)));
        }
        bBqlFunction.setDistinct(bl);
        return bBqlFunction;
    }

    private final BListExpression makeList(BExpression[] bExpressionArray) {
        BListExpression bListExpression = new BListExpression();
        int n = 0;
        while (n < bExpressionArray.length) {
            bListExpression.add(bExpressionArray[n]);
            ++n;
        }
        return bListExpression;
    }

    protected BExpression bqltime() {
        this.next();
        this.match(12);
        Token token = this.current;
        if (this.current.type != 1) {
            throw new UnexpectedTokenTypeException(token.index, 1, token.type);
        }
        String string = this.current.lex;
        return BBqlFunction.make(TIME_LIB, string, this.makeList(this.parameters(7, 8)));
    }

    private final Token next() {
        Token token = this.current;
        this.current = this.tokens.next();
        return token;
    }

    private final Token match(int n) {
        Token token = this.current;
        if (this.current.type != n) {
            throw new UnexpectedTokenTypeException(this.current.index, n, this.current.type);
        }
        this.next();
        return token;
    }

    private final Token matchWord() {
        Token token = this.current;
        if (!this.current.isWord) {
            throw new UnexpectedTokenTypeException(this.current.index, 1, this.current.type);
        }
        this.next();
        return token;
    }

    private final Token matchOperator(int n) {
        Token token = this.match(6);
        if (token.opType != n) {
            throw new UnexpectedOperatorTypeException(token.index, n, token.opType);
        }
        return token;
    }

    private final String lexText(String string) {
        return lex.get(string, string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

