/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql;

import com.tridium.bql.Range;
import com.tridium.bql.RangeSet;
import com.tridium.bql.RangeSetImpl;
import com.tridium.bql.SelectQuery;
import com.tridium.bql.compiler.Constants;
import com.tridium.bql.compiler.ExprUtil;
import com.tridium.bql.expression.BPath;
import com.tridium.bql.expression.ExprEngine;
import javax.baja.bql.BqlQuery;
import javax.baja.query.BExpression;
import javax.baja.query.expression.BBinaryExpression;
import javax.baja.query.expression.BUnaryExpression;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Type;
import javax.baja.util.BAbsTimeRange;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RangeUtil
implements Constants {
    private BExpression expr;
    private ExprEngine engine;
    private ExprEngine.MorphUtil morpher;
    private String index;
    private Type prototype;
    private boolean equalityOnly;
    private int notDepth;
    static /* synthetic */ Class class$java$lang$Comparable;

    public RangeSet solveRange(boolean bl) {
        try {
            this.equalityOnly = bl;
            RangeSet rangeSet = this.solve(this.expr);
            rangeSet.sort();
            return rangeSet;
        }
        catch (CannotIndex cannotIndex) {
            return Range.ALL;
        }
        catch (CannotSolve cannotSolve) {
            return Range.ALL;
        }
    }

    protected RangeSet solve(BExpression bExpression) {
        int n = ExprUtil.getOpId(bExpression);
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.comparison((BBinaryExpression)bExpression, n);
            }
            case 13: {
                return this.solveAnd((BBinaryExpression)bExpression);
            }
            case 14: {
                return this.solveOr((BBinaryExpression)bExpression);
            }
            case 12: {
                return this.solveNot((BUnaryExpression)bExpression);
            }
            case 15: {
                return this.containment((BBinaryExpression)bExpression);
            }
            case 11: {
                throw new CannotIndex("like expressions cannot be indexed", bExpression);
            }
        }
        throw new CannotSolve("opId: " + n);
    }

    protected RangeSet comparison(BBinaryExpression bBinaryExpression, int n) {
        Class clazz;
        BExpression bExpression = null;
        if (this.isProperty(bBinaryExpression.lhs())) {
            bExpression = bBinaryExpression.rhs();
        } else if (this.isProperty(bBinaryExpression.rhs())) {
            bExpression = bBinaryExpression.lhs();
            n = this.reverseOperator(n);
        } else {
            throw new CannotIndex("comparison not on index", (BExpression)bBinaryExpression);
        }
        if (this.equalityOnly) {
            if (this.notDepth % 2 == 0 && n != 5) {
                throw new CannotSolve("equality violated");
            }
            if (this.notDepth % 2 == 1 && n != 6) {
                throw new CannotSolve("equality violated");
            }
        }
        if ((clazz = class$java$lang$Comparable) == null) {
            clazz = class$java$lang$Comparable = RangeUtil.class("[Ljava.lang.Comparable;", false);
        }
        if (!clazz.isAssignableFrom(this.prototype.getTypeClass()) && n != 5 && n != 6) {
            throw new IllegalArgumentException("Range evaluation can only be performed on Comparable objects");
        }
        BSimple bSimple = this.eval(bExpression);
        if (n == 5) {
            return new Range(bSimple);
        }
        if (n == 6) {
            return new Range(bSimple).not();
        }
        if (n == 7 || n == 8) {
            boolean bl = false;
            if (n == 8) {
                bl = true;
            }
            return new Range(bSimple, bl, null, false);
        }
        if (n == 9 || n == 10) {
            boolean bl = false;
            if (n == 10) {
                bl = true;
            }
            return new Range(null, false, bSimple, bl);
        }
        throw new IllegalArgumentException("Cannot create range from operator id: " + n);
    }

    protected RangeSet solveAnd(BBinaryExpression bBinaryExpression) {
        RangeSet rangeSet = null;
        RangeSet rangeSet2 = null;
        try {
            rangeSet = this.solve(bBinaryExpression.lhs());
        }
        catch (CannotIndex cannotIndex) {}
        try {
            rangeSet2 = this.solve(bBinaryExpression.rhs());
        }
        catch (CannotIndex cannotIndex) {}
        if (rangeSet == null && rangeSet2 == null) {
            throw new CannotIndex("<not index> AND <not index>", (BExpression)bBinaryExpression);
        }
        if (rangeSet == null) {
            return rangeSet2;
        }
        if (rangeSet2 == null) {
            return rangeSet;
        }
        return RangeSetImpl.crossProduct(rangeSet, rangeSet2);
    }

    protected RangeSet solveOr(BBinaryExpression bBinaryExpression) {
        RangeSet rangeSet = this.solve(bBinaryExpression.lhs());
        RangeSet rangeSet2 = this.solve(bBinaryExpression.rhs());
        return new RangeSetImpl(rangeSet, rangeSet2).union();
    }

    protected RangeSet solveNot(BUnaryExpression bUnaryExpression) {
        ++this.notDepth;
        try {
            if (bUnaryExpression.operand() instanceof BPath && !this.isProperty(bUnaryExpression.operand())) {
                throw new CannotIndex("unary on non-indexed property");
            }
            RangeSet rangeSet = this.solve(bUnaryExpression.operand()).not().union();
            Object var3_3 = null;
            --this.notDepth;
            return rangeSet;
        }
        catch (CannotIndex cannotIndex) {
            try {
                throw cannotIndex;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                --this.notDepth;
                throw throwable;
            }
        }
    }

    protected RangeSet containment(BBinaryExpression bBinaryExpression) {
        if (!this.isProperty(bBinaryExpression.lhs())) {
            throw new CannotIndex("", (BExpression)bBinaryExpression);
        }
        try {
            if (this.prototype.equals(BAbsTime.TYPE)) {
                if (this.equalityOnly) {
                    throw new CannotSolve("equality only with BAbsTimeRange");
                }
                BObject bObject = this.engine.evaluate(bBinaryExpression.rhs(), null, null);
                if (bObject instanceof BAbsTimeRange) {
                    BAbsTimeRange bAbsTimeRange = (BAbsTimeRange)bObject;
                    return new Range((BSimple)bAbsTimeRange.getStartTime(), true, (BSimple)bAbsTimeRange.getEndTime(), true);
                }
            }
        }
        catch (Exception exception) {}
        throw new CannotIndex("", (BExpression)bBinaryExpression);
    }

    protected BSimple eval(BExpression bExpression) {
        try {
            BObject bObject = this.engine.evaluate(bExpression, null, null);
            if (!bObject.getType().is(this.prototype)) {
                ExprEngine.MorphUtil.MorphedTuple morphedTuple = this.morpher.morph(this.prototype.getInstance(), bObject);
                bObject = morphedTuple.rhs;
                if (!bObject.getType().is(this.prototype)) {
                    throw new CannotIndex("evaluated to non-prototype '" + bObject.getTypeDisplayName(null) + '\'');
                }
            }
            return bObject.asSimple();
        }
        catch (CannotIndex cannotIndex) {
            throw cannotIndex;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CannotIndex("failed to evaluate", bExpression);
        }
    }

    protected boolean isProperty(BExpression bExpression) {
        BPath bPath;
        return bExpression instanceof BPath && (bPath = (BPath)bExpression).getPath().getName().equals(this.index);
    }

    protected int reverseOperator(int n) {
        switch (n) {
            case 7: {
                return 9;
            }
            case 9: {
                return 7;
            }
            case 8: {
                return 10;
            }
            case 10: {
                return 8;
            }
            case 5: 
            case 6: {
                return n;
            }
        }
        throw new IllegalStateException();
    }

    public static void main(String[] stringArray) {
        Type type = BTypeSpec.make((String)stringArray[0]).getResolvedType();
        boolean bl = Boolean.valueOf(stringArray[1]);
        SelectQuery selectQuery = (SelectQuery)BqlQuery.make("select * where " + stringArray[2]);
        RangeSet rangeSet = selectQuery.getRange("x", type, bl);
        System.out.println("Prototype: " + type);
        System.out.println("Query: " + selectQuery);
        System.out.println("Range: " + rangeSet);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.equalityOnly = false;
        this.notDepth = 0;
    }

    public RangeUtil(BExpression bExpression, ExprEngine exprEngine, String string, Type type) {
        this.this();
        this.expr = bExpression;
        this.engine = exprEngine;
        this.morpher = new ExprEngine.MorphUtil();
        this.index = string;
        this.prototype = type;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CannotIndex
    extends RuntimeException {
        public CannotIndex(String string, BExpression bExpression) {
            this(string + ": " + ExprUtil.toExprStr(bExpression));
        }

        public CannotIndex(String string) {
            super(string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CannotSolve
    extends RuntimeException {
        public CannotSolve(String string) {
            super(string);
        }
    }
}

