/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScanXpr;

import com.tridium.platHwScan.BBaseBoard;
import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.optionCards.BOptionSlot;
import com.tridium.platHwScan.ports.BEthernetPort;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.util.BHardwareRef;
import com.tridium.sys.Nre;
import java.util.Vector;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNpmXprBoard
extends BBaseBoard {
    public static final Property LAN1 = BNpmXprBoard.newProperty((int)1, (BValue)new BEthernetPort("en0"), null);
    public static final Property LAN2 = BNpmXprBoard.newProperty((int)1, (BValue)new BEthernetPort("en1"), null);
    public static final Property COM1 = BNpmXprBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs232, "tridium:serial", "COM"), null);
    public static final Property COM2 = BNpmXprBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs485, "tridium:serial", "COM"), null);
    public static final Property COM3 = BNpmXprBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.nrio, "tridium:nrio", "COM", BHwScanStatusEnum.dedicated), null);
    public static final Property optionSlot1 = BNpmXprBoard.newProperty((int)1, (BValue)new BOptionSlot(1), null);
    public static final Type TYPE;
    private static final Lexicon lex;
    private static final String BASE_BOARD_CODE = "05";
    private static final String VIEW = "pxView";
    private static final String IMAGES_DIR = "imageDir";
    private static final int BASE_LAN_PORT = 3;
    private static final int BASE_LON_PORT = 1;
    private static final int BASE_SERIAL_PORT = 7;
    private static final int HARDWARE_REF_COUNT = 8;
    static /* synthetic */ Class class$com$tridium$platHwScanXpr$BNpmXprBoard;
    static /* synthetic */ Class class$com$tridium$platHwScan$optionCards$BOptionCard;
    static /* synthetic */ Class class$com$tridium$platHwScan$ports$BPort;

    public BEthernetPort getLAN1() {
        return (BEthernetPort)this.get(LAN1);
    }

    public void setLAN1(BEthernetPort bEthernetPort) {
        this.set(LAN1, (BValue)bEthernetPort, null);
    }

    public BEthernetPort getLAN2() {
        return (BEthernetPort)this.get(LAN2);
    }

    public void setLAN2(BEthernetPort bEthernetPort) {
        this.set(LAN2, (BValue)bEthernetPort, null);
    }

    public BPort getCOM1() {
        return (BPort)this.get(COM1);
    }

    public void setCOM1(BPort bPort) {
        this.set(COM1, (BValue)bPort, null);
    }

    public BPort getCOM2() {
        return (BPort)this.get(COM2);
    }

    public void setCOM2(BPort bPort) {
        this.set(COM2, (BValue)bPort, null);
    }

    public BPort getCOM3() {
        return (BPort)this.get(COM3);
    }

    public void setCOM3(BPort bPort) {
        this.set(COM3, (BValue)bPort, null);
    }

    public BOptionSlot getOptionSlot1() {
        return (BOptionSlot)this.get(optionSlot1);
    }

    public void setOptionSlot1(BOptionSlot bOptionSlot) {
        this.set(optionSlot1, (BValue)bOptionSlot, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void autoConfig(Array array, boolean bl) {
        this.simulation = bl;
        this.setProductModel(lex.getText(Nre.getHostModel().toUpperCase()));
        this.initializeStandardPorts();
        this.nextSerialPort = 7;
        this.nextLonPort = 1;
        this.nextLanPort = 3;
        this.configureOptionSlot(this.getOptionSlot1(), (String)array.get(0), (String)array.get(1));
        this.scanFactoryOptions(array);
    }

    public String getBoardCode() {
        return BASE_BOARD_CODE;
    }

    public String getImagesDirectory() {
        return lex.getText(IMAGES_DIR);
    }

    public String getView(BObject bObject) {
        return lex.getText(VIEW);
    }

    public void configureOptionSlot(BOptionSlot bOptionSlot, String string, String string2) {
        bOptionSlot.removeAll();
        if (!string.equalsIgnoreCase("FF") || !string2.equalsIgnoreCase("FF")) {
            BOptionCard bOptionCard = BOptionCard.lookup((String)(string + ' ' + string2));
            if (bOptionCard == null) {
                bOptionSlot.addCard(new BOptionCard(BHardwareScanService.lex.getText("unknownOptionCard", new Object[]{string, string2}), string + ' ' + string2));
            } else {
                BOptionCard bOptionCard2 = (BOptionCard)bOptionCard.newCopy(true);
                bOptionSlot.addCard(bOptionCard2);
                BPort[] bPortArray = bOptionCard2.getPorts();
                int n = 0;
                while (n < bPortArray.length) {
                    if (bPortArray[n] != null) {
                        BPort bPort = bPortArray[n];
                        if (bOptionCard2.getUsesCom()) {
                            bOptionCard2.rename(bOptionCard2.getProperty("Port" + (n + 1)), bPort.getPrefix() + '1', null);
                            if (this.getCOM1().getStatus().equals((Object)BHwScanStatusEnum.serialShell)) {
                                bPort.setStatus(BHwScanStatusEnum.unavailable);
                            } else {
                                this.getCOM1().setStatus(BHwScanStatusEnum.unavailable);
                                if (!this.simulation) {
                                    bPort.initOwnerAndStatus();
                                }
                            }
                        } else {
                            bOptionCard2.rename(bOptionCard2.getProperty("Port" + (n + 1)), this.makePortName(n + 1, bPort.getPrefix()), null);
                            if (!this.simulation) {
                                bPort.initOwnerAndStatus();
                            }
                        }
                    }
                    ++n;
                }
            }
        }
        if (bOptionSlot.isEmpty()) {
            bOptionSlot.add("Contents", (BValue)BHwScanStatusEnum.empty, 3);
        }
    }

    public Vector getHardwareRefs() {
        Vector<BHardwareRef> vector = new Vector<BHardwareRef>();
        int n = 1;
        while (n <= 8) {
            switch (n) {
                case 1: {
                    vector.addElement(this.makeBaseboardCommRef(n, (BPort)this.getLAN1()));
                    break;
                }
                case 2: {
                    vector.addElement(this.makeBaseboardCommRef(n, (BPort)this.getLAN2()));
                    break;
                }
                case 3: {
                    vector.addElement(this.makeJumperRef(n));
                    break;
                }
                case 4: {
                    BOptionCard bOptionCard;
                    Object object;
                    vector.addElement(new BHardwareRef(n, this.getBaseUnitText(), lex.getText("HardwareRef.factoryOptions")));
                    Class clazz = class$com$tridium$platHwScan$optionCards$BOptionCard;
                    if (clazz == null) {
                        clazz = BNpmXprBoard.class("[Lcom.tridium.platHwScan.optionCards.BOptionCard;", false);
                    }
                    BOptionCard[] bOptionCardArray = (BOptionCard[])this.getChildren(clazz);
                    int n2 = 1;
                    while (n2 <= bOptionCardArray.length) {
                        object = String.valueOf(n) + Character.forDigit(9 + n2, 16);
                        bOptionCard = bOptionCardArray[n2 - 1];
                        vector.addElement(new BHardwareRef((String)object, this.getBaseUnitText(), bOptionCard.getDescription()));
                        Class clazz2 = class$com$tridium$platHwScan$ports$BPort;
                        if (clazz2 == null) {
                            clazz2 = BNpmXprBoard.class("[Lcom.tridium.platHwScan.ports.BPort;", false);
                        }
                        BPort[] bPortArray = (BPort[])bOptionCard.getChildren(clazz2);
                        int n3 = 0;
                        while (n3 < bPortArray.length) {
                            vector.addElement(this.makePortRef((String)object, n3 + 1, bPortArray[n3]));
                            ++n3;
                        }
                        ++n2;
                    }
                    break;
                }
                case 5: {
                    vector.addElement(this.makeBaseboardCommRef(n, this.getCOM3()));
                    break;
                }
                case 6: {
                    BOptionSlot bOptionSlot = this.getOptionSlot1();
                    vector.addElement(this.makeSlotRef(n, bOptionSlot));
                    if (bOptionSlot.isEmpty()) break;
                    Object object = (BOptionCard)bOptionSlot.getContents();
                    object.lease(1);
                    Class clazz = class$com$tridium$platHwScan$ports$BPort;
                    if (clazz == null) {
                        clazz = BNpmXprBoard.class("[Lcom.tridium.platHwScan.ports.BPort;", false);
                    }
                    BOptionCard bOptionCard = (BOptionCard)object.getChildren(clazz);
                    int n4 = 0;
                    while (n4 < ((BPort[])bOptionCard).length) {
                        vector.addElement(this.makePortRef(n, n4 + 1, bOptionCard[n4]));
                        ++n4;
                    }
                    break;
                }
                case 7: {
                    vector.addElement(this.makeBaseboardCommRef(n, this.getCOM1()));
                    break;
                }
                case 8: {
                    vector.addElement(this.makeBaseboardCommRef(n, this.getCOM2()));
                    break;
                }
            }
            ++n;
        }
        return vector;
    }

    private final void initializeStandardPorts() {
        this.setDisplayName(COM1, BFormat.make((String)("COM".toUpperCase() + '1')), null);
        this.setDisplayName(COM2, BFormat.make((String)("COM".toUpperCase() + '2')), null);
        this.setDisplayName(COM3, BFormat.make((String)("COM".toUpperCase() + '3')), null);
        this.setDisplayName(LAN1, BFormat.make((String)("LAN".toUpperCase() + '1')), null);
        this.setDisplayName(LAN2, BFormat.make((String)("LAN".toUpperCase() + '2')), null);
        if (!this.simulation) {
            this.getCOM1().initOwnerAndStatus();
            this.getCOM2().initOwnerAndStatus();
            this.getCOM3().initOwnerAndStatus();
            this.getLAN1().initStatus();
            this.getLAN2().initStatus();
        }
    }

    public void scanFactoryOptions(Array array) {
        BOptionCard bOptionCard;
        BOptionCard bOptionCard2;
        String string = (String)array.get(4);
        String string2 = (String)array.get(5);
        if (((String)array.get(5)).equalsIgnoreCase("8A") && (bOptionCard2 = BOptionCard.lookup((String)(string + ' ' + string2))) != null) {
            bOptionCard = (BOptionCard)bOptionCard2.newCopy(true);
            this.add("WIRELESS8A", (BValue)bOptionCard);
            bOptionCard.rename(bOptionCard.getProperty("Port1"), "COM4", null);
        }
        string = (String)array.get(6);
        string2 = (String)array.get(7);
        if (string.equalsIgnoreCase("62") && (bOptionCard2 = BOptionCard.lookup((String)(string + ' ' + string2))) != null) {
            bOptionCard = (BOptionCard)bOptionCard2.newCopy(true);
            this.add("GPRS", (BValue)bOptionCard);
            bOptionCard.rename(bOptionCard.getProperty("Port1"), "COM5", null);
            bOptionCard.rename(bOptionCard.getProperty("Port2"), "COM6", null);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$platHwScanXpr$BNpmXprBoard;
        if (clazz == null) {
            clazz = class$com$tridium$platHwScanXpr$BNpmXprBoard = BNpmXprBoard.class("[Lcom.tridium.platHwScanXpr.BNpmXprBoard;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$platHwScanXpr$BNpmXprBoard;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$platHwScanXpr$BNpmXprBoard = BNpmXprBoard.class("[Lcom.tridium.platHwScanXpr.BNpmXprBoard;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }
}

