/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import com.tridium.data.BDataTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BChart;
import javax.baja.chart.ChartModelEvent;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Type;

public abstract class ChartModel
extends BChart.ChartSupport {
    public abstract int getSpecCount();

    public abstract ChartSpec getSpec(int var1);

    public Series[] getAllSeries() {
        int n = this.getSpecCount();
        Series[] seriesArray = new Series[n];
        int n2 = 0;
        while (n2 < n) {
            seriesArray[n2] = this.getSpec(n2).getSeries();
            ++n2;
        }
        return seriesArray;
    }

    public void fireSeriesModified(Series series) {
        BChart bChart = this.getChart();
        if (bChart == null) {
            return;
        }
        ChartSpec chartSpec = this.getSpecForSeries(series);
        if (chartSpec != null) {
            this.fireSpecModified(chartSpec);
        } else {
            this.fireModelModified();
        }
    }

    public void fireSpecModified(ChartSpec chartSpec) {
        BChart bChart = this.getChart();
        if (bChart == null) {
            return;
        }
        bChart.modelModified(new ChartModelEvent(this, 3, chartSpec));
    }

    public void fireSpecAdded(ChartSpec chartSpec) {
        BChart bChart = this.getChart();
        if (bChart == null) {
            return;
        }
        bChart.modelModified(new ChartModelEvent(this, 1, chartSpec));
    }

    public void fireSpecRemoved(ChartSpec chartSpec) {
        BChart bChart = this.getChart();
        if (bChart == null) {
            return;
        }
        bChart.modelModified(new ChartModelEvent(this, 2, chartSpec));
    }

    public void fireModelModified() {
        BChart bChart = this.getChart();
        if (bChart == null) {
            return;
        }
        bChart.modelModified(new ChartModelEvent(this, 0));
    }

    public ChartSpec getSpecForSeries(Series series) {
        if (series == null) {
            return null;
        }
        int n = this.getSpecCount();
        int n2 = 0;
        while (n2 < n) {
            ChartSpec chartSpec = this.getSpec(n2);
            if (chartSpec.getSeries() == series) {
                return chartSpec;
            }
            ++n2;
        }
        return null;
    }

    public BAxis[] getAxes(BAxisDimension bAxisDimension) {
        int n = this.getSpecCount();
        ArrayList<BAxis> arrayList = new ArrayList<BAxis>(n);
        int n2 = 0;
        while (n2 < n) {
            ChartSpec chartSpec = this.getSpec(n2);
            BAxis bAxis = chartSpec.getXAxis();
            if (bAxis.getDimension() == bAxisDimension && !arrayList.contains((Object)bAxis)) {
                arrayList.add(bAxis);
            }
            if ((bAxis = chartSpec.getYAxis()).getDimension() == bAxisDimension && !arrayList.contains((Object)bAxis)) {
                arrayList.add(bAxis);
            }
            ++n2;
        }
        return arrayList.toArray(new BAxis[arrayList.size()]);
    }

    public BAxis findAxis(BAxis bAxis) {
        BAxisDimension bAxisDimension = bAxis.getDimension();
        int n = this.getSpecCount();
        int n2 = 0;
        while (n2 < n) {
            ChartSpec chartSpec = this.getSpec(n2);
            BAxis bAxis2 = null;
            bAxis2 = bAxisDimension == BAxisDimension.x ? chartSpec.getXAxis() : chartSpec.getYAxis();
            if (bAxis2 != null && bAxis2.isCompatible(bAxis)) {
                return bAxis2;
            }
            ++n2;
        }
        return null;
    }

    public BITable export() {
        BIDataValue[] bIDataValueArray;
        BFacets bFacets;
        Object object;
        BIDataValue[] bIDataValueArray2;
        BDataTable bDataTable = new BDataTable();
        Series[] seriesArray = this.getAllSeries();
        int n = 0;
        while (n < seriesArray.length) {
            String string;
            Series series = seriesArray[n];
            if (n == 0) {
                bIDataValueArray2 = series.getColumnName(0);
                string = series.getColumnDisplayName(0);
                object = series.getColumnType(0);
                bFacets = series.getColumnFacets(0);
                bDataTable.addColumn((String)bIDataValueArray2, string, object, 0, bFacets);
            }
            bIDataValueArray2 = series.getColumnName(1);
            string = series.getColumnDisplayName(1);
            object = series.getColumnType(1);
            bFacets = series.getColumnFacets(1);
            bIDataValueArray = BFacets.make((String)"SERIES_NAME", (String)series.getName());
            bFacets = BFacets.make((BFacets)bFacets, (BFacets)bIDataValueArray);
            bDataTable.addColumn((String)bIDataValueArray2, string, object, 0, bFacets);
            ++n;
        }
        ArrayList<BIDataValue[]> arrayList = new ArrayList<BIDataValue[]>();
        int n2 = 0;
        while (n2 < seriesArray.length) {
            bIDataValueArray2 = seriesArray[n2];
            int n3 = 0;
            while (n3 < bIDataValueArray2.getRowCount()) {
                object = (BIDataValue)bIDataValueArray2.getValue(n3, 0);
                bFacets = (BIDataValue)bIDataValueArray2.getValue(n3, 1);
                bIDataValueArray = null;
                int n4 = 0;
                while (n4 < arrayList.size()) {
                    BIDataValue[] bIDataValueArray3 = (BIDataValue[])arrayList.get(n4);
                    if (bIDataValueArray3[0].equals(object)) {
                        bIDataValueArray = bIDataValueArray3;
                        break;
                    }
                    ++n4;
                }
                if (bIDataValueArray == null) {
                    bIDataValueArray = new BIDataValue[seriesArray.length + 1];
                    bIDataValueArray[0] = object;
                    arrayList.add(bIDataValueArray);
                }
                bIDataValueArray[n2 + 1] = bFacets;
                ++n3;
            }
            ++n2;
        }
        Collections.sort(arrayList, new KeyComparator());
        bDataTable.startRows();
        n2 = 0;
        while (n2 < arrayList.size()) {
            bDataTable.startRow();
            bIDataValueArray2 = (BIDataValue[])arrayList.get(n2);
            int n5 = 0;
            while (n5 < bIDataValueArray2.length) {
                object = bIDataValueArray2[n5];
                if (object == null) {
                    bFacets = bDataTable.getColumns();
                    bIDataValueArray = bFacets.get(n5);
                    Type type = bIDataValueArray.getType();
                    char c = type.getDataTypeSymbol();
                    object = c == 'b' ? BBoolean.DEFAULT : (c == 's' ? BString.DEFAULT : BDouble.NaN);
                }
                bDataTable.set((BIDataValue)object, BFacets.NULL);
                ++n5;
            }
            bDataTable.endRow();
            ++n2;
        }
        return bDataTable;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class KeyComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            BIDataValue[] bIDataValueArray = (BIDataValue[])object;
            BIDataValue[] bIDataValueArray2 = (BIDataValue[])object2;
            if (bIDataValueArray.length > 0 && bIDataValueArray2.length > 0 && bIDataValueArray[0] instanceof Comparable) {
                return ((Comparable)bIDataValueArray[0]).compareTo(bIDataValueArray2[0]);
            }
            return 0;
        }

        private KeyComparator() {
        }
    }
}

