/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import javax.baja.chart.BAxis;
import javax.baja.chart.BChart;
import javax.baja.chart.BContinuousAxis;
import javax.baja.chart.BDiscreteAxis;
import javax.baja.chart.ChartModel;
import javax.baja.chart.JoinTable;
import javax.baja.chart.Series;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BStackedBarChart
extends BChart {
    public static final Type TYPE;
    private JoinTable joinTable;
    private double barWidth;
    static /* synthetic */ Class class$javax$baja$chart$BStackedBarChart;

    public Type getType() {
        return TYPE;
    }

    public void updateAxes() {
        Object object;
        ChartModel chartModel = this.getModel();
        int n = chartModel.getSpecCount();
        if (n == 0) {
            return;
        }
        BAxis bAxis = chartModel.getSpec(0).getYAxis();
        BAxis bAxis2 = chartModel.getSpec(0).getXAxis();
        if (bAxis2 == null || bAxis == null) {
            return;
        }
        if (this.joinTable == null) {
            this.joinTable = JoinTable.make(chartModel.getAllSeries(), 0);
        }
        if (bAxis2 != null) {
            bAxis2.updateFacets(this.joinTable.getSeries(0).getColumnFacets(0));
            if (bAxis2.isMinAuto() && (object = this.joinTable.getSeries(0).getMin(0)) != null) {
                bAxis2.updateAutoMin(object);
            }
            if (bAxis2.isMaxAuto() && (object = this.joinTable.getSeries(0).getMax(0)) != null) {
                bAxis2.updateAutoMax(object);
            }
        }
        if (bAxis != null) {
            bAxis.updateFacets(this.joinTable.getSeries(0).getColumnFacets(1));
            if (bAxis.isMinAuto() && (object = this.joinTable.getMinRow()) != null) {
                bAxis.updateAutoMin(object);
            }
            if (bAxis.isMaxAuto() && (object = this.joinTable.getMaxRow()) != null) {
                bAxis.updateAutoMax(object);
            }
        }
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth();
        ChartModel chartModel = this.getModel();
        int n = chartModel.getSpecCount();
        if (n == 0) {
            return;
        }
        if (this.joinTable == null) {
            this.joinTable = JoinTable.make(chartModel.getAllSeries(), 0);
        }
        BAxis bAxis = chartModel.getSpec(0).getXAxis();
        this.barWidth = 0.0;
        if (bAxis instanceof BDiscreteAxis) {
            Object[] objectArray = bAxis.getTickValues();
            if (objectArray.length == 1) {
                this.barWidth = d * (double)2 / (double)3;
            } else {
                double d2 = bAxis.toDisplaySpace(objectArray[1]) - bAxis.toDisplaySpace(objectArray[0]);
                this.barWidth = d2 * (double)2 / (double)3;
            }
        } else {
            this.barWidth = d / 16.0;
        }
    }

    public void doPaint(Graphics graphics) {
        ChartModel chartModel = this.getModel();
        int n = chartModel.getSpecCount();
        if (n == 0) {
            return;
        }
        BAxis bAxis = chartModel.getSpec(0).getXAxis();
        BContinuousAxis bContinuousAxis = (BContinuousAxis)chartModel.getSpec(0).getYAxis();
        if (this.joinTable == null) {
            this.joinTable = this.join(0);
        }
        int n2 = this.joinTable.getRowCount();
        int n3 = this.joinTable.getColumnCount();
        double d = bContinuousAxis.toDisplaySpace(bContinuousAxis.getZero());
        int n4 = 0;
        while (n4 < n2) {
            Object object = this.joinTable.getKey(n4);
            double d2 = bAxis.toDisplaySpace(object);
            double d3 = d2 - this.barWidth / (double)2;
            double d4 = d;
            int n5 = 0;
            while (n5 < n3) {
                double d5;
                Object object2 = this.joinTable.getValue(n4, n5);
                if (object2 != null && !((d5 = bContinuousAxis.toDisplaySpace(this.joinTable.getValue(n4, n5))) > d)) {
                    Series series = this.joinTable.getSeries(n5);
                    BPen bPen = series.getPen();
                    graphics.setPen(bPen == null ? BPen.DEFAULT : bPen);
                    graphics.setBrush(series.getBrush());
                    graphics.fillRect(d3, d5 - (d - d4), this.barWidth, d - d5);
                    graphics.setBrush(BColor.black.toBrush());
                    graphics.strokeRect(d3, d5 - (d - d4), this.barWidth, d - d5);
                    d4 = d5 - (d - d4);
                }
                ++n5;
            }
            ++n4;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BStackedBarChart() {
    }

    public BStackedBarChart(ChartModel chartModel) {
        super(chartModel);
    }

    static {
        Class clazz = class$javax$baja$chart$BStackedBarChart;
        if (clazz == null) {
            clazz = class$javax$baja$chart$BStackedBarChart = BStackedBarChart.class("[Ljavax.baja.chart.BStackedBarChart;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

