/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import com.tridium.ui.theme.Theme;
import java.text.DecimalFormat;
import javax.baja.chart.BChart;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.JoinTable;
import javax.baja.chart.Series;
import javax.baja.chart.SimpleChartModel;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BEllipseGeom;
import javax.baja.gx.BFont;
import javax.baja.gx.BGeom;
import javax.baja.gx.BPathGeom;
import javax.baja.gx.BPen;
import javax.baja.gx.EllipseGeom;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.sys.BDouble;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPieChart
extends BChart {
    public static final Property font = BPieChart.newProperty((int)0, (BValue)BFont.NULL, null);
    public static final Property showSliceLabels = BPieChart.newProperty((int)0, (boolean)true, null);
    public static final Property pen = BPieChart.newProperty((int)0, (BValue)BPen.make((double)1.0), null);
    public static final Property stroke = BPieChart.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Type TYPE;
    private static final int ABOVE = 0;
    private static final int BELOW = 2;
    private static final int RIGHT = 0;
    private static final int LEFT = 2;
    private static final int CENTER = 1;
    private static final BDouble ZERO;
    private DecimalFormat ratioFormat;
    private JoinTable joinTable;
    private int pieCount;
    private int pieColumns;
    private Pie[] pies;
    private double cellWidth;
    private double cellHeight;
    private int pr;
    static /* synthetic */ Class class$javax$baja$chart$BPieChart;

    public BFont getFont() {
        return (BFont)this.get(font);
    }

    public void setFont(BFont bFont) {
        this.set(font, (BValue)bFont, null);
    }

    public boolean getShowSliceLabels() {
        return this.getBoolean(showSliceLabels);
    }

    public void setShowSliceLabels(boolean bl) {
        this.setBoolean(showSliceLabels, bl, null);
    }

    public BPen getPen() {
        return (BPen)this.get(pen);
    }

    public void setPen(BPen bPen) {
        this.set(pen, (BValue)bPen, null);
    }

    public BBrush getStroke() {
        return (BBrush)this.get(stroke);
    }

    public void setStroke(BBrush bBrush) {
        this.set(stroke, (BValue)bBrush, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void setModel(ChartModel chartModel) {
        this.joinTable = null;
        super.setModel(chartModel);
    }

    public ChartModel setModel(String[] stringArray, double[] dArray) {
        SimpleChartModel simpleChartModel = new SimpleChartModel();
        if (stringArray.length != dArray.length) {
            String string = "Label list and value list must have equal lengths. (" + stringArray.length + " != " + dArray.length + ')';
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        while (n < stringArray.length) {
            simpleChartModel.add(new ChartSpec(new SingleValueSeries(stringArray[n], dArray[n])));
            ++n;
        }
        this.setModel(simpleChartModel);
        return simpleChartModel;
    }

    public void setPieLayout(int n) {
        this.pieColumns = n;
    }

    public boolean usesXAxis() {
        return false;
    }

    public boolean usesYAxis() {
        return false;
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d;
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        ChartModel chartModel = this.getModel();
        int n = chartModel.getSpecCount();
        if (n == 0) {
            this.pies = new Pie[0];
            return;
        }
        if (this.joinTable == null) {
            this.joinTable = JoinTable.make(chartModel.getAllSeries(), 0);
        }
        this.pieCount = this.joinTable.getRowCount();
        int n2 = 1;
        n2 = this.pieColumns > 0 ? this.pieColumns : ((double)((int)(d = Math.sqrt(this.pieCount))) < d ? (int)d + 1 : (int)d);
        if (n2 < 1) {
            n2 = 1;
        }
        this.pr = this.pieCount / n2;
        if (this.pr * n2 < this.pieCount) {
            ++this.pr;
        }
        this.cellWidth = d2 / (double)n2;
        this.cellHeight = d3 / (double)this.pr;
        this.pies = new Pie[this.pieCount];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.pr) {
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                this.pies[n4] = this.makePie(n6, n3, this.cellWidth, this.cellHeight, this.joinTable, n4);
                n6 = (int)((double)n6 + this.cellWidth);
                if (++n4 == this.pieCount) break;
                ++n7;
            }
            n3 = (int)((double)n3 + this.cellHeight);
            if (n4 == this.pieCount) break;
            ++n5;
        }
    }

    public void doPaint(Graphics graphics) {
        int n = this.pr;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.pies.length) {
            Pie pie = this.pies[n4];
            boolean bl = true;
            int n5 = 0;
            while (n5 < pie.slices.length) {
                Slice slice = pie.slices[n5];
                if (slice != null && slice.ratio > 0.0) {
                    bl = false;
                    break;
                }
                ++n5;
            }
            if (bl) {
                double d = this.cellWidth;
                double d2 = this.cellHeight;
                double d3 = (Math.min(d / (double)2, d2 / (double)2) - 20.0) * (double)2;
                double d4 = (d - d3) / (double)2;
                double d5 = (d2 - d3) / (double)2;
                EllipseGeom ellipseGeom = new EllipseGeom(d4 += (double)n2 * this.cellWidth, d5 += (double)n3 * this.cellHeight, d3, d3);
                graphics.setBrush(BColor.make((String)"#eee"));
                graphics.fill((IGeom)ellipseGeom);
                graphics.setBrush(BColor.black);
                graphics.stroke((IGeom)ellipseGeom);
            } else {
                pie.paint(graphics);
            }
            if (++n2 >= n) {
                n2 = 0;
                ++n3;
            }
            ++n4;
        }
    }

    private final Pie makePie(double d, double d2, double d3, double d4, JoinTable joinTable, int n) {
        double d5 = 0.0;
        int n2 = joinTable.getColumnCount();
        int n3 = 0;
        while (n3 < n2) {
            BINumeric bINumeric = (BINumeric)joinTable.getValue(n, n3);
            if (bINumeric != null) {
                d5 += bINumeric.getNumeric();
            }
            ++n3;
        }
        double d6 = d + d3 / (double)2;
        double d7 = d2 + d4 / (double)2;
        double d8 = Math.min(d3 / (double)2, d4 / (double)2) - 20.0;
        double d9 = 0.0;
        Slice[] sliceArray = new Slice[n2];
        int n4 = 0;
        while (n4 < n2) {
            double d10;
            BEllipseGeom bEllipseGeom;
            double d11;
            BINumeric bINumeric = (BINumeric)joinTable.getValue(n, n4);
            double d12 = 0.0;
            if (bINumeric != null) {
                d12 = ((BINumeric)joinTable.getValue(n, n4)).getNumeric();
            }
            if ((d11 = d12 / d5) == 1.0) {
                bEllipseGeom = BEllipseGeom.make((double)(d6 - d8), (double)(d7 - d8), (double)((double)2 * d8), (double)((double)2 * d8));
                d10 = d11 * (double)2 * Math.PI;
                LabelLocation labelLocation = this.creatLabelLocation(d6, d7, d8, d9 += d10, d10);
                sliceArray[n4] = new Slice(d12, d11, joinTable.getSeries(n4), (BGeom)bEllipseGeom, labelLocation);
            } else {
                bEllipseGeom = new IPathGeom.Segment[4];
                bEllipseGeom[0] = new IPathGeom.MoveTo(true, d6, d7);
                d10 = d6 + d8 * Math.sin(d9);
                double d13 = d7 - d8 * Math.cos(d9);
                bEllipseGeom[1] = new IPathGeom.LineTo(true, d10, d13);
                double d14 = d11 * (double)2 * Math.PI;
                double d15 = d6 + d8 * Math.sin(d9 += d14);
                double d16 = d7 - d8 * Math.cos(d9);
                boolean bl = false;
                if (d14 > Math.PI) {
                    bl = true;
                }
                bEllipseGeom[2] = new IPathGeom.ArcTo(true, d8, d8, 0.0, bl, true, d15, d16);
                bEllipseGeom[3] = new IPathGeom.LineTo(true, d6, d7);
                LabelLocation labelLocation = this.creatLabelLocation(d6, d7, d8, d9, d14);
                sliceArray[n4] = new Slice(d12, d11, joinTable.getSeries(n4), (BGeom)BPathGeom.make((IPathGeom.Segment[])bEllipseGeom), labelLocation);
            }
            ++n4;
        }
        return new Pie(sliceArray);
    }

    private final LabelLocation creatLabelLocation(double d, double d2, double d3, double d4, double d5) {
        double d6 = d4 - d5 / (double)2;
        double d7 = d + (d3 + (double)5) * Math.sin(d6);
        double d8 = d2 - (d3 + (double)5) * Math.cos(d6);
        LabelLocation labelLocation = new LabelLocation(d7, d8, this.getTextHAlign(d6), this.getTextVAlign(d6));
        return labelLocation;
    }

    private final int getTextHAlign(double d) {
        if (d > Math.PI * 1.9 || d < Math.PI * 0.1 || d > Math.PI * 0.9 && d < Math.PI * 1.1) {
            return 1;
        }
        if (d < Math.PI) {
            return 0;
        }
        return 2;
    }

    private final int getTextVAlign(double d) {
        if (d >= Math.PI * 1.75 || d <= Math.PI * 0.25) {
            return 0;
        }
        if (d > Math.PI * 0.25 && d < Math.PI * 0.75 || d > Math.PI * 1.25 && d < Math.PI * 1.75) {
            return 1;
        }
        return 2;
    }

    static /* synthetic */ int access$1() {
        return 2;
    }

    static /* synthetic */ int access$2() {
        return 1;
    }

    static /* synthetic */ int access$3() {
        return 0;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ratioFormat = new DecimalFormat("#");
        this.pieColumns = -1;
    }

    public BPieChart() {
        this.this();
    }

    public BPieChart(ChartModel chartModel) {
        super(chartModel);
        this.this();
    }

    public BPieChart(String[] stringArray, double[] dArray) {
        this.this();
        this.setModel(stringArray, dArray);
    }

    static {
        Class clazz = class$javax$baja$chart$BPieChart;
        if (clazz == null) {
            clazz = class$javax$baja$chart$BPieChart = BPieChart.class("[Ljavax.baja.chart.BPieChart;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ZERO = BDouble.make((double)0.0);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SingleValueSeries
    extends Series {
        String label;
        BDouble value;

        public String getName() {
            return this.label;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "id";
            }
            return this.label;
        }

        public String getColumnDisplayName(int n) {
            return this.getColumnName(n);
        }

        public Type getColumnType(int n) {
            return BDouble.TYPE;
        }

        public int getRowCount() {
            return 1;
        }

        public Object getValue(int n, int n2) {
            if (n2 == 1) {
                return this.value;
            }
            return ZERO;
        }

        public Object getMin(int n) {
            return this.getValue(0, n);
        }

        public Object getMax(int n) {
            return this.getValue(0, n);
        }

        public SingleValueSeries(String string, double d) {
            this.label = string;
            this.value = BDouble.make((double)d);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Pie {
        protected Slice[] slices;

        public void paint(Graphics graphics) {
            int n = 0;
            while (n < this.slices.length) {
                if (this.slices[n] != null && this.slices[n].ratio != 0.0) {
                    BBrush bBrush = this.slices[n].series.getBrush();
                    if (bBrush == null) {
                        return;
                    }
                    graphics.setBrush(bBrush);
                    graphics.fill((IGeom)this.slices[n].path);
                }
                ++n;
            }
            BFont bFont = BPieChart.this.getFont();
            if (bFont.isNull()) {
                bFont = Theme.widget().getTextFont();
            }
            graphics.setFont(bFont);
            graphics.setPen(BPieChart.this.getPen());
            graphics.setBrush(BPieChart.this.getStroke());
            int n2 = 0;
            while (n2 < this.slices.length) {
                if (this.slices[n2] != null && this.slices[n2].ratio != 0.0) {
                    graphics.stroke((IGeom)this.slices[n2].path);
                    LabelLocation labelLocation = this.slices[n2].labelLoc;
                    String string = BPieChart.this.ratioFormat.format(this.slices[n2].ratio * 100.0) + '%';
                    double d = 0.0;
                    double d2 = 0.0;
                    d = labelLocation.halign == 2 ? labelLocation.x - bFont.width(string) : (labelLocation.halign == 1 ? labelLocation.x - bFont.width(string) / (double)2 : labelLocation.x);
                    d2 = labelLocation.valign == 0 ? labelLocation.y : (labelLocation.valign == 1 ? labelLocation.y + bFont.getAscent() / (double)2 : labelLocation.y + bFont.getAscent());
                    graphics.drawString(string, d, d2);
                }
                ++n2;
            }
        }

        public Pie(Slice[] sliceArray) {
            this.slices = sliceArray;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Slice {
        double value;
        double ratio;
        Series series;
        BGeom path;
        LabelLocation labelLoc;

        public Slice(double d, double d2, Series series, BGeom bGeom, LabelLocation labelLocation) {
            this.value = d;
            this.ratio = d2;
            this.series = series;
            this.path = bGeom;
            this.labelLoc = labelLocation;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LabelLocation {
        double x;
        double y;
        int halign;
        int valign;

        public LabelLocation(double d, double d2, int n, int n2) {
            this.x = d;
            this.y = d2;
            this.halign = n;
            this.valign = n2;
        }
    }
}

