/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import java.text.DecimalFormat;
import java.text.ParseException;
import javax.baja.chart.BContinuousAxis;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNumericAxis
extends BContinuousAxis {
    public static final Type TYPE;
    public static final Lexicon lex;
    private static final String ERR_PARSE_FORMAT = "chart.axis.numeric.error.parse";
    private static final double LOG10E = 0.4342944819018;
    private static final BDouble ZERO;
    private double min;
    private double max;
    private boolean initMin;
    private boolean initMax;
    private double tickIncrement;
    private BINumeric[] tickValues;
    private DecimalFormat format;
    static /* synthetic */ Class class$javax$baja$chart$BNumericAxis;

    public Type getValueType() {
        return BINumeric.TYPE;
    }

    public Object getAxisMin() {
        if (this.min == this.max) {
            this.expandRangeForConstant();
        }
        return BDouble.make((double)this.min);
    }

    public void setAxisMin(Object object) {
        double d = ((BINumeric)object).getNumeric();
        Double d2 = new Double(d);
        if (d2.isNaN()) {
            return;
        }
        this.min = d;
    }

    public void updateAutoMin(Object object) {
        double d = ((BINumeric)object).getNumeric();
        Double d2 = new Double(d);
        if (d2.isNaN()) {
            return;
        }
        if (this.initMin) {
            this.min = d;
            this.initMin = false;
        } else {
            this.min = Math.min(this.min, d);
        }
    }

    public Object getAxisMax() {
        if (this.min == this.max) {
            this.expandRangeForConstant();
        }
        return BDouble.make((double)this.max);
    }

    public void setAxisMax(Object object) {
        double d = ((BINumeric)object).getNumeric();
        Double d2 = new Double(d);
        if (d2.isNaN()) {
            return;
        }
        this.max = d;
    }

    public void updateAutoMax(Object object) {
        double d = ((BINumeric)object).getNumeric();
        Double d2 = new Double(d);
        if (d2.isNaN()) {
            return;
        }
        if (this.initMax) {
            this.max = d;
            this.initMax = false;
        } else {
            this.max = Math.max(this.max, d);
        }
    }

    private final void expandRangeForConstant() {
        if (this.min != this.max) {
            return;
        }
        double d = this.min;
        if (this.isMinAuto()) {
            this.min = d - 10.0;
        }
        if (this.isMaxAuto()) {
            this.max = d + 10.0;
        }
    }

    private final void expandRangeForTicks() {
        double d;
        if (this.tickValues == null || this.tickValues.length > 3) {
            return;
        }
        double d2 = this.tickValues[0].getNumeric();
        if (this.min > d2) {
            this.min = d2;
        }
        if (this.max < (d = this.tickValues[this.tickValues.length - 1].getNumeric())) {
            this.max = d;
        }
    }

    public void reset() {
        if (this.isMinAuto()) {
            this.initMin = true;
            this.min = 0.0;
        }
        if (this.isMaxAuto()) {
            this.initMax = true;
            this.max = 100.0;
        }
    }

    public double toPercentOfRange(Object object) {
        return (((BINumeric)object).getNumeric() - this.min) / (this.max - this.min);
    }

    public Object fromPercentOfRange(double d) {
        double d2 = this.min + (this.max - this.min) * d;
        return BDouble.make((double)d2);
    }

    public Object getZero() {
        return ZERO;
    }

    public void doLayout() {
        double d = this.max - this.min;
        double d2 = Math.log(d) * 0.4342944819018;
        this.tickIncrement = Math.max((float)Math.pow(10.0, Math.round(d2) - (long)2), Float.MIN_VALUE);
        if (d > 10.0 && this.tickIncrement < (double)5) {
            this.tickIncrement = 5;
        }
        try {
            this.tickIncrement = this.format.parse(this.format.format(this.tickIncrement)).doubleValue();
            double d3 = Math.pow(10.0, -this.getFacets().geti("precision", 2));
            if (this.tickIncrement < d3) {
                this.tickIncrement = d3;
            }
        }
        catch (ParseException parseException) {
            log.error(lex.getText(ERR_PARSE_FORMAT, new Object[]{new Double(this.tickIncrement)}));
        }
        int n = (int)(d / this.tickIncrement) + 1;
        while (n > 20) {
            this.tickIncrement = this.tickIncrement == 1.0 ? (this.tickIncrement *= 10.0) : (this.tickIncrement *= (double)2);
            n = (int)(d / this.tickIncrement);
        }
        double d4 = this.min;
        if ((d4 = (double)Math.round(d4)) > this.min) {
            try {
                d4 -= this.tickIncrement;
                if (d4 > this.min) {
                    d4 = this.min - this.tickIncrement;
                }
                d4 = this.format.parse(this.format.format(d4)).doubleValue();
            }
            catch (ParseException parseException) {
                log.error(lex.getText(ERR_PARSE_FORMAT, new Object[]{new Double(this.tickIncrement)}));
            }
        }
        double d5 = this.max;
        if ((d5 = (double)Math.round(d5)) < this.max) {
            d5 = d4 + this.tickIncrement * ((this.max - d4) / this.tickIncrement + 1.0);
        }
        n = (int)((d5 - d4) / this.tickIncrement) + 1;
        this.tickValues = new BINumeric[n];
        double d6 = d4;
        int n2 = 0;
        while (n2 < n) {
            this.tickValues[n2] = BDouble.make((double)d6);
            d6 += this.tickIncrement;
            ++n2;
        }
        if (n <= 3) {
            this.expandRangeForTicks();
        }
    }

    public Object[] getTickValues() {
        return this.tickValues;
    }

    public String valueToString(Object object) {
        return this.format.format(((BINumeric)object).getNumeric());
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.format = decimalFormat;
    }

    public boolean validateZoom(Object object, Object object2) {
        double d = ((BINumeric)object).getNumeric();
        double d2 = ((BINumeric)object2).getNumeric();
        if (d2 - d < 0.01) {
            return false;
        }
        return super.validateZoom(object, object2);
    }

    public BFacets updateFacets(BFacets bFacets) {
        if (bFacets == null) {
            bFacets = BFacets.DEFAULT;
        }
        int n = bFacets.geti("precision", 2);
        StringBuffer stringBuffer = new StringBuffer("###,###,###,##0");
        int n2 = 0;
        while (n2 < n) {
            if (n2 == 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append("0");
            ++n2;
        }
        this.format = new DecimalFormat(stringBuffer.toString());
        return super.updateFacets(bFacets);
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.min = 0.0;
        this.max = 0.0;
        this.initMin = true;
        this.initMax = true;
    }

    public BNumericAxis() {
        this.this();
        this.format = new DecimalFormat("###,###,###,##0.00");
    }

    public BNumericAxis(Object object, Object object2) {
        this();
        this.min = ((BINumeric)object).getNumeric();
        this.max = ((BINumeric)object2).getNumeric();
    }

    public BNumericAxis(DecimalFormat decimalFormat) {
        this.this();
        this.format = decimalFormat;
    }

    static {
        Class clazz = class$javax$baja$chart$BNumericAxis;
        if (clazz == null) {
            clazz = class$javax$baja$chart$BNumericAxis = BNumericAxis.class("[Ljavax.baja.chart.BNumericAxis;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$javax$baja$chart$BNumericAxis;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$chart$BNumericAxis = BNumericAxis.class("[Ljavax.baja.chart.BNumericAxis;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        ZERO = BDouble.make((double)0.0);
    }
}

