/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import java.util.ArrayList;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BAxisLocation;
import javax.baja.chart.Series;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDiscreteAxis
extends BAxis {
    public static final Type TYPE;
    private Object NULL;
    private Object[] range;
    private double[] locs;
    static /* synthetic */ Class class$javax$baja$chart$BDiscreteAxis;

    public Type getValueType() {
        return BValue.TYPE;
    }

    public void setRange(Object[] objectArray) {
        this.range = objectArray;
        this.locs = new double[objectArray.length];
    }

    public Object getAxisMin() {
        if (this.range.length == 0) {
            return this.NULL;
        }
        return this.range[0];
    }

    public void setAxisMin(Object object) {
    }

    public Object getAxisMax() {
        if (this.range.length == 0) {
            return this.NULL;
        }
        return this.range[this.range.length - 1];
    }

    public void setAxisMax(Object object) {
    }

    public Object[] getTickValues() {
        return this.range;
    }

    public String valueToString(Object object) {
        if (object instanceof BObject) {
            return ((BObject)object).toString((Context)this.getFacets());
        }
        return object.toString();
    }

    public void doLayout() {
        block3: {
            BAxisDimension bAxisDimension;
            double d;
            double d2;
            double d3;
            block2: {
                double d4 = this.getFullLength();
                int n = this.range.length + 1;
                d3 = d4 / (double)this.range.length / (double)5;
                d2 = (d4 - (double)n * d3) / (double)this.range.length;
                double d5 = d2 / (double)2;
                d = d3 + d5;
                bAxisDimension = this.getDimension();
                if (bAxisDimension != BAxisDimension.y) break block2;
                int n2 = this.range.length - 1;
                while (n2 >= 0) {
                    this.locs[n2] = d;
                    d += d2 + d3;
                    --n2;
                }
                break block3;
            }
            if (bAxisDimension != BAxisDimension.x) break block3;
            int n = 0;
            while (n < this.range.length) {
                this.locs[n] = d;
                d += d2 + d3;
                ++n;
            }
        }
    }

    public double toDisplaySpace(Object object) {
        if (object instanceof BEnum) {
            int n = 0;
            while (n < this.range.length) {
                if (((BEnum)this.range[n]).getOrdinal() == ((BEnum)object).getOrdinal()) {
                    return this.locs[n];
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.range.length) {
                if (this.range[n].equals(object)) {
                    return this.locs[n];
                }
                ++n;
            }
        }
        throw new IllegalArgumentException("Value out of discrete axis range: " + object);
    }

    public Object fromDisplaySpace(double d) {
        double d2;
        if (this.getLocation() == BAxisLocation.left || this.getLocation() == BAxisLocation.right) {
            if (d > this.locs[0]) {
                return this.range[0];
            }
            if (d < this.locs[this.locs.length - 1]) {
                return this.range[this.range.length - 1];
            }
            int n = 1;
            while (d < this.locs[n]) {
                ++n;
            }
            double d3 = (this.locs[n - 1] - this.locs[n]) / (double)2 + this.locs[n];
            return d3 < d ? this.range[n - 1] : this.range[n];
        }
        if (d < this.locs[0]) {
            return this.range[0];
        }
        if (d > this.locs[this.locs.length - 1]) {
            return this.range[this.range.length - 1];
        }
        int n = 0;
        while (d > this.locs[n]) {
            ++n;
        }
        double d4 = d - this.locs[n];
        double d5 = d2 = n < this.locs.length - 2 ? this.locs[n + 1] - d : Double.MAX_VALUE;
        if (d4 < d2) {
            return this.range[n];
        }
        return this.range[n + 1];
    }

    public boolean isZoomEnabled() {
        return false;
    }

    public static Object[] extractRange(Series series, int n) {
        Object object;
        if (series.getColumnType(n).is(BEnum.TYPE)) {
            BEnumRange bEnumRange = null;
            object = series.getColumnFacets(n);
            if (object != null) {
                BObject bObject = object.get("range");
                if (bObject != null && bObject instanceof BEnumRange) {
                    bEnumRange = (BEnumRange)bObject;
                }
                return BDiscreteAxis.extractEnumRange(bEnumRange, series, n);
            }
        }
        int n2 = series.getRowCount();
        object = new ArrayList(n2);
        int n3 = 0;
        while (n3 < n2) {
            Object object2 = series.getValue(n3, n);
            if (!((ArrayList)object).contains(object2)) {
                ((ArrayList)object).add(object2);
            }
            ++n3;
        }
        Object[] objectArray = ((ArrayList)object).toArray();
        if (objectArray.length > 0 && objectArray[0] instanceof Comparable) {
            SortUtil.sort((Object[])objectArray, (Object[])objectArray, (boolean)true);
        }
        return objectArray;
    }

    public static Object[] extractEnumRange(BEnumRange bEnumRange, Series series, int n) {
        if (bEnumRange == null) {
            bEnumRange = BEnumRange.NULL;
        }
        int[] nArray = bEnumRange.getOrdinals();
        IntHashMap intHashMap = new IntHashMap(Math.max(7, nArray.length));
        int n2 = 0;
        while (n2 < nArray.length) {
            intHashMap.put(nArray[n2], (Object)bEnumRange.get(nArray[n2]));
            ++n2;
        }
        n2 = series.getRowCount();
        int n3 = 0;
        while (n3 < n2) {
            BEnum bEnum = (BEnum)series.getValue(n3, n);
            if (intHashMap.get(bEnum.getOrdinal()) == null) {
                intHashMap.put(bEnum.getOrdinal(), (Object)bEnum);
            }
            ++n3;
        }
        Object[] objectArray = (BEnum[])intHashMap.toArray((Object[])new BEnum[intHashMap.size()]);
        SortUtil.sort((Object[])objectArray);
        return objectArray;
    }

    public void merge(BDiscreteAxis bDiscreteAxis) {
        if (this.isCompatible(bDiscreteAxis)) {
            Series[] seriesArray = bDiscreteAxis.getSeries();
            int n = 0;
            while (n < seriesArray.length) {
                this.updateSeries(seriesArray[n]);
                ++n;
            }
            n = bDiscreteAxis.range.length + this.range.length;
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            int n2 = 0;
            while (n2 < bDiscreteAxis.range.length) {
                arrayList.add(bDiscreteAxis.range[n2]);
                ++n2;
            }
            n2 = 0;
            while (n2 < this.range.length) {
                arrayList.add(this.range[n2]);
                ++n2;
            }
            Object[] objectArray = arrayList.toArray();
            if (objectArray[0] instanceof Comparable) {
                SortUtil.sort((Object[])objectArray, (Object[])objectArray, (boolean)true);
            }
            this.range = objectArray;
            this.locs = new double[n];
        }
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.NULL = new Object();
    }

    public BDiscreteAxis() {
        this.this();
        this.setMinAuto(false);
        this.setMaxAuto(false);
    }

    static {
        Class clazz = class$javax$baja$chart$BDiscreteAxis;
        if (clazz == null) {
            clazz = class$javax$baja$chart$BDiscreteAxis = BDiscreteAxis.class("[Ljavax.baja.chart.BDiscreteAxis;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

