/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import com.tridium.chart.BAxisContainer;
import com.tridium.chart.BDockedPanControl;
import com.tridium.ui.UiEnv;
import java.util.ArrayList;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BAxisLocation;
import javax.baja.chart.BChart;
import javax.baja.chart.BChartCanvas;
import javax.baja.chart.BChartHeader;
import javax.baja.chart.BChartLegend;
import javax.baja.chart.BDefaultChartLegend;
import javax.baja.chart.BNumericAxis;
import javax.baja.chart.ChartController;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.chart.binding.BoundChartModel;
import javax.baja.collection.BITable;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BPane;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BChartPane
extends BPane {
    public static final Property border = BChartPane.newProperty((int)0, (BValue)BBorder.solid, null);
    public static final Property background = BChartPane.newProperty((int)0, (BValue)BColor.make((String)"#eee").toBrush(), null);
    public static final Property header = BChartPane.newProperty((int)0, (BValue)new BChartHeader(), null);
    public static final Property canvas = BChartPane.newProperty((int)0, (BValue)new BChartCanvas(), null);
    public static final Property legend = BChartPane.newProperty((int)0, (BValue)new BDefaultChartLegend(), null);
    public static final Property zoomEnabled = BChartPane.newProperty((int)0, (boolean)true, null);
    public static final Property leftAxes = BChartPane.newProperty((int)6, (BValue)new BAxisContainer(BAxisDimension.y, BAxisLocation.left), null);
    public static final Property rightAxes = BChartPane.newProperty((int)6, (BValue)new BAxisContainer(BAxisDimension.y, BAxisLocation.right), null);
    public static final Property topAxes = BChartPane.newProperty((int)6, (BValue)new BAxisContainer(BAxisDimension.x, BAxisLocation.top), null);
    public static final Property bottomAxes = BChartPane.newProperty((int)6, (BValue)new BAxisContainer(BAxisDimension.x, BAxisLocation.bottom), null);
    public static final Action showPanControl = BChartPane.newAction((int)0, null);
    public static final Action hidePanControl = BChartPane.newAction((int)0, null);
    public static final Topic showPanRequested = BChartPane.newTopic((int)0, null);
    public static final Topic hidePanRequested = BChartPane.newTopic((int)0, null);
    public static final Type TYPE;
    private static Lexicon lex;
    private static BFont font;
    public static final BColor[] DEFAULT_COLORS;
    private int rebuildCountDown;
    private boolean buildRequired;
    private ChartController controller;
    private ArrayList zoomStack;
    private BDockedPanControl panControl;
    private BBorderPane panPane;
    private boolean zoomed;
    private Context context;
    static /* synthetic */ Class class$javax$baja$chart$BChartPane;
    static /* synthetic */ Class class$javax$baja$chart$BChart;

    public BBorder getBorder() {
        return (BBorder)this.get(border);
    }

    public void setBorder(BBorder bBorder) {
        this.set(border, (BValue)bBorder, null);
    }

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush bBrush) {
        this.set(background, (BValue)bBrush, null);
    }

    public BChartHeader getHeader() {
        return (BChartHeader)this.get(header);
    }

    public void setHeader(BChartHeader bChartHeader) {
        this.set(header, (BValue)bChartHeader, null);
    }

    public BChartCanvas getCanvas() {
        return (BChartCanvas)this.get(canvas);
    }

    public void setCanvas(BChartCanvas bChartCanvas) {
        this.set(canvas, (BValue)bChartCanvas, null);
    }

    public BChartLegend getLegend() {
        return (BChartLegend)this.get(legend);
    }

    public void setLegend(BChartLegend bChartLegend) {
        this.set(legend, (BValue)bChartLegend, null);
    }

    public boolean getZoomEnabled() {
        return this.getBoolean(zoomEnabled);
    }

    public void setZoomEnabled(boolean bl) {
        this.setBoolean(zoomEnabled, bl, null);
    }

    public BWidget getLeftAxes() {
        return (BWidget)this.get(leftAxes);
    }

    public void setLeftAxes(BWidget bWidget) {
        this.set(leftAxes, (BValue)bWidget, null);
    }

    public BWidget getRightAxes() {
        return (BWidget)this.get(rightAxes);
    }

    public void setRightAxes(BWidget bWidget) {
        this.set(rightAxes, (BValue)bWidget, null);
    }

    public BWidget getTopAxes() {
        return (BWidget)this.get(topAxes);
    }

    public void setTopAxes(BWidget bWidget) {
        this.set(topAxes, (BValue)bWidget, null);
    }

    public BWidget getBottomAxes() {
        return (BWidget)this.get(bottomAxes);
    }

    public void setBottomAxes(BWidget bWidget) {
        this.set(bottomAxes, (BValue)bWidget, null);
    }

    public void showPanControl() {
        this.invoke(showPanControl, null, null);
    }

    public void hidePanControl() {
        this.invoke(hidePanControl, null, null);
    }

    public void fireShowPanRequested(BWidgetEvent bWidgetEvent) {
        this.fire(showPanRequested, (BValue)bWidgetEvent, null);
    }

    public void fireHidePanRequested(BWidgetEvent bWidgetEvent) {
        this.fire(hidePanRequested, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!UiEnv.get().hasMouse()) {
            this.panControl = new BDockedPanControl(this);
            this.panPane = new BBorderPane((BWidget)this.panControl);
            this.panPane.setPadding(BInsets.make((double)0.0));
            this.panPane.setBorder(BBorder.make((int)7));
            this.add(null, (BValue)this.panPane);
            this.linkTo((BComponent)this, (Slot)showPanRequested, (Slot)showPanControl);
            this.linkTo((BComponent)this, (Slot)hidePanRequested, (Slot)hidePanControl);
        }
        this.build();
    }

    public final BChart[] getCharts() {
        BObject bObject;
        BChart[] bChartArray = new BChart[this.getSlotCount()];
        int n = 0;
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.nextComponent()) {
            bObject = slotCursor.get();
            if (!(bObject instanceof BChart)) continue;
            bChartArray[n++] = (BChart)bObject;
        }
        bObject = new BChart[n];
        System.arraycopy(bChartArray, 0, bObject, 0, n);
        return bObject;
    }

    /*
     * Unable to fully structure code
     */
    public Series[] getAllSeries() {
        var1_1 = new ArrayList<Series>(this.getSlotCount());
        var2_2 = this.getProperties();
        if (true) ** GOTO lbl14
        do {
            var3_3 = (BChart)var2_2.get();
            var4_4 = var3_3.getModel();
            var5_5 = var4_4.getSpecCount();
            var6_6 = 0;
            while (var6_6 < var5_5) {
                var1_1.add(var4_4.getSpec(var6_6).getSeries());
                ++var6_6;
            }
lbl14:
            // 2 sources

            if ((v0 = BChartPane.class$javax$baja$chart$BChart) != null) continue;
            v0 = BChartPane.class("[Ljavax.baja.chart.BChart;", false);
        } while (var2_2.next(v0));
        return var1_1.toArray(new Series[var1_1.size()]);
    }

    public BAxis[] getAxes(BAxisDimension bAxisDimension) {
        BAxis[] bAxisArray = null;
        if (bAxisDimension == BAxisDimension.x) {
            BAxisContainer bAxisContainer = (BAxisContainer)this.getBottomAxes();
            BAxisContainer bAxisContainer2 = (BAxisContainer)this.getTopAxes();
            bAxisArray = new BAxis[bAxisContainer.getAxisCount() + bAxisContainer2.getAxisCount()];
            bAxisContainer.copyInto(bAxisArray, 0);
            bAxisContainer2.copyInto(bAxisArray, bAxisContainer.getAxisCount());
        } else if (bAxisDimension == BAxisDimension.y) {
            BAxisContainer bAxisContainer = (BAxisContainer)this.getLeftAxes();
            BAxisContainer bAxisContainer3 = (BAxisContainer)this.getRightAxes();
            bAxisArray = new BAxis[bAxisContainer.getAxisCount() + bAxisContainer3.getAxisCount()];
            bAxisContainer.copyInto(bAxisArray, 0);
            bAxisContainer3.copyInto(bAxisArray, bAxisContainer.getAxisCount());
        }
        if (bAxisArray == null) {
            return new BAxis[0];
        }
        return bAxisArray;
    }

    public ChartController getController() {
        return this.controller;
    }

    public void setController(ChartController chartController) {
        if (chartController == null) {
            throw new NullPointerException();
        }
        if (chartController == this.controller) {
            return;
        }
        if (chartController.getPane() != null) {
            throw new IllegalStateException("Controller is already installed on another pane.");
        }
        chartController.setPane(this);
        if (this.controller != null) {
            this.controller.setPane(null);
        }
        this.controller = chartController;
    }

    public void doShowPanControl() {
        this.zoomed = true;
        this.panControl.updateActionStates();
        this.relayout();
        this.repaint();
    }

    public void doHidePanControl() {
        this.zoomed = false;
        this.relayout();
        this.repaint();
    }

    public void zoomIn(BAxisDimension bAxisDimension, double d, double d2) {
        ZoomSpec zoomSpec = new ZoomSpec(bAxisDimension);
        BAxis[] bAxisArray = this.getAxes(bAxisDimension);
        int n = 0;
        while (n < bAxisArray.length) {
            Object object;
            Object object2;
            BAxis bAxis = bAxisArray[n];
            if (bAxis.isZoomEnabled() && bAxis.validateZoom(object2 = bAxis.fromDisplaySpace(d), object = bAxis.fromDisplaySpace(d2))) {
                zoomSpec.add(bAxis, bAxis.getAxisMin(), bAxis.getAxisMax());
                bAxis.setAxisMin(object2);
                bAxis.setAxisMax(object);
                bAxis.doLayout();
            }
            ++n;
        }
        this.getCanvas().relayout();
        if (!zoomSpec.isEmpty()) {
            this.zoomStack.add(zoomSpec);
            this.fireShowPanRequested(null);
        }
    }

    public boolean isZoomed(BAxisDimension bAxisDimension) {
        int n = this.zoomStack.size();
        int n2 = 0;
        while (n2 < n) {
            ZoomSpec zoomSpec = (ZoomSpec)this.zoomStack.get(n2);
            if (zoomSpec.dim == bAxisDimension) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void zoomOut() {
        if (this.zoomStack.size() == 0) {
            return;
        }
        ZoomSpec zoomSpec = (ZoomSpec)this.zoomStack.get(this.zoomStack.size() - 1);
        this.zoomStack.remove(this.zoomStack.size() - 1);
        int n = zoomSpec.list.size();
        int n2 = 0;
        while (n2 < n) {
            Restore restore = (Restore)zoomSpec.list.get(n2);
            restore.axis.setAxisMin(restore.min);
            restore.axis.setAxisMax(restore.max);
            restore.axis.doLayout();
            ++n2;
        }
        if (this.zoomStack.size() == 0) {
            this.fireHidePanRequested(null);
        } else {
            this.fireShowPanRequested(null);
        }
        this.getCanvas().relayout();
        this.getCanvas().repaint();
    }

    /*
     * Unable to fully structure code
     */
    public void noZoom() {
        if (this.zoomStack.size() != 0) ** GOTO lbl16
        this.fireHidePanRequested(null);
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = (ZoomSpec)this.zoomStack.get(this.zoomStack.size() - 1);
            this.zoomStack.remove(this.zoomStack.size() - 1);
            var2_2 = var1_1.list.size();
            var3_3 = 0;
            while (var3_3 < var2_2) {
                var4_4 = (Restore)var1_1.list.get(var3_3);
                var4_4.axis.setAxisMin(var4_4.min);
                var4_4.axis.setAxisMax(var4_4.max);
                var4_4.axis.doLayout();
                ++var3_3;
            }
lbl16:
            // 2 sources

            ** while (this.zoomStack.size() > 0)
        }
lbl17:
        // 1 sources

        this.fireHidePanRequested(null);
        this.getCanvas().relayout();
        this.getCanvas().repaint();
    }

    public void panLeft() {
        if (!this.isZoomed(BAxisDimension.x)) {
            return;
        }
        BChartCanvas bChartCanvas = this.getCanvas();
        double d = bChartCanvas.getWidth();
        double d2 = d / 10.0;
        double d3 = -d2;
        double d4 = d3 + d;
        BAxis[] bAxisArray = this.getAxes(BAxisDimension.x);
        int n = bAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            BAxis bAxis = bAxisArray[n2];
            if (bAxis.isZoomEnabled()) {
                Object object = bAxis.fromDisplaySpace(d3 += bAxis.getMinMargin());
                Object object2 = bAxis.fromDisplaySpace(d4 -= bAxis.getMaxMargin());
                bAxis.setAxisMin(object);
                bAxis.setAxisMax(object2);
                bAxis.doLayout();
            }
            ++n2;
        }
        this.getCanvas().relayout();
        this.repaint();
    }

    public void panRight() {
        double d;
        if (!this.isZoomed(BAxisDimension.x)) {
            return;
        }
        BChartCanvas bChartCanvas = this.getCanvas();
        double d2 = bChartCanvas.getWidth();
        double d3 = d = d2 / 10.0;
        double d4 = d3 + d2;
        BAxis[] bAxisArray = this.getAxes(BAxisDimension.x);
        int n = bAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            BAxis bAxis = bAxisArray[n2];
            if (bAxis.isZoomEnabled()) {
                Object object = bAxis.fromDisplaySpace(d3 += bAxis.getMinMargin());
                Object object2 = bAxis.fromDisplaySpace(d4 -= bAxis.getMaxMargin());
                bAxis.setAxisMin(object);
                bAxis.setAxisMax(object2);
                bAxis.doLayout();
            }
            ++n2;
        }
        this.getCanvas().relayout();
        this.repaint();
    }

    public void panUp() {
        if (!this.isZoomed(BAxisDimension.y)) {
            return;
        }
        BChartCanvas bChartCanvas = this.getCanvas();
        double d = bChartCanvas.getHeight();
        double d2 = d / 10.0;
        double d3 = d - d2;
        double d4 = d3 - d;
        BAxis[] bAxisArray = this.getAxes(BAxisDimension.y);
        int n = bAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            BAxis bAxis = bAxisArray[n2];
            if (bAxis.isZoomEnabled()) {
                Object object;
                Object object2;
                if (bAxis instanceof BNumericAxis) {
                    double d5 = ((BDouble)bAxis.getAxisMin()).getDouble();
                    double d6 = ((BDouble)bAxis.getAxisMax()).getDouble();
                    object2 = bAxis.fromDisplaySpace(d3);
                    object = BDouble.make((double)(((BDouble)object2).getDouble() + (d6 - d5)));
                } else {
                    object2 = bAxis.fromDisplaySpace(d3);
                    object = bAxis.fromDisplaySpace(d4);
                }
                bAxis.setAxisMin(object2);
                bAxis.setAxisMax(object);
                bAxis.doLayout();
            }
            ++n2;
        }
        this.getCanvas().relayout();
        this.repaint();
    }

    public void panDown() {
        if (!this.isZoomed(BAxisDimension.y)) {
            return;
        }
        BChartCanvas bChartCanvas = this.getCanvas();
        double d = bChartCanvas.getHeight();
        double d2 = d / 10.0;
        double d3 = d + d2;
        double d4 = d3 - d;
        BAxis[] bAxisArray = this.getAxes(BAxisDimension.y);
        int n = bAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            BAxis bAxis = bAxisArray[n2];
            if (bAxis.isZoomEnabled()) {
                Object object;
                Object object2;
                if (bAxis instanceof BNumericAxis) {
                    double d5 = ((BDouble)bAxis.getAxisMin()).getDouble();
                    double d6 = ((BDouble)bAxis.getAxisMax()).getDouble();
                    object2 = bAxis.fromDisplaySpace(d3);
                    object = BDouble.make((double)(((BDouble)object2).getDouble() + (d6 - d5)));
                } else {
                    object2 = bAxis.fromDisplaySpace(d3);
                    object = bAxis.fromDisplaySpace(d4);
                }
                bAxis.setAxisMin(object2);
                bAxis.setAxisMax(object);
                bAxis.doLayout();
            }
            ++n2;
        }
        this.getCanvas().relayout();
        this.repaint();
    }

    public BWidget childAt(Point point) {
        BChartCanvas bChartCanvas = this.getCanvas();
        if (bChartCanvas.contains(point.x - bChartCanvas.getX(), point.y - bChartCanvas.getY())) {
            return this.getCanvas();
        }
        return super.childAt(point);
    }

    public void computePreferredSize() {
        BChartHeader bChartHeader = this.getHeader();
        bChartHeader.computePreferredSize();
        this.setPreferredSize(Math.max(300.0, bChartHeader.getPreferredWidth()), 300.0);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void refresh() {
        var1_1 = this.getProperties();
        ((BAxisContainer)this.getLeftAxes()).reset();
        ((BAxisContainer)this.getBottomAxes()).reset();
        ((BAxisContainer)this.getRightAxes()).reset();
        ((BAxisContainer)this.getTopAxes()).reset();
        if (true) ** GOTO lbl11
        do {
            var2_2 = (BChart)var1_1.get();
            var2_2.updateAxes();
            var2_2.relayout();
lbl11:
            // 2 sources

            if ((v0 = BChartPane.class$javax$baja$chart$BChart) != null) continue;
            v0 = BChartPane.class("[Ljavax.baja.chart.BChart;", false);
        } while (var1_1.next(v0));
        this.getCanvas().relayout();
        this.repaint();
    }

    public void animate() {
        super.animate();
        if (this.buildRequired) {
            if (this.rebuildCountDown == 0) {
                this.buildRequired = false;
                this.build();
                this.relayout();
            } else {
                --this.rebuildCountDown;
            }
        }
    }

    public void rebuild() {
        this.buildRequired = true;
        this.rebuildCountDown = 1;
    }

    public synchronized void build() {
        BAxisContainer bAxisContainer = (BAxisContainer)this.getLeftAxes();
        BAxisContainer bAxisContainer2 = (BAxisContainer)this.getRightAxes();
        BAxisContainer bAxisContainer3 = (BAxisContainer)this.getTopAxes();
        BAxisContainer bAxisContainer4 = (BAxisContainer)this.getBottomAxes();
        bAxisContainer.removeAllAxes();
        bAxisContainer2.removeAllAxes();
        bAxisContainer3.removeAllAxes();
        bAxisContainer4.removeAllAxes();
        BChart[] bChartArray = this.getCharts();
        int n = bChartArray.length;
        ArrayList arrayList = new ArrayList(n);
        ArrayList arrayList2 = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            bChartArray[n2].updateAxes();
            boolean bl = bChartArray[n2].usesXAxis();
            boolean bl2 = bChartArray[n2].usesYAxis();
            ChartModel chartModel = bChartArray[n2].getModel();
            int n3 = chartModel.getSpecCount();
            int n4 = 0;
            while (n4 < n3) {
                BAxis bAxis;
                ChartSpec chartSpec = chartModel.getSpec(n4);
                this.assignColors(chartSpec);
                BAxis bAxis2 = bl ? chartSpec.getXAxis() : null;
                BAxis bAxis3 = bAxis = bl2 ? chartSpec.getYAxis() : null;
                if (bAxis2 != null && !this.alreadyAdded(bAxis2)) {
                    if (bAxisContainer4.getAxisCount() == 0) {
                        bAxisContainer4.addAxis(bAxis2);
                    } else if (bAxisContainer3.getAxisCount() == 0) {
                        bAxisContainer3.addAxis(bAxis2);
                    } else {
                        bAxisContainer4.addAxis(bAxis2);
                    }
                }
                if (bAxis != null && !this.alreadyAdded(bAxis)) {
                    if (bAxisContainer.getAxisCount() == 0) {
                        bAxisContainer.addAxis(bAxis);
                    } else {
                        bAxisContainer2.addAxis(bAxis);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        this.getCanvas().build();
    }

    private final boolean alreadyAdded(BAxis bAxis) {
        boolean bl = false;
        if (((BAxisContainer)this.getLeftAxes()).contains(bAxis) || ((BAxisContainer)this.getBottomAxes()).contains(bAxis) || ((BAxisContainer)this.getRightAxes()).contains(bAxis) || ((BAxisContainer)this.getTopAxes()).contains(bAxis)) {
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public BAxis findAxis(BAxis var1_1) {
        var2_2 = this.getProperties();
        if (true) ** GOTO lbl6
        do {
            if ((var3_3 = ((BChart)var2_2.get()).getModel().findAxis(var1_1)) != null) {
                return var3_3;
            }
lbl6:
            // 3 sources

            if ((v0 = BChartPane.class$javax$baja$chart$BChart) != null) continue;
            v0 = BChartPane.class("[Ljavax.baja.chart.BChart;", false);
        } while (var2_2.next(v0));
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void doLayout(BWidget[] var1_1) {
        var2_2 = this.getWidth();
        var4_3 = this.getHeight();
        var6_4 = 0.0;
        var8_5 = 0.0;
        if (this.panControl != null && this.zoomed) {
            this.panPane.computePreferredSize();
            var6_4 = this.panPane.getPreferredHeight();
            var8_5 = this.panPane.getPreferredWidth();
        }
        var10_6 = this.getHeader();
        var10_6.computePreferredSize();
        var11_7 = (BAxisContainer)this.getLeftAxes();
        var12_8 = (BAxisContainer)this.getRightAxes();
        var13_9 = (BAxisContainer)this.getTopAxes();
        var14_10 = (BAxisContainer)this.getBottomAxes();
        var11_7.computePreferredSize();
        var12_8.computePreferredSize();
        var13_9.computePreferredSize();
        var14_10.computePreferredSize();
        var15_11 = this.getLegend();
        var16_12 = Math.max((double)5, var11_7.getPreferredWidth());
        var18_13 = Math.max((double)5, var12_8.getPreferredWidth());
        var20_14 = var15_11.getPreferredHeight(var2_2 - (var16_12 + var18_13) - 16.0);
        var22_15 = var14_10.getPreferredHeight() + var20_14;
        if (var20_14 > 0.0) {
            var22_15 += 8.0;
        }
        if (var14_10.getPreferredHeight() == 0.0) {
            var22_15 += 8.0;
        }
        var24_16 = var6_4 + var10_6.getPreferredHeight() + var13_9.getPreferredHeight();
        var11_7.setBounds(0.0, 0.0, var16_12, var4_3);
        var11_7.setRange(var24_16, var4_3 - (var24_16 + var22_15));
        var11_7.doLayout(var11_7.getChildWidgets());
        var12_8.setBounds(var2_2 - var18_13, 0.0, var18_13, var4_3);
        var12_8.setRange(var24_16, var4_3 - (var24_16 + var22_15));
        var12_8.doLayout(var12_8.getChildWidgets());
        var13_9.setBounds(0.0, var10_6.getPreferredHeight(), var2_2, var13_9.getPreferredHeight());
        var13_9.setRange(var16_12, var2_2 - (var16_12 + var18_13));
        var13_9.doLayout(var13_9.getChildWidgets());
        var14_10.setBounds(0.0, var4_3 - var22_15, var2_2, var14_10.getPreferredHeight());
        var14_10.setRange(var16_12, var2_2 - (var16_12 + var18_13));
        var14_10.doLayout(var14_10.getChildWidgets());
        var15_11.setBounds(var16_12 + 8.0, var4_3 - var20_14 - 8.0, var2_2 - (var16_12 + var18_13) - 16.0, var20_14);
        if (this.panControl != null) {
            this.panPane.setBounds(0.0, 0.0, var2_2, var6_4);
            this.panPane.doLayout(this.panPane.getChildWidgets());
        }
        var10_6.setBounds(var16_12 + 8.0, 0.0 + var6_4, var2_2 - (var18_13 + var16_12) - 16.0, var10_6.getPreferredHeight());
        this.getCanvas().setBounds(var16_12, var24_16, var2_2 - (var18_13 + var16_12), var4_3 - (var24_16 + var22_15));
        var26_17 = this.getProperties();
        if (true) ** GOTO lbl52
        do {
            var27_18 = (BChart)var26_17.get();
            var27_18.setBounds(var16_12, var24_16, var2_2 - (var18_13 + var16_12), var4_3 - (var24_16 + var22_15));
lbl52:
            // 2 sources

            if ((v0 = BChartPane.class$javax$baja$chart$BChart) != null) continue;
            v0 = BChartPane.class("[Ljavax.baja.chart.BChart;", false);
        } while (var26_17.next(v0));
    }

    public synchronized void paint(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        graphics.setBrush(this.getBackground());
        graphics.fillRect(0.0, 0.0, d, d2);
        BChartCanvas bChartCanvas = this.getCanvas();
        if (bChartCanvas.getWidth() <= 0.0 || bChartCanvas.getHeight() <= 0.0) {
            graphics.setBrush(BColor.black);
            graphics.setFont(font);
            String string = Lexicon.make((String)"chart").getText("insufficientArea");
            graphics.drawString(string, (this.getWidth() - font.width(string)) / (double)2, (this.getHeight() - font.getHeight()) / (double)2);
        }
        if (this.panControl != null) {
            this.paintChild(graphics, (BWidget)this.panPane);
        }
        this.paintChild(graphics, this.getHeader());
        this.paintChild(graphics, this.getLeftAxes());
        this.paintChild(graphics, this.getBottomAxes());
        this.paintChild(graphics, this.getRightAxes());
        this.paintChild(graphics, this.getTopAxes());
        this.paintChild(graphics, this.getCanvas());
        this.paintChild(graphics, this.getLegend());
        this.getBorder().paint(graphics, 1.0, 1.0, this.getWidth() - (double)2, this.getHeight() - (double)2);
    }

    private final void assignColors(ChartSpec chartSpec) {
        Series[] seriesArray = this.getAllSeries();
        int n = 0;
        while (n < seriesArray.length) {
            Series series = seriesArray[n];
            BBrush bBrush = series.getBrush();
            BColor bColor = null;
            if (bBrush != null && !bBrush.isNull()) {
                return;
            }
            boolean bl = false;
            int n2 = 0;
            while (n2 < DEFAULT_COLORS.length) {
                bColor = DEFAULT_COLORS[n2];
                bl = false;
                int n3 = 0;
                while (n3 < seriesArray.length) {
                    BBrush.Paint paint;
                    BBrush bBrush2 = seriesArray[n3].getBrush();
                    if (bBrush2 != null && (paint = bBrush2.getPaint()) instanceof BBrush.Solid && ((BBrush.Solid)paint).getColor().equals((Object)bColor)) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) break;
                ++n2;
            }
            if (bl) {
                bColor = BColor.black;
            }
            series.setBrush(bColor.toBrush());
            ++n;
        }
    }

    public BITable export() {
        BChart[] bChartArray = this.getCharts();
        return bChartArray.length == 0 ? null : bChartArray[0].getModel().export();
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.controller.mousePressed(bMouseEvent);
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.controller.mouseReleased(bMouseEvent);
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.controller.mouseEntered(bMouseEvent);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.controller.mouseExited(bMouseEvent);
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        this.controller.mouseMoved(bMouseEvent);
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        this.controller.mouseDragged(bMouseEvent);
    }

    public void mouseWheel(BMouseEvent bMouseEvent) {
        this.controller.mouseWheel(bMouseEvent);
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        this.controller.mousePulsed(bMouseEvent);
    }

    public void mouseHover(BMouseEvent bMouseEvent) {
        this.controller.mouseHover(bMouseEvent);
    }

    public void added(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.getType().is(BChart.TYPE)) {
            this.build();
            this.doLayout(null);
        }
    }

    public void prepare() {
        BChart[] bChartArray = this.getCharts();
        int n = 0;
        while (n < bChartArray.length) {
            ChartModel chartModel = bChartArray[n].getModel();
            if (chartModel instanceof BoundChartModel) {
                ((BoundChartModel)chartModel).doSyncBindings();
            }
            ++n;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.rebuildCountDown = 0;
        this.buildRequired = false;
        this.zoomStack = new ArrayList();
        this.panControl = null;
        this.zoomed = false;
    }

    public BChartPane() {
        this.this();
        this.setController(new ChartController());
    }

    public BChartPane(BChart bChart) {
        this.this();
        this.setController(new ChartController());
        this.add(null, (BValue)bChart);
    }

    static {
        Class clazz = class$javax$baja$chart$BChartPane;
        if (clazz == null) {
            clazz = class$javax$baja$chart$BChartPane = BChartPane.class("[Ljavax.baja.chart.BChartPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"chart");
        font = BFont.make((String)lex.getText("chart.pane.font"));
        DEFAULT_COLORS = new BColor[]{BColor.make((int)3882693), BColor.make((int)11808816), BColor.make((int)0x2AA22A), BColor.make((int)9468084), BColor.make((int)13866541), BColor.make((int)4959430), BColor.make((int)10337121), BColor.make((int)4547207), BColor.make((int)0x800000), BColor.make((int)3703188), BColor.make((int)6311032), BColor.make((int)128)};
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ZoomSpec {
        BAxisDimension dim;
        ArrayList list;

        public boolean isEmpty() {
            boolean bl = false;
            if (this.list.size() == 0) {
                bl = true;
            }
            return bl;
        }

        public void add(BAxis bAxis, Object object, Object object2) {
            this.list.add(new Restore(bAxis, object, object2));
        }

        private final /* synthetic */ void this() {
            this.list = new ArrayList();
        }

        public ZoomSpec(BAxisDimension bAxisDimension) {
            this.this();
            this.dim = bAxisDimension;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Restore {
        BAxis axis;
        Object min;
        Object max;

        public Restore(BAxis bAxis, Object object, Object object2) {
            this.axis = bAxis;
            this.min = object;
            this.max = object2;
        }
    }
}

