/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import javax.baja.agent.AgentList;
import javax.baja.chart.BAxis;
import javax.baja.chart.BChartPane;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartModelEvent;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.JoinTable;
import javax.baja.chart.Series;
import javax.baja.chart.binding.BoundChartModel;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BChart
extends BWidget {
    public static final Type TYPE;
    private static Lexicon lex;
    private static final BFont errFont;
    private boolean syncRequired;
    private int syncCountDown;
    private ChartModel model;
    static /* synthetic */ Class class$javax$baja$chart$BChart;

    public Type getType() {
        return TYPE;
    }

    public BChartPane getPane() {
        try {
            return (BChartPane)this.getParent();
        }
        catch (Exception exception) {
            throw new IllegalStateException("ChartPane parent required.");
        }
    }

    public void setModel(ChartModel chartModel) {
        this.installSupport(this.model, chartModel);
        this.model = chartModel;
        this.rebuild();
        this.relayout();
    }

    public ChartModel getModel() {
        return this.model;
    }

    public void modelModified(ChartModelEvent chartModelEvent) {
        BChartPane bChartPane = this.getPane();
        if (bChartPane == null) {
            return;
        }
        int n = chartModelEvent.getId();
        if (n == 3) {
            if (bChartPane != null) {
                bChartPane.refresh();
            }
        } else {
            this.rebuild();
        }
    }

    public boolean usesXAxis() {
        return true;
    }

    public boolean usesYAxis() {
        return true;
    }

    public void bindingsChanged() {
    }

    public void added(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.getType().is(BBinding.TYPE) && this.model instanceof BoundChartModel) {
            ((BoundChartModel)this.model).syncBindings();
        }
    }

    public void removed(Property property, BValue bValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (bValue instanceof BBinding && this.model instanceof BoundChartModel) {
            ((BoundChartModel)this.model).syncBindings();
        }
    }

    public void syncBindings() {
        this.syncRequired = true;
        this.syncCountDown = 1;
    }

    public void animate() {
        if (this.syncRequired) {
            if (this.syncCountDown == 0) {
                this.syncRequired = false;
                if (this.model instanceof BoundChartModel) {
                    ((BoundChartModel)this.model).doSyncBindings();
                    this.relayout();
                }
            } else {
                --this.syncCountDown;
            }
        }
    }

    private final void installSupport(ChartSupport chartSupport, ChartSupport chartSupport2) {
        if (chartSupport2 == null) {
            throw new NullPointerException();
        }
        if (chartSupport == chartSupport2) {
            return;
        }
        if (chartSupport2.chart != null) {
            throw new IllegalArgumentException("Already installed on another chart.");
        }
        if (chartSupport != null) {
            chartSupport.setChart(null);
        }
        chartSupport2.setChart(this);
    }

    public void computePreferredSize() {
        this.setPreferredSize(300.0, 300.0);
    }

    public void rebuild() {
        BChartPane bChartPane = this.getPane();
        if (bChartPane != null) {
            bChartPane.rebuild();
        }
    }

    public final void paint(Graphics graphics) {
        BWidget bWidget = (BWidget)this.getParent();
        if (bWidget == null || !(bWidget instanceof BChartPane)) {
            graphics.setFont(errFont);
            graphics.setBrush(BColor.black.toBrush());
            graphics.drawString(((Object)((Object)this)).getClass().getName() + ": ChartPane required.", (double)5, errFont.getHeight());
        } else {
            this.doPaint(graphics);
        }
    }

    public void doPaint(Graphics graphics) {
    }

    public void updateAxes() {
        int n = this.model.getSpecCount();
        int n2 = 0;
        while (n2 < n) {
            BAxis bAxis;
            ChartSpec chartSpec = this.model.getSpec(n2);
            Series series = chartSpec.getSeries();
            BAxis bAxis2 = this.usesXAxis() ? chartSpec.getXAxis() : null;
            BAxis bAxis3 = bAxis = this.usesYAxis() ? chartSpec.getYAxis() : null;
            if (bAxis2 != null || bAxis != null) {
                Object object;
                if (bAxis2 != null) {
                    bAxis2.updateFacets(series.getColumnFacets(0));
                    if (bAxis2.isMinAuto() && (object = series.getMin(0)) != null) {
                        bAxis2.updateAutoMin(object);
                    }
                    if (bAxis2.isMaxAuto() && (object = series.getMax(0)) != null) {
                        bAxis2.updateAutoMax(object);
                    }
                }
                if (bAxis != null) {
                    bAxis.updateSeries(series);
                    bAxis.updateFacets(series.getColumnFacets(1));
                    if (bAxis.isMinAuto() && (object = series.getMin(1)) != null) {
                        bAxis.updateAutoMin(object);
                    }
                    if (bAxis.isMaxAuto() && (object = series.getMax(1)) != null) {
                        bAxis.updateAutoMax(object);
                    }
                }
            }
            ++n2;
        }
    }

    public JoinTable join(int n) {
        Series[] seriesArray = this.model.getAllSeries();
        return JoinTable.make(seriesArray, n);
    }

    public boolean receiveInputEvents() {
        return false;
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.toTop("chart:ValueChartBinding");
        return agentList;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.syncRequired = false;
        this.syncCountDown = 0;
    }

    public BChart() {
        this.this();
        this.setModel(new BoundChartModel());
    }

    public BChart(ChartModel chartModel) {
        this.this();
        this.setModel(chartModel);
    }

    static {
        Class clazz = class$javax$baja$chart$BChart;
        if (clazz == null) {
            clazz = class$javax$baja$chart$BChart = BChart.class("[Ljavax.baja.chart.BChart;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"chart");
        errFont = BFont.make((String)lex.getText("chart.err.font"));
    }

    public static abstract class ChartSupport {
        public BChart chart;

        public final BChart getChart() {
            return this.chart;
        }

        public final void setChart(BChart bChart) {
            this.chart = bChart;
        }

        public ChartModel getModel() {
            return this.chart.model;
        }
    }
}

