/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import java.util.ArrayList;
import javax.baja.agent.BIAgent;
import javax.baja.chart.AxisRenderer;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BAxisLocation;
import javax.baja.chart.DefaultAxisRenderer;
import javax.baja.chart.Series;
import javax.baja.log.Log;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BAxis
extends BObject
implements BIAgent {
    public static final Type TYPE;
    public static final Log log;
    public static final double DEFAULT_MARGIN_SIZE = 5.0;
    private static AxisRenderer defRenderer;
    private Context context;
    private AxisRenderer renderer;
    private BAxisDimension dim;
    private BAxisLocation loc;
    private String title;
    private double prefWidth;
    private double prefHeight;
    private double x;
    private double y;
    private double w;
    private double h;
    private boolean showSwatches;
    private boolean minAuto;
    private boolean maxAuto;
    private double minMargin;
    private double maxMargin;
    private BFacets facets;
    private String unitText;
    private ArrayList units;
    private ArrayList series;
    static /* synthetic */ Class class$javax$baja$chart$BAxis;

    public abstract Type getValueType();

    public BAxisDimension getDimension() {
        return this.dim;
    }

    public void setDimension(BAxisDimension bAxisDimension) {
        this.dim = bAxisDimension;
    }

    public BAxisLocation getLocation() {
        return this.loc;
    }

    public void setLocation(BAxisLocation bAxisLocation) {
        this.loc = bAxisLocation;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    private final void addUnit(String string) {
        if (this.units.contains(string)) {
            return;
        }
        this.units.add(string);
        this.unitText = null;
    }

    private final void clearUnits() {
        this.units.clear();
        this.unitText = null;
    }

    public String getUnitLabel() {
        if (this.unitText == null) {
            int n = this.units.size();
            if (n == 0) {
                this.unitText = "";
            } else if (n == 1) {
                this.unitText = (String)this.units.get(0);
            } else {
                StringBuffer stringBuffer = new StringBuffer(12);
                int n2 = 0;
                while (n2 < n) {
                    if (n2 != 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append((String)this.units.get(n2));
                    ++n2;
                }
                this.unitText = stringBuffer.toString();
            }
        }
        return this.unitText;
    }

    public void setShowSwatches(boolean bl) {
        this.showSwatches = bl;
    }

    public boolean getShowSwatches() {
        return this.showSwatches;
    }

    public void computePreferredSize() {
        if (this.dim == BAxisDimension.x) {
            this.setPreferredSize(100.0, this.getRenderer().getPreferredAxisWidth(this));
        } else if (this.dim == BAxisDimension.y) {
            this.setPreferredSize(this.getRenderer().getPreferredAxisWidth(this), 100.0);
        }
    }

    protected void setPreferredSize(double d, double d2) {
        this.prefWidth = d;
        this.prefHeight = d2;
    }

    public double getPreferredWidth() {
        return this.prefWidth;
    }

    public double getPreferredHeight() {
        return this.prefHeight;
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.w = d3;
        this.h = d4;
    }

    public void doLayout() {
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.w;
    }

    public double getHeight() {
        return this.h;
    }

    public double getLength() {
        if (this.dim == BAxisDimension.x) {
            return this.w - this.getMinMargin() - this.getMaxMargin();
        }
        if (this.dim == BAxisDimension.y) {
            return this.h - this.getMinMargin() - this.getMaxMargin();
        }
        return 0.0;
    }

    public double getFullLength() {
        if (this.dim == BAxisDimension.x) {
            return this.w;
        }
        if (this.dim == BAxisDimension.y) {
            return this.h;
        }
        return 0.0;
    }

    public void setMinAuto(boolean bl) {
        this.minAuto = bl;
    }

    public boolean isMinAuto() {
        return this.minAuto;
    }

    public void updateAutoMin(Object object) {
    }

    public abstract Object getAxisMin();

    public abstract void setAxisMin(Object var1);

    public double getMinMargin() {
        return this.minMargin;
    }

    public void setMinMargin(double d) {
        this.minMargin = d;
    }

    public void setMaxAuto(boolean bl) {
        this.maxAuto = bl;
    }

    public boolean isMaxAuto() {
        return this.maxAuto;
    }

    public void updateAutoMax(Object object) {
    }

    public abstract Object getAxisMax();

    public abstract void setAxisMax(Object var1);

    public double getMaxMargin() {
        return this.maxMargin;
    }

    public void setMaxMargin(double d) {
        this.maxMargin = d;
    }

    public void reset() {
    }

    public BFacets updateFacets(BFacets bFacets) {
        if (bFacets == null) {
            return this.facets;
        }
        this.facets = BFacets.make((BFacets)this.facets, (BFacets)bFacets);
        BUnit bUnit = (BUnit)bFacets.getFacet("units");
        if (bUnit != null && !bUnit.isNull()) {
            this.addUnit(bUnit.getSymbol());
        }
        return this.facets;
    }

    public BFacets getFacets() {
        return this.facets;
    }

    public void updateSeries(Series series) {
        if (!this.series.contains(series)) {
            this.series.add(series);
        }
    }

    public Series[] getSeries() {
        return this.series.toArray(new Series[this.series.size()]);
    }

    public boolean isZoomEnabled() {
        return true;
    }

    public boolean validateZoom(Object object, Object object2) {
        return this.isZoomEnabled();
    }

    public abstract Object[] getTickValues();

    public abstract String valueToString(Object var1);

    public abstract double toDisplaySpace(Object var1);

    public abstract Object fromDisplaySpace(double var1);

    public static AxisRenderer getDefaultRenderer() {
        return defRenderer;
    }

    public static void setDefaultRenderer(AxisRenderer axisRenderer) {
        if (axisRenderer == null) {
            throw new NullPointerException();
        }
        defRenderer = axisRenderer;
    }

    public void setRenderer(AxisRenderer axisRenderer) {
        this.renderer = axisRenderer;
    }

    public AxisRenderer getRenderer() {
        if (this.renderer == null) {
            return defRenderer;
        }
        return this.renderer;
    }

    public boolean isCompatible(BAxis bAxis) {
        if (!((Object)((Object)bAxis)).getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        if (bAxis.dim != this.dim) {
            return false;
        }
        if (!bAxis.getRenderer().equals(this.getRenderer())) {
            return false;
        }
        BObject bObject = this.facets.get("precision");
        BObject bObject2 = bAxis.facets.get("precision");
        if (bObject == null && bObject2 != null) {
            return false;
        }
        if (bObject2 == null && bObject != null) {
            return false;
        }
        if (bObject2 != null && bObject != null && !bObject2.equals((Object)bObject)) {
            return false;
        }
        String string = bAxis.getTitle();
        String string2 = this.getTitle();
        if (string == null && string2 != null) {
            return false;
        }
        if (string2 == null && string != null) {
            return false;
        }
        if (string != null && string2 != null && !string.equals(string2)) {
            return false;
        }
        String string3 = bAxis.getUnitLabel();
        String string4 = this.getUnitLabel();
        if (string3 == null && string4 != null) {
            return false;
        }
        if (string4 == null && string3 != null) {
            return false;
        }
        if (string3 != null && string4 != null && !string3.equals(string4)) {
            return false;
        }
        Object object = this.getAxisMin();
        Object object2 = this.getAxisMax();
        Object object3 = bAxis.getAxisMin();
        Object object4 = bAxis.getAxisMax();
        if (object == null || object3 == null || object2 == null || object4 == null) {
            return false;
        }
        if (this.isMinAuto() && !bAxis.isMinAuto() || !this.isMinAuto() && bAxis.isMinAuto()) {
            return false;
        }
        if (!(this.isMinAuto() || bAxis.isMinAuto() || object.equals(object3))) {
            return false;
        }
        if (this.isMaxAuto() && !bAxis.isMaxAuto() || !this.isMaxAuto() && bAxis.isMaxAuto()) {
            return false;
        }
        return this.isMaxAuto() || bAxis.isMaxAuto() || object2.equals(object4);
    }

    public boolean equals(Object object) {
        if (!object.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        BAxis bAxis = (BAxis)((Object)object);
        if (bAxis.dim != this.dim) {
            return false;
        }
        if (!bAxis.facets.equals((Object)this.facets)) {
            return false;
        }
        if (bAxis.isMinAuto() != this.isMinAuto()) {
            return false;
        }
        if (!this.isMinAuto() && !bAxis.getAxisMin().equals(this.getAxisMin())) {
            return false;
        }
        if (bAxis.isMaxAuto() != this.isMaxAuto()) {
            return false;
        }
        if (!this.isMaxAuto() && !bAxis.getAxisMax().equals(this.getAxisMax())) {
            return false;
        }
        if (!bAxis.getRenderer().equals(this.getRenderer())) {
            return false;
        }
        String string = bAxis.getTitle();
        String string2 = this.getTitle();
        if (string == null && string2 != null) {
            return false;
        }
        if (string2 == null && string != null) {
            return false;
        }
        if (string != null && string2 != null && !string.equals(string2)) {
            return false;
        }
        String string3 = bAxis.getUnitLabel();
        String string4 = this.getUnitLabel();
        if (string3 == null && string4 != null) {
            return false;
        }
        if (string4 == null && string3 != null) {
            return false;
        }
        return string3 == null || string4 == null || string3.equals(string4);
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.showSwatches = true;
        this.minAuto = true;
        this.maxAuto = true;
        this.minMargin = 5;
        this.maxMargin = 5;
        this.facets = BFacets.NULL;
        this.units = new ArrayList();
        this.series = new ArrayList();
    }

    public BAxis() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$chart$BAxis;
        if (clazz == null) {
            clazz = class$javax$baja$chart$BAxis = BAxis.class("[Ljavax.baja.chart.BAxis;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"chart.axis");
        defRenderer = new DefaultAxisRenderer();
    }
}

