/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import javax.baja.chart.BContinuousAxis;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAbsTimeAxis
extends BContinuousAxis {
    public static final Type TYPE;
    private static final BAbsTime ZERO;
    private BFacets timeFacets;
    private BFacets formatFacets;
    private BAbsTime min;
    private BAbsTime max;
    private boolean initMin;
    private boolean initMax;
    private BRelTime tickIncrement;
    private BAbsTime[] tickValues;
    private BTimeZone timeZone;
    static /* synthetic */ Class class$javax$baja$chart$BAbsTimeAxis;

    public BFacets updateFacets(BFacets bFacets) {
        BFacets bFacets2 = super.updateFacets(bFacets);
        this.setTimeZone((BTimeZone)bFacets2.get("TimeZone", (BObject)BTimeZone.getLocal()));
        return bFacets2;
    }

    public BTimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(BTimeZone bTimeZone) {
        this.timeZone = bTimeZone;
        this.timeFacets = super.updateFacets(null);
    }

    public Type getValueType() {
        return BAbsTime.TYPE;
    }

    public Object getAxisMin() {
        return this.min;
    }

    public void setAxisMin(Object object) {
        this.min = (BAbsTime)object;
    }

    public void updateAutoMin(Object object) {
        if (this.initMin) {
            this.min = (BAbsTime)object;
            this.initMin = false;
        } else if (((BAbsTime)object).isBefore(this.min)) {
            this.min = (BAbsTime)object;
        }
    }

    public Object getAxisMax() {
        return this.max;
    }

    public void setAxisMax(Object object) {
        this.max = (BAbsTime)object;
    }

    public void updateAutoMax(Object object) {
        if (this.initMax) {
            this.max = (BAbsTime)object;
            this.initMax = false;
        } else if (((BAbsTime)object).isAfter(this.max)) {
            this.max = (BAbsTime)object;
        }
    }

    public void reset() {
        this.initMax = true;
        this.initMin = true;
        this.max = BAbsTime.now();
        this.min = this.max.subtract(BRelTime.makeHours((int)1));
    }

    public double toPercentOfRange(Object object) {
        long l = ((BAbsTime)object).getMillis();
        long l2 = this.min.getMillis();
        long l3 = this.max.getMillis();
        return (double)(l - l2) / (double)(l3 - l2);
    }

    public Object fromPercentOfRange(double d) {
        long l = this.min.getMillis();
        long l2 = this.max.getMillis();
        long l3 = l + (long)((double)(l2 - l) * d);
        return BAbsTime.make((long)l3);
    }

    public Object getZero() {
        return ZERO;
    }

    public void doLayout() {
        BFacets bFacets;
        long l = this.max.getMillis();
        long l2 = this.min.getMillis();
        long l3 = l - l2;
        long l4 = this.computeTickIncrement(l3);
        int n = (int)(l3 / l4) + 1;
        while (n > 30) {
            n = (int)(l3 / (l4 *= (long)2)) + 1;
        }
        if (this.timeFacets.getFacet("timeFormat") == null) {
            bFacets = this.deltaToTimeFormat(l3);
            this.formatFacets = BFacets.make((BFacets)this.timeFacets, (BFacets)bFacets);
        } else {
            this.formatFacets = this.timeFacets;
        }
        bFacets = BRelTime.make((long)l4);
        if (n < 0) {
            n = 0;
        }
        this.tickValues = new BAbsTime[n];
        BAbsTime bAbsTime = this.min;
        int n2 = 0;
        while (n2 < n) {
            this.tickValues[n2] = bAbsTime;
            bAbsTime = bAbsTime.add((BRelTime)bFacets);
            ++n2;
        }
    }

    private final long computeTickIncrement(long l) {
        long l2 = 1L;
        l2 = l <= 1000L ? 1L : (l < 60000L ? 1000L : (l < 300000L ? 15000L : (l < 1800000L ? 60000L : (l < 3600000L ? 300000L : (l < 21600000L ? 900000L : (l <= 108000000L ? 3600000L : (l <= 3110400000L ? 86400000L : (l < 94608000000L ? 2592000000L : 31536000000L))))))));
        return l2;
    }

    private final BFacets deltaToTimeFormat(long l) {
        if (l < 10000L) {
            return BFacets.make((String)"timeFormat", (BIDataValue)BString.make((String)"D-MMM-YY h:mm:ss a z"), (String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
        }
        if (l < 3600000L) {
            return BFacets.make((String)"timeFormat", (BIDataValue)BString.make((String)"D-MMM-YY h:mm:ss a z"), (String)"showSeconds", (BIDataValue)BBoolean.TRUE);
        }
        if (l > 2592000000L) {
            return BFacets.make((String)"timeFormat", (BIDataValue)BString.make((String)"D-MMM-YY z"));
        }
        return BFacets.make((String)"timeFormat", (BIDataValue)BString.make((String)"D-MMM-YY h:mm a z"));
    }

    public Object[] getTickValues() {
        return this.tickValues;
    }

    public String valueToString(Object object) {
        BAbsTime bAbsTime = (BAbsTime)object;
        return bAbsTime.toString((Context)this.timeFacets);
    }

    public boolean validateZoom(Object object, Object object2) {
        long l = ((BAbsTime)object).getMillis();
        long l2 = ((BAbsTime)object2).getMillis();
        long l3 = l2 - l;
        if (l3 < 10L) {
            return false;
        }
        return super.validateZoom(object, object2);
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.min = ZERO;
        this.max = this.min.add(BRelTime.makeHours((int)1));
        this.initMin = true;
        this.initMax = true;
    }

    public BAbsTimeAxis() {
        this.this();
    }

    public BAbsTimeAxis(BTimeZone bTimeZone) {
        this.this();
        this.setTimeZone(bTimeZone);
    }

    static {
        Class clazz = class$javax$baja$chart$BAbsTimeAxis;
        if (clazz == null) {
            clazz = class$javax$baja$chart$BAbsTimeAxis = BAbsTimeAxis.class("[Ljavax.baja.chart.BAbsTimeAxis;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ZERO = BAbsTime.make((long)0L);
    }
}

