/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.ui;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BScrollEvent;
import javax.baja.ui.pane.BPane;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BReportPane
extends BPane {
    public static final Property logo = BReportPane.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Property pageNumber = BReportPane.newProperty((int)0, (boolean)true, null);
    public static final Property timestamp = BReportPane.newProperty((int)0, (boolean)true, null);
    public static final Property scrollBar = BReportPane.newProperty((int)7, (BValue)new BNullWidget(), null);
    public static final Action vscroll = BReportPane.newAction((int)0, (BValue)new BScrollEvent(), null);
    public static final Type TYPE;
    static Lexicon lex;
    private Point logoPos;
    private Point pageNumPos;
    private Point tstampPos;
    private BAbsTime tstamp;
    private double yoff;
    static /* synthetic */ Class class$com$tridium$report$ui$BReportPane;

    public BImage getLogo() {
        return (BImage)this.get(logo);
    }

    public void setLogo(BImage bImage) {
        this.set(logo, (BValue)bImage, null);
    }

    public boolean getPageNumber() {
        return this.getBoolean(pageNumber);
    }

    public void setPageNumber(boolean bl) {
        this.setBoolean(pageNumber, bl, null);
    }

    public boolean getTimestamp() {
        return this.getBoolean(timestamp);
    }

    public void setTimestamp(boolean bl) {
        this.setBoolean(timestamp, bl, null);
    }

    public BWidget getScrollBar() {
        return (BWidget)this.get(scrollBar);
    }

    public void setScrollBar(BWidget bWidget) {
        this.set(scrollBar, (BValue)bWidget, null);
    }

    public void vscroll(BScrollEvent bScrollEvent) {
        this.invoke(vscroll, (BValue)bScrollEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void computePreferredSize() {
        double d = 100.0;
        double d2 = this.getChromeHeight();
        BWidget[] bWidgetArray = this.getChildWidgets();
        int n = 0;
        while (n < bWidgetArray.length) {
            bWidgetArray[n].computePreferredSize();
            d = Math.max(d, bWidgetArray[n].getPreferredHeight());
            d2 += bWidgetArray[n].getPreferredHeight();
            ++n;
        }
        this.setPreferredSize(d, d2);
    }

    public double getChromeHeight() {
        double d = this.getPadding();
        double d2 = 18.0;
        double d3 = 0.0;
        double d4 = 0.0;
        BFont bFont = Theme.widget().getTextFont();
        double d5 = bFont.getAscent();
        double d6 = bFont.getDescent();
        double d7 = bFont.getHeight();
        if (!this.getLogo().isNull()) {
            d3 = this.getLogo().getHeight();
        }
        if (this.getPageNumber()) {
            d3 = Math.max(d3, d7);
        }
        if (this.getTimestamp()) {
            d4 = d7;
        }
        if (d3 > 0.0) {
            d3 += d2;
        }
        if (d4 > 0.0) {
            d4 += d2;
        }
        return d3 + d4;
    }

    public void doLayout(BWidget[] bWidgetArray) {
        String string;
        double d = this.getPadding();
        double d2 = 18.0;
        double d3 = this.getWidth();
        double d4 = this.getHeight();
        this.computePreferredSize();
        double d5 = this.getPreferredHeight();
        if (!this.getScrollBar().isNull()) {
            BScrollBar bScrollBar = (BScrollBar)this.getScrollBar();
            bScrollBar.computePreferredSize();
            double d6 = bScrollBar.getPreferredWidth();
            bScrollBar.setBounds(d3 - d6, 0.0, d6, d4);
            d3 -= d6;
            bScrollBar.setMin(0);
            bScrollBar.setMax((int)d5);
            bScrollBar.setExtent((int)Math.min(d5, d4));
            if ((double)bScrollBar.getPosition() > d5 - (double)bScrollBar.getExtent()) {
                this.yoff = d5 - (double)bScrollBar.getExtent();
                bScrollBar.setPosition((int)this.yoff);
            } else {
                this.yoff = bScrollBar.getPosition();
            }
        }
        double d7 = d;
        double d8 = d;
        double d9 = d4 - d * (double)2;
        double d10 = d3 - d * (double)2;
        double d11 = 0.0;
        double d12 = 0.0;
        BFont bFont = Theme.widget().getTextFont();
        double d13 = bFont.getAscent();
        double d14 = bFont.getDescent();
        double d15 = bFont.getHeight();
        if (!this.getLogo().isNull()) {
            d11 = this.getLogo().getHeight();
            this.logoPos.set(d, d);
        }
        if (this.getPageNumber()) {
            d11 = Math.max(d11, d15);
            string = this.getCurrentPageNumber();
            this.pageNumPos.set(d3 - d - bFont.width(string), d13 + d);
        }
        if (this.getTimestamp()) {
            d12 = d15;
            string = this.getCurrentTimestamp();
            double d16 = this.getScrollBar().isNull() ? d4 - d - d14 : d5 - d - d14;
            this.tstampPos.set(d3 - d - bFont.width(string), d16);
        }
        if (d11 > 0.0) {
            d8 += d11 + d2;
            d9 -= d11 + d2;
        }
        if (d12 > 0.0) {
            d9 -= d12 + d2;
        }
        this.layoutContent(d7, d8, d10, d9);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics graphics) {
        BFont bFont = Theme.widget().getTextFont();
        this.paintBackground(graphics);
        BWidget bWidget = this.getScrollBar();
        if (!bWidget.isNull()) {
            this.paintChild(graphics, bWidget);
        }
        graphics.push();
        try {
            graphics.translate(0.0, -this.yoff);
            if (!this.getLogo().isNull()) {
                graphics.drawImage(this.getLogo(), this.logoPos.x, this.logoPos.y);
            }
            if (this.getPageNumber()) {
                graphics.setFont(bFont);
                graphics.setBrush(BColor.black);
                graphics.drawString(this.getCurrentPageNumber(), this.pageNumPos.x, this.pageNumPos.y);
            }
            if (this.getTimestamp()) {
                graphics.setFont(bFont);
                graphics.setBrush(BColor.black);
                graphics.drawString(this.getCurrentTimestamp(), this.tstampPos.x, this.tstampPos.y);
            }
            BWidget[] bWidgetArray = this.getChildWidgets();
            int n = 0;
            while (n < bWidgetArray.length) {
                if (bWidgetArray[n] != bWidget) {
                    this.paintChild(graphics, bWidgetArray[n]);
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        graphics.pop();
        this.paintBorder(graphics);
    }

    public double getPadding() {
        return 36.0;
    }

    protected String getCurrentPageNumber() {
        return lex.getText("pageNumber");
    }

    protected String getCurrentTimestamp() {
        return this.tstamp.toString();
    }

    protected void paintBackground(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        graphics.setBrush(Theme.widget().getWindowBackground());
        graphics.fillRect(0.0, 0.0, d, d2);
    }

    protected void paintBorder(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        graphics.setBrush(BColor.black);
        graphics.strokeRect(0.0, 0.0, d - 1.0, d2 - 1.0);
    }

    protected void layoutContent(double d, double d2, double d3, double d4) {
        BWidget[] bWidgetArray = this.getChildWidgets();
        int n = 1;
        while (n < bWidgetArray.length) {
            BWidget bWidget = bWidgetArray[n];
            bWidget.computePreferredSize();
            double d5 = bWidget.getPreferredHeight();
            bWidget.setBounds(d, d2, d3, d5);
            d2 += d5;
            ++n;
        }
    }

    public BWidget childAt(Point point) {
        BScrollBar bScrollBar = (BScrollBar)this.getScrollBar();
        if (bScrollBar.contains(point.x - bScrollBar.getX(), point.y - bScrollBar.getY())) {
            return bScrollBar;
        }
        return super.childAt(new Point(point.x, point.y + this.yoff));
    }

    public Point translateToChild(BWidget bWidget, Point point) {
        if (bWidget != this.getScrollBar()) {
            point.translate(0.0, this.yoff);
        }
        return super.translateToChild(bWidget, point);
    }

    public void mouseWheel(BMouseWheelEvent bMouseWheelEvent) {
        BScrollBar bScrollBar = (BScrollBar)this.getScrollBar();
        int n = 25;
        if (bMouseWheelEvent.getWheelRotation() > 0) {
            int n2 = 0;
            while (n2 < n) {
                bScrollBar.incrementByUnit();
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                bScrollBar.decrementByUnit();
                ++n3;
            }
        }
        bMouseWheelEvent.consume();
    }

    public void doVscroll(BScrollEvent bScrollEvent) {
        this.yoff = bScrollEvent.getPosition();
        this.repaint();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.logoPos = new Point();
        this.pageNumPos = new Point();
        this.tstampPos = new Point();
        this.yoff = 0.0;
    }

    public BReportPane() {
        this.this();
        this.tstamp = BAbsTime.now();
        BScrollBar bScrollBar = new BScrollBar();
        this.linkTo((BComponent)bScrollBar, (Slot)BScrollBar.positionChanged, (Slot)vscroll);
        this.setScrollBar((BWidget)bScrollBar);
    }

    static {
        Class clazz = class$com$tridium$report$ui$BReportPane;
        if (clazz == null) {
            clazz = class$com$tridium$report$ui$BReportPane = BReportPane.class("[Lcom.tridium.report.ui.BReportPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"report");
    }
}

