/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.grid.ui;

import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.report.grid.GridModel;
import javax.baja.status.BIStatusValue;
import javax.baja.status.BStatus;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.util.BFormat;

public class GridUtil {
    public static String getString(GridModel gridModel, int n, int n2, Context context) {
        BObject bObject = gridModel.getObjectAt(n, n2);
        if (bObject == null) {
            return "-";
        }
        BFormat bFormat = gridModel.getColumnFormat(n2);
        return bFormat == null ? bObject.toString() : bFormat.format((Object)bObject, context);
    }

    public static String getSummary(GridModel gridModel, int n, int n2, BOrd bOrd, boolean bl, Context context) {
        BObject bObject = gridModel.getObjectAt(n, n2);
        String string = gridModel.getColumnName(n2) + " = " + (bObject == null ? "" : bObject.toString());
        if (!(bOrd.isNull() || bl && n2 != 0)) {
            bOrd = GridUtil.makeHyperlink(gridModel, n, bOrd);
            string = "Link to " + bOrd + " | " + string;
        }
        return string;
    }

    public static BOrd makeHyperlink(GridModel gridModel, int n, BOrd bOrd) {
        if (bOrd.isNull()) {
            return BOrd.NULL;
        }
        BObject bObject = gridModel.getObjectAt(n, 0);
        if (bObject.isComponent()) {
            BOrd bOrd2 = BOrd.make((String)("station:|" + bObject.asComponent().getSlotPath()));
            bOrd = BOrd.make((BOrd)bOrd2, (BOrd)bOrd).normalize();
        }
        return bOrd;
    }

    public static BBrush getStatusFg(BObject bObject) {
        if (bObject instanceof BIStatusValue) {
            BStatus bStatus = ((BIStatusValue)bObject).getStatusValue().getStatus();
            if (bStatus.isDisabled()) {
                return GridUtil.b(BStatus.disabledFg);
            }
            if (bStatus.isFault()) {
                return GridUtil.b(BStatus.faultFg);
            }
            if (bStatus.isDown()) {
                return GridUtil.b(BStatus.downFg);
            }
            if (bStatus.isAlarm()) {
                return GridUtil.b(BStatus.alarmFg);
            }
            if (bStatus.isStale()) {
                return GridUtil.b(BStatus.staleFg);
            }
            if (bStatus.isOverridden()) {
                return GridUtil.b(BStatus.overriddenFg);
            }
        }
        return null;
    }

    public static BBrush getStatusBg(BObject bObject) {
        if (bObject instanceof BIStatusValue) {
            BStatus bStatus = ((BIStatusValue)bObject).getStatusValue().getStatus();
            if (bStatus.isDisabled()) {
                return GridUtil.b(BStatus.disabledBg);
            }
            if (bStatus.isFault()) {
                return GridUtil.b(BStatus.faultBg);
            }
            if (bStatus.isDown()) {
                return GridUtil.b(BStatus.downBg);
            }
            if (bStatus.isAlarm()) {
                return GridUtil.b(BStatus.alarmBg);
            }
            if (bStatus.isStale()) {
                return GridUtil.b(BStatus.staleBg);
            }
            if (bStatus.isOverridden()) {
                return GridUtil.b(BStatus.overriddenBg);
            }
        }
        return null;
    }

    private static final BBrush b(BSimple bSimple) {
        return ((BColor)bSimple).toBrush();
    }
}

