/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.grid.ui;

import com.tridium.report.grid.ui.GridUtil;
import com.tridium.ui.theme.Theme;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.report.grid.BGrid;
import javax.baja.report.grid.GridModel;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BGridLabelPane
extends BWbComponentView {
    public static final Property headerFont = BGridLabelPane.newProperty((int)0, (BValue)Theme.widget().getBoldText(), null);
    public static final Property headerBrush = BGridLabelPane.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Property headerAlign = BGridLabelPane.newProperty((int)0, (BValue)BHalign.center, null);
    public static final Property cellFont = BGridLabelPane.newProperty((int)0, (BValue)Theme.widget().getTextFont(), null);
    public static final Property cellBrush = BGridLabelPane.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Property cellAlign = BGridLabelPane.newProperty((int)0, (BValue)BHalign.center, null);
    public static final Property firstColumnFont = BGridLabelPane.newProperty((int)0, (BValue)Theme.widget().getTextFont(), null);
    public static final Property firstColumnBrush = BGridLabelPane.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Property firstColumnAlign = BGridLabelPane.newProperty((int)0, (BValue)BHalign.left, null);
    public static final Property border = BGridLabelPane.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property hyperlink = BGridLabelPane.newProperty((int)0, (BValue)BOrd.make((String)"slot:"), (BFacets)BFacets.make((String)"chooseView", (BIDataValue)BBoolean.FALSE));
    public static final Type TYPE;
    public GridModel grid;
    private int colCount;
    private int rowCount;
    private int cw;
    private int ch;
    static /* synthetic */ Class class$com$tridium$report$grid$ui$BGridLabelPane;

    public BFont getHeaderFont() {
        return (BFont)this.get(headerFont);
    }

    public void setHeaderFont(BFont bFont) {
        this.set(headerFont, (BValue)bFont, null);
    }

    public BBrush getHeaderBrush() {
        return (BBrush)this.get(headerBrush);
    }

    public void setHeaderBrush(BBrush bBrush) {
        this.set(headerBrush, (BValue)bBrush, null);
    }

    public BHalign getHeaderAlign() {
        return (BHalign)this.get(headerAlign);
    }

    public void setHeaderAlign(BHalign bHalign) {
        this.set(headerAlign, (BValue)bHalign, null);
    }

    public BFont getCellFont() {
        return (BFont)this.get(cellFont);
    }

    public void setCellFont(BFont bFont) {
        this.set(cellFont, (BValue)bFont, null);
    }

    public BBrush getCellBrush() {
        return (BBrush)this.get(cellBrush);
    }

    public void setCellBrush(BBrush bBrush) {
        this.set(cellBrush, (BValue)bBrush, null);
    }

    public BHalign getCellAlign() {
        return (BHalign)this.get(cellAlign);
    }

    public void setCellAlign(BHalign bHalign) {
        this.set(cellAlign, (BValue)bHalign, null);
    }

    public BFont getFirstColumnFont() {
        return (BFont)this.get(firstColumnFont);
    }

    public void setFirstColumnFont(BFont bFont) {
        this.set(firstColumnFont, (BValue)bFont, null);
    }

    public BBrush getFirstColumnBrush() {
        return (BBrush)this.get(firstColumnBrush);
    }

    public void setFirstColumnBrush(BBrush bBrush) {
        this.set(firstColumnBrush, (BValue)bBrush, null);
    }

    public BHalign getFirstColumnAlign() {
        return (BHalign)this.get(firstColumnAlign);
    }

    public void setFirstColumnAlign(BHalign bHalign) {
        this.set(firstColumnAlign, (BValue)bHalign, null);
    }

    public BBrush getBorder() {
        return (BBrush)this.get(border);
    }

    public void setBorder(BBrush bBrush) {
        this.set(border, (BValue)bBrush, null);
    }

    public BOrd getHyperlink() {
        return (BOrd)this.get(hyperlink);
    }

    public void setHyperlink(BOrd bOrd) {
        this.set(hyperlink, (BValue)bOrd, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject bObject, Context context) {
        this.grid = ((BGrid)bObject).resolve(bObject, context);
        if (this.grid.getRowCount() == 0 || this.grid.getColumnCount() == 0) {
            String string = Lexicon.make((String)"report").getText("emptyGrid");
            this.setContent((BWidget)new BLabel(string));
        } else {
            BComponent[] bComponentArray = this.grid.getComponents();
            if (bComponentArray.length > 0) {
                this.registerForComponentEvents(bComponentArray, 0);
            }
            this.relayout();
        }
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (this.grid != null) {
            this.repaint();
        }
    }

    public void computePreferredSize() {
        if (this.grid == null) {
            this.setPreferredSize(100.0, 100.0);
            return;
        }
        int n = this.grid.getColumnCount();
        int n2 = this.grid.getRowCount();
        Context context = this.getCurrentContext();
        double d = 0.0;
        double d2 = this.getHeaderFont().getHeight();
        d2 += (double)n2 * (this.getCellFont().getHeight() + (double)5);
        double d3 = 0.0;
        int n3 = 0;
        while (n3 < n) {
            double d4 = this.getHeaderFont().width(this.grid.getColumnName(n3));
            int n4 = 0;
            while (n4 < n2) {
                String string = GridUtil.getString(this.grid, n4, n3, context);
                d4 = Math.max(d4, this.getCellFont().width(string));
                ++n4;
            }
            d3 = Math.max(d3, d4);
            ++n3;
        }
        d = d3 * (double)n + (double)(3 * (n - 1));
        this.setPreferredSize(d, d2);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        if (this.grid == null) {
            return;
        }
        double d = this.getWidth();
        double d2 = this.getHeight();
        this.colCount = this.grid.getColumnCount();
        this.rowCount = this.grid.getRowCount() + 1;
        this.cw = (int)(d / (double)this.colCount);
        this.ch = (int)(d2 / (double)this.rowCount);
    }

    public void paint(Graphics graphics) {
        if (this.grid == null) {
            super.paint(graphics);
            return;
        }
        Context context = this.getCurrentContext();
        double d = this.getWidth();
        double d2 = this.getHeight();
        if (this.grid.getRowCount() == 0 || this.grid.getColumnCount() == 0) {
            String string = Lexicon.make((String)"report").getText("emptyGrid");
            BFont bFont = Theme.widget().getTextFont();
            double d3 = (d - bFont.width(string)) / (double)2;
            double d4 = (d2 - bFont.getHeight()) / (double)2;
            graphics.setFont(bFont);
            graphics.setBrush(BColor.black);
            graphics.drawString(string, d3, d4);
        } else {
            BHalign bHalign;
            String string;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            BBrush bBrush = this.getBorder();
            if (!bBrush.isNull()) {
                graphics.setBrush(bBrush);
                graphics.strokeRect(0.0, 0.0, d - 1.0, d2 - 1.0);
            }
            BFont bFont = this.getHeaderFont();
            graphics.setFont(bFont);
            int n = 0;
            while (n < this.colCount) {
                string = this.grid.getColumnName(n);
                BHalign bHalign2 = bHalign = n == 0 ? this.getFirstColumnAlign() : this.getHeaderAlign();
                d7 = bHalign == BHalign.left ? d5 + (double)(bBrush.isNull() ? 0 : 3) : (bHalign == BHalign.right ? d5 + (double)this.cw - bFont.width(string) - (double)(bBrush.isNull() ? 0 : 2) : d5 + ((double)this.cw - bFont.width(string)) / (double)2);
                if (!bBrush.isNull()) {
                    graphics.setBrush(bBrush);
                    graphics.strokeLine(d5 - 1.0, 0.0, d5 - 1.0, d2);
                }
                d8 = d6 + ((double)this.ch - bFont.getHeight()) / (double)2 + bFont.getAscent();
                graphics.setBrush(this.getHeaderBrush());
                graphics.drawString(string, d7, d8);
                d5 += (double)this.cw;
                ++n;
            }
            n = 1;
            while (n < this.rowCount) {
                d5 = 0.0;
                d6 += (double)this.ch;
                if (!bBrush.isNull()) {
                    graphics.setBrush(bBrush);
                    graphics.strokeLine(0.0, d6 - 1.0, d, d6 - 1.0);
                }
                int n2 = 0;
                while (n2 < this.colCount) {
                    BBrush bBrush2;
                    BObject bObject = this.grid.getObjectAt(n - 1, n2);
                    string = GridUtil.getString(this.grid, n - 1, n2, context);
                    BBrush bBrush3 = GridUtil.getStatusBg(bObject);
                    if (bBrush3 != null) {
                        graphics.setBrush(bBrush3);
                        graphics.fillRect(d5, d6, (double)(this.cw - 1), (double)(this.ch - 1));
                    }
                    if (n2 == 0) {
                        bHalign = this.getFirstColumnAlign();
                        bFont = this.getFirstColumnFont();
                        graphics.setFont(bFont);
                        bBrush2 = GridUtil.getStatusFg(bObject);
                        graphics.setBrush(bBrush2 != null ? bBrush2 : this.getFirstColumnBrush());
                    } else {
                        bHalign = this.getCellAlign();
                        bFont = this.getCellFont();
                        graphics.setFont(bFont);
                        bBrush2 = GridUtil.getStatusFg(bObject);
                        graphics.setBrush(bBrush2 != null ? bBrush2 : this.getCellBrush());
                    }
                    d7 = bHalign == BHalign.left ? d5 + (double)(bBrush.isNull() ? 0 : 3) : (bHalign == BHalign.right ? d5 + (double)this.cw - bFont.width(string) - (double)(bBrush.isNull() ? 0 : 2) : d5 + ((double)this.cw - bFont.width(string)) / (double)2);
                    d8 = d6 + ((double)this.ch - bFont.getHeight()) / (double)2 + bFont.getAscent();
                    graphics.drawString(string, d7, d8);
                    d5 += (double)this.cw;
                    ++n2;
                }
                ++n;
            }
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (bMouseEvent.isPopupTrigger()) {
            this.doMouseEvent(bMouseEvent);
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        if (bMouseEvent.isPopupTrigger()) {
            this.doMouseEvent(bMouseEvent);
        } else {
            BWbShell bWbShell;
            int n = this.getColAt(bMouseEvent.getX());
            int n2 = this.getRowAt(bMouseEvent.getY());
            if (n == 0 && n2 >= 0 && !this.getHyperlink().isNull() && (bWbShell = this.getWbShell()) != null) {
                bWbShell.hyperlink(GridUtil.makeHyperlink(this.grid, n2, this.getHyperlink()));
            }
        }
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        Context context = this.getCurrentContext();
        BWbShell bWbShell = this.getWbShell();
        int n = this.getColAt(bMouseEvent.getX());
        int n2 = this.getRowAt(bMouseEvent.getY());
        if (n < 0 || n2 < 0) {
            this.setMouseCursor(MouseCursor.normal);
            if (bWbShell != null) {
                bWbShell.showStatus("");
            }
        } else {
            boolean bl;
            boolean bl2 = false;
            if (n == 0 && !this.getHyperlink().isNull()) {
                bl2 = true;
            }
            this.setMouseCursor((bl = bl2) ? MouseCursor.hand : MouseCursor.normal);
            if (bWbShell != null) {
                bWbShell.showStatus(GridUtil.getSummary(this.grid, n2, n, this.getHyperlink(), true, context));
            }
        }
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        BWbShell bWbShell = this.getWbShell();
        if (bWbShell != null) {
            bWbShell.showStatus("");
        }
        this.setMouseCursor(MouseCursor.normal);
    }

    private final void doMouseEvent(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        int n = this.getColAt(d);
        int n2 = this.getRowAt(d2);
        if (n < 0 || n2 < 0) {
            return;
        }
        BObject bObject = this.grid.getObjectAt(n2, n);
        if (!(bObject instanceof BComponent)) {
            return;
        }
        BMenu bMenu = NavMenuUtil.makeActionsMenu((BWidget)this, (BComponent)bObject.asComponent());
        if (bMenu.isEnabled()) {
            bMenu.open((BWidget)this, d, d2);
        }
    }

    private final int getColAt(double d) {
        int n = (int)(d / (double)this.cw);
        return n < this.colCount ? n : -1;
    }

    private final int getRowAt(double d) {
        if (d < (double)this.ch) {
            return -1;
        }
        int n = (int)(d / (double)this.ch) - 1;
        return n < this.rowCount - 1 ? n : -1;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.colCount = 0;
        this.rowCount = 0;
        this.cw = 0;
        this.ch = 0;
    }

    public BGridLabelPane() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$report$grid$ui$BGridLabelPane;
        if (clazz == null) {
            clazz = class$com$tridium$report$grid$ui$BGridLabelPane = BGridLabelPane.class("[Lcom.tridium.report.grid.ui.BGridLabelPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

