/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.grid.editor;

import com.tridium.report.grid.BCompGridColumn;
import com.tridium.report.grid.BCompGridRow;
import com.tridium.report.grid.BSingleQueryRow;
import com.tridium.report.grid.BSingleRow;
import com.tridium.report.grid.editor.BComponentGridEditor;
import com.tridium.report.grid.editor.BComponentGridQueryEditor;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.transfer.TransferUtil;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.space.Mark;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BScrollEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BGridEditorPane
extends BTransferWidget {
    public static final Action vscroll = BGridEditorPane.newAction((int)0, (BValue)new BScrollEvent(), null);
    public static final Type TYPE;
    static final BModule module;
    static final Lexicon lex;
    static final BFont font;
    static final BFont bold;
    static final BImage warningIcon;
    private static final String BRUSH_DYNAMIC_ROW_BG = "#FFEBA5";
    private static final String BRUSH_QUERY_BG = "#C8C1FF";
    private static final String QUERY_RESULT_ROW_TEXT = "queryResultRow";
    String defName;
    BFormat defFormat;
    BOrd defOrd;
    double colWidth;
    double headerHeight;
    double templateHeight;
    double queryHeight;
    double rowHeight;
    int selectedCol;
    int selectedRow;
    boolean mouseDown;
    int dragZone;
    int dragCol;
    int dragRow;
    int dragColOrig;
    int dragRowOrig;
    BComponentGridEditor.Model model;
    Command delete;
    BScrollBar vbar;
    static /* synthetic */ Class class$com$tridium$report$grid$editor$BGridEditorPane;

    public void vscroll(BScrollEvent bScrollEvent) {
        this.invoke(vscroll, (BValue)bScrollEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int getColumnAt(double d) {
        int n = this.model.getColumnCount();
        if (n == 0) {
            return -1;
        }
        if (d < 0.0) {
            return 0;
        }
        int n2 = (int)(d / this.colWidth);
        if (n2 >= n) {
            n2 = n - 1;
        }
        return n2;
    }

    public int getRowAt(double d) {
        if (d < this.headerHeight) {
            return -1;
        }
        if (d < this.headerHeight + this.templateHeight) {
            return -2;
        }
        if (d < this.headerHeight + this.templateHeight + this.queryHeight) {
            return -3;
        }
        int n = (int)((d - this.headerHeight - this.templateHeight - this.queryHeight) / this.rowHeight) + this.vbar.getPosition();
        if (n < this.model.getRowCount()) {
            return n;
        }
        return -4;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        int n = this.model.getColumnCount();
        int n2 = false;
        if (n != 0) {
            n2 = (int)(d / (double)this.model.getColumnCount());
        }
        this.colWidth = n2;
        this.headerHeight = bold.getHeight() + font.getHeight() * (double)2 + 10.0;
        this.templateHeight = font.getHeight() + 20.0;
        this.queryHeight = font.getHeight() + 20.0;
        this.rowHeight = font.getHeight() + 10.0;
        this.vbar.computePreferredSize();
        double d3 = this.vbar.getPreferredWidth();
        double d4 = this.headerHeight + this.templateHeight + this.queryHeight - 1.0;
        double d5 = d - d3;
        double d6 = d2 - d4;
        this.vbar.setBounds(d5, d4, d3, d6);
        int n3 = this.model.getRowCount();
        if (this.model.getQuery() != null) {
            ++n3;
        }
        int n4 = n3;
        int n5 = (int)(d6 / this.rowHeight);
        if (n3 > n5) {
            n4 = n5;
        }
        this.vbar.setMin(0);
        this.vbar.setMax(n3);
        this.vbar.setExtent(n4);
        this.vbar.setBlockIncrement(Math.max(3, n5 - 1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics graphics) {
        double d;
        double d2;
        Object var9_15;
        double d3 = this.getWidth();
        double d4 = this.getHeight();
        int n = this.model.getColumnCount();
        int n2 = this.model.getRowCount();
        if (n == 0) {
            this.paintNoColumns(graphics);
        }
        int n3 = 0;
        while (n3 < n) {
            Object var10_10;
            graphics.push();
            try {
                double d5 = this.colWidth;
                if (n3 == n - 1) {
                    d5 += d3 - (double)n * this.colWidth;
                }
                graphics.translate((double)n3 * this.colWidth, 0.0);
                graphics.clip(0.0, 0.0, d5, this.headerHeight);
                this.paintColumn(graphics, n3, d5);
                var10_10 = null;
            }
            catch (Throwable throwable) {
                var10_10 = null;
                graphics.pop();
                throw throwable;
            }
            graphics.pop();
            ++n3;
        }
        graphics.push();
        try {
            graphics.translate(0.0, this.headerHeight);
            graphics.clip(0.0, 0.0, d3, this.templateHeight);
            this.paintTemplate(graphics);
            var9_15 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            graphics.pop();
            throw throwable;
        }
        graphics.pop();
        graphics.push();
        try {
            graphics.translate(0.0, this.headerHeight + this.templateHeight);
            graphics.clip(0.0, 0.0, d3, this.queryHeight);
            this.paintQuery(graphics);
            var9_15 = null;
        }
        catch (Throwable throwable) {
            var9_15 = null;
            graphics.pop();
            throw throwable;
        }
        graphics.pop();
        double d6 = this.headerHeight + this.templateHeight + this.queryHeight;
        double d7 = this.rowHeight * (double)this.model.getRowCount();
        if (this.model.getQuery() != null) {
            d7 += this.rowHeight;
        }
        graphics.setBrush(Theme.widget().getWindowBackground());
        graphics.fillRect(0.0, d6, d3, d7);
        if (n2 == 0) {
            this.paintNoRows(graphics);
        } else {
            graphics.push();
            try {
                d2 = this.headerHeight + this.templateHeight + this.queryHeight;
                double d8 = d4 - d2;
                graphics.translate(0.0, d2);
                graphics.clip(0.0, 0.0, d3, d8);
                int n4 = this.vbar.getPosition();
                graphics.translate(0.0, -((double)n4 * this.rowHeight));
                int n5 = 0;
                while (n5 < n2) {
                    block31: {
                        Object var23_23;
                        graphics.push();
                        try {
                            graphics.translate(0.0, (double)n5 * this.rowHeight);
                            graphics.clip(0.0, 0.0, d3, this.rowHeight);
                            if (this.model.getRow(n5) instanceof BSingleQueryRow) {
                                var23_23 = null;
                                graphics.pop();
                                break block31;
                            }
                            this.paintRow(graphics, n5);
                            var23_23 = null;
                        }
                        catch (Throwable throwable) {
                            var23_23 = null;
                            graphics.pop();
                            throw throwable;
                        }
                        graphics.pop();
                    }
                    ++n5;
                }
                Object var15_28 = null;
            }
            catch (Throwable throwable) {
                Object var15_27 = null;
                graphics.pop();
                throw throwable;
            }
            graphics.pop();
        }
        graphics.push();
        try {
            d = this.headerHeight + this.templateHeight + this.queryHeight + this.rowHeight * (double)this.model.getRowCount();
            d2 = d4 - d;
            graphics.translate(0.0, d);
            graphics.clip(0.0, 0.0, d3, d2);
            int n6 = this.vbar.getPosition();
            graphics.translate(0.0, -((double)n6 * this.rowHeight));
            this.paintQueryResultsRow(graphics);
            var9_15 = null;
        }
        catch (Throwable throwable) {
            var9_15 = null;
            graphics.pop();
            throw throwable;
        }
        graphics.pop();
        this.paintChild(graphics, (BWidget)this.vbar);
        graphics.setBrush(BColor.black);
        graphics.strokeRect(0.0, 0.0, d3 - 1.0, d4 - 1.0);
        if (this.dragZone != -1) {
            graphics.setBrush(Theme.widget().getDropOkBackground());
            d = 0.0;
            d2 = 0.0;
            double d9 = d3;
            if (this.dragZone == 0) {
                d = 0.0;
                d2 = this.headerHeight;
            } else if (this.dragZone == 1) {
                d = this.headerHeight - 1.0;
                d2 = this.templateHeight + this.queryHeight + 1.0;
            } else {
                d = this.headerHeight + this.templateHeight + this.queryHeight - 1.0;
                d2 = d4 - d;
                d9 -= this.vbar.getPreferredWidth() - 1.0;
            }
            graphics.strokeRect(1.0, d + 1.0, d9 - (double)3, d2 - (double)3);
            graphics.strokeRect((double)2, d + (double)2, d9 - (double)5, d2 - (double)5);
            graphics.strokeRect((double)3, d + (double)3, d9 - 7.0, d2 - 7.0);
        }
    }

    private final void paintNoColumns(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.headerHeight;
        String string = lex.getText("compGridEditor.noColumns");
        double d3 = Math.max(16.0, bold.getHeight());
        double d4 = (d - bold.width(string) - 20.0) / (double)2;
        double d5 = (d2 - d3) / (double)2 + bold.getAscent();
        double d6 = d4 - 20.0;
        double d7 = (d2 - d3) / (double)2;
        graphics.setBrush(Theme.widget().getControlAuxiliary());
        graphics.fillRect(0.0, 0.0, d, d2);
        graphics.setBrush(BColor.black);
        graphics.setFont(bold);
        graphics.drawImage(warningIcon, d6, d7);
        graphics.drawString(string, d4, d5);
        graphics.setBrush(BColor.black);
        graphics.strokeLine(0.0, d2 - 1.0, d, d2 - 1.0);
    }

    private final void paintNoRows(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.headerHeight + this.templateHeight + this.queryHeight;
        double d3 = this.getHeight() - d2;
        String string = lex.getText("compGridEditor.noRows");
        double d4 = Math.max(16.0, bold.getHeight());
        double d5 = (d - bold.width(string) - 20.0) / (double)2;
        double d6 = (d3 - d4) / (double)2 + bold.getAscent();
        double d7 = d5 - 20.0;
        double d8 = (d3 - d4) / (double)2;
        graphics.setBrush(Theme.widget().getControlBackground());
        graphics.fillRect(0.0, d2, d, d3);
        graphics.setBrush(BColor.black);
        graphics.setFont(bold);
        graphics.drawImage(warningIcon, d7, d8);
        graphics.drawString(string, d5, d6);
    }

    private final void paintColumn(Graphics graphics, int n, double d) {
        double d2 = this.headerHeight;
        boolean bl = false;
        if (n == this.selectedCol) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (n == this.dragCol) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        BBrush bBrush = Theme.widget().getControlAuxiliary();
        if (bl2) {
            bBrush = Theme.widget().getSelectionBackground();
        }
        if (bl4) {
            bBrush = Theme.widget().getDropOkBackground();
        }
        BBrush bBrush2 = BColor.black.toBrush();
        if (bl2) {
            bBrush2 = Theme.widget().getSelectionForeground();
        }
        if (bl4) {
            bBrush2 = Theme.widget().getDropOkForeground();
        }
        graphics.setBrush(bBrush);
        graphics.fillRect(0.0, 0.0, d, d2);
        BCompGridColumn bCompGridColumn = this.model.getColumn(n);
        String string = bCompGridColumn.getDisplayName();
        String string2 = bCompGridColumn.getFormat().getFormat();
        String string3 = bCompGridColumn.getOrd().toString();
        double d3 = (d - bold.width(string)) / (double)2;
        double d4 = bold.getAscent() + (double)5;
        graphics.setBrush(bBrush2);
        graphics.setFont(bold);
        graphics.drawString(string, d3, d4);
        d3 = (d - font.width(string3)) / (double)2;
        graphics.setFont(font);
        graphics.drawString(string3, d3, d4 += font.getHeight());
        d3 = (d - font.width(string2)) / (double)2;
        graphics.setFont(font);
        graphics.drawString(string2, d3, d4 += font.getHeight());
        graphics.setBrush(BColor.black);
        graphics.strokeLine(0.0, d2 - 1.0, d - 1.0, d2 - 1.0);
        graphics.strokeLine(d - 1.0, 0.0, d - 1.0, d2);
    }

    private final void paintTemplate(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.templateHeight;
        if (this.model.getTemplate() == null) {
            String string = lex.getText("compGridEditor.noTemplate");
            double d3 = Math.max(16.0, bold.getHeight());
            double d4 = (d - bold.width(string) - 20.0) / (double)2;
            double d5 = (d2 - d3) / (double)2 + bold.getAscent();
            double d6 = d4 - 20.0;
            double d7 = (d2 - d3) / (double)2;
            graphics.setBrush(BBrush.make((String)"#ffffc0"));
            graphics.fillRect(0.0, 0.0, d, d2);
            graphics.setBrush(BColor.black);
            graphics.setFont(bold);
            graphics.drawImage(warningIcon, d6, d7);
            graphics.drawString(string, d4, d5);
        } else {
            boolean bl;
            boolean bl2 = false;
            if (this.selectedRow == -2) {
                bl2 = true;
            }
            if (bl = bl2) {
                graphics.setBrush(Theme.widget().getSelectionBackground());
                graphics.fillRect(0.0, 0.0, d, d2);
            }
            String string = SlotPath.unescape((String)("station:|" + this.model.getTemplate().getSlotPath().toString()));
            double d8 = 5;
            double d9 = 10.0 + font.getAscent();
            if (bl) {
                graphics.setBrush(Theme.widget().getSelectionForeground());
            } else {
                graphics.setBrush(BColor.black);
            }
            graphics.setFont(font);
            graphics.drawString(string, d8, d9);
        }
        graphics.setBrush(BColor.black);
        graphics.strokeLine(0.0, d2 - 1.0, d, d2 - 1.0);
    }

    private final void paintQuery(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.queryHeight;
        if (this.model.getQuery() == null || this.model.getQuery() == BOrd.NULL) {
            String string = lex.getText("compGridEditor.noQuery");
            double d3 = Math.max(16.0, bold.getHeight());
            double d4 = (d - bold.width(string) - 20.0) / (double)2;
            double d5 = (d2 - d3) / (double)2 + bold.getAscent();
            double d6 = d4 - 20.0;
            double d7 = (d2 - d3) / (double)2;
            graphics.setBrush(BBrush.make((String)BRUSH_QUERY_BG));
            graphics.fillRect(0.0, 0.0, d, d2);
            graphics.setBrush(BColor.black);
            graphics.setFont(bold);
            graphics.drawImage(warningIcon, d6, d7);
            graphics.drawString(string, d4, d5);
        } else {
            boolean bl;
            boolean bl2 = false;
            if (this.selectedRow == -3) {
                bl2 = true;
            }
            if (bl = bl2) {
                graphics.setBrush(Theme.widget().getSelectionBackground());
                graphics.fillRect(0.0, 0.0, d, d2);
            } else {
                graphics.setBrush(BBrush.make((String)BRUSH_QUERY_BG));
                graphics.fillRect(0.0, 0.0, d, d2);
            }
            String string = SlotPath.unescape((String)this.model.getQuery().encodeToString());
            double d8 = 5;
            double d9 = 10.0 + font.getAscent();
            if (bl) {
                graphics.setBrush(Theme.widget().getSelectionForeground());
            } else {
                graphics.setBrush(BColor.black);
            }
            graphics.setFont(font);
            graphics.drawString(string, d8, d9);
        }
        graphics.setBrush(BColor.black);
        graphics.strokeLine(0.0, d2 - 1.0, d, d2 - 1.0);
    }

    private final void paintRow(Graphics graphics, int n) {
        double d = this.getWidth();
        double d2 = this.rowHeight;
        boolean bl = false;
        if (n == this.selectedRow) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (n == this.dragRow) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        BCompGridRow bCompGridRow = this.model.getRow(n);
        if (bl4) {
            graphics.setBrush(Theme.widget().getDropOkBackground());
            graphics.fillRect(0.0, 0.0, d, d2);
        } else if (bl2) {
            graphics.setBrush(Theme.widget().getSelectionBackground());
            graphics.fillRect(0.0, 0.0, d, d2);
        }
        graphics.setBrush(n < this.model.getRowCount() - 1 ? Theme.widget().getControlBackground() : BColor.black.toBrush());
        graphics.strokeLine(0.0, d2 - 1.0, d, d2 - 1.0);
        String string = SlotPath.unescape((String)bCompGridRow.toString());
        double d3 = 5;
        double d4 = (double)5 + font.getAscent();
        if (bl4) {
            graphics.setBrush(Theme.widget().getDropOkForeground());
        } else if (bl2) {
            graphics.setBrush(Theme.widget().getSelectionForeground());
        } else {
            graphics.setBrush(BColor.black);
        }
        graphics.setFont(font);
        graphics.drawString(string, d3, d4);
    }

    private final void paintQueryResultsRow(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.rowHeight;
        BOrd bOrd = this.model.getQuery();
        if (bOrd != null && bOrd != BOrd.NULL) {
            graphics.setBrush(BBrush.make((String)BRUSH_DYNAMIC_ROW_BG));
            graphics.fillRect(0.0, 0.0, d, d2);
            graphics.setBrush(BColor.black.toBrush());
            graphics.strokeLine(0.0, d2 - 1.0, d, d2 - 1.0);
            double d3 = 5;
            double d4 = (double)5 + font.getAscent();
            graphics.setFont(font);
            graphics.drawString(lex.getText(QUERY_RESULT_ROW_TEXT), d3, d4);
        } else {
            graphics.setBrush(BColor.black.toBrush());
            graphics.strokeLine(0.0, 0.0, d, 0.0);
        }
    }

    public void doVscroll(BScrollEvent bScrollEvent) {
        this.repaint();
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getKeyCode() == 27) {
            if (this.dragCol != -1 && this.dragCol != this.dragColOrig) {
                this.model.moveColumn(this.dragCol, this.dragColOrig);
                this.selectColumn(this.dragColOrig);
                this.setMouseCursor(MouseCursor.normal);
                this.dragCol = -1;
                this.mouseDown = false;
                this.repaint();
            } else if (this.dragRow != -1 && this.dragRow != this.dragRowOrig) {
                this.model.moveRow(this.dragRow, this.dragRowOrig);
                this.selectRow(this.dragRowOrig);
                this.setMouseCursor(MouseCursor.normal);
                this.dragRow = -1;
                this.mouseDown = false;
                this.repaint();
            }
        } else {
            super.keyReleased(bKeyEvent);
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.requestFocus();
        this.mouseDown = true;
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        int n = this.getColumnAt(d);
        int n2 = this.getRowAt(d2);
        if (n2 == -1) {
            this.selectColumn(n);
        } else {
            this.selectRow(n2);
        }
        this.repaint();
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.setMouseCursor(MouseCursor.normal);
        if (!this.mouseDown) {
            return;
        }
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        if (this.dragCol != -1) {
            this.dragCol = -1;
            this.repaint();
            return;
        }
        if (this.dragRow != -1) {
            this.dragRow = -1;
            this.repaint();
            return;
        }
        boolean bl = false;
        if (bMouseEvent.getClickCount() == 2) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = bMouseEvent.isPopupTrigger();
        int n = this.getColumnAt(d);
        int n2 = this.getRowAt(d2);
        if (bl3) {
            if (n2 != -2) {
                BMenu bMenu = n2 == -1 ? this.makeColumnPopup(n) : this.makeRowPopup(n2);
                bMenu.open((BWidget)this, d, d2);
            }
        } else if (bl2) {
            if (n2 == -1) {
                if (n != -1) {
                    this.editColumn(n);
                }
            } else if (n2 == -2) {
                this.editTemplate();
            } else if (n2 == -3) {
                this.editQuery();
            } else if (n2 != -4) {
                this.editRow(n2);
            }
        }
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        if (!this.mouseDown) {
            return;
        }
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        int n = this.getColumnAt(d);
        int n2 = this.getRowAt(d2);
        if (this.dragRow == -2 || this.dragRow == -3 || this.dragRow == -4) {
            return;
        }
        if (this.dragRow != -1) {
            if (n2 == -4) {
                if (this.model.getRowCount() == 1) {
                    return;
                }
                n2 = this.model.getRowCount() - 1;
            }
            if (n2 == -1 || n2 == -2) {
                n2 = 0;
            }
        } else if (this.dragCol != -1) {
            n2 = -1;
        }
        if (n2 != -1) {
            if (this.dragRow == -1) {
                this.dragRow = n2;
                this.dragRowOrig = n2;
                if (this.dragRow == -2 || this.dragRow == -3 || this.dragRow == -4) {
                    return;
                }
                this.repaint();
                this.setMouseCursor(MouseCursor.move);
            } else if (this.dragRow != n2) {
                this.model.moveRow(this.dragRow, n2);
                this.dragRow = n2;
                this.selectRow(this.dragRow);
            }
        } else if (this.dragCol == -1) {
            this.dragCol = n;
            this.dragColOrig = n;
            this.repaint();
            this.setMouseCursor(MouseCursor.move);
        } else if (this.dragCol != n) {
            this.model.moveColumn(this.dragCol, n);
            this.dragCol = n;
            this.selectColumn(this.dragCol);
        }
    }

    public void mouseWheel(BMouseWheelEvent bMouseWheelEvent) {
        if (bMouseWheelEvent.getWheelRotation() > 0) {
            this.vbar.incrementByUnit();
        } else {
            this.vbar.decrementByUnit();
        }
    }

    public BMenu makeColumnPopup(int n) {
        BMenu bMenu = new BMenu();
        bMenu.add(null, (Command)new AddColumn((BWidget)this, this, n));
        bMenu.add(null, this.delete);
        return bMenu;
    }

    public BMenu makeRowPopup(int n) {
        BMenu bMenu = new BMenu();
        bMenu.add(null, (Command)new AddRow((BWidget)this, this, n));
        if (n >= 0) {
            bMenu.add(null, this.delete);
        }
        return bMenu;
    }

    public void editColumn(int n) {
        BCompGridColumn bCompGridColumn = this.model.getColumn(n);
        if ((bCompGridColumn = this.editColumn(bCompGridColumn)) != null) {
            this.model.setColumn(n, bCompGridColumn);
        }
    }

    public BCompGridColumn editColumn(BCompGridColumn bCompGridColumn) {
        BTextField bTextField = new BTextField(bCompGridColumn.getDisplayName(), 40);
        BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bCompGridColumn.getFormat());
        BWbFieldEditor bWbFieldEditor2 = BWbFieldEditor.makeFor((BObject)bCompGridColumn.getOrd());
        bWbFieldEditor.loadValue((BObject)bCompGridColumn.getFormat(), this.model.cx);
        bWbFieldEditor2.loadValue((BObject)bCompGridColumn.getOrd(), this.model.cx);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.add(null, (BValue)new BLabel(BGridEditorPane.lex("name")));
        bGridPane.add(null, (BValue)bTextField);
        bGridPane.add(null, (BValue)new BLabel(BGridEditorPane.lex("format")));
        bGridPane.add(null, (BValue)bWbFieldEditor);
        bGridPane.add(null, (BValue)new BLabel(BGridEditorPane.lex("ord")));
        bGridPane.add(null, (BValue)bWbFieldEditor2);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane);
        if (1 == BDialog.open((BWidget)this, (String)BGridEditorPane.lex("editColumn"), (Object)bBorderPane, (int)3)) {
            try {
                String string = bTextField.getText();
                BFormat bFormat = (BFormat)bWbFieldEditor.saveValue();
                BOrd bOrd = (BOrd)bWbFieldEditor2.saveValue();
                bCompGridColumn.setDisplayName(string);
                bCompGridColumn.setFormat(bFormat);
                bCompGridColumn.setOrd(bOrd);
                return bCompGridColumn;
            }
            catch (Exception exception) {
                BDialog.error((BWidget)this, (Object)exception);
            }
        }
        return null;
    }

    public void editTemplate() {
        BComponent bComponent = this.model.getTemplate();
        BOrd bOrd = bComponent == null ? BOrd.NULL : bComponent.getNavOrd().relativizeToSession();
        BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bOrd);
        bWbFieldEditor.loadValue((BObject)bOrd, this.model.cx);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.add(null, (BValue)new BLabel(BGridEditorPane.lex("ord")));
        bGridPane.add(null, (BValue)bWbFieldEditor);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane);
        if (1 == BDialog.open((BWidget)this, (String)BGridEditorPane.lex("editTemplate"), (Object)bBorderPane, (int)3)) {
            try {
                BOrd bOrd2 = (BOrd)bWbFieldEditor.saveValue();
                bComponent = bOrd2.resolve(this.model.base).get().asComponent();
                this.model.setTemplate(bComponent);
            }
            catch (Exception exception) {
                BDialog.error((BWidget)this, (Object)exception);
            }
        }
    }

    public void editQuery() {
        BOrd bOrd = this.model.getQuery();
        BComponent bComponent = this.model.getTemplate();
        if (bComponent == null) {
            throw new BajaRuntimeException("Must define Component Grid Template before defining Query");
        }
        bOrd = BComponentGridQueryEditor.open((BWidget)this, (BObject)bComponent, bOrd);
        this.model.setQuery(bOrd);
        this.repaint();
    }

    public void editRow(int n) {
        BCompGridRow bCompGridRow = this.model.getRow(n);
        if ((bCompGridRow = this.editRow(bCompGridRow)) != null) {
            this.model.setRow(n, bCompGridRow);
        }
    }

    public BCompGridRow editRow(BCompGridRow bCompGridRow) {
        BSingleRow bSingleRow = (BSingleRow)bCompGridRow;
        BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bSingleRow.getOrd());
        bWbFieldEditor.loadValue((BObject)bSingleRow.getOrd(), (Context)bSingleRow.getSlotFacets((Slot)BSingleRow.ord));
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.add(null, (BValue)new BLabel(BGridEditorPane.lex("ord")));
        bGridPane.add(null, (BValue)bWbFieldEditor);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane);
        if (1 == BDialog.open((BWidget)this, (String)BGridEditorPane.lex("editRow"), (Object)bBorderPane, (int)3)) {
            try {
                BOrd bOrd = (BOrd)bWbFieldEditor.saveValue();
                if (bOrd.isNull()) {
                    throw new RuntimeException(lex.getText("compGridEditor.ordCannotBeNull"));
                }
                BObject bObject = bOrd.resolve(this.model.base).get();
                if (!(bObject instanceof BComponent)) {
                    throw new RuntimeException(lex.getText("compGridEditor.mustChooseBComponent"));
                }
                bSingleRow.setOrd(bOrd);
                return bSingleRow;
            }
            catch (Exception exception) {
                BDialog.error((BWidget)this, (Object)exception);
            }
        }
        return null;
    }

    private final void selectColumn(int n) {
        this.selectedCol = n;
        this.selectedRow = -1;
        boolean bl = false;
        if (this.selectedCol != -1) {
            bl = true;
        }
        this.delete.setEnabled(bl);
    }

    private final void selectRow(int n) {
        this.selectedCol = -1;
        this.selectedRow = n;
        boolean bl = false;
        if (this.selectedRow != -2 && this.selectedRow != -3) {
            bl = true;
        }
        this.delete.setEnabled(bl);
    }

    private final BCompGridColumn makeNewColumn() {
        BCompGridColumn bCompGridColumn = new BCompGridColumn();
        bCompGridColumn.setDisplayName(this.defName);
        bCompGridColumn.setFormat(this.defFormat);
        bCompGridColumn.setOrd(this.defOrd);
        return bCompGridColumn;
    }

    public TransferEnvelope getTransferData() throws Exception {
        return null;
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        return null;
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        return null;
    }

    public CommandArtifact doDuplicate() throws Exception {
        return null;
    }

    public CommandArtifact doDelete() throws Exception {
        return null;
    }

    public CommandArtifact doRename() throws Exception {
        return null;
    }

    public int dragOver(TransferContext transferContext) {
        Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
        if (!TransferUtil.isComponent((Mark)mark)) {
            return 0;
        }
        switch (this.getRowAt(transferContext.getY())) {
            case -1: {
                this.dragZone = 0;
                break;
            }
            case -2: {
                this.dragZone = 1;
                break;
            }
            default: {
                this.dragZone = 2;
            }
        }
        if (this.model.getTemplate() == null && this.dragZone != 1) {
            this.dragZone = -1;
            this.repaint();
            return 0;
        }
        this.repaint();
        return 16;
    }

    public void dragExit(TransferContext transferContext) {
        this.dragZone = -1;
        this.repaint();
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        int n = this.dragZone;
        this.dragZone = -1;
        this.repaint();
        if (n == 0) {
            return this.insertColumns(transferContext);
        }
        if (n == 1) {
            return this.insertTemplate(transferContext);
        }
        return this.insertRows(transferContext);
    }

    private final CommandArtifact insertColumns(TransferContext transferContext) throws Exception {
        BComponent bComponent = this.model.getTemplate();
        if (bComponent == null) {
            return null;
        }
        Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
        if (!TransferUtil.isComponent((Mark)mark)) {
            return null;
        }
        BCompGridColumn[] bCompGridColumnArray = new BCompGridColumn[mark.size()];
        int n = 0;
        while (n < mark.size()) {
            BComponent bComponent2 = mark.getValue(n).asComponent();
            String string = bComponent2.getNavOrd().relativizeToSession().toString();
            String string2 = bComponent.getNavOrd().relativizeToSession().toString();
            if (string.length() < string2.length() || !string.startsWith(string2)) {
                throw new LocalizableException("report", "compGridEditor.notUnderTemplate");
            }
            if (string.equals(string2)) {
                bCompGridColumnArray[n] = new BCompGridColumn();
                bCompGridColumnArray[n].setDisplayName(lex.getText("compGridEditor.name"));
                bCompGridColumnArray[n].setFormat(BFormat.make((String)"%displayName%"));
                bCompGridColumnArray[n].setOrd(BOrd.make((String)"slot:"));
            } else {
                bCompGridColumnArray[n] = new BCompGridColumn();
                bCompGridColumnArray[n].setDisplayName(bComponent2.getDisplayName(this.model.cx));
                bCompGridColumnArray[n].setFormat(this.defFormat);
                bCompGridColumnArray[n].setOrd(BOrd.make((String)("slot:" + string.substring(string2.length() + 1))));
            }
            ++n;
        }
        this.selectColumn(this.model.getColumnCount() + (bCompGridColumnArray.length - 1));
        this.model.addColumns(bCompGridColumnArray);
        return null;
    }

    private final CommandArtifact insertTemplate(TransferContext transferContext) {
        Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
        if (!TransferUtil.isComponent((Mark)mark)) {
            return null;
        }
        this.model.setTemplate(mark.getValue(0).asComponent());
        BSingleRow bSingleRow = new BSingleRow();
        bSingleRow.setOrd(mark.getValue(0).asComponent().getNavOrd().relativizeToSession());
        this.selectRow(this.model.getRowCount());
        this.model.addRow(bSingleRow);
        return null;
    }

    private final CommandArtifact insertRows(TransferContext transferContext) {
        Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
        if (!TransferUtil.isComponent((Mark)mark)) {
            return null;
        }
        BCompGridRow[] bCompGridRowArray = new BSingleRow[mark.size()];
        int n = 0;
        while (n < mark.size()) {
            bCompGridRowArray[n] = new BSingleRow();
            bCompGridRowArray[n].setOrd(mark.getValue(n).asComponent().getNavOrd().relativizeToSession());
            ++n;
        }
        this.selectRow(this.model.getRowCount() + (bCompGridRowArray.length - 1));
        this.model.addRows(bCompGridRowArray);
        return null;
    }

    static String lex(String string) {
        return lex.getText("compGridEditor." + string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.defName = lex.getText("compGridEditor.defaultColumnName");
        this.defFormat = BFormat.make((String)"%.%");
        this.defOrd = BOrd.make((String)"slot:");
        this.selectedCol = -1;
        this.selectedRow = -1;
        this.mouseDown = false;
        this.dragZone = -1;
        this.dragCol = -1;
        this.dragRow = -1;
        this.dragColOrig = -1;
        this.dragRowOrig = -1;
        this.vbar = new BScrollBar(BOrientation.vertical);
    }

    public BGridEditorPane(BComponentGridEditor.Model model) {
        this.this();
        this.model = model;
        this.delete = new Delete((BWidget)this);
        this.delete.setEnabled(false);
        this.add("vbar", (BValue)this.vbar);
        this.linkTo((BComponent)this.vbar, (Slot)BScrollBar.positionChanged, (Slot)vscroll);
    }

    static {
        Class clazz = class$com$tridium$report$grid$editor$BGridEditorPane;
        if (clazz == null) {
            clazz = class$com$tridium$report$grid$editor$BGridEditorPane = BGridEditorPane.class("[Lcom.tridium.report.grid.editor.BGridEditorPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$report$grid$editor$BGridEditorPane;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$report$grid$editor$BGridEditorPane = BGridEditorPane.class("[Lcom.tridium.report.grid.editor.BGridEditorPane;", false);
        }
        module = Sys.getModuleForClass((Class)clazz2);
        lex = Lexicon.make((String)"report");
        font = Theme.widget().getTextFont();
        bold = Theme.widget().getBoldText();
        warningIcon = BImage.make((String)"module://icons/x16/warning.png");
    }

    static class AddColumn
    extends Command {
        BGridEditorPane editor;
        int col;

        public CommandArtifact doInvoke() throws Exception {
            BCompGridColumn bCompGridColumn = this.editor.makeNewColumn();
            if ((bCompGridColumn = this.editor.editColumn(bCompGridColumn)) == null) {
                return null;
            }
            if (this.col < 0) {
                this.editor.selectColumn(this.editor.model.getColumnCount());
                this.editor.model.addColumn(bCompGridColumn);
            } else {
                this.editor.selectColumn(this.editor.selectedCol + 1);
                this.editor.model.addColumn(this.col, bCompGridColumn);
            }
            return null;
        }

        public AddColumn(BWidget bWidget, BGridEditorPane bGridEditorPane, int n) {
            super(bWidget, module, "compGridEditor.commands.addColumn");
            this.editor = bGridEditorPane;
            this.col = n;
        }
    }

    static class AddRow
    extends Command {
        BGridEditorPane editor;
        int row;

        public CommandArtifact doInvoke() throws Exception {
            BCompGridRow bCompGridRow = this.editor.editRow(new BSingleRow());
            if (bCompGridRow == null) {
                return null;
            }
            if (this.editor.model.getTemplate() == null) {
                BOrd bOrd = ((BSingleRow)bCompGridRow).getOrd();
                BComponent bComponent = bOrd.resolve(this.editor.model.base).get().asComponent();
                this.editor.model.setTemplate(bComponent);
            }
            if (this.row < 0) {
                this.editor.selectRow(this.editor.model.getRowCount());
                this.editor.model.addRow(bCompGridRow);
            } else {
                this.editor.selectRow(this.editor.selectedRow + 1);
                this.editor.model.addRow(this.row, bCompGridRow);
            }
            return null;
        }

        public AddRow(BWidget bWidget, BGridEditorPane bGridEditorPane, int n) {
            super(bWidget, module, "compGridEditor.commands.addRow");
            this.editor = bGridEditorPane;
            this.row = n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Delete
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            if (BGridEditorPane.this.selectedRow >= 0) {
                int n = BGridEditorPane.this.selectedRow;
                if (n == BGridEditorPane.this.model.getRowCount() - 1) {
                    BGridEditorPane.this.selectRow(n - 1);
                }
                BGridEditorPane.this.model.removeRow(n);
            } else if (BGridEditorPane.this.selectedCol != -1) {
                int n = BGridEditorPane.this.selectedCol;
                if (n == BGridEditorPane.this.model.getColumnCount() - 1) {
                    BGridEditorPane.this.selectColumn(n - 1);
                }
                BGridEditorPane.this.model.removeColumn(n);
                return null;
            }
            return null;
        }

        public Delete(BWidget bWidget) {
            super(bWidget, module, "compGridEditor.commands.delete");
        }
    }
}

