/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.analyzer;

import com.tridium.box.BBoxRecordType;
import com.tridium.box.BBoxService;
import com.tridium.box.analyzer.BBoxFrameRecord;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.PatternFilter;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBoxAnalyzer
extends BComponent
implements BBoxService.IBoxListener {
    public static final Property active = BBoxAnalyzer.newProperty((int)75, (boolean)false, null);
    public static final Property viewLogLimit = BBoxAnalyzer.newProperty((int)0, (int)4096, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)5)));
    public static final Property userPattern = BBoxAnalyzer.newProperty((int)0, (String)"*", null);
    public static final Property hostPattern = BBoxAnalyzer.newProperty((int)0, (String)"*", null);
    public static final Property totalFrames = BBoxAnalyzer.newProperty((int)67, (int)0, null);
    public static final Property lastNewFrameDateTime = BBoxAnalyzer.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    public static final Property historyEnabled = BBoxAnalyzer.newProperty((int)64, (boolean)false, null);
    public static final Property historyId = BBoxAnalyzer.newProperty((int)0, (BValue)BHistoryId.make((String)"^", (String)"box"), null);
    public static final Property historyConfig = BBoxAnalyzer.newProperty((int)0, (BValue)new BHistoryConfig(BHistoryId.DEFAULT, BBoxFrameRecord.TYPE.getTypeSpec()), null);
    public static final Topic newFrame = BBoxAnalyzer.newTopic((int)264, null);
    public static final Type TYPE;
    private static final Log log;
    private static final BIcon icon;
    private static Worker worker;
    private static final Queue queue;
    private static int startCount;
    private volatile PatternFilter userFilter;
    private volatile PatternFilter hostFilter;
    static /* synthetic */ Class class$com$tridium$box$analyzer$BBoxAnalyzer;

    public final boolean getActive() {
        return this.getBoolean(active);
    }

    public final void setActive(boolean bl) {
        this.setBoolean(active, bl, null);
    }

    public final int getViewLogLimit() {
        return this.getInt(viewLogLimit);
    }

    public final void setViewLogLimit(int n) {
        this.setInt(viewLogLimit, n, null);
    }

    public final String getUserPattern() {
        return this.getString(userPattern);
    }

    public final void setUserPattern(String string) {
        this.setString(userPattern, string, null);
    }

    public final String getHostPattern() {
        return this.getString(hostPattern);
    }

    public final void setHostPattern(String string) {
        this.setString(hostPattern, string, null);
    }

    public final int getTotalFrames() {
        return this.getInt(totalFrames);
    }

    public final void setTotalFrames(int n) {
        this.setInt(totalFrames, n, null);
    }

    public final BAbsTime getLastNewFrameDateTime() {
        return (BAbsTime)this.get(lastNewFrameDateTime);
    }

    public final void setLastNewFrameDateTime(BAbsTime bAbsTime) {
        this.set(lastNewFrameDateTime, (BValue)bAbsTime, null);
    }

    public final boolean getHistoryEnabled() {
        return this.getBoolean(historyEnabled);
    }

    public final void setHistoryEnabled(boolean bl) {
        this.setBoolean(historyEnabled, bl, null);
    }

    public final BHistoryId getHistoryId() {
        return (BHistoryId)this.get(historyId);
    }

    public final void setHistoryId(BHistoryId bHistoryId) {
        this.set(historyId, (BValue)bHistoryId, null);
    }

    public final BHistoryConfig getHistoryConfig() {
        return (BHistoryConfig)this.get(historyConfig);
    }

    public final void setHistoryConfig(BHistoryConfig bHistoryConfig) {
        this.set(historyConfig, (BValue)bHistoryConfig, null);
    }

    public final void fireNewFrame(BBoxFrameRecord bBoxFrameRecord) {
        this.fire(newFrame, (BValue)bBoxFrameRecord, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final BIcon getIcon() {
        return icon;
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BBoxService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void started() throws Exception {
        this.userFilter = new PatternFilter(this.getUserPattern());
        this.hostFilter = new PatternFilter(this.getHostPattern());
        Class clazz = class$com$tridium$box$analyzer$BBoxAnalyzer;
        if (clazz == null) {
            clazz = class$com$tridium$box$analyzer$BBoxAnalyzer = BBoxAnalyzer.class("[Lcom.tridium.box.analyzer.BBoxAnalyzer;", false);
        }
        Class clazz2 = clazz;
        synchronized (clazz) {
            block6: {
                ++startCount;
                if (worker == null) {
                    worker = new Worker((Worker.ITodo)queue);
                    worker.start("boxStationAnalyzer");
                    if (log.isTraceOn()) {
                        log.trace("Starting Box Analyzer Worker Thread");
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (!this.requiresRegistering()) break block6;
                this.getBoxService().registerListener((BBoxService.IBoxListener)this);
                this.setActive(true);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void stopped() throws Exception {
        this.getBoxService().unregisterListener((BBoxService.IBoxListener)this);
        this.setActive(false);
        Class clazz = class$com$tridium$box$analyzer$BBoxAnalyzer;
        if (clazz == null) {
            clazz = class$com$tridium$box$analyzer$BBoxAnalyzer = BBoxAnalyzer.class("[Lcom.tridium.box.analyzer.BBoxAnalyzer;", false);
        }
        Class clazz2 = clazz;
        synchronized (clazz) {
            if (--startCount <= 0 && worker != null) {
                worker.stop();
                worker = null;
                if (log.isTraceOn()) {
                    log.trace("Stopping Box Analyzer Worker Thread");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == userPattern) {
            this.userFilter = new PatternFilter(this.getUserPattern());
        } else if (property == hostPattern) {
            this.hostFilter = new PatternFilter(this.getHostPattern());
        } else if (property == historyEnabled) {
            if (this.requiresRegistering()) {
                this.getBoxService().registerListener((BBoxService.IBoxListener)this);
                this.setActive(true);
            } else {
                this.getBoxService().unregisterListener((BBoxService.IBoxListener)this);
                this.setActive(false);
            }
        }
    }

    public final void subscribed() {
        if (this.isRunning() && this.requiresRegistering()) {
            this.getBoxService().registerListener((BBoxService.IBoxListener)this);
            this.setActive(true);
        }
    }

    public final void unsubscribed() {
        if (this.isRunning() && !this.requiresRegistering()) {
            this.getBoxService().unregisterListener((BBoxService.IBoxListener)this);
            this.setActive(false);
        }
    }

    public final void newRecord(BAbsTime bAbsTime, BBoxRecordType bBoxRecordType, String string, String string2, int n, String string3) {
        final BBoxFrameRecord bBoxFrameRecord = new BBoxFrameRecord();
        bBoxFrameRecord.setTimestamp(bAbsTime);
        bBoxFrameRecord.setUser(string);
        bBoxFrameRecord.setHost(string2);
        bBoxFrameRecord.setPort(n);
        bBoxFrameRecord.setRecordType(bBoxRecordType);
        bBoxFrameRecord.setData(string3);
        if (this.userFilter.accept(bBoxFrameRecord.getUser()) && this.hostFilter.accept(bBoxFrameRecord.getHost())) {
            this.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final void run() {
                    BBoxAnalyzer bBoxAnalyzer = BBoxAnalyzer.this;
                    synchronized (bBoxAnalyzer) {
                        BBoxAnalyzer.this.setTotalFrames(BBoxAnalyzer.this.getTotalFrames() + 1);
                        BBoxAnalyzer.this.setLastNewFrameDateTime(BAbsTime.now());
                        // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
                        BBoxAnalyzer.this.fireNewFrame(bBoxFrameRecord);
                    }
                    BBoxAnalyzer.this.recordToHistory(bBoxFrameRecord);
                }
            });
        }
    }

    private final BBoxService getBoxService() {
        return (BBoxService)this.getParent();
    }

    private final boolean requiresRegistering() {
        boolean bl = false;
        if (this.isSubscribed() || this.getHistoryEnabled()) {
            bl = true;
        }
        return bl;
    }

    private final void post(Runnable runnable) {
        queue.enqueue((Object)runnable);
    }

    private final void recordToHistory(BBoxFrameRecord bBoxFrameRecord) {
        if (!this.getHistoryEnabled()) {
            return;
        }
        try {
            BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
            BHistoryConfig bHistoryConfig = this.getHistoryConfig();
            bHistoryConfig.setTimeZone(BTimeZone.getLocal());
            BHistoryId bHistoryId = this.getHistoryId();
            bHistoryId = bHistoryId.fromShorthand(Sys.getStation().getStationName());
            bHistoryConfig.setId(bHistoryId);
            if (!bHistoryDatabase.exists(bHistoryId)) {
                bHistoryDatabase.createHistory(bHistoryConfig);
            } else {
                bHistoryDatabase.reconfigureHistory(bHistoryConfig);
            }
            BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
            bIHistory.append((BIHistoryRecordSet)bBoxFrameRecord);
            bIHistory.flush();
        }
        catch (Exception exception) {
            log.error("Writing Box Analyzer History", (Throwable)exception);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.userFilter = new PatternFilter("*");
        this.hostFilter = new PatternFilter("*");
    }

    public BBoxAnalyzer() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$box$analyzer$BBoxAnalyzer;
        if (clazz == null) {
            clazz = class$com$tridium$box$analyzer$BBoxAnalyzer = BBoxAnalyzer.class("[Lcom.tridium.box.analyzer.BBoxAnalyzer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"boxStationAnalyzer");
        icon = BIcon.std((String)"magnifyingGlass.png");
        queue = new Queue();
        startCount = 0;
    }
}

