/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nhtml;

import com.tridium.nhtml.Token;
import java.io.IOException;
import java.io.InputStream;
import java.util.EmptyStackException;
import java.util.Stack;

public class NhtmlTokenizer {
    private CharInput in;
    private Stack tokenStack;

    public Token nextToken() throws IOException {
        Token token = null;
        if (!this.tokenStack.empty()) {
            token = (Token)this.tokenStack.pop();
        } else {
            int n = this.in.read();
            if (n == -1) {
                return Token.eof;
            }
            switch (n) {
                case 60: {
                    token = this.startComment1();
                    break;
                }
                case 45: {
                    token = this.endComment1();
                    break;
                }
                default: {
                    this.in.push(n);
                    token = this.text();
                }
            }
        }
        if (token.getTokenType() == 5) {
            Token token2 = this.nextToken();
            while (token2.getTokenType() == 5) {
                token.mergeText(token2);
                token2 = this.nextToken();
            }
            if (token2.getTokenType() != 5) {
                this.tokenStack.push(token2);
            }
        }
        return token;
    }

    public void push(Token token) {
        this.tokenStack.push(token);
    }

    private final Token startComment1() throws IOException {
        int n = this.in.read();
        if (n == 33) {
            return this.startComment2();
        }
        if (n != -1) {
            this.in.push(n);
        }
        return Token.text("<");
    }

    private final Token startComment2() throws IOException {
        int n = this.in.read();
        if (n == 45) {
            return this.startComment3();
        }
        if (n != -1) {
            this.in.push(n);
        }
        return Token.text("<!");
    }

    private final Token startComment3() throws IOException {
        int n = this.in.read();
        if (n == 45) {
            return Token.commentStart;
        }
        if (n != -1) {
            this.in.push(n);
        }
        return Token.text("<!-");
    }

    private final Token endComment1() throws IOException {
        int n = this.in.read();
        if (n == 45) {
            return this.endComment2();
        }
        if (n != -1) {
            this.in.push(n);
        }
        return Token.text("-");
    }

    private final Token endComment2() throws IOException {
        int n = this.in.read();
        if (n == 62) {
            return Token.commentEnd;
        }
        if (n != -1) {
            this.in.push(n);
        }
        return Token.text("--");
    }

    private final Token text() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = this.in.read();
        while (n != 60 && n != 45 && n != -1) {
            stringBuffer.append((char)n);
            n = this.in.read();
        }
        if (n != -1) {
            this.in.push(n);
        }
        return Token.text(stringBuffer.toString());
    }

    public NhtmlTokenizer(InputStream inputStream) {
        this.in = new CharInput(inputStream);
        this.tokenStack = new Stack();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CharInput {
        private InputStream in;
        private CharStack stack;

        public int read() throws IOException {
            if (!this.stack.isEmpty()) {
                return this.stack.pop();
            }
            return this.in.read();
        }

        public void push(int n) {
            this.stack.push(n);
        }

        public CharInput(InputStream inputStream) {
            this.in = inputStream;
            this.stack = new CharStack();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CharStack {
        private int[] buf = new int[8];
        private int size = 0;

        public boolean isEmpty() {
            boolean bl = false;
            if (this.size == 0) {
                bl = true;
            }
            return bl;
        }

        public void push(int n) {
            if (this.size == this.buf.length) {
                int[] nArray = new int[this.buf.length * 2];
                System.arraycopy(this.buf, 0, nArray, 0, this.buf.length);
                this.buf = nArray;
            }
            this.buf[this.size++] = n;
        }

        public int pop() {
            if (this.size == 0) {
                throw new EmptyStackException();
            }
            --this.size;
            return this.buf[this.size];
        }
    }
}

