/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tunnel;

import com.tridium.driver.util.DrByteArrayUtil;
import com.tridium.tunnel.BISerialShare;
import com.tridium.tunnel.BTunnel;
import com.tridium.tunnel.BTunnelConnection;
import com.tridium.tunnel.TunnelConst;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.serial.BISerialPort;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSerialTunnelShare
extends BTunnel
implements TunnelConst {
    public static final Property identifier = BSerialTunnelShare.newProperty((int)1, (String)"none", null);
    public static final Type TYPE;
    public static final BFacets showMilliSecs;
    private Log log;
    private boolean connected;
    private OutputStream comPortOut;
    private InputStream comPortIn;
    private ReadSerial rcvDriver;
    private Thread rcvThread;
    private WriteTunnel tunSndDriver;
    private Thread tunSndThread;
    private PipedInputStream pipedInput;
    private PipedOutputStream pipedOutput;
    private BufferedInputStream bufferedPipeIn;
    static /* synthetic */ Class class$com$tridium$tunnel$BSerialTunnelShare;

    public String getIdentifier() {
        return this.getString(identifier);
    }

    public void setIdentifier(String string) {
        this.setString(identifier, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BISerialShare;
    }

    private final BISerialShare getSerialShare() {
        return (BISerialShare)this.getParent();
    }

    public void started() throws Exception {
        this.setIdentifier(this.getSerialShare().getTunnelIdentifier());
        super.started();
    }

    public void stopped() throws Exception {
        this.doDisconnectAll();
        super.stopped();
    }

    public void tunnelIdChanged(String string) {
        this.setIdentifier(string);
        if (this.connected) {
            this.stopSerialTunnel();
            this.startSerialTunnel();
        }
    }

    public void service(BTunnelConnection bTunnelConnection) throws IOException {
        byte[] byArray = new byte[1024];
        while (bTunnelConnection.isConnected()) {
            int n = bTunnelConnection.read(byArray, 0, 1000);
            if (n <= 0) continue;
            this.log().trace(this.toDebugString("to Serial:   ", byArray, n));
            if (this.comPortOut == null) {
                this.log().error("comPortOut is null");
                bTunnelConnection.disconnect();
                continue;
            }
            this.comPortOut.write(byArray, 0, n);
        }
    }

    public void sessionClosed(BTunnelConnection bTunnelConnection) {
    }

    public boolean supportsConcurrentConnections() {
        return false;
    }

    protected void addConnection(BTunnelConnection bTunnelConnection) {
        super.addConnection(bTunnelConnection);
        this.startSerialTunnel();
    }

    protected void removeConnection(BTunnelConnection bTunnelConnection) {
        super.removeConnection(bTunnelConnection);
        this.stopSerialTunnel();
    }

    public Log log() {
        if (this.log == null) {
            this.log = Log.getLog((String)("Tunnel_" + this.getIdentifier().toLowerCase()));
        }
        return this.log;
    }

    public boolean startSerialTunnel() {
        if (!this.getEnabled()) {
            return true;
        }
        this.log().trace("start()::thread=" + Thread.currentThread().getName());
        try {
            this.log().trace("opening com port...");
            BISerialPort bISerialPort = this.getSerialShare().accessPort(this);
            if (bISerialPort == null) {
                throw new Exception("Unable to access comm port.");
            }
            this.comPortOut = bISerialPort.getOutputStream();
            this.comPortIn = bISerialPort.getInputStream();
            this.pipedInput = new PipedInputStream();
            this.pipedOutput = new PipedOutputStream(this.pipedInput);
            this.bufferedPipeIn = new BufferedInputStream(this.pipedInput, 8000);
            this.connected = true;
        }
        catch (Exception exception) {
            this.log().trace("SerialTunnel exception: " + exception);
            exception.printStackTrace();
            this.connected = false;
            return false;
        }
        this.rcvDriver = new ReadSerial();
        this.rcvThread = new Thread((Runnable)this.rcvDriver, "tunPtoB." + this.getIdentifier());
        this.log().trace("SerialTunnel > starting ReadSerial");
        this.rcvThread.start();
        this.rcvThread.setPriority(5);
        this.tunSndDriver = new WriteTunnel();
        this.tunSndThread = new Thread((Runnable)this.tunSndDriver, "tunBtoT." + this.getIdentifier());
        this.log().trace("WriteTunnel.start()");
        this.tunSndThread.start();
        this.tunSndThread.setPriority(5);
        return true;
    }

    public void stopSerialTunnel() {
        if (!this.connected) {
            return;
        }
        this.log().trace("stop()::thread=" + Thread.currentThread().getName());
        this.connected = false;
        if (this.rcvDriver != null) {
            this.rcvThread.interrupt();
        }
        if (this.tunSndDriver != null) {
            this.tunSndThread.interrupt();
        }
        this.getSerialShare().releaseAccess(this);
        try {
            this.bufferedPipeIn.close();
            this.pipedOutput.close();
            this.pipedInput.close();
            this.bufferedPipeIn = null;
            this.pipedInput = null;
            this.pipedOutput = null;
        }
        catch (Exception exception) {
            this.log().error("SerialTunnel exception: " + exception);
            exception.printStackTrace();
        }
        this.rcvDriver = null;
        this.tunSndDriver = null;
    }

    String toDebugString(String string, byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(30 + n * 3);
        stringBuffer.append(string).append(BSerialTunnelShare.timeStamp());
        stringBuffer.append("|");
        stringBuffer.append(DrByteArrayUtil.toString((byte[])byArray, (int)n));
        return stringBuffer.toString();
    }

    public static String timeStamp() {
        return BAbsTime.make((long)System.currentTimeMillis()).toTimeString((Context)showMilliSecs);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.log = null;
        this.connected = false;
    }

    public BSerialTunnelShare() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$tunnel$BSerialTunnelShare;
        if (clazz == null) {
            clazz = class$com$tridium$tunnel$BSerialTunnelShare = BSerialTunnelShare.class("[Lcom.tridium.tunnel.BSerialTunnelShare;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        showMilliSecs = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ReadSerial
    implements Runnable {
        BufferedOutputStream bufferedPipeOut;

        public void run() {
            BSerialTunnelShare.this.log().trace("ReadSerial.run()::thread=" + Thread.currentThread().getName());
            byte[] byArray = new byte[1024];
            while (BSerialTunnelShare.this.connected) {
                int n;
                try {
                    n = BSerialTunnelShare.this.comPortIn.read(byArray);
                }
                catch (Exception exception) {
                    if (!BSerialTunnelShare.this.connected) {
                        BSerialTunnelShare.this.log().trace("exiting " + Thread.currentThread().getName() + "...");
                        break;
                    }
                    BSerialTunnelShare.this.log().error("ReadSerial.run()::thread=" + Thread.currentThread().getName() + " Exception:" + exception);
                    exception.printStackTrace();
                    BSerialTunnelShare.this.connected = false;
                    break;
                }
                try {
                    if (n <= 0) continue;
                    BSerialTunnelShare.this.log().trace(BSerialTunnelShare.this.toDebugString("from Serial: ", byArray, n));
                    if (BSerialTunnelShare.this.connected) {
                        this.bufferedPipeOut.write(byArray, 0, n);
                    }
                    this.bufferedPipeOut.flush();
                }
                catch (Exception exception) {
                    BSerialTunnelShare.this.log().error("ReadSerial.run()::thread=" + Thread.currentThread().getName() + " Exception:" + exception);
                    exception.printStackTrace();
                }
            }
            try {
                this.bufferedPipeOut.close();
                BSerialTunnelShare.this.pipedOutput.close();
            }
            catch (Exception exception) {}
            BSerialTunnelShare.this.log().trace(Thread.currentThread().getName() + " is stopped!");
        }

        private final /* synthetic */ void this() {
            this.bufferedPipeOut = new BufferedOutputStream(BSerialTunnelShare.this.pipedOutput, 8000);
        }

        ReadSerial() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WriteTunnel
    implements Runnable {
        public void run() {
            byte[] byArray = new byte[1024];
            while (BSerialTunnelShare.this.connected) {
                int n;
                try {
                    n = BSerialTunnelShare.this.bufferedPipeIn.read(byArray);
                }
                catch (Exception exception) {
                    if (!BSerialTunnelShare.this.connected) {
                        BSerialTunnelShare.this.log().trace("closing SerialTunnel WriteTunnel...");
                        break;
                    }
                    BSerialTunnelShare.this.log().error("Exception in SerialTunnel WriteTunnel in.read():" + exception);
                    BSerialTunnelShare.this.connected = false;
                    break;
                }
                try {
                    if (n == -1) continue;
                    BSerialTunnelShare.this.log().trace(BSerialTunnelShare.this.toDebugString("to tunnel:   ", byArray, n));
                    BTunnelConnection[] bTunnelConnectionArray = BSerialTunnelShare.this.getTunnelConnectionsArray();
                    int n2 = 0;
                    while (n2 < bTunnelConnectionArray.length) {
                        if (BSerialTunnelShare.this.connected) {
                            bTunnelConnectionArray[n2].write(byArray, 0, n);
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    BSerialTunnelShare.this.log().error("WriteTunnel.run()while::thread=" + Thread.currentThread().getName() + " Exception:" + exception);
                }
            }
            try {
                if (BSerialTunnelShare.this.bufferedPipeIn != null) {
                    BSerialTunnelShare.this.bufferedPipeIn.close();
                }
                if (BSerialTunnelShare.this.pipedInput != null) {
                    BSerialTunnelShare.this.pipedInput.close();
                }
            }
            catch (IOException iOException) {}
            BSerialTunnelShare.this.log().trace(Thread.currentThread().getName() + " is stopped!");
        }

        WriteTunnel() {
        }
    }
}

