/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tunnel;

import com.tridium.tunnel.BTunnel;
import com.tridium.tunnel.BTunnelConnection;
import com.tridium.tunnel.TunnelConst;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.baja.log.Log;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSerialTunnel
extends BTunnel
implements TunnelConst,
BISerialHelperParent {
    public static final Property identifier = BSerialTunnel.newProperty((int)1, (String)"none", null);
    public static final Property serialPortConfig = BSerialTunnel.newProperty((int)0, (BValue)new BSerialHelper(), null);
    public static final Type TYPE;
    private static boolean IN_FROM_TUNNEL_OUT_TO_COMM;
    private static boolean IN_FROM_COMM_OUT_TO_TUNNEL;
    boolean newDirection;
    boolean oldDirection;
    private Log log;
    private boolean connected;
    private BISerialPort comm;
    private InputStream comPortIn;
    private OutputStream comPortOut;
    private ReadDataFromComPortDriver rcvDriver;
    private Thread rcvThread;
    private SendDataToTunnelDriver tunSndDriver;
    private Thread tunSndThread;
    private PipedInputStream pipedInput;
    private PipedOutputStream pipedOutput;
    private BufferedInputStream bufferedPipeIn;
    static /* synthetic */ Class class$com$tridium$tunnel$BSerialTunnel;

    public String getIdentifier() {
        return this.getString(identifier);
    }

    public void setIdentifier(String string) {
        this.setString(identifier, string, null);
    }

    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    public void setSerialPortConfig(BSerialHelper bSerialHelper) {
        this.set(serialPortConfig, (BValue)bSerialHelper, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.getSerialPortConfig().setSerialHelperParent((BISerialHelperParent)this);
        this.setIdentifier(this.getSerialPortConfig().getPortName());
        super.started();
    }

    public void stopped() throws Exception {
        this.doDisconnectAll();
        super.stopped();
    }

    public void changed(Property property, Context context) {
        if (context != Context.decoding) {
            if (property == BSerialHelper.portName) {
                this.setIdentifier(this.getSerialPortConfig().getPortName());
            } else if (property == identifier) {
                String string = "none";
                if (this.log != null) {
                    Log.deleteLog((String)this.log.getLogName());
                    this.log = null;
                    this.log().trace("changed name from " + string);
                }
            }
        }
        super.changed(property, context);
    }

    public void service(BTunnelConnection bTunnelConnection) throws IOException {
        byte[] byArray = new byte[1024];
        while (bTunnelConnection.isConnected()) {
            int n = bTunnelConnection.read(byArray, 0, 1000);
            if (n <= 0) continue;
            this.newDirection = IN_FROM_TUNNEL_OUT_TO_COMM;
            try {
                if (this.log().isTraceOn()) {
                    this.log().trace("snd:" + this.debugBytes(ByteArrayUtil.toHexString((byte[])byArray, (int)0, (int)n)));
                }
            }
            catch (RuntimeException runtimeException) {}
            if (this.comPortOut == null) {
                this.log().error("comPortOut is null");
                bTunnelConnection.disconnect();
                continue;
            }
            this.comPortOut.write(byArray, 0, n);
        }
    }

    public String debugBytes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.newDirection == this.oldDirection) {
            stringBuffer.append(string);
        } else {
            if (this.newDirection == IN_FROM_COMM_OUT_TO_TUNNEL) {
                stringBuffer.append("\n<" + string);
            } else {
                stringBuffer.append("\n>" + string);
            }
            this.oldDirection = this.newDirection;
        }
        return stringBuffer.toString();
    }

    public void sessionClosed(BTunnelConnection bTunnelConnection) {
        this.doDisconnectAll();
    }

    public boolean supportsConcurrentConnections() {
        return false;
    }

    protected void addConnection(BTunnelConnection bTunnelConnection) {
        super.addConnection(bTunnelConnection);
        this.startSerialTunnel();
    }

    protected void removeConnection(BTunnelConnection bTunnelConnection) {
        super.removeConnection(bTunnelConnection);
        this.stopSerialTunnel();
    }

    public final void reopenPort() {
    }

    public Log log() {
        if (this.log == null) {
            this.log = Log.getLog((String)("Tunnel_" + this.getIdentifier().toLowerCase()));
        }
        return this.log;
    }

    public boolean startSerialTunnel() {
        if (!this.getEnabled()) {
            return true;
        }
        this.log().trace("start()::thread=" + Thread.currentThread().getName());
        try {
            this.log().trace("opening com port...");
            this.comm = this.getSerialPortConfig().open("SerialTunnel");
            BISerialService bISerialService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            this.comm.enableReceiveTimeout(bISerialService.getMinTimeout());
            this.comPortIn = this.comm.getInputStream();
            this.comPortOut = this.comm.getOutputStream();
            this.pipedInput = new PipedInputStream();
            this.pipedOutput = new PipedOutputStream(this.pipedInput);
            this.bufferedPipeIn = new BufferedInputStream(this.pipedInput, 8000);
            this.connected = true;
        }
        catch (Exception exception) {
            this.log().trace("SerialTunnel exception: " + exception);
            exception.printStackTrace();
            this.connected = false;
            this.comPortIn = null;
            this.comPortOut = null;
            return false;
        }
        this.rcvDriver = new ReadDataFromComPortDriver();
        this.rcvThread = new Thread((Runnable)this.rcvDriver, "tunPtoB" + this.getIdentifier());
        this.log().trace("SerialTunnel > starting ReadDataFromComPortDriver");
        this.rcvThread.start();
        this.rcvThread.setPriority(5);
        this.tunSndDriver = new SendDataToTunnelDriver();
        this.tunSndThread = new Thread((Runnable)this.tunSndDriver, "tunBtoT" + this.getIdentifier());
        this.log().trace("SendDataToTunnelDriver.start()");
        this.tunSndThread.start();
        this.tunSndThread.setPriority(5);
        return true;
    }

    public void stopSerialTunnel() {
        if (!this.connected) {
            return;
        }
        this.log().trace("stop()::thread=" + Thread.currentThread().getName());
        this.connected = false;
        if (this.rcvDriver != null) {
            this.rcvThread.interrupt();
        }
        if (this.tunSndDriver != null) {
            this.tunSndThread.interrupt();
        }
        try {
            this.bufferedPipeIn.close();
            this.pipedOutput.close();
            this.pipedInput.close();
            this.comPortIn.close();
            this.comPortOut.close();
            this.comm.close();
            this.bufferedPipeIn = null;
            this.pipedInput = null;
            this.pipedOutput = null;
            this.comPortIn = null;
            this.comPortOut = null;
            this.comm = null;
        }
        catch (Exception exception) {
            this.log().error("SerialTunnel exception: " + exception);
            exception.printStackTrace();
        }
        this.rcvDriver = null;
        this.tunSndDriver = null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.newDirection = IN_FROM_TUNNEL_OUT_TO_COMM;
        this.oldDirection = IN_FROM_TUNNEL_OUT_TO_COMM;
        this.log = null;
        this.connected = false;
    }

    public BSerialTunnel() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$tunnel$BSerialTunnel;
        if (clazz == null) {
            clazz = class$com$tridium$tunnel$BSerialTunnel = BSerialTunnel.class("[Lcom.tridium.tunnel.BSerialTunnel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        IN_FROM_TUNNEL_OUT_TO_COMM = false;
        IN_FROM_COMM_OUT_TO_TUNNEL = true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ReadDataFromComPortDriver
    implements Runnable {
        BufferedOutputStream bufferedPipeOut;

        public void run() {
            BSerialTunnel.this.log().trace("ReadDataFromComPortDriver.run()::thread=" + Thread.currentThread().getName());
            byte[] byArray = new byte[1024];
            while (BSerialTunnel.this.connected) {
                int n;
                try {
                    n = BSerialTunnel.this.comPortIn.read(byArray);
                }
                catch (Exception exception) {
                    if (!BSerialTunnel.this.connected) {
                        BSerialTunnel.this.log().trace("exiting " + Thread.currentThread().getName() + "...");
                        break;
                    }
                    BSerialTunnel.this.log().error("ReadDataFromComPortDriver.run()::thread=" + Thread.currentThread().getName() + " Exception:" + exception);
                    exception.printStackTrace();
                    BSerialTunnel.this.connected = false;
                    break;
                }
                try {
                    if (n <= 0) continue;
                    BSerialTunnel.this.log().trace(Thread.currentThread().getName() + " comm input: " + n + " bytes");
                    BSerialTunnel.this.newDirection = IN_FROM_COMM_OUT_TO_TUNNEL;
                    try {
                        if (n > 0 && BSerialTunnel.this.log().isTraceOn()) {
                            BSerialTunnel.this.log().trace("rcv:" + BSerialTunnel.this.debugBytes(ByteArrayUtil.toHexString((byte[])byArray, (int)0, (int)n)));
                        }
                    }
                    catch (RuntimeException runtimeException) {}
                    if (BSerialTunnel.this.connected) {
                        this.bufferedPipeOut.write(byArray, 0, n);
                    }
                    this.bufferedPipeOut.flush();
                }
                catch (Exception exception) {
                    BSerialTunnel.this.log().error("ReadDataFromComPortDriver.run()::thread=" + Thread.currentThread().getName() + " Exception:" + exception);
                    exception.printStackTrace();
                }
            }
            try {
                this.bufferedPipeOut.close();
                BSerialTunnel.this.pipedOutput.close();
            }
            catch (Exception exception) {}
            BSerialTunnel.this.log().trace(Thread.currentThread().getName() + " is stopped!");
        }

        private final /* synthetic */ void this() {
            this.bufferedPipeOut = new BufferedOutputStream(BSerialTunnel.this.pipedOutput, 8000);
        }

        ReadDataFromComPortDriver() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SendDataToTunnelDriver
    implements Runnable {
        public void run() {
            byte[] byArray = new byte[1024];
            while (BSerialTunnel.this.connected) {
                int n;
                try {
                    n = BSerialTunnel.this.bufferedPipeIn.read(byArray);
                }
                catch (Exception exception) {
                    if (!BSerialTunnel.this.connected) {
                        BSerialTunnel.this.log().trace("closing SerialTunnel SendDataToTunnelDriver...");
                        break;
                    }
                    BSerialTunnel.this.log().error("Exception in SerialTunnel SendDataToTunnelDriver in.read():" + exception);
                    BSerialTunnel.this.connected = false;
                    break;
                }
                try {
                    if (n == -1) continue;
                    BTunnelConnection[] bTunnelConnectionArray = BSerialTunnel.this.getTunnelConnectionsArray();
                    int n2 = 0;
                    while (n2 < bTunnelConnectionArray.length) {
                        if (BSerialTunnel.this.connected) {
                            bTunnelConnectionArray[n2].write(byArray, 0, n);
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    BSerialTunnel.this.log().error("SendDataToTunnelDriver.run()while::thread=" + Thread.currentThread().getName() + " Exception:" + exception);
                }
            }
            try {
                if (BSerialTunnel.this.bufferedPipeIn != null) {
                    BSerialTunnel.this.bufferedPipeIn.close();
                }
                if (BSerialTunnel.this.pipedInput != null) {
                    BSerialTunnel.this.pipedInput.close();
                }
            }
            catch (IOException iOException) {}
            BSerialTunnel.this.log().trace(Thread.currentThread().getName() + " is stopped!");
        }

        SendDataToTunnelDriver() {
        }
    }
}

