/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.db2;

import com.ibm.db2.jcc.DB2ConnectionPoolDataSource;
import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.db2.history.BDb2HistoryDeviceExt;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.sql.Connection;
import java.sql.SQLException;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.sql.PooledConnection;

public class BDb2Database
extends BRdbms {
    public static final Property databaseName = BDb2Database.newProperty((int)0, (String)"", null);
    public static final Property port = BDb2Database.newProperty((int)0, (int)6789, null);
    public static final Property histories = BDb2Database.newProperty((int)0, (BValue)new BDb2HistoryDeviceExt(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$db2$BDb2Database == null ? (class$com$tridium$rdb$db2$BDb2Database = BDb2Database.class$("com.tridium.rdb.db2.BDb2Database")) : class$com$tridium$rdb$db2$BDb2Database));
    private final RdbmsDialect DIALECT = new RdbmsDialect(){

        public String getValidationQuery() {
            return "values 1";
        }

        public void issueCheckpoint(Connection connection) throws SQLException {
        }

        public boolean supportsBatchInsert() {
            return false;
        }

        public boolean supportsBatchUpdate() {
            return false;
        }

        public boolean supportsBatchDelete() {
            return false;
        }

        public int getInsertionMode() {
            return 2;
        }

        public String getIdentityCreation() {
            return "GENERATED ALWAYS AS IDENTITY";
        }

        public String getIdentityLookup() {
            return "SELECT IDENTITY_VAL_LOCAL() FROM SYSIBM.SYSDUMMY1";
        }

        public AesSysKeyEncoder getAesEncoder() {
            return BDb2Database.this.getEncoder();
        }

        public String getSequenceName(String string) {
            throw new UnsupportedOperationException();
        }

        public String getSequenceLookup(String string) {
            throw new UnsupportedOperationException();
        }

        public String getAlterColumn() {
            return "ALTER COLUMN";
        }

        public String getAlterColumnSuffix() {
            return "SET DATA TYPE";
        }

        public boolean getAlterColumnSupportsNotNull() {
            return false;
        }

        public String getStringLengthFunctionName() {
            return "LENGTH";
        }

        public int getMaxTableName() {
            return 128;
        }

        public int getMaxIndexName() {
            return 18;
        }

        public int getMaxConstraintName() {
            return 18;
        }

        public int getMaxColumnName() {
            return 18;
        }

        public boolean allowsUnicodeNames() {
            return false;
        }

        public String getColumnIdentifier(String string, String string2, String string3) {
            if (string != null && string.length() > 0) {
                return string + "." + string2 + ".\"" + string3 + "\"";
            }
            return string2 + ".\"" + string3 + "\"";
        }

        public String getTableIdentifier(String string, String string2) {
            if (string != null && string.length() > 0) {
                return string + "." + string2;
            }
            return string2;
        }

        public String getDropIndex(String string, String string2) {
            return "DROP INDEX " + string2;
        }

        public String getDropConstraint(String string, Constraint constraint) {
            return "ALTER TABLE " + string + " " + "DROP CONSTRAINT " + constraint.getName();
        }

        public String getIntType() {
            return "INTEGER";
        }

        public String getLongType() {
            return "BIGINT";
        }

        public String getFloatType() {
            return "REAL";
        }

        public String getDoubleType() {
            return "DOUBLE";
        }

        public String getCharType() {
            return BDb2Database.this.getUseUnicodeEncodingScheme() ? "NCHAR" : "CHAR";
        }

        public String getVarCharType() {
            return BDb2Database.this.getUseUnicodeEncodingScheme() ? "NVARCHAR" : "VARCHAR";
        }

        public String getUuidType() {
            return "CHAR(16) FOR BIT DATA";
        }

        public String getDateType() {
            return "DATE";
        }

        public String getTimestampType() {
            return "TIMESTAMP";
        }

        public String getBooleanType() {
            throw new UnsupportedOperationException();
        }

        public boolean supportsBooleanType() {
            return false;
        }

        public boolean supportsDateType() {
            return true;
        }

        public boolean supportsMillisecondTimestamp() {
            return !BDb2Database.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcMillis);
        }

        public boolean useUtcTimestamps() {
            return BDb2Database.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp);
        }

        public String getBlobType() {
            return "BLOB";
        }

        public boolean usesDefaultBlobTranslator() {
            return true;
        }

        public void setBlobValue(RdbmsPreparedStatement rdbmsPreparedStatement, int n2, byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        public String getClobType() {
            return "CLOB";
        }

        public boolean usesDefaultClobTranslator() {
            return true;
        }

        public void setClobValue(RdbmsPreparedStatement rdbmsPreparedStatement, int n2, String string) {
            throw new UnsupportedOperationException();
        }

        public String getOnDelete(int n2) {
            switch (n2) {
                case 1: {
                    return "CASCADE";
                }
                case 0: {
                    return "NO ACTION";
                }
            }
            throw new IllegalStateException();
        }

        public boolean supportsDropColumn() {
            return false;
        }

        public boolean supportsRenameTable() {
            return true;
        }

        public boolean supportsClusteredIndex() {
            return false;
        }

        public int getJdbcTypeBlob() {
            return 2004;
        }

        public int getJdbcTypeBoolean() {
            return 1;
        }

        public int getJdbcTypeChar() {
            return 1;
        }

        public int getJdbcTypeClob() {
            return 2005;
        }

        public int getJdbcTypeDouble() {
            return 8;
        }

        public int getJdbcTypeFloat() {
            return 7;
        }

        public int getJdbcTypeInt() {
            return 4;
        }

        public int getJdbcTypeLong() {
            return -5;
        }

        public int getJdbcTypeTimestamp() {
            return 93;
        }

        public int getJdbcTypeUuid() {
            return -2;
        }

        public int getJdbcTypeVarchar() {
            return 12;
        }

        public int getJdbcTypeDate() {
            return 91;
        }
    };
    static /* synthetic */ Class class$com$tridium$rdb$db2$BDb2Database;

    public String getDatabaseName() {
        return this.getString(databaseName);
    }

    public void setDatabaseName(String string) {
        this.setString(databaseName, string, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n2) {
        this.setInt(port, n2, null);
    }

    public BDb2HistoryDeviceExt getHistories() {
        return (BDb2HistoryDeviceExt)this.get(histories);
    }

    public void setHistories(BDb2HistoryDeviceExt bDb2HistoryDeviceExt) {
        this.set(histories, (BValue)bDb2HistoryDeviceExt, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDb2Database() {
    }

    public BDb2Database(BOrd bOrd, String string, int n2) {
        this.setHostAddress(bOrd);
        this.setDatabaseName(string);
        this.setPort(n2);
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "rdbDb2");
    }

    public AesSysKeyEncoder getEncoder() {
        return this.getRdbSecuritySettings().getEncoder();
    }

    public Connection getConnection(String string, BPassword bPassword) throws SQLException {
        BStatus bStatus = this.getStatus();
        if (bStatus.isFault()) {
            return null;
        }
        DB2ConnectionPoolDataSource dB2ConnectionPoolDataSource = new DB2ConnectionPoolDataSource();
        dB2ConnectionPoolDataSource.setDriverType(4);
        dB2ConnectionPoolDataSource.setServerName(this.getHostname());
        dB2ConnectionPoolDataSource.setDatabaseName(this.getDatabaseName());
        dB2ConnectionPoolDataSource.setPortNumber(this.getPort());
        dB2ConnectionPoolDataSource.setUser(string);
        dB2ConnectionPoolDataSource.setPassword(bPassword.getString());
        PooledConnection pooledConnection = dB2ConnectionPoolDataSource.getPooledConnection();
        return pooledConnection.getConnection();
    }

    public RdbmsContext getRdbmsContext() {
        return this.DIALECT;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

