/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2InputStream;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.IOException;
import java.sql.SQLException;

public class DB2UnicodeStream
extends DB2InputStream {
    protected int bytesRetrieved = 0;

    protected native String SQLReadString(int var1, Integer var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public DB2UnicodeStream(DB2Statement stmt, int loc, int type) throws SQLException {
        super(stmt, loc, type);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "DB2UnicodeStream( stmt, " + loc + ", " + type + " )");
        }
        if (type == -351) {
            this.docLength /= 2;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "docLength", this.docLength);
            DB2Trace.methodExit(this, "DB2UnicodeStream()");
        }
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        return this.bufferEnd - this.bufferPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b2) throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        int bytesRead = 0;
        int bytesAvailable = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read( b )");
            }
            int bytesToRead = b2.length;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "bytesToRead", bytesToRead);
            }
            if (this.buffer != null) {
                bytesAvailable = this.bufferEnd - this.bufferPos;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "bytesAvailable", bytesAvailable);
                }
                if (bytesAvailable != 0) {
                    if (bytesToRead <= bytesAvailable) {
                        System.arraycopy(this.buffer, this.bufferPos, b2, 0, bytesToRead);
                        this.bufferPos += bytesToRead;
                        bytesRead = bytesToRead;
                        bytesToRead = 0;
                    } else {
                        System.arraycopy(this.buffer, this.bufferPos, b2, 0, bytesAvailable);
                        this.bufferPos += bytesAvailable;
                        bytesRead = bytesAvailable;
                        bytesToRead -= bytesAvailable;
                    }
                }
            }
            if (bytesToRead != 0 && this.currentPosition <= this.docLength) {
                String str;
                bytesAvailable = 0;
                int len = Math.max(32000, bytesToRead);
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(30, "currentPosition", this.currentPosition);
                    DB2Trace.data(30, "bytesToRead", bytesToRead);
                    DB2Trace.data(30, "len", len);
                }
                Integer rcObj = new Integer(0);
                try {
                    this.numBytesRead = 0;
                    DB2Statement dB2Statement = this.statement;
                    synchronized (dB2Statement) {
                        str = this.SQLReadString(len, rcObj, this.lobType, this.locator, this.currentPosition, this.docLength, this.statement.statementHandle, this.connection.connectionHandle);
                        int rc2 = rcObj;
                        if (rc2 != 0) {
                            this.connection.sqlExcptGen.check_return_code(this.statement, rc2);
                        }
                    }
                }
                catch (SQLException e2) {
                    throw new IOException(e2.toString());
                }
                if (str != null) {
                    int numCharsRead = str.length();
                    this.buffer = str.getBytes("UTF8");
                    bytesAvailable = this.buffer.length;
                    this.currentPosition = this.lobType == 41 ? (this.currentPosition += this.numBytesRead) : (this.currentPosition += numCharsRead);
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(40, "numBytesRead", this.numBytesRead);
                    DB2Trace.data(40, "bytesAvailable", bytesAvailable);
                }
                this.bufferPos = 0;
                this.bufferEnd = bytesAvailable;
                if (bytesAvailable != 0) {
                    if (bytesToRead <= bytesAvailable) {
                        System.arraycopy(this.buffer, this.bufferPos, b2, bytesRead, bytesToRead);
                        this.bufferPos += bytesToRead;
                        bytesRead += bytesToRead;
                    } else {
                        System.arraycopy(this.buffer, this.bufferPos, b2, bytesRead, bytesAvailable);
                        this.bufferPos += bytesAvailable;
                        bytesRead += bytesAvailable;
                    }
                }
            }
            this.bytesRetrieved += bytesRead;
            if (bytesRead == 0) {
                bytesRead = -1;
            }
            int n2 = bytesRead;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "read()", bytesRead);
            }
        }
    }

    public synchronized long skip(long n2) {
        return 0L;
    }

    public synchronized void mark(int m2) {
    }

    public synchronized void reset() {
    }

    public boolean markSupported() {
        return false;
    }
}

